/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

#include	<stdio.h>
#include	<string.h>

#include	"manifest.h"
#include	"contool.h"

PRIVATE	regexp_error();

#define		INIT			register char *expbuf = ep, *sp = instring;
#define		GETC()			(*sp++)
#define		PEEKC()			(*sp)
#define		UNGETC(c)		(--sp)
#define		RETURN(p)		{memcpy(sp = (char *) malloc(p - expbuf), expbuf, p - expbuf); return(sp);}
#define		ERROR(val)		{regexp_error(val, instring); return(NULL);}

#include	<regexp.h>

PRIVATE	char	error_message[512];

/************************************************************************/
EXPORT	int	match_exp(exp, circ, str)

char	*exp;
int	circ;
char	*str;

{	char	*p;
	int	result;

	p = str + strlen(str) - 1;
	if (p >= str && *p == '\n')
	   *p = '\0';
	circf = circ;
	result = step(str, exp);
	if (p >= str && *p == '\0')
	   *p = '\n';
	return(result);
}

/************************************************************************/
PRIVATE	regexp_error(val, string)

int	val;
char	*string;

{	char	*msg;

	switch (val) {
	   case 11 : msg = "range endpoint too large";
	   case 16 : msg = "bad number";
	   case 25 : msg = "\"\\digit\" out of range";
	   case 36 : msg = "illegal or missing delimiter";
	   case 41 : msg = "no remembered search string";
	   case 42 : msg = "\\(\\) imbalance";
	   case 43 : msg = "too many \\(";
	   case 44 : msg = "more than 2 numbers given in \\{\\}";
	   case 45 : msg = "} expected after \\";
	   case 46 : msg = "first number exceeds second in \\{\\}";
	   case 49 : msg = "[] imbalance";
	   case 50 : msg = "regular expression overflow";
	   default : msg = "regular expression error";
	   }
	sprintf(error_message, "%s in %s", msg, string);
}

/************************************************************************/
PRIVATE	char	*fix_control_chars(s)

char	*s;

{	static	char	buf[2048];
	char	*p;

	for (p = buf; *s; s++, p++)
	   if (*s == '\\' && *(s + 1) >= '0' && *(s + 1) <= '7') {
	      for (*p = 0, s++; *s && *s >= '0' && *s <= '7'; s++)
	         *p = (*p << 3) + *s - '0';
	      s--;
	      }
	   else
	      *p = *s;
	*p = '\0';
	return(buf);
}

/************************************************************************/
EXPORT	char	*compile_exp(filter, start, stop)

Filter	*filter;
char	*start;
char	*stop;

{	char	rbuf[1024], *sre, *ere;
	int	sc, ec;

	sre = ere = NULL;
	if (start) {
	   if ((sre = compile(fix_control_chars(start), rbuf, rbuf+1024, '\0')) == NULL)
	      return(error_message);
	   sc = circf;
	   }
	if (stop) {
	   if ((ere = compile(fix_control_chars(stop), rbuf, rbuf+1024, '\0')) == NULL) {
	      cond_free(sre);
	      return(error_message);
	      }
	   ec = circf;
	   }
	if (filter) {
	   filter->start = start;
	   filter->stop = stop;
	   filter->start_re = sre;
	   filter->stop_re = ere;
	   filter->start_circf = sc;
	   filter->stop_circf = ec;
	   }
	else {
	   cond_free(sre);
	   if (ere)
	      cond_free(ere);
	   }
	return(NULL);
}
