/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

/************************************************************************/
/*									*/
/*	props.c		contool properties dialog manager		*/
/*									*/
/************************************************************************/

#include	<stdio.h>
#include	<string.h>

#include	<xview/xview.h>
#include	<xview/panel.h>
#include	<xview/rect.h>
#include	<xview/screen.h>

#include	"manifest.h"
#include	"contool.h"
#include	"contool_ui.h"

EXPORT	Props	defaults = {3,			/* beeps			 */
			    TRUE,		/* flash the icon		 */
			    TRUE,		/* write the message to the log	 */
			    FALSE,		/* don't pop the window		 */
			    TRUE,		/* timestamp the message	 */
			    NULL,		/* no command to run		 */
			    NULL,		/* default good icon		 */
			    NULL,		/* default good icon mask	 */
			    NULL,		/* default bad icon		 */
			    NULL,		/* default bad icon mask	 */
			    NULL,		/* default flash icon		 */
			    NULL,		/* default flash icon mask	 */
			    "lpr",		/* default print filter		 */
			    NULL,		/* no log file			 */
			    TRUE,		/* log after filtering		 */
			    ARCHIVE_MANUALLY,	/* archive only at user request  */
			    60,			/* timestamp every 60 seconds	 */
			    32768,		/* save 32K of messages		 */
			    1024		/* remove 1K when we get full	 */
			   };

PRIVATE	contool_props_objects	*contool_props = NULL;

/************************************************************************/
PRIVATE	init_props(ip)

contool_props_objects	*ip;

{	int	val;

	val = 0;
	if (defaults.beep > 0)
	   val |= BEEP_BIT;
	if (defaults.command != NULL)
	   val |= COMMAND_BIT;
	if (defaults.flash)
	   val |= FLASH_BIT;
	if (defaults.log)
	   val |= LOG_BIT;
	if (defaults.open)
	   val |= OPEN_BIT;
	if (defaults.stamp > 0)
	   val |= STAMP_BIT;
	xv_set(ip->default_action,     PANEL_VALUE,    val,                       NULL);
	xv_set(ip->default_beep_count, PANEL_VALUE,    defaults.beep,
				       PANEL_INACTIVE, defaults.beep == 0,        NULL);
	xv_set(ip->default_beep_times, PANEL_INACTIVE, defaults.beep == 0,        NULL);
	xv_set(ip->default_command,    PANEL_VALUE,    is_null(defaults.command),
				       PANEL_INACTIVE, defaults.command == NULL,  NULL);
	xv_set(ip->log_file,           PANEL_VALUE,    defaults.log_file,         NULL);
	xv_set(ip->log_style,          PANEL_VALUE,    defaults.log_after,        NULL);
	xv_set(ip->archive_style,      PANEL_VALUE,    defaults.archive_style,    NULL);
	xv_set(ip->good_icon,          PANEL_VALUE,    defaults.good_icon,        NULL);
	xv_set(ip->good_icon_mask,     PANEL_VALUE,    defaults.good_icon_mask,   NULL);
	xv_set(ip->bad_icon,           PANEL_VALUE,    defaults.bad_icon,         NULL);
	xv_set(ip->bad_icon_mask,      PANEL_VALUE,    defaults.bad_icon_mask,    NULL);
	xv_set(ip->flash_icon,         PANEL_VALUE,    defaults.flash_icon,       NULL);
	xv_set(ip->flash_icon_mask,    PANEL_VALUE,    defaults.flash_icon_mask,  NULL);
	xv_set(ip->print_filter,       PANEL_VALUE,    defaults.print_filter,     NULL);
	xv_set(ip->max_message,        PANEL_VALUE,    defaults.max_size,         NULL);
	xv_set(ip->stamp_resolution,   PANEL_VALUE,    defaults.stamp_resolution, NULL);
	xv_set(ip->delete_amount,      PANEL_VALUE,    defaults.delete_amount,    NULL);
}

/************************************************************************/
EXPORT	Menu_item	edit_properties(item, op)

Menu_item	item;
Menu_generate	op;

{	contool_base_objects	*ip = (contool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	if (op == MENU_NOTIFY) {
	   xv_set(ip->base, FRAME_BUSY, TRUE, NULL);
	   if (contool_props == NULL) {
	      contool_props = contool_props_objects_initialize(NULL, ip->base);
	      xv_set(contool_props->log_file,
	      	        PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
	      	        PANEL_NOTIFY_STRING, "\n\r\t ",
	      	     NULL);
	      xv_set(contool_props->good_icon,
	      	        PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
	      	        PANEL_NOTIFY_STRING, "\n\r\t ",
	      	     NULL);
	      xv_set(contool_props->good_icon_mask,
	      	        PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
	      	        PANEL_NOTIFY_STRING, "\n\r\t ",
	      	     NULL);
	      xv_set(contool_props->bad_icon,
	      	        PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
	      	        PANEL_NOTIFY_STRING, "\n\r\t ",
	      	     NULL);
	      xv_set(contool_props->bad_icon_mask,
	      	        PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
	      	        PANEL_NOTIFY_STRING, "\n\r\t ",
	      	     NULL);
	      xv_set(contool_props->flash_icon,
	      	        PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
	      	        PANEL_NOTIFY_STRING, "\n\r\t ",
	      	     NULL);
	      xv_set(contool_props->flash_icon_mask,
	      	        PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
	      	        PANEL_NOTIFY_STRING, "\n\r\t ",
	      	     NULL);
	      place_dialog(ip->base, contool_props->props);
	      }
	   init_props(contool_props);
	   xv_set(contool_props->props, XV_SHOW, TRUE, NULL);
	   xv_set(ip->base, FRAME_BUSY, FALSE, NULL);
	   }
	return item;
}

/************************************************************************/
EXPORT	void	default_action(item, value, event)

Panel_item	item;
unsigned int	value;
Event		*event;

{	contool_props_objects	*ip = (contool_props_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	xv_set(ip->default_beep_count, PANEL_INACTIVE, !(value & BEEP_BIT), NULL);
	xv_set(ip->default_beep_times, PANEL_INACTIVE, !(value & BEEP_BIT), NULL);
	xv_set(ip->default_command,    PANEL_INACTIVE, !(value & COMMAND_BIT), NULL);
}

/************************************************************************/
EXPORT	void	accept_properties(item, event)

Panel_item	item;
Event		*event;

{	contool_props_objects	*ip = (contool_props_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	Props	new;
	int	val;
	Server_image	icon = (Server_image) NULL, load_icon();
	char	msg[1024];

	val = (int) xv_get(ip->default_action, PANEL_VALUE);

	if (val & BEEP_BIT)
	   new.beep = (int) xv_get(ip->default_beep_count, PANEL_VALUE);
	else
	   new.beep = 0;

	if (val & COMMAND_BIT) {
	   new.command = (char *) xv_get(ip->default_command, PANEL_VALUE);
	   if (is_empty(new.command)) {
	      error("You must specify a command to be executed");
	      xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	      return;
	      }
	   }
	else
	   new.command = NULL;

	new.flash            = (val & FLASH_BIT)? TRUE : FALSE;
	new.log              = (val & LOG_BIT)? TRUE : FALSE;
	new.open             = (val & OPEN_BIT)? TRUE : FALSE;
	new.stamp            = (val & STAMP_BIT)? TRUE : FALSE;
	new.log_file         = (char *) xv_get(ip->log_file,         PANEL_VALUE);
	new.log_after        = (int)    xv_get(ip->log_style,        PANEL_VALUE);
	new.archive_style    = (int)    xv_get(ip->archive_style,    PANEL_VALUE);
	new.good_icon        = (char *) xv_get(ip->good_icon,        PANEL_VALUE);
	new.good_icon_mask   = (char *) xv_get(ip->good_icon_mask,   PANEL_VALUE);
	new.bad_icon         = (char *) xv_get(ip->bad_icon,         PANEL_VALUE);
	new.bad_icon_mask    = (char *) xv_get(ip->bad_icon_mask,    PANEL_VALUE);
	new.flash_icon       = (char *) xv_get(ip->flash_icon,       PANEL_VALUE);
	new.flash_icon_mask  = (char *) xv_get(ip->flash_icon_mask,  PANEL_VALUE);
	new.print_filter     = (char *) xv_get(ip->print_filter,     PANEL_VALUE);
	new.max_size         = (int)    xv_get(ip->max_message,      PANEL_VALUE);
	new.stamp_resolution = (int)    xv_get(ip->stamp_resolution, PANEL_VALUE);
	new.delete_amount    = (int)    xv_get(ip->delete_amount,    PANEL_VALUE);

	new.good_icon = is_empty(new.good_icon)? NULL : expand_tilde(new.good_icon);
	new.good_icon_mask = is_empty(new.good_icon_mask)? NULL : expand_tilde(new.good_icon_mask);
	new.bad_icon = is_empty(new.bad_icon)? NULL : expand_tilde(new.bad_icon);
	new.bad_icon_mask = is_empty(new.bad_icon_mask)? NULL : expand_tilde(new.bad_icon_mask);
	new.flash_icon = is_empty(new.flash_icon)? NULL : expand_tilde(new.flash_icon);
	new.flash_icon_mask = is_empty(new.flash_icon_mask)? NULL : expand_tilde(new.flash_icon_mask);

	if (new.good_icon && (icon = load_icon(new.good_icon, msg)) == (Server_image) NULL) {
	   error("Invalid \"All is well\" icon: %s", msg);
	   xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	   return;
	   }
	else if (icon) {
	   xv_destroy(icon);
	   icon = (Server_image) NULL;
	   }
	if (new.good_icon_mask && (icon = load_icon(new.good_icon_mask, msg)) == (Server_image) NULL) {
	   error("Invalid \"All is well\" icon mask: %s", msg);
	   xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	   return;
	   }
	else if (icon) {
	   xv_destroy(icon);
	   icon = (Server_image) NULL;
	   }
	if (new.bad_icon && (icon = load_icon(new.bad_icon, msg)) == (Server_image) NULL) {
	   error("Invalid \"Check console\" icon: %s", msg);
	   xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	   return;
	   }
	else if (icon) {
	   xv_destroy(icon);
	   icon = (Server_image) NULL;
	   }
	if (new.bad_icon_mask && (icon = load_icon(new.bad_icon_mask, msg)) == (Server_image) NULL) {
	   error("Invalid \"Check console\" icon mask: %s", msg);
	   xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	   return;
	   }
	else if (icon) {
	   xv_destroy(icon);
	   icon = (Server_image) NULL;
	   }
	if (new.flash_icon && (icon = load_icon(new.flash_icon, msg)) == (Server_image) NULL) {
	   error("Invalid \"Flash\" icon: %s", msg);
	   xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	   return;
	   }
	else if (icon) {
	   xv_destroy(icon);
	   icon = (Server_image) NULL;
	   }
	if (new.flash_icon_mask && (icon = load_icon(new.flash_icon_mask, msg)) == (Server_image) NULL) {
	   error("Invalid \"Flash\" icon mask: %s", msg);
	   xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	   return;
	   }
	else if (icon) {
	   xv_destroy(icon);
	   icon = (Server_image) NULL;
	   }

	new.log_file = is_empty(new.log_file)? NULL : expand_tilde(new.log_file);
	new.print_filter = strsave(new.print_filter);
	new.command = strsave(new.command);
	defaults = new;

	adjust_window_limit();
	update_icons();
	update_logging();
}

/************************************************************************/
EXPORT	void	reset_properties(item, event)

Panel_item	item;
Event		*event;

{	contool_props_objects	*ip = (contool_props_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	init_props(ip);
	xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
}
