/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

%{

#include	<stdio.h>
#include	<ctype.h>
#include	<string.h>

#include	"manifest.h"
#include	"contool.h"

EXPORT	Props	*parsed_defaults;
EXPORT	Filter	*parsed_filters;
EXPORT	int	filter_version = 0;

EXPORT	int	parse_errors_occured;

PRIVATE	char	*get_last_token();

PRIVATE	Filter	*curr;
PRIVATE	char	*curr_file;
PRIVATE	int	line_count = 1;
PRIVATE	char	lastc = -1;

%}

%start	configuration

%union	{char	*cpval;
	 int	ival;
	 Filter	*fval;
	 Props	*pval;
	}

%token	<cpval>	STRING
%token	<ival>	INTEGER

%token		LBRACE RBRACE

%token		ARCHIVE BEEP CHECK_ICON CHECK_ICON_MASK COMMAND COMMENT DEFAULTS
		DELETE DISPLAY FILTERS FLASH FLASH_ICON FLASH_ICON_MASK GOOD_ICON
		GOOD_ICON_MASK IGNORE LOG LOG_BEFORE_FILTERING LOG_FILE MATCH NO
		NOFLASH NOOPEN NOSTAMP OPEN PRINT QUIET SAVE STAMP TIMEOUT TIMESTAMP
		TO VERSION YES

%type	<ival>	beep flash log old_flash old_open old_stamp open stamp yes_no
%type	<cpval>	command old_end_string string
%type	<fval>	filter filter_list old_filter old_filter_list old_ignore old_quiet old_save

%%

configuration	:	empty
		|	old_style
		|	new_style
		;

old_style	:	old_filter_list
					{ parsed_defaults = NULL;
					  parsed_filters = $1;
					}
		;

old_filter_list	:	old_filter
					{ $$ = $1; }
		|	old_filter_list old_filter
					{ Filter	*f;
					
					  for (f = $1; f->next; f = f->next)
					     ;
					  f->next = $2;
					  $$ = $1;
					}
		;

old_filter	:	old_save
		|	old_ignore
		|	old_quiet
		;

old_save	:	SAVE beep old_flash old_open old_stamp STRING old_end_string
					{ Filter	*f;
					  char		*msg;

					  f = (Filter *) malloc(sizeof(Filter));
					  f->save     = TRUE;
					  f->beep     = $2;
					  f->flash    = $3;
					  f->open     = $4;
					  f->stamp    = $5;
					  f->timeout  = 0;
					  f->log      = TRUE;
					  f->start    = $6;
					  f->stop     = $7;
					  f->start_re = NULL;
					  f->stop_re  = NULL;
					  f->command  = NULL;
					  f->comment  = NULL;
					  f->next     = NULL;
					  if (msg = compile_exp(f, f->start, f->stop))
					     yyerror(msg);
					  $$ = f;
					}
		;

old_ignore	:	IGNORE STRING old_end_string
					{ Filter	*f;
					  char		*msg;
					
					  f = (Filter *) malloc(sizeof(Filter));
					  f->save     = FALSE;
					  f->beep     = 0;
					  f->flash    = FALSE;
					  f->open     = FALSE;
					  f->stamp    = FALSE;
					  f->timeout  = 0;
					  f->log      = TRUE;
					  f->start    = $2;
					  f->stop     = $3;
					  f->start_re = NULL;
					  f->stop_re  = NULL;
					  f->command  = NULL;
					  f->comment  = NULL;
					  f->next     = NULL;
					  if (msg = compile_exp(f, f->start, f->stop))
					     yyerror(msg);
					  $$ = f;
					}
		;

old_quiet	:	QUIET STRING old_end_string
					{ Filter	*f;
					  char		*msg;
					
					  f = (Filter *) malloc(sizeof(Filter));
					  f->save     = TRUE;
					  f->beep     = 0;
					  f->flash    = FALSE;
					  f->open     = FALSE;
					  f->stamp    = TRUE;
					  f->timeout  = 0;
					  f->log      = TRUE;
					  f->start    = $2;
					  f->stop     = $3;
					  f->start_re = NULL;
					  f->stop_re  = NULL;
					  f->command  = NULL;
					  f->comment  = NULL;
					  f->next     = NULL;
					  if (msg = compile_exp(f, f->start, f->stop))
					     yyerror(msg);
					  $$ = f;
					}
		;

old_flash	:	FLASH
					{ $$ = TRUE; }
		|	NOFLASH
					{ $$ = FALSE; }
		;

old_open	:	OPEN
					{ $$ = TRUE; }
		|	NOOPEN
					{ $$ = FALSE; }
		;

old_stamp	:	STAMP
					{ $$ = TRUE; }
		|	NOSTAMP
					{ $$ = FALSE; }
		;

old_end_string	:	empty
					{ $$ = NULL; }
		|	TO STRING
					{ $$ = $2; }
		;
		
new_style	:	version defaults
		|	version filters
		|	version defaults filters
		;

version		:	empty
					{ filter_version = 0; }
		|	VERSION INTEGER
					{ filter_version = $2;
					  if (filter_version > FILTER_VERSION)
					     yyerror("This release of contool (%d.%d) cannot read filters created by release %d.%d", FILTER_VERSION / 100, (FILTER_VERSION % 100) / 10, filter_version / 100, (filter_version % 100) / 10);
					}
		;

defaults	:	DEFAULTS
					{ parsed_defaults = (Props *) malloc(sizeof(Props));
					  *parsed_defaults = defaults;
					}
			LBRACE default_list RBRACE
		;

filters		:	FILTERS LBRACE filter_list RBRACE
					{ parsed_filters = $3; }
		;

default_list	:	empty
		|	default_list default
		;

default		:	beep
					{ parsed_defaults->beep = $1; }
		|	command
					{ parsed_defaults->command = $1; }
		|	flash
					{ parsed_defaults->flash = $1; }
		|	log
					{ parsed_defaults->log = $1; }
		|	open
					{ parsed_defaults->open = $1; }
		|	stamp
					{ parsed_defaults->stamp = $1; }
		|	ARCHIVE INTEGER
					{ parsed_defaults->archive_style = $2; }
		|	CHECK_ICON string
					{ parsed_defaults->bad_icon = $2; }
		|	CHECK_ICON_MASK string
					{ parsed_defaults->bad_icon_mask = $2; }
		|	DELETE INTEGER
					{ parsed_defaults->delete_amount = $2; }
		|	DISPLAY INTEGER
					{ parsed_defaults->max_size = $2; }
		|	FLASH_ICON string
					{ parsed_defaults->flash_icon = $2; }
		|	FLASH_ICON_MASK string
					{ parsed_defaults->flash_icon_mask = $2; }
		|	GOOD_ICON string
					{ parsed_defaults->good_icon = $2; }
		|	GOOD_ICON_MASK string
					{ parsed_defaults->good_icon_mask = $2; }
		|	LOG_BEFORE_FILTERING yes_no
					{ parsed_defaults->log_after = !$2; }
		|	LOG_FILE string
					{ parsed_defaults->log_file = $2; }
		|	PRINT STRING
					{ parsed_defaults->print_filter = $2; }
		|	TIMESTAMP INTEGER
					{ parsed_defaults->stamp_resolution = $2; }
		;

filter_list	:	empty
					{ $$ = NULL; }
		|	filter_list filter
					{ Filter	*f;
					
					  if ($1 == NULL)
					     $$ = $2;
					  else {
					     for (f = $1; f->next; f = f->next)
					        ;
					     f->next = $2;
					     $$ = $1;
					     }
					}
		;

filter		:	LBRACE
					{ curr = (Filter *) malloc(sizeof(Filter));
					  memset((char *) curr, 0, sizeof(Filter));
					  if (filter_version < 310)
					     curr->log = TRUE;
					}
			filter_attr_list RBRACE
					{ char	*msg;
					
					  if (curr->start == NULL)
					     yyerror("no filter pattern specified");
					  if (msg = compile_exp(curr, curr->start, curr->stop))
					     yyerror(msg);
					  $$ = curr;
					}
		;

filter_attr_list:	empty
		|	filter_attr_list filter_attr
		;

filter_attr	:	beep
					{ curr->beep = $1; }
		|	command
					{ curr->command = $1; }
		|	flash
					{ curr->flash = $1; }
		|	log
					{ curr->log = $1; }
		|	open
					{ curr->open = $1; }
		|	stamp
					{ curr->stamp = $1; }
		|	COMMENT string
					{ curr->comment = $2; }
		|	IGNORE yes_no
					{ curr->save = !$2; }
		|	MATCH string
					{ curr->start = $2; }
		|	TIMEOUT INTEGER
					{ curr->timeout = $2; }
		|	TO string
					{ curr->stop = $2; }
		;

beep		:	BEEP INTEGER
					{ $$ = $2; }
		;

command		:	COMMAND string
					{ $$ = $2; }
		;
flash		:	FLASH yes_no
					{ $$ = $2; }
		;

log		:	LOG yes_no
					{ $$ = $2; }
		;

open		:	OPEN yes_no
					{ $$ = $2; }
		;

stamp		:	STAMP yes_no
					{ $$ = $2; }
		;

yes_no		:	YES
					{ $$ = TRUE; }
		|	NO
					{ $$ = FALSE; }
		;

string		:	STRING
					{ $$ = (*$1 == '\0')? NULL : $1; }
		;

empty		: ;

%%

/************************************************************************/
PRIVATE	yyerror(s1, s2, s3, s4, s5, s6, s7)

char	*s1, *s2, *s3, *s4, *s5, *s6, *s7;

{	char	buf1[1024], buf2[1024];

	sprintf(buf1, "%s: line %d: ", curr_file, line_count - ((lastc == '\n')? 1 : 0));
	sprintf(buf2, s1, s2, s3, s4, s5, s6, s7);
	strcat(buf1, buf2);
	if (strcmp(s1, "syntax error") == 0) {
	   strcat(buf1, " at or near ");
	   strcat(buf1, get_last_token());
	   }
	error(buf1);
	yyclearin;
	parse_errors_occured++;
}

#include "lex.c"
