/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

/************************************************************************/
/*									*/
/*	load.c		contool load dialog manager			*/
/*									*/
/************************************************************************/

#include	<stdio.h>

#include	<xview/xview.h>
#include	<xview/panel.h>
#include	<xview/xv_xrect.h>

#include	"manifest.h"
#include	"contool.h"
#include	"contool_ui.h"

PRIVATE	contool_load_objects	*contool_load = NULL;

/************************************************************************/
EXPORT	Menu_item	popup_load_config(item, op)

Menu_item	item;
Menu_generate	op;

{	contool_base_objects * ip = (contool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	if (op == MENU_NOTIFY) {
	   if (contool_load == NULL) {
	      contool_load = contool_load_objects_initialize(NULL, ip->base);
	      xv_set(contool_load->load_file,
	      	        PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
	      	        PANEL_NOTIFY_STRING, "\n\r ",
	      	     NULL);
	      xv_set(contool_load->load_type, PANEL_VALUE, 3, NULL);
	      place_dialog(ip->base, contool_load->load);
	      }
	   xv_set(contool_load->load_file, PANEL_VALUE, filter_file, NULL);
	   xv_set(contool_load->load, XV_SHOW, TRUE, NULL);
	   }
	return item;
}

/************************************************************************/
EXPORT	void	load_filters(item, event)

Panel_item	item;
Event		*event;

{	contool_load_objects	*ip = (contool_load_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	int	kind;
	char	*path;

	path = expand_tilde(xv_get(ip->load_file, PANEL_VALUE));
	if (lex_init(path)) {
	   yyparse();
	   if (parse_errors_occured) {
	      error("Error in configuration file.  Configuration not loaded");
	      xv_set(ip->accept_load, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	      }
	   else {
	      kind = (int) xv_get(ip->load_type, PANEL_VALUE);
	      if (kind & 1 && parsed_defaults) {
	         defaults = *parsed_defaults;
	         adjust_window_limit();
	         }
	      if (kind & 2)
	         filters = parsed_filters;
	      free(parsed_defaults);
	      filter_file = path;
	      }
	   }
	else {
	   error("Unable to read configuration file");
	   xv_set(ip->accept_load, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	   free(path);
	   }
}
