/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

/************************************************************************/
/*									*/
/*	filters.c	contool filters dialog manager			*/
/*									*/
/************************************************************************/

#include	<stdio.h>
#include	<string.h>

#include	<xview/xview.h>
#include	<xview/panel.h>
#include	<xview/notice.h>
#include	<xview/xv_xrect.h>

#include	"manifest.h"
#include	"contool.h"
#include	"contool_ui.h"

EXPORT	Filter	*filters = NULL;

PUBLIC	contool_base_objects	*contool_base;

PRIVATE	unsigned	short	single_bits[] = {
#include	"images/single.icon"
						};

PRIVATE	unsigned	short	range_bits[]  = {
#include	"images/range.icon"
						};

PRIVATE	unsigned	short	empty_bits[]  = {
#include	"images/empty.icon"
						};

PRIVATE	Filter	*edit_set = NULL, *clipboard = NULL;
PRIVATE	contool_filters_objects	*contool_filters = NULL;
PRIVATE	Server_image	single, range, empty;

/************************************************************************/
PRIVATE	int	selection_count()

{	int	i, s, total;

	total = (int) xv_get(contool_filters->filter_list, PANEL_LIST_NROWS);
	for (i = s = 0; i < total; i++)
	   if (xv_get(contool_filters->filter_list, PANEL_LIST_SELECTED, i))
	      s++;
	return(s);
}

/************************************************************************/
PRIVATE	int	curr_selection()

{	int	i, total;

	for (i = 0, total = (int) xv_get(contool_filters->filter_list, PANEL_LIST_NROWS); i < total; i++)
	   if (xv_get(contool_filters->filter_list, PANEL_LIST_SELECTED, i))
	      break;
	if (i >= total)
	   fprintf(stderr, "No item selected!\n");
	return(i);
}

/************************************************************************/
PRIVATE	Filter	*duplicate_filter(f)

Filter	*f;

{	Filter	*new;

	new = (Filter *) malloc(sizeof(Filter));
	*new = *f;
	new->start = strsave(f->start);
	new->stop = strsave(f->stop);
	compile_exp(new, new->start, new->stop);
	new->command = strsave(f->command);
	new->comment = strsave(f->comment);
	new->next = NULL;
	return(new);
}

/************************************************************************/
PRIVATE	Filter	*duplicate_list(list)

Filter	*list;

{	Filter	*f, *head = NULL, *curr;

	for (f = list; f; f = f->next)
	   if (head == NULL)
	      head = curr = duplicate_filter(f);
	   else {
	      curr->next = duplicate_filter(f);
	      curr = curr->next;
	      }
	return(head);
}

/************************************************************************/
PRIVATE	void	free_filter(f)

Filter	*f;

{
	cond_free(f->start);
	cond_free(f->start_re);
	cond_free(f->stop);
	cond_free(f->stop_re);
	cond_free(f->command);
	cond_free(f->comment);
	free(f);
}

/************************************************************************/
EXPORT	void	free_list(list)

Filter	*list;

{	Filter	*next;

	for ( ; list; list = next) {
	   next = list->next;
	   free_filter(list);
	   }
}

/************************************************************************/
PRIVATE	void	update_controls()

{	Filter	*f;
	int	i;

	if (selection_count() == 1) {
	   for (f = edit_set, i = 0; f; f = f->next, i++)
	      if (xv_get(contool_filters->filter_list, PANEL_LIST_SELECTED, i))
	         break;
	   if (f == NULL) {
	      error("Internal error: filters do not match scrolling list!");
	      return;
	      }
	   xv_set(contool_filters->filter_update, PANEL_INACTIVE, FALSE, NULL);
	   xv_set(contool_filters->filter_type, PANEL_INACTIVE, FALSE, PANEL_VALUE, f->stop? 1 : 0, NULL);
	   xv_set(contool_filters->start, PANEL_INACTIVE, FALSE, PANEL_VALUE, is_null(f->start), NULL);
	   xv_set(contool_filters->stop, PANEL_INACTIVE, f->stop == NULL, PANEL_VALUE, is_null(f->stop), NULL);
	   xv_set(contool_filters->filter_timeout, PANEL_INACTIVE, f->stop == NULL, PANEL_VALUE, f->timeout, NULL);
	   xv_set(contool_filters->filter_timeout_units, PANEL_INACTIVE, f->stop == NULL, NULL);
	   xv_set(contool_filters->comment, PANEL_INACTIVE, FALSE, PANEL_VALUE, is_null(f->comment), NULL);
	   xv_set(contool_filters->ignore, PANEL_INACTIVE, FALSE, PANEL_VALUE, f->save? 0 : 1, NULL);
	   if (f->save) {
	      i = 0;
	      if (f->beep) {
	         i |= BEEP_BIT;
	         xv_set(contool_filters->filter_beep_count, PANEL_INACTIVE, FALSE, PANEL_VALUE, f->beep, NULL);
	         xv_set(contool_filters->filter_beep_times, PANEL_INACTIVE, FALSE, NULL);
	         }
	      else {
	         xv_set(contool_filters->filter_beep_count, PANEL_INACTIVE, TRUE, NULL);
	         xv_set(contool_filters->filter_beep_times, PANEL_INACTIVE, TRUE, NULL);
	         }
	      if (f->command) {
	         i |= COMMAND_BIT;
	         xv_set(contool_filters->filter_command, PANEL_INACTIVE, FALSE, PANEL_VALUE, f->command, NULL);
	         xv_set(contool_filters->filter_beep_times, PANEL_INACTIVE, FALSE, NULL);
	         }
	      else
	         xv_set(contool_filters->filter_command, PANEL_INACTIVE, TRUE, NULL);
	      if (f->flash)
	         i |= FLASH_BIT;
	      if (f->log)
	         i |= LOG_BIT;
	      if (f->open)
	         i |= OPEN_BIT;
	      if (f->stamp)
	         i |= STAMP_BIT;
	      xv_set(contool_filters->action, PANEL_INACTIVE, FALSE, PANEL_VALUE, i, NULL);
	      }
	   else {
	      xv_set(contool_filters->action, PANEL_INACTIVE, TRUE, NULL);
	      xv_set(contool_filters->filter_beep_count, PANEL_INACTIVE, TRUE, NULL);
	      xv_set(contool_filters->filter_beep_times, PANEL_INACTIVE, TRUE, NULL);
	      xv_set(contool_filters->filter_command, PANEL_INACTIVE, TRUE, NULL);
	      }
	   }
	else {
	   xv_set(contool_filters->filter_update,        PANEL_INACTIVE, TRUE, NULL);
	   xv_set(contool_filters->filter_type,          PANEL_INACTIVE, TRUE, NULL);
	   xv_set(contool_filters->filter_timeout,       PANEL_INACTIVE, TRUE, NULL);
	   xv_set(contool_filters->filter_timeout_units, PANEL_INACTIVE, TRUE, NULL);
	   xv_set(contool_filters->start,                PANEL_INACTIVE, TRUE, NULL);
	   xv_set(contool_filters->stop,                 PANEL_INACTIVE, TRUE, NULL);
	   xv_set(contool_filters->comment,              PANEL_INACTIVE, TRUE, NULL);
	   xv_set(contool_filters->ignore,               PANEL_INACTIVE, TRUE, NULL);
	   xv_set(contool_filters->action,               PANEL_INACTIVE, TRUE, NULL);
	   xv_set(contool_filters->filter_beep_count,    PANEL_INACTIVE, TRUE, NULL);
	   xv_set(contool_filters->filter_beep_times,    PANEL_INACTIVE, TRUE, NULL);
	   xv_set(contool_filters->filter_command,       PANEL_INACTIVE, TRUE, NULL);
	   }
}

/************************************************************************/
PRIVATE	void	init_filters()

{	Filter	*f;
	int	i, total;

	for (total = (int) xv_get(contool_filters->filter_list, PANEL_LIST_NROWS); total > 0; total--)
	   xv_set(contool_filters->filter_list,
	             PANEL_LIST_DELETE, total - 1,
	             PANEL_PAINT, PANEL_NONE,
	          NULL);
	xv_set(contool_filters->filter_list, PANEL_PAINT, PANEL_CLEAR, NULL);
	free_list(edit_set);
	edit_set = duplicate_list(filters);
	for (i = 0, f = edit_set; f; f = f->next, i++)
	   xv_set(contool_filters->filter_list,
	   	     PANEL_LIST_INSERT, i,
	   	     PANEL_LIST_GLYPH,  i, f->stop? range : single,
	   	     PANEL_LIST_STRING, i, f->start,
	   	     PANEL_PAINT, PANEL_NONE,
	   	  NULL);
	xv_set(contool_filters->filter_list, PANEL_PAINT, PANEL_CLEAR, NULL);
	update_controls();
}

/************************************************************************/
PRIVATE	void	insert_item(pos)

int	pos;

{	int	i, total;
	Filter	*f, *t;

	total = (int) xv_get(contool_filters->filter_list, PANEL_LIST_NROWS);
	for (i = 0; i < total; i++)
	   if (xv_get(contool_filters->filter_list, PANEL_LIST_SELECTED, i))
	      xv_set(contool_filters->filter_list, PANEL_LIST_SELECT, i, FALSE, NULL);
	xv_set(contool_filters->filter_list, PANEL_LIST_INSERT, pos, NULL);
	xv_set(contool_filters->filter_list, PANEL_LIST_GLYPH, pos, empty, NULL);
	xv_set(contool_filters->filter_list, PANEL_LIST_SELECT, pos, TRUE, NULL);
	if (pos == 0) {
	   f = (Filter *) malloc(sizeof(Filter));
	   f->next = edit_set;
	   edit_set = f;
	   }
	else {
	   for (i = 1, f = edit_set; i < pos; i++, f = f->next)
	      ;
	   t = f->next;
	   f->next = (Filter *) malloc(sizeof(Filter));
	   f = f->next;
	   f->next = t;
	   }
	f->start = f->stop = f->comment = NULL;
	f->beep = defaults.beep;
	f->command = strsave(defaults.command);
	f->flash = defaults.flash;
	f->log = defaults.log;
	f->open = defaults.open;
	f->stamp = defaults.stamp;
	f->timeout = 0;
	f->save = TRUE;
	update_controls();
/* update the scrolling view */
}

/************************************************************************/
PRIVATE	void	paste_items(pos)

int	pos;

{	int	i;
	Filter	*new, *tail, *f;

	new = duplicate_list(clipboard);
	for (f = new, i = 0; f; f = f->next, i++) {
	   xv_set(contool_filters->filter_list,
	             PANEL_LIST_INSERT, pos + i,
	   	     PANEL_LIST_STRING, pos + i, f->start,
	   	     PANEL_LIST_GLYPH,  pos + i, f->stop? range : single,
	   	     PANEL_PAINT, PANEL_NONE,
	   	  NULL);
	   tail = f;
	   }
	xv_set(contool_filters->filter_list, PANEL_PAINT, PANEL_CLEAR, NULL);
	if (pos == 0) {
	   tail->next = edit_set;
	   edit_set = new;
	   }
	else {
	   for (i = 1, f = edit_set; i < pos; i++, f = f->next)
	      ;
	   tail->next = f->next;
	   f->next = new;
	   }
	update_controls();
}

/************************************************************************/
PRIVATE	int	update_values(f, flag)

Filter	*f;
int	flag;

{	char	*start, *stop, *msg;
	int	i;

	start = (char *) xv_get(contool_filters->start, PANEL_VALUE);
	if (is_empty(start)) {
	   if (flag)
	      error("You must specify a starting message pattern");
	   return(FALSE);
	   }
	if (xv_get(contool_filters->filter_type, PANEL_VALUE) == 1) {
	   stop = (char *) xv_get(contool_filters->stop, PANEL_VALUE);
	   if (is_empty(stop)) {
	      if (flag)
	         error("You must specify an ending message pattern");
	      return(FALSE);
	      }
	   }
	else
	   stop = NULL;
	if (msg = compile_exp(f, start, stop)) {
	   if (flag)
	      error(msg);
	   return(FALSE);
	   }
	if ((int) xv_get(contool_filters->ignore, PANEL_VALUE) == 0) {
	   i = (int) xv_get(contool_filters->action, PANEL_VALUE);
	   if (i & COMMAND_BIT)
	      if (msg = (char *) xv_get(contool_filters->filter_command, PANEL_VALUE))
	         f->command = strsave(msg);
	      else {
	         if (flag)
	            error("You must specify a command for this filter");
	         return(FALSE);
	         }
	   else
	      f->command = NULL;
	   if (i & BEEP_BIT)
	      f->beep = (int) xv_get(contool_filters->filter_beep_count, PANEL_VALUE);
	   else
	      f->beep = 0;
	   f->flash = (i & FLASH_BIT)? TRUE : FALSE;
	   f->log = (i & LOG_BIT)? TRUE : FALSE;
	   f->open = (i & OPEN_BIT)? TRUE : FALSE;
	   f->stamp = (i & STAMP_BIT)? TRUE : FALSE;
	   f->save = TRUE;
	   }
	else
	   f->save = FALSE;
	f->timeout = (stop == NULL)? 0 : (int) xv_get(contool_filters->filter_timeout, PANEL_VALUE);
	f->start = strsave(start);
	f->stop = strsave(stop);
	f->comment = strsave((char *) xv_get(contool_filters->comment, PANEL_VALUE));
	return(TRUE);
}

/************************************************************************/
EXPORT	Menu_item	edit_filters(item, op)

Menu_item	item;
Menu_generate	op;

{	Filter	*f, *curr;

	if (op == MENU_NOTIFY) {
	   xv_set(contool_base->base, FRAME_BUSY, TRUE, NULL);
	   if (contool_filters == NULL) {
	      contool_filters = contool_filters_objects_initialize(NULL, contool_base->base);
	      place_dialog(contool_base->base, contool_filters->filters);
	      xv_set(contool_filters->filter_list, PANEL_LIST_ROW_HEIGHT, 16, NULL);
	      single = (Server_image) xv_create((Frame) NULL, SERVER_IMAGE,
	      					   XV_WIDTH, 16,
	      					   XV_HEIGHT, 16,
	      					   SERVER_IMAGE_BITS, single_bits,
	      					0);
	      range  = (Server_image) xv_create((Frame) NULL, SERVER_IMAGE,
	      					   XV_WIDTH, 16,
	      					   XV_HEIGHT, 16,
	      					   SERVER_IMAGE_BITS, range_bits,
	      					0);
	      empty  = (Server_image) xv_create((Frame) NULL, SERVER_IMAGE,
	      					   XV_WIDTH, 16,
	      					   XV_HEIGHT, 16,
	      					   SERVER_IMAGE_BITS, empty_bits,
	      					0);
	      }
	   if (xv_get(contool_filters->filters, XV_SHOW) == FALSE) {
	      edit_set = duplicate_list(filters);
	      free_list(clipboard);
	      clipboard = NULL;
	      init_filters();
	      }
	   xv_set(contool_filters->filters, XV_SHOW, TRUE, NULL);
	   xv_set(contool_base->base, FRAME_BUSY, FALSE, NULL);
	   }
	return item;
}

/************************************************************************/
EXPORT	int	filter_notify(item, string, client_data, op, event)

Panel_item	item;
char		*string;
Xv_opaque	client_data;
Panel_list_op	op;
Event		*event;

{	
	if (op == PANEL_LIST_OP_DESELECT || op == PANEL_LIST_OP_SELECT)
	   update_controls();
	return XV_OK;
}

/************************************************************************/
EXPORT	Menu	filter_insert_handler(menu, op)

Menu		menu;
Menu_generate	op;

{
	xv_set(menu, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(contool_filters->filter_insert, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	return menu;
}

/************************************************************************/
EXPORT	Menu_item	insert_at_top(item, op)

Menu_item	item;
Menu_generate	op;

{
	xv_set(item, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(contool_filters->filter_insert, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_NOTIFY)
	   insert_item(0);
	return item;
}

/************************************************************************/
EXPORT	Menu_item	insert_above(item, op)

Menu_item	item;
Menu_generate	op;

{
	xv_set(item, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(contool_filters->filter_insert, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_DISPLAY)
	   xv_set(item, MENU_INACTIVE, selection_count() != 1, NULL);
	else if (op == MENU_NOTIFY)
	   insert_item(curr_selection());
	return item;
}

/************************************************************************/
EXPORT	Menu_item	insert_below(item, op)

Menu_item	item;
Menu_generate	op;

{
	xv_set(item, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(contool_filters->filter_insert, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_DISPLAY)
	   xv_set(item, MENU_INACTIVE, selection_count() != 1, NULL);
	else if (op == MENU_NOTIFY)
	   insert_item(curr_selection() + 1);
	return item;
}

/************************************************************************/
EXPORT	Menu_item	insert_at_bottom(item, op)

Menu_item	item;
Menu_generate	op;

{
	xv_set(item, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(contool_filters->filter_insert, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_NOTIFY)
	   insert_item(xv_get(contool_filters->filter_list, PANEL_LIST_NROWS));
	return item;
}

/************************************************************************/
EXPORT	Menu	filter_edit_handler(menu, op)

Menu		menu;
Menu_generate	op;

{
	xv_set(menu, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(contool_filters->filter_insert, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(xv_get(contool_filters->filter_edit, PANEL_ITEM_MENU), MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	return menu;
}

/************************************************************************/
EXPORT	Menu_item	filter_cut(item, op)

Menu_item	item;
Menu_generate	op;

{	int	i, total;
	Filter	*f, *prev, *curr = NULL;

	xv_set(item, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(contool_filters->filter_edit, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(xv_get(contool_filters->filter_edit, PANEL_ITEM_MENU), MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_DISPLAY)
	   xv_set(item, MENU_INACTIVE, selection_count() == 0, NULL);
	else if (op == MENU_NOTIFY) {
	   free_list(clipboard);
	   clipboard = NULL;
	   total = (int) xv_get(contool_filters->filter_list, PANEL_LIST_NROWS);
	   for (prev = NULL, f = edit_set, i = 0; i < total; i++, f = f->next)
	      if (xv_get(contool_filters->filter_list, PANEL_LIST_SELECTED, i)) {
	         if (clipboard == NULL)
	            clipboard = curr = f;
	         else {
	            curr->next = f;
	            curr = curr->next;
	            }
	         if (prev == NULL)
	            edit_set = f->next;
	         else
	            prev->next = f->next;
	         xv_set(contool_filters->filter_list,
	                   PANEL_LIST_DELETE, i,
	                   PANEL_PAINT, PANEL_NONE,
	                NULL);
	         i--;
	         total--;
	         }
	      else
	         prev = f;
	   xv_set(contool_filters->filter_list, PANEL_PAINT, PANEL_CLEAR, NULL);
	   if (curr)
	      curr->next = NULL;
	   update_controls();
	   xv_set(item, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	   }
	return item;
}

/************************************************************************/
EXPORT	Menu_item	filter_copy(item, op)

Menu_item	item;
Menu_generate	op;

{	int	i, total;
	Filter	*f, *curr;

	xv_set(item, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(contool_filters->filter_edit, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(xv_get(contool_filters->filter_edit, PANEL_ITEM_MENU), MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_DISPLAY)
	   xv_set(item, MENU_INACTIVE, selection_count() == 0, NULL);
	else if (op == MENU_NOTIFY) {
	   free_list(clipboard);
	   clipboard = NULL;
	   total = (int) xv_get(contool_filters->filter_list, PANEL_LIST_NROWS);
	   for (f = edit_set, i = 0; i < total; i++, f = f->next)
	      if (xv_get(contool_filters->filter_list, PANEL_LIST_SELECTED, i))
	         if (clipboard == NULL)
	            clipboard = curr = duplicate_filter(f);
	         else {
	            curr->next = duplicate_filter(f);
	            curr = curr->next;
	            }
	   curr->next = NULL;
	   xv_set(item, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	   }
	return item;
}

/************************************************************************/
EXPORT	Menu_item	filter_delete(item, op)

Menu_item	item;
Menu_generate	op;

{	int	i, total;
	Filter	*f, *prev, *temp = NULL, *curr;

	xv_set(item, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(contool_filters->filter_edit, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(xv_get(contool_filters->filter_edit, PANEL_ITEM_MENU), MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_DISPLAY)
	   xv_set(item, MENU_INACTIVE, selection_count() == 0, NULL);
	else if (op == MENU_NOTIFY) {
	   total = (int) xv_get(contool_filters->filter_list, PANEL_LIST_NROWS);
	   for (prev = NULL, f = edit_set, i = 0; i < total; i++, f = f->next)
	      if (xv_get(contool_filters->filter_list, PANEL_LIST_SELECTED, i)) {
	         if (temp == NULL)
	            temp = curr = f;
	         else {
	            curr->next = f;
	            curr = curr->next;
	            }
	         if (prev == NULL)
	            edit_set = f->next;
	         else
	            prev->next = f->next;
	         xv_set(contool_filters->filter_list,
	                   PANEL_LIST_DELETE, i,
	                   PANEL_PAINT, PANEL_NONE,
	                NULL);
	         i--;
	         total--;
	         }
	      else
	         prev = f;
	   xv_set(contool_filters->filter_list, PANEL_PAINT, PANEL_CLEAR, NULL);
	   if (curr)
	      curr->next = NULL;
	   free_list(temp);
	   update_controls();
	   xv_set(item, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	   }
	return item;
}

/************************************************************************/
EXPORT	Menu_item	filter_paste(item, op)

Menu_item	item;
Menu_generate	op;

{
	xv_set(xv_get(contool_filters->filter_edit, PANEL_ITEM_MENU), MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_DISPLAY)
	   xv_set(item, MENU_INACTIVE, clipboard == NULL, NULL);
	return item;
}

/************************************************************************/
EXPORT	Menu_item	paste_at_top(item, op)

Menu_item	item;
Menu_generate	op;

{
	xv_set(xv_get(contool_filters->filter_edit, PANEL_ITEM_MENU), MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_NOTIFY)
	   paste_items(0);
	return item;
}

/************************************************************************/
EXPORT	Menu_item	paste_above(item, op)

Menu_item	item;
Menu_generate	op;

{
	xv_set(xv_get(contool_filters->filter_edit, PANEL_ITEM_MENU), MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_DISPLAY)
	   xv_set(item, MENU_INACTIVE, selection_count() != 1, NULL);
	else if (op == MENU_NOTIFY)
	   paste_items(curr_selection());
	return item;
}

/************************************************************************/
EXPORT	Menu_item	paste_below(item, op)

Menu_item	item;
Menu_generate	op;

{
	xv_set(xv_get(contool_filters->filter_edit, PANEL_ITEM_MENU), MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_DISPLAY)
	   xv_set(item, MENU_INACTIVE, selection_count() != 1, NULL);
	else if (op == MENU_NOTIFY)
	   paste_items(curr_selection() + 1);
	return item;
}

/************************************************************************/
EXPORT	Menu_item	paste_at_bottom(item, op)

Menu_item	item;
Menu_generate	op;

{
	xv_set(xv_get(contool_filters->filter_edit, PANEL_ITEM_MENU), MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	if (op == MENU_NOTIFY)
	   paste_items((int) xv_get(contool_filters->filter_list, PANEL_LIST_NROWS));
	return item;
}

/************************************************************************/
EXPORT	void	filter_update(item, event)

Panel_item	item;
Event		*event;

{	int	i, curr;
	Filter	*f;

	xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);

	curr = curr_selection();
	for (i = 0, f = edit_set; i < curr; i++, f = f->next)
	   ;
	if (update_values(f, TRUE))
	   xv_set(contool_filters->filter_list,
		     PANEL_LIST_STRING, curr, f->start,
		     PANEL_LIST_GLYPH,  curr, f->stop? range : single,
	          NULL);
}

/************************************************************************/
EXPORT	void	set_filter_type(item, value, event)

Panel_item	item;
int		value;
Event		*event;

{
	xv_set(contool_filters->stop, PANEL_INACTIVE, value == 0, NULL);
	xv_set(contool_filters->filter_timeout, PANEL_INACTIVE, value == 0, NULL);
	xv_set(contool_filters->filter_timeout_units, PANEL_INACTIVE, value == 0, NULL);
}

/************************************************************************/
EXPORT	void	set_filter_action(item, value, event)

Panel_item	item;
int		value;
Event		*event;

{	contool_filters_objects	*ip = (contool_filters_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	if (value == 0) { /* save this message */
	   xv_set(ip->action,            PANEL_INACTIVE, FALSE, NULL);
	   xv_set(ip->filter_beep_count, PANEL_INACTIVE, !((int) xv_get(ip->action, PANEL_VALUE) & BEEP_BIT), NULL);
	   xv_set(ip->filter_beep_times, PANEL_INACTIVE, !((int) xv_get(ip->action, PANEL_VALUE) & BEEP_BIT), NULL);
	   xv_set(ip->filter_command,    PANEL_INACTIVE, !((int) xv_get(ip->action, PANEL_VALUE) & COMMAND_BIT), NULL);
	   }
	else { /* ignore this message */
	   xv_set(ip->action,            PANEL_INACTIVE, TRUE, NULL);
	   xv_set(ip->filter_beep_count, PANEL_INACTIVE, TRUE, NULL);
	   xv_set(ip->filter_beep_times, PANEL_INACTIVE, TRUE, NULL);
	   xv_set(ip->filter_command,    PANEL_INACTIVE, TRUE, NULL);
	   }
}

/************************************************************************/
EXPORT	void	set_match_action(item, value, event)

Panel_item	item;
unsigned int	value;
Event		*event;

{	contool_filters_objects	*ip = (contool_filters_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	xv_set(ip->filter_beep_count, PANEL_INACTIVE, !(value & BEEP_BIT), NULL);
	xv_set(ip->filter_beep_times, PANEL_INACTIVE, !(value & BEEP_BIT), NULL);
	xv_set(ip->filter_command,    PANEL_INACTIVE, !(value & COMMAND_BIT), NULL);
}

/************************************************************************/
EXPORT	void	filter_done(frame)

Frame		frame;

{
	free_list(edit_set);
	edit_set = NULL;
	free_list(clipboard);
	clipboard = NULL;
	xv_set(frame, XV_SHOW, FALSE, 0);
}

/************************************************************************/
PRIVATE	int	check_for_update()

{	int	i, result, curr, diff = FALSE;
	Filter	*f, new;

	if (selection_count() != 1)
	   return(TRUE);
	curr = curr_selection();
	for (i = 0, f = edit_set; i < curr; i++, f = f->next)
	   ;
	new = *f;
	if (update_values(&new, FALSE) == FALSE)
	   diff = TRUE;
	else if ((f->start != NULL && new.start == NULL) || (f->start == NULL && new.start != NULL))
	   diff = TRUE;
	else if ((f->stop != NULL && new.stop == NULL) || (f->stop == NULL && new.stop != NULL))
	   diff = TRUE;
	else if ((f->comment != NULL && new.comment == NULL) || (f->comment == NULL && new.comment != NULL))
	   diff = TRUE;
	else if ((f->command != NULL && new.command == NULL) || (f->command == NULL && new.command != NULL))
	   diff = TRUE;
	else if (new.stop && f->timeout != new.timeout)
	   diff = TRUE;
	else if (f->save != new.save || f->beep != new.beep || f->flash != new.flash || f->log != new.log || f->open != new.open || f->stamp != new.stamp)
	   diff = TRUE;
	else if (f->start && strcmp(f->start, new.start) != 0)
	   diff = TRUE;
	else if (f->stop && strcmp(f->stop, new.stop) != 0)
	   diff = TRUE;
	else if (f->comment && strcmp(f->comment, new.comment) != 0)
	   diff = TRUE;
	else if (f->command && strcmp(f->command, new.command) != 0)
	   diff = TRUE;
	if (diff) {
	   result = notice_prompt(contool_base->base, NULL,
	   			     NOTICE_MESSAGE_STRINGS,
	   			        "You have modified the attributes of the selected filter.",
	   			        " ",
	   			        "Do you wish to perform an Update before doing an Apply?",
	   			        NULL,
	   			     NOTICE_BUTTON_YES, "Update, then Apply",
	   			     NOTICE_BUTTON_NO, "Apply",
	   			     NOTICE_BUTTON, "Cancel", 101,
	   			  NULL);
	   if (result == NOTICE_YES)
	      filter_update(contool_filters->filters, NULL);
	   return(result != 101);
	   }
	return(TRUE);
}

/************************************************************************/
EXPORT	void	accept_filters(item, event)

Panel_item	item;
Event		*event;

{	Filter	*f;
	int	i, total;
	char	*msg = NULL;

	xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);

	if (!check_for_update())
	   return;

	total = (int) xv_get(contool_filters->filter_list, PANEL_LIST_NROWS);
	for (i = 0; i < total; i++)
	   if (xv_get(contool_filters->filter_list, PANEL_LIST_SELECTED, i))
	      xv_set(contool_filters->filter_list, PANEL_LIST_SELECT, i, FALSE, NULL);
	update_controls();
	for (f = edit_set, i = 0; f; f = f->next, i++)
	   if (is_empty(f->start) || (msg = compile_exp(f, f->start, f->stop))) {
	      xv_set(contool_filters->filter_list, PANEL_LIST_SELECT, i, TRUE, NULL);
	      update_controls();
	      error(msg? msg : "No pattern is specified for the indicated filter");
	      return;
	      }
	free_list(filters);
	filters = edit_set;
	if (xv_get(contool_filters->filters, FRAME_CMD_PUSHPIN_IN))
	   edit_set = duplicate_list(filters);
	else {
	   edit_set = NULL;
	   free_list(clipboard);
	   clipboard = NULL;
	   }
	filters_changed();
	xv_set(item, PANEL_NOTIFY_STATUS, XV_OK, NULL);
}

/************************************************************************/
EXPORT	void	accept_and_save_filters(item, event)

Panel_item	item;
Event		*event;

{
	accept_filters(item, event);
	if (xv_get(item, PANEL_NOTIFY_STATUS) == XV_OK)
	   if (!store_filters_to_file(filter_file, TRUE, TRUE))
	      xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
}

/************************************************************************/
EXPORT	void	reset_filters(item, event)

Panel_item	item;
Event		*event;

{
	init_filters();
	xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
}
