/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

/************************************************************************/
/*									*/
/*	contool.h	internal contool data structures		*/
/*									*/
/************************************************************************/

#define		is_null(x)		((x)? x : "")

#define		BEEP_BIT		0x01
#define		COMMAND_BIT		0x02
#define		FLASH_BIT		0x04
#define		LOG_BIT			0x08
#define		OPEN_BIT		0x10
#define		STAMP_BIT		0x20

#define		ARCHIVE_MANUALLY	0
#define		ARCHIVE_ON_CLOSE	1

#define		CONTOOL_LABEL		"CONTOOL_LABEL"
#define		CONTOOL_LOGNAME		"CONTOOL_LOGNAME"
#define		CONTOOL_FILTERS		"CONTOOL_FILTERS"

#define		FILTER_VERSION		330

typedef	struct	filter	Filter;
typedef	struct	props	Props;

struct	filter	{char	*start;
		 char	*start_re;
		 int	start_circf;
		 char	*stop;
		 char	*stop_re;
		 int	stop_circf;
		 char	*comment;
		 int	save;
		 int	beep;
		 int	flash;
		 int	log;
		 int	open;
		 int	stamp;
		 int	timeout;
		 char	*command;
		 Filter	*next;
		};

struct	props	{int	beep;
		 int	flash;
		 int	log;
		 int	open;
		 int	stamp;
		 char	*command;
		 char	*good_icon;
		 char	*good_icon_mask;
		 char	*bad_icon;
		 char	*bad_icon_mask;
		 char	*flash_icon;
		 char	*flash_icon_mask;
		 char	*print_filter;
		 char	*log_file;
		 int	log_after;
		 int	archive_style;
		 int	stamp_resolution;
		 int	max_size;
		 int	delete_amount;
		};

PUBLIC	char	*compile_exp();
PUBLIC	char	*expand_tilde();

PUBLIC	Props	defaults;
PUBLIC	Props	*parsed_defaults;
PUBLIC	Filter	*parsed_filters;
PUBLIC	Filter	*filters;
PUBLIC	int	parse_errors_occured;
PUBLIC	char	*filter_file;
PUBLIC	int	filter_version;
