// This file generated by clo++, do not edit.
#ifndef __Clo_Parser__
#define __Clo_Parser__
#include <exception>
#include <vector>
#include <string>
#include <cstring>

// Use namespaces to keep things clean.
namespace Clo {
	using namespace std;
	const string k_usage =
		"-h, --help"
		"       this message\n"
		"-t, --test-flag"
		"  when true, this file will self-destruct\n"
		; // end of k_usage
	
	class Parser {
		public:
			void parse(int argc, char *argv[]);
			string usage() {return k_usage;}
			vector<string> &get_file_list() {return m_file_list;}
			bool get_flag_option(string option);
		private:
			struct Values {
				bool v_test_flag;
			};
			
			enum State {
				state_option,
				state_value
			};
			
			vector<string> m_file_list;
			Values m_values;
	}; // End class
	
	class Exception : public exception {
		public:
			Exception(int argc, char *argv[], int which, string why) {
				int count=-1; size_t offset=0, length=0; m_why = why;
				while (++count < argc) {
					if (which == count) length = strlen(argv[count]);
					if (!length) offset += strlen(argv[count]) + 1;
					m_fancy += argv[count]; m_fancy += ' ';
				}
				m_fancy += '\n';
				for (count=0; count < offset; count++) m_fancy += ' ';
				for (count=0; count < length; count++) m_fancy += '^';
				m_fancy += '\n'; m_fancy += why;
				autohelp = autoversion = false;
			} // end constructor
			Exception(string why) {m_why = why; autohelp=autoversion=false;}
			const char *what() {return m_why.c_str();}
			const char *fancy() {if(m_fancy.empty()) return m_why.c_str(); else return m_fancy.c_str();}
			bool autohelp, autoversion;
		private:
			string m_why, m_fancy;
	}; // end Exception
	
	void Parser::parse(int argc, char *argv[]) {
		State  state = state_option;
		int    option_c = 0;
		string option_v;
		string option_passon;
		
		struct Found {
			bool v_test_flag;
		} found_list;
		
		found_list.v_test_flag = false;
		
		// setup defaults
		m_values.v_test_flag = false;
		
		while (++option_c < argc) {
			if (option_v.empty()) option_v = argv[option_c];
			// a double dash will end command line processing
			// and place remaining command line options in the filename vector
			if (option_v == "--") {
				if (state == state_option) {
					while (++option_c < argc) m_file_list.push_back(argv[option_c]);
					break; // leave main while loop
				} else {
					throw Exception("missing value for '" + option_passon + "'\n");
				}
			}
			if (state == state_option) {
				if (option_v.size() > 1 && option_v.substr(0, 2) == "--") {
					option_v.erase(0, 2);
					// some temp variables
					string::size_type eq = option_v.find('=');
					string            tmp_value;
					
					if (eq != string::npos) {
						tmp_value = option_v.substr(eq + 1);
						option_v.erase(eq);
					}
					
					if (option_v == "test-flag") {
						if (tmp_value.size()) throw Exception(argc, argv, option_c, "--test-flag option does not take an argument\n");
						m_values.v_test_flag = true;
						option_v.erase(); continue;
						found_list.v_test_flag = true;
						continue;
					} else if (option_v == "help") {
						Exception e(k_usage); e.autohelp=true; throw e;
					} else {
						throw Exception(argc, argv, option_c, "option --" + option_v + " is not valid\n(for usage information try the --help option)\n");
					}
				} else if (option_v.size() > 1 && option_v[0] == '-') {
					option_v.erase(0, 1);
					while (option_v.size()) {
						if (option_v[0] == 't') {
							found_list.v_test_flag = true;
							option_v.erase(0, 1);
							m_values.v_test_flag = true;
						} else if (option_v[0] == 'h') {
							Exception e(k_usage); e.autohelp=true; throw e;
						} else {
							option_v.erase(1);
							throw Exception(argc, argv, option_c, "option -" + option_v + " is not valid\n");
						}
					}
				} else {
					m_file_list.push_back(option_v);
					option_v.erase();
				}
			} else if (state == state_value) {
				state = state_option;
				option_v.erase();
			}
		} // end parse() while loop
		if (state == state_value) throw Exception("missing value for '" + option_passon + "'\n");
		
	} // End parse()
	bool Parser::get_flag_option(string option) {
		if (option == "test-flag") {
			return m_values.v_test_flag;
		} else {
			throw Exception("option '" + option + "' is not a bool option\n");
		}
	} // End get_flag_option()
} // End namespace
#endif
