/*
 *
 * CLEX File Manager
 *
 * Copyright (C) 1997-2000 Tempest s.r.o. http://www.tempest.sk
 * Copyright (C) 2001-2004 Vlado Potisk <vlado_potisk@clex.sk>
 *
 * CLEX is free software without warranty of any kind; see the
 * GNU General Public License as set out in the "COPYING" document
 * which accompanies the CLEX File Manager package.
 *
 * CLEX can be downloaded from http://www.clex.sk
 *
 */

#include <config.h>

#include <sys/types.h>			/* clex.h */
#include <string.h>				/* strcmp() */

#include "clex.h"
#include "undo.h"

#include "edit.h"				/* edit_update() */
#include "inout.h"				/* win_remark() */
#include "ustring.h"			/* USTRING */

static TEXTLINE *current;
static USTRING undo_line = { 0,0 };
static int undo_size, undo_curs, undo_offset;

/* make a copy of 'textline' before an edit operation */
void
undo_before(void)
{
	if (textline == 0)
		return;

	current = textline;

	us_copy(&undo_line,USTR(textline->line));
	undo_size   = textline->size;
	undo_curs   = textline->curs;
	undo_offset = textline->offset;
}

/* compare the saved copy with the 'textline' after an operation */
void
undo_after(void)
{
	if (textline == 0 || textline != current)
		return;

	if (textline->size != undo_size
	  || strcmp(USTR(textline->line),USTR(undo_line))) {
		/* textline was modified */
		textline->undo_possible = 1;
		us_copy(&textline->save_line,USTR(undo_line));
		textline->save_size   = undo_size;
		textline->save_curs   = undo_curs;
		textline->save_offset = undo_offset;
	}
}

void
cx_undo(void)
{
	if (textline == 0)
		return;
	if (!textline->undo_possible) {
		win_remark("undo not possible");
		return;
	}

	current = 0;	/* prevent undo of undo */

	textline->undo_possible = 0;
	us_copy(&textline->line,USTR(textline->save_line));
	textline->size   = textline->save_size;
	textline->curs   = textline->save_curs;
	textline->offset = textline->save_offset;
	edit_update();
}
