<?php

/*
 * $Horde: chora/diff.php,v 1.43.2.4 2002/03/20 20:30:04 chuck Exp $
 *
 * Copyright 2000-2002 Anil Madhavapeddy <anil@recoil.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('CHORA_BASE', dirname(__FILE__));
require_once CHORA_BASE . '/lib/base.php';

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

if (Chora::isRestricted($where)) {
    fatal('403 Forbidden', "$where: forbidden by server configuration");
}

/* Spawn the repository and file objects */

$fl = new CVSLib_File($CVS, $CVS->cvsRoot() . '/' . $where);
checkError($fl->getBrowseInfo());

/* Initialise the form variables correctly.
 * If r1/r2 are empty, then use the corresponding text field instead */

$r1 = Horde::getFormData('r1', 0);
$r2 = Horde::getFormData('r2', 0);

if (!$r1) $r1 = Horde::getFormData('tr1');
if (!$r2) $r2 = Horde::getFormData('tr2');

/* If no context-size has been specified, default to 3. */
$num = Horde::getFormData('num', 3);

/* If no type has been specified, then default to human readable. */
$ty = Horde::getFormData('ty', 'h');

/* Unless otherwise specified, show whitespace differences. */
$ws = Horde::getFormData('ws', 1);

/* Figure out what type of diff has been requested */
switch ($ty) {
case 'u':
    $type = CVSLIB_DIFF_UNIFIED;
    break;
case 'h':
    $type = CVSLIB_DIFF_UNIFIED;
    break;
case 's':
    $type = CVSLIB_DIFF_COLUMN;
    break;
case 'c':
    $type = CVSLIB_DIFF_CONTEXT;
    break;
case 'e':
    $type = CVSLIB_DIFF_ED;
    break;
default:
    $type = CVSLIB_DIFF_UNIFIED;
    break;
}

/* Ensure that we have valid revision numbers */
if (!CVSLib_Rev::valid($r1) || !CVSLib_Rev::valid($r2)) {
    checkError(new CVSLib_Error(CVSLIB_NOT_FOUND, 'Malformed Query'));
}

/* Cache the output of the diff for a week - it can be longer, since
 * it should never change */

Header('Cache-Control: max-age=604800');

/* All is ok, proceed with the diff */
/* A plain-text diff */
if ($ty != 'h') {
    header("Content-Type: text/plain\n\n");
    echo implode("\n", CVSLib_Diff::get($CVS, $fl, $r1, $r2, $type, $num, $ws));

/* Human-Readable diff */
} else {
  
    /* Output standard header information for the page */
    $filename = preg_replace('/^.*\//', '', $where);
    $pathname = preg_replace('/[^\/]*$/', '', $where);
    $title = sprintf(_("Diff for %s between version %s and %s"), Text::htmlallspaces($where), $r1, $r2);

    $log = $fl->logs[$r2];
    $log_print = htmlify($log->queryLog());

    $js_onLoad = null;
    include CHORA_TEMPLATES . '/common-header.inc';
    include CHORA_TEMPLATES . '/diff/hr/header.inc';

    /* Retrieve the tree of changes from CVSLib */
    $lns = CVSLib_Diff::humanReadable(
           CVSLib_Diff::get($CVS, $fl, $r1, $r2, CVSLIB_DIFF_UNIFIED, $num, $ws));
    /* TODO: check for errors here (CVSLib_Error returned) - avsm */
    /* Is the diff empty? */
    if (!sizeof($lns)) {
        include CHORA_TEMPLATES.'/diff/hr/nochange.inc';
    } else {
        /* Iterate through every header block of changes */
        foreach ($lns as $header) {
            $lefthead = Text::htmlspaces(@$header['oldline']);
            $righthead = Text::htmlspaces(@$header['newline']);
            $headfunc = Text::htmlspaces(@$header['function']);
            include CHORA_TEMPLATES.'/diff/hr/row.inc';
            
            /* Each header block consists of a number of changes (add, remove, change) */
            foreach ($header['contents'] as $change) {
                switch ($change['type']) {
                case CVSLIB_DIFF_ADD:
                    foreach ($change['lines'] as $line) {
                        $line = Text::htmlspaces($line);
                        include CHORA_TEMPLATES.'/diff/hr/add.inc';
                    }
                    break;
                case CVSLIB_DIFF_REMOVE:
                    foreach ($change['lines'] as $line) {
                        $line = Text::htmlspaces($line);
                        include CHORA_TEMPLATES.'/diff/hr/remove.inc';
                    }
                    break;
                case CVSLIB_DIFF_EMPTY:
                    $line = Text::htmlspaces($change['line']);
                    include CHORA_TEMPLATES.'/diff/hr/empty.inc';
                    break;
                case CVSLIB_DIFF_CHANGE:
                    /* Pop the old/new stacks one by one, until both are empty */
                    while (sizeof($change['old']) || sizeof($change['new'])) {
                        if ($left = array_shift($change['old'])) {
                            $left = Text::htmlspaces($left);
                        }
                        if ($right = array_shift($change['new'])) {
                            $right = Text::htmlspaces($right);
                        }
                        include CHORA_TEMPLATES.'/diff/hr/change.inc';
                    }
                    break;
                }
            }
        }
    }

    /* print legend */
    include CHORA_TEMPLATES . '/diff/hr/footer.inc';
    include CHORA_TEMPLATES . '/common-footer.inc';
}

?>
