/* Generated from posixwin.scm by the Chicken compiler
   2006-10-04 09:03
   Version 2.5rc1 - linux-unix-gnu-x86 - [ libffi dload ptables applyhook ]
   command line: posixwin.scm -output-file posixwin.c -quiet -no-trace -optimize-level 2 -include-path . -explicit-use
   unit: posix
*/

#include "chicken.h"

#ifndef WIN32_LEAN_AND_MEAN
# define WIN32_LEAN_AND_MEAN
#endif

/*
MinGW should have winsock2.h and ws2tcpip.h as well.
The CMake build will set HAVE_WINSOCK2_H and HAVE_WS2TCPIP_H.
However, the _MSC_VER test is still needed for vcbuild.bat.
./configure doesn't test for these.  It should, for MinGW.
*/
#if (_MSC_VER > 1300) || (defined(HAVE_WINSOCK2_H) && defined(HAVE_WS2TCPIP_H))
#include <winsock2.h>
#include <ws2tcpip.h>
#else
#include <winsock.h>
#endif

#include <errno.h>
#include <io.h>
#include <stdio.h>
#include <process.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <direct.h>

#include <time.h>

#define ARG_MAX 256
#define PIPE_BUF 512

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS struct stat C_statbuf;
/* pipe handles */
static C_TLS HANDLE C_rd0, C_wr0, C_wr0_, C_rd1, C_wr1, C_rd1_;
static C_TLS HANDLE C_save0, C_save1; /* saved I/O handles */
static C_TLS char C_rdbuf; /* one-char buffer for read */
static C_TLS int C_exstatus;

static C_TLS char C_hostname[256];
static C_TLS char C_osver[16];
static C_TLS char C_osrel[16];
static C_TLS char C_processor[16];

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str)))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#ifndef __WATCOMC__
/* DIRENT stuff */
struct dirent
{
    char *		d_name;
};

typedef struct
{
    struct _finddata_t	fdata;
    int			handle;
    struct dirent	current;
} DIR;

static DIR *opendir(const char *name);
static int closedir(DIR *dir);
static struct dirent *readdir(DIR *dir);

static DIR *opendir(const char *name)
{
    int name_len = strlen(name);
    DIR *dir = (DIR *)malloc(sizeof(DIR));
    char *what;
    if (!dir)
    {
	errno = ENOMEM;
	return NULL;
    }
    what = (char *)malloc(name_len + 3);
    if (!what)
    {
	free(dir);
	errno = ENOMEM;
	return NULL;
    }
    strcpy(what, name);
    if (strchr("\\/", name[name_len - 1]))
	strcat(what, "*");
    else
	strcat(what, "\\*");

    dir->handle = _findfirst(what, &dir->fdata);
    if (dir->handle == -1)
    {
	free(what);
	free(dir);
	return NULL;
    }
    dir->current.d_name = NULL; /* as the first-time indicator */
    free(what);
    return dir;
}
static int closedir(DIR * dir)
{
    if (dir)
    {
	int res = _findclose(dir->handle);
	free(dir);
	return res;
    }
    return -1;
}
static struct dirent *readdir(DIR * dir)
{
    if (dir)
    {
	if (!dir->current.d_name /* first time after opendir */
	     || _findnext(dir->handle, &dir->fdata) != -1)
	{
	    dir->current.d_name = dir->fdata.name;
	    return &dir->current;
	}
    }
    return NULL;
}
#endif /* ifndef __WATCOMC__ */

#ifdef __WATCOMC__
# define mktemp _mktemp
/* there is no P_DETACH in Watcom CRTL */
# define P_DETACH P_NOWAIT
#endif

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)   	(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name),	C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, _popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, _popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(_pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_getpid            getpid
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_pipe(d)           C_fix(_pipe(C_pipefds, PIPE_BUF, O_BINARY))
#define C_close(fd)         C_fix(close(C_unfix(fd)))

#define C_getenventry(i)   environ[ i ]

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);				       
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}

static void C_fcall C_set_exec_arg(int i, char *a, int len);
void C_fcall C_set_exec_arg(int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  C_exec_args[ i ] = ptr;
}

static void C_fcall C_free_exec_args();
void C_fcall C_free_exec_args() {
  char **a = C_exec_args;
  while((*a) != NULL) C_free(*(a++));
}

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))

/* MS replacement for the fork-exec pair */
#define C_spawnvp(m, f)	    C_fix(spawnvp(C_unfix(m), C_data_pointer(f), C_exec_args))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mktemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
#define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = mktime(&C_tm)) != -1)

/* mapping from Win32 error codes to errno */
typedef struct
{
    DWORD   win32;
    int	    libc;
} errmap_t;
static errmap_t errmap[] =
{
    {ERROR_INVALID_FUNCTION,      EINVAL},
    {ERROR_FILE_NOT_FOUND,        ENOENT},
    {ERROR_PATH_NOT_FOUND,        ENOENT},
    {ERROR_TOO_MANY_OPEN_FILES,   EMFILE},
    {ERROR_ACCESS_DENIED,         EACCES},
    {ERROR_INVALID_HANDLE,        EBADF},
    {ERROR_ARENA_TRASHED,         ENOMEM},
    {ERROR_NOT_ENOUGH_MEMORY,     ENOMEM},
    {ERROR_INVALID_BLOCK,         ENOMEM},
    {ERROR_BAD_ENVIRONMENT,       E2BIG},
    {ERROR_BAD_FORMAT,            ENOEXEC},
    {ERROR_INVALID_ACCESS,        EINVAL},
    {ERROR_INVALID_DATA,          EINVAL},
    {ERROR_INVALID_DRIVE,         ENOENT},
    {ERROR_CURRENT_DIRECTORY,     EACCES},
    {ERROR_NOT_SAME_DEVICE,       EXDEV},
    {ERROR_NO_MORE_FILES,         ENOENT},
    {ERROR_LOCK_VIOLATION,        EACCES},
    {ERROR_BAD_NETPATH,           ENOENT},
    {ERROR_NETWORK_ACCESS_DENIED, EACCES},
    {ERROR_BAD_NET_NAME,          ENOENT},
    {ERROR_FILE_EXISTS,           EEXIST},
    {ERROR_CANNOT_MAKE,           EACCES},
    {ERROR_FAIL_I24,              EACCES},
    {ERROR_INVALID_PARAMETER,     EINVAL},
    {ERROR_NO_PROC_SLOTS,         EAGAIN},
    {ERROR_DRIVE_LOCKED,          EACCES},
    {ERROR_BROKEN_PIPE,           EPIPE},
    {ERROR_DISK_FULL,             ENOSPC},
    {ERROR_INVALID_TARGET_HANDLE, EBADF},
    {ERROR_INVALID_HANDLE,        EINVAL},
    {ERROR_WAIT_NO_CHILDREN,      ECHILD},
    {ERROR_CHILD_NOT_COMPLETE,    ECHILD},
    {ERROR_DIRECT_ACCESS_HANDLE,  EBADF},
    {ERROR_NEGATIVE_SEEK,         EINVAL},
    {ERROR_SEEK_ON_DEVICE,        EACCES},
    {ERROR_DIR_NOT_EMPTY,         ENOTEMPTY},
    {ERROR_NOT_LOCKED,            EACCES},
    {ERROR_BAD_PATHNAME,          ENOENT},
    {ERROR_MAX_THRDS_REACHED,     EAGAIN},
    {ERROR_LOCK_FAILED,           EACCES},
    {ERROR_ALREADY_EXISTS,        EEXIST},
    {ERROR_FILENAME_EXCED_RANGE,  ENOENT},
    {ERROR_NESTING_NOT_ALLOWED,   EAGAIN},
    {ERROR_NOT_ENOUGH_QUOTA,      ENOMEM},
    {0, 0}
};

static void set_errno(DWORD w32err)
{
    errmap_t *map = errmap;
    for (; errmap->win32; ++map)
    {
	if (errmap->win32 == w32err)
	{
	    errno = errmap->libc;
	    return;
	}
    }
}

/* functions for creating process with redirected I/O */
static int zero_handles()
{
    C_rd0 = C_wr0 = C_wr0_ = INVALID_HANDLE_VALUE;
    C_rd1 = C_wr1 = C_rd1_ = INVALID_HANDLE_VALUE;
    C_save0 = C_save1 = INVALID_HANDLE_VALUE;
    return 1;
}
static int close_handles()
{
    if (C_rd0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd0);
    if (C_rd1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1);
    if (C_wr0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0);
    if (C_wr1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr1);
    if (C_rd1_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1_);
    if (C_wr0_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0_);
    if (C_save0 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	CloseHandle(C_save0);
    }
    if (C_save1 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	CloseHandle(C_save1);
    }
    return zero_handles();
}
static int redir_io()
{
    SECURITY_ATTRIBUTES sa;
    sa.nLength = sizeof(SECURITY_ATTRIBUTES);
    sa.bInheritHandle = TRUE;
    sa.lpSecurityDescriptor = NULL;

    zero_handles();

    C_save0 = GetStdHandle(STD_INPUT_HANDLE);
    C_save1 = GetStdHandle(STD_OUTPUT_HANDLE);
    if (!CreatePipe(&C_rd0, &C_wr0, &sa, 0)
	    || !SetStdHandle(STD_INPUT_HANDLE, C_rd0)
	    || !DuplicateHandle(GetCurrentProcess(), C_wr0, GetCurrentProcess(),
		&C_wr0_, 0, FALSE, DUPLICATE_SAME_ACCESS)
	    || !CreatePipe(&C_rd1, &C_wr1, &sa, 0)
	    || !SetStdHandle(STD_OUTPUT_HANDLE, C_wr1)
	    || !DuplicateHandle(GetCurrentProcess(), C_rd1, GetCurrentProcess(),
		&C_rd1_, 0, FALSE, DUPLICATE_SAME_ACCESS))
    {
	set_errno(GetLastError());
	close_handles();
	return 0;
    }

    CloseHandle(C_wr0);
    C_wr0 = INVALID_HANDLE_VALUE;
    CloseHandle(C_rd1);
    C_rd1 = INVALID_HANDLE_VALUE;
    return 1;
}
static int run_process(char *cmdline)
{
    PROCESS_INFORMATION pi;
    STARTUPINFO si;

    ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
    ZeroMemory(&si, sizeof(STARTUPINFO));
    si.cb = sizeof(STARTUPINFO);

    C_wr0_ = C_rd1_ = INVALID_HANDLE_VALUE; /* these handles are saved */

    if (CreateProcess(NULL, cmdline, NULL, NULL, TRUE, 0, NULL,
		NULL, &si, &pi))
    {
	CloseHandle(pi.hThread);

	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	C_save0 = C_save1 = INVALID_HANDLE_VALUE;

	CloseHandle(C_rd0);
	CloseHandle(C_wr1);
	C_rd0 = C_wr1 = INVALID_HANDLE_VALUE;
	return (int)pi.hProcess;
    }
    else
    {
	set_errno(GetLastError());
	return 0;
    }
}
static int pipe_write(int hpipe, void* buf, int count)
{
    DWORD done = 0;
    if (WriteFile((HANDLE)hpipe, buf, count, &done, NULL))
	return 1;
    else
    {
	set_errno(GetLastError());
	return 0;
    }
}
static int pipe_read(int hpipe)
{
    DWORD done = 0;
    /* TODO:
    if (!pipe_ready(hpipe))
	go_to_sleep;
    */
    if (ReadFile((HANDLE)hpipe, &C_rdbuf, 1, &done, NULL))
    {
	if (done > 0) /* not EOF yet */
	    return 1;
	else
	    return -1;
    }
    set_errno(GetLastError());
    return 0;
}
static int pipe_ready(int hpipe)
{
    DWORD avail = 0;
    if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL) && avail)
	return 1;
    else 
    {
	Sleep(0); /* give pipe a chance */
	if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL))
	    return (avail > 0);
	else
	    return 0;
    }
}

#define C_zero_handles() C_fix(zero_handles())
#define C_close_handles() C_fix(close_handles())
#define C_redir_io() (redir_io() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_run_process(cmdline) C_fix(run_process(C_c_string(cmdline)))
#define C_pipe_write(h, b, n) (pipe_write(C_unfix(h), C_c_string(b), C_unfix(n)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_pipe_read(h) C_fix(pipe_read(C_unfix(h)))
#define C_pipe_ready(h) (pipe_ready(C_unfix(h)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define close_handle(h) CloseHandle((HANDLE)h)

int process_wait(int h, int t)
{   
    if (WaitForSingleObject((HANDLE)h, (t ? 0 : INFINITE)) == WAIT_OBJECT_0)
    {
	DWORD ret;
	if (GetExitCodeProcess((HANDLE)h, &ret))
	{
	    CloseHandle((HANDLE)h);
	    C_exstatus = ret;
	    return 1;
	}
    }
    set_errno(GetLastError());
    return 0;
}

#define C_process_wait(p, t) (process_wait(C_unfix(p), C_truep(t)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sleep(t) (Sleep(C_unfix(t) * 1000), C_SCHEME_UNDEFINED)

int get_hostname()
{
    WSADATA wsa;
    if (WSAStartup(MAKEWORD(1, 1), &wsa) == 0)
    {
	int nok = gethostname(C_hostname, 256);
	WSACleanup();
	return !nok;
    }
    return 0;
}

int sysinfo()
{
    OSVERSIONINFO ovf;
    ZeroMemory(&ovf, sizeof(ovf));
    ovf.dwOSVersionInfoSize = sizeof(ovf);
    if (get_hostname() && GetVersionEx(&ovf))
    {
	SYSTEM_INFO si;
	_snprintf(C_osver, sizeof(C_osver) - 1, "%d.%d.%d", 
			   ovf.dwMajorVersion, ovf.dwMinorVersion, ovf.dwBuildNumber);
	switch (ovf.dwPlatformId)
	{
	case VER_PLATFORM_WIN32s:
	    strncpy(C_osrel, "Win32s", sizeof(C_osrel) - 1);
	    break;
	case VER_PLATFORM_WIN32_WINDOWS:
	    strncpy(C_osrel, "Win9x", sizeof(C_osrel) - 1);
	    break;
	case VER_PLATFORM_WIN32_NT:
	default:
	    strncpy(C_osrel, "WinNT", sizeof(C_osrel) - 1);
	    break;
	}
	GetSystemInfo(&si);
	switch (si.wProcessorArchitecture)
	{
    	case PROCESSOR_ARCHITECTURE_INTEL:
	    strncpy(C_processor, "Intel", sizeof(C_processor) - 1);
	    break;
    	case PROCESSOR_ARCHITECTURE_UNKNOWN:
	default:
	    strncpy(C_processor, "Unknown", sizeof(C_processor) - 1);
	    break;
	}
	return 1;
    }
    set_errno(GetLastError());
    return 0;
}

#define C_get_hostname() (get_hostname() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sysinfo() (sysinfo() ? C_SCHEME_TRUE : C_SCHEME_FALSE)


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[364];


/* from close-handle in k717 in k714 in k711 in k708 in k705 */
static C_word C_fcall stub466(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub466(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_truep(C_a0);
C_r=C_fix((C_word)close_handle(t0));
return C_r;}

/* from get-shell in k717 in k714 in k711 in k708 in k705 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub457(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub457(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
    char *ret = getenv("COMSPEC");
    if (ret)
	return (ret);
    else
    {
	OSVERSIONINFO ovf;
	ovf.dwOSVersionInfoSize = sizeof(ovf);
	if (GetVersionEx(&ovf) && (ovf.dwPlatformId == VER_PLATFORM_WIN32_NT))
	    return ("cmd.exe");
	else
	    return ("command.com");
    }
C_return:
#undef return

return C_r;}

/* from current-process-id in k717 in k714 in k711 in k708 in k705 */
static C_word C_fcall stub455(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub455(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeargs */
static C_word C_fcall stub431(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub431(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k2562 */
static C_word C_fcall stub424(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub424(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub379(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub379(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k2399 */
static C_word C_fcall stub372(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub372(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k2198 */
static C_word C_fcall stub323(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub323(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from asctime */
static C_word C_fcall stub309(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub309(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k2119 */
static C_word C_fcall stub300(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub300(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k2026 */
static C_word C_fcall stub283(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub283(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_707)
static void C_ccall f_707(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_710)
static void C_ccall f_710(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_713)
static void C_ccall f_713(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_716)
static void C_ccall f_716(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_719)
static void C_ccall f_719(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2943)
static void C_ccall f_2943(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2943)
static void C_ccall f_2943r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3100)
static void C_fcall f_3100(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3106)
static void C_ccall f_3106(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3095)
static void C_fcall f_3095(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3090)
static void C_fcall f_3090(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2945)
static void C_fcall f_2945(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3077)
static void C_ccall f_3077(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3085)
static void C_ccall f_3085(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2952)
static void C_fcall f_2952(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3065)
static void C_ccall f_3065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2962)
static void C_ccall f_2962(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2964)
static void C_fcall f_2964(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2983)
static void C_ccall f_2983(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3051)
static void C_ccall f_3051(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3058)
static void C_ccall f_3058(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3045)
static void C_ccall f_3045(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2998)
static void C_ccall f_2998(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3032)
static void C_ccall f_3032(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3018)
static void C_ccall f_3018(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3030)
static void C_ccall f_3030(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3026)
static void C_ccall f_3026(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3010)
static void C_ccall f_3010(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3008)
static void C_ccall f_3008(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3069)
static void C_ccall f_3069(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2912)
static void C_ccall f_2912(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2938)
static void C_ccall f_2938(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2923)
static void C_ccall f_2923(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2927)
static void C_ccall f_2927(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2931)
static void C_ccall f_2931(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2935)
static void C_ccall f_2935(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2900)
static void C_ccall f_2900(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2897)
static void C_ccall f_2897(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2855)
static void C_ccall f_2855(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2855)
static void C_ccall f_2855r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2877)
static void C_ccall f_2877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2704)
static void C_ccall f_2704(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2704)
static void C_ccall f_2704r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2807)
static void C_fcall f_2807(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2802)
static void C_fcall f_2802(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2706)
static void C_fcall f_2706(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2798)
static void C_ccall f_2798(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2713)
static void C_ccall f_2713(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2785)
static void C_ccall f_2785(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2788)
static void C_ccall f_2788(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2791)
static void C_ccall f_2791(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2778)
static void C_ccall f_2778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2775)
static void C_ccall f_2775(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2751)
static void C_ccall f_2751(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2726)
static void C_ccall f_2726(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2745)
static void C_ccall f_2745(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2732)
static void C_ccall f_2732(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2730)
static void C_ccall f_2730(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2701)
static C_word C_fcall f_2701(C_word t0);
C_noret_decl(f_2672)
static void C_ccall f_2672(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2672)
static void C_ccall f_2672r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2689)
static void C_ccall f_2689(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2666)
static void C_ccall f_2666(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2663)
static void C_ccall f_2663(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2570)
static void C_ccall f_2570(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2570)
static void C_ccall f_2570r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2586)
static void C_ccall f_2586(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2594)
static void C_fcall f_2594(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2627)
static void C_ccall f_2627(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2608)
static void C_ccall f_2608(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2611)
static void C_ccall f_2611(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2614)
static void C_ccall f_2614(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2551)
static C_word C_fcall f_2551(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_2407)
static void C_ccall f_2407(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2407)
static void C_ccall f_2407r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2503)
static void C_fcall f_2503(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2498)
static void C_fcall f_2498(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2409)
static void C_fcall f_2409(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2422)
static void C_ccall f_2422(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2430)
static void C_fcall f_2430(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2463)
static void C_ccall f_2463(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2444)
static void C_ccall f_2444(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2447)
static void C_ccall f_2447(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2388)
static C_word C_fcall f_2388(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_2279)
static void C_ccall f_2279(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2279)
static void C_ccall f_2279r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2285)
static void C_fcall f_2285(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2306)
static void C_ccall f_2306(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2377)
static void C_ccall f_2377(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2310)
static void C_ccall f_2310(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2317)
static void C_ccall f_2317(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2319)
static void C_fcall f_2319(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2336)
static void C_ccall f_2336(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2346)
static void C_ccall f_2346(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2350)
static void C_ccall f_2350(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2300)
static void C_ccall f_2300(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2220)
static void C_ccall f_2220(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2220)
static void C_ccall f_2220r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2224)
static void C_ccall f_2224(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2230)
static void C_ccall f_2230(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2201)
static void C_ccall f_2201(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2201)
static void C_ccall f_2201r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2205)
static void C_ccall f_2205(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2167)
static void C_ccall f_2167(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2174)
static void C_ccall f_2174(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2139)
static void C_ccall f_2139(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2146)
static void C_ccall f_2146(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2149)
static void C_ccall f_2149(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2152)
static void C_ccall f_2152(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2122)
static void C_ccall f_2122(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2126)
static void C_ccall f_2126(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2129)
static void C_ccall f_2129(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2103)
static void C_ccall f_2103(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2094)
static void C_ccall f_2094(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2029)
static void C_ccall f_2029(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2035)
static void C_fcall f_2035(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2039)
static void C_ccall f_2039(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2047)
static void C_fcall f_2047(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2073)
static void C_ccall f_2073(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2077)
static void C_ccall f_2077(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2065)
static void C_ccall f_2065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2009)
static void C_ccall f_2009(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2017)
static void C_ccall f_2017(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1992)
static void C_ccall f_1992(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2003)
static void C_ccall f_2003(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2007)
static void C_ccall f_2007(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1962)
static void C_ccall f_1962(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1962)
static void C_ccall f_1962r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1969)
static void C_fcall f_1969(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1978)
static void C_ccall f_1978(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1972)
static void C_ccall f_1972(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1927)
static void C_ccall f_1927(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1931)
static void C_ccall f_1931(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1960)
static void C_ccall f_1960(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1946)
static void C_ccall f_1946(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1940)
static void C_ccall f_1940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1913)
static void C_ccall f_1913(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1913)
static void C_ccall f_1913r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1925)
static void C_ccall f_1925(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1899)
static void C_ccall f_1899(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1899)
static void C_ccall f_1899r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1911)
static void C_ccall f_1911(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1881)
static void C_fcall f_1881(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1885)
static void C_ccall f_1885(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1897)
static void C_ccall f_1897(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1844)
static void C_fcall f_1844(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1852)
static void C_ccall f_1852(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1835)
static void C_ccall f_1835(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1829)
static void C_ccall f_1829(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1823)
static void C_ccall f_1823(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1799)
static void C_fcall f_1799(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1821)
static void C_ccall f_1821(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1817)
static void C_ccall f_1817(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1809)
static void C_ccall f_1809(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1769)
static void C_ccall f_1769(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1797)
static void C_ccall f_1797(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1793)
static void C_ccall f_1793(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1785)
static void C_ccall f_1785(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1713)
static void C_ccall f_1713(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1726)
static void C_ccall f_1726(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1717)
static void C_ccall f_1717(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1693)
static void C_ccall f_1693(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1693)
static void C_ccall f_1693r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1697)
static void C_ccall f_1697(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1703)
static void C_ccall f_1703(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1703)
static void C_ccall f_1703r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1707)
static void C_ccall f_1707(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1673)
static void C_ccall f_1673(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1673)
static void C_ccall f_1673r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1677)
static void C_ccall f_1677(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1683)
static void C_ccall f_1683(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1683)
static void C_ccall f_1683r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1687)
static void C_ccall f_1687(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1649)
static void C_ccall f_1649(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1649)
static void C_ccall f_1649r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1653)
static void C_ccall f_1653(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1664)
static void C_ccall f_1664(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1664)
static void C_ccall f_1664r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1668)
static void C_ccall f_1668(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1658)
static void C_ccall f_1658(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1625)
static void C_ccall f_1625(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1625)
static void C_ccall f_1625r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1629)
static void C_ccall f_1629(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1640)
static void C_ccall f_1640(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1640)
static void C_ccall f_1640r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1644)
static void C_ccall f_1644(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1634)
static void C_ccall f_1634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1606)
static void C_ccall f_1606(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1610)
static void C_ccall f_1610(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1613)
static void C_ccall f_1613(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1570)
static void C_ccall f_1570(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1570)
static void C_ccall f_1570r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1601)
static void C_ccall f_1601(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1591)
static void C_ccall f_1591(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1584)
static void C_ccall f_1584(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1534)
static void C_ccall f_1534(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1534)
static void C_ccall f_1534r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1565)
static void C_ccall f_1565(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1555)
static void C_ccall f_1555(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1548)
static void C_ccall f_1548(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1516)
static void C_fcall f_1516(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1520)
static void C_ccall f_1520(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1532)
static void C_ccall f_1532(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1510)
static void C_fcall f_1510(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1498)
static C_word C_fcall f_1498(C_word t0);
C_noret_decl(f_1452)
static void C_ccall f_1452(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1452)
static void C_ccall f_1452r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1456)
static void C_ccall f_1456(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1465)
static void C_ccall f_1465(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1468)
static void C_ccall f_1468(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1429)
static void C_ccall f_1429(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1450)
static void C_ccall f_1450(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1436)
static void C_ccall f_1436(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1269)
static void C_ccall f_1269(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1269)
static void C_ccall f_1269r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1377)
static void C_fcall f_1377(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1385)
static void C_ccall f_1385(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1372)
static void C_fcall f_1372(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1271)
static void C_fcall f_1271(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1278)
static void C_ccall f_1278(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1281)
static void C_ccall f_1281(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1284)
static void C_ccall f_1284(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1371)
static void C_ccall f_1371(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1288)
static void C_ccall f_1288(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1305)
static void C_fcall f_1305(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1315)
static void C_ccall f_1315(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1327)
static void C_fcall f_1327(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1337)
static void C_ccall f_1337(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1297)
static void C_ccall f_1297(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1242)
static void C_ccall f_1242(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1267)
static void C_ccall f_1267(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1263)
static void C_ccall f_1263(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1255)
static void C_ccall f_1255(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1215)
static void C_ccall f_1215(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1240)
static void C_ccall f_1240(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1236)
static void C_ccall f_1236(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1228)
static void C_ccall f_1228(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1188)
static void C_ccall f_1188(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1213)
static void C_ccall f_1213(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1209)
static void C_ccall f_1209(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1201)
static void C_ccall f_1201(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1127)
static void C_ccall f_1127(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1127)
static void C_ccall f_1127r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1140)
static void C_ccall f_1140(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1155)
static void C_ccall f_1155(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1146)
static void C_ccall f_1146(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1149)
static void C_ccall f_1149(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1087)
static void C_ccall f_1087(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1106)
static void C_ccall f_1106(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1091)
static void C_ccall f_1091(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1100)
static void C_ccall f_1100(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1094)
static void C_ccall f_1094(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1081)
static void C_ccall f_1081(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1058)
static void C_ccall f_1058(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1079)
static void C_ccall f_1079(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1065)
static void C_ccall f_1065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1052)
static void C_ccall f_1052(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1056)
static void C_ccall f_1056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1046)
static void C_ccall f_1046(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1050)
static void C_ccall f_1050(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1040)
static void C_ccall f_1040(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1044)
static void C_ccall f_1044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1034)
static void C_ccall f_1034(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1038)
static void C_ccall f_1038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1028)
static void C_ccall f_1028(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1032)
static void C_ccall f_1032(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1022)
static void C_ccall f_1022(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1026)
static void C_ccall f_1026(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_991)
static void C_ccall f_991(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_991)
static void C_ccall f_991r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_995)
static void C_ccall f_995(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_998)
static void C_ccall f_998(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_953)
static void C_fcall f_953(C_word t0,C_word t1) C_noret;
C_noret_decl(f_986)
static void C_ccall f_986(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_982)
static void C_ccall f_982(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_957)
static void C_ccall f_957(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_966)
static void C_ccall f_966(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_915)
static void C_ccall f_915(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_922)
static void C_ccall f_922(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_925)
static void C_ccall f_925(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_945)
static void C_ccall f_945(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_928)
static void C_ccall f_928(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_935)
static void C_ccall f_935(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_873)
static void C_ccall f_873(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_873)
static void C_ccall f_873r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_880)
static void C_ccall f_880(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_895)
static void C_ccall f_895(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_889)
static void C_ccall f_889(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_828)
static void C_ccall f_828(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_828)
static void C_ccall f_828r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_838)
static void C_ccall f_838(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_841)
static void C_ccall f_841(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_853)
static void C_ccall f_853(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_844)
static void C_ccall f_844(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_810)
static void C_ccall f_810(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_823)
static void C_ccall f_823(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_769)
static void C_ccall f_769(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_769)
static void C_ccall f_769r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_802)
static void C_ccall f_802(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_786)
static void C_ccall f_786(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_795)
static void C_ccall f_795(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_789)
static void C_ccall f_789(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_721)
static void C_ccall f_721(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_727)
static void C_ccall f_727(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_736)
static void C_ccall f_736(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_3100)
static void C_fcall trf_3100(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3100(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3100(t0,t1);}

C_noret_decl(trf_3095)
static void C_fcall trf_3095(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3095(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3095(t0,t1,t2);}

C_noret_decl(trf_3090)
static void C_fcall trf_3090(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3090(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3090(t0,t1,t2,t3);}

C_noret_decl(trf_2945)
static void C_fcall trf_2945(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2945(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2945(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2952)
static void C_fcall trf_2952(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2952(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2952(t0,t1);}

C_noret_decl(trf_2964)
static void C_fcall trf_2964(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2964(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2964(t0,t1,t2,t3);}

C_noret_decl(trf_2807)
static void C_fcall trf_2807(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2807(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2807(t0,t1);}

C_noret_decl(trf_2802)
static void C_fcall trf_2802(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2802(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2802(t0,t1);}

C_noret_decl(trf_2706)
static void C_fcall trf_2706(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2706(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2706(t0,t1);}

C_noret_decl(trf_2594)
static void C_fcall trf_2594(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2594(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2594(t0,t1,t2,t3);}

C_noret_decl(trf_2503)
static void C_fcall trf_2503(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2503(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2503(t0,t1);}

C_noret_decl(trf_2498)
static void C_fcall trf_2498(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2498(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2498(t0,t1,t2);}

C_noret_decl(trf_2409)
static void C_fcall trf_2409(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2409(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2409(t0,t1,t2);}

C_noret_decl(trf_2430)
static void C_fcall trf_2430(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2430(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2430(t0,t1,t2,t3);}

C_noret_decl(trf_2285)
static void C_fcall trf_2285(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2285(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2285(t0,t1,t2);}

C_noret_decl(trf_2319)
static void C_fcall trf_2319(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2319(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2319(t0,t1,t2);}

C_noret_decl(trf_2035)
static void C_fcall trf_2035(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2035(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2035(t0,t1,t2);}

C_noret_decl(trf_2047)
static void C_fcall trf_2047(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2047(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2047(t0,t1,t2);}

C_noret_decl(trf_1969)
static void C_fcall trf_1969(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1969(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1969(t0,t1);}

C_noret_decl(trf_1881)
static void C_fcall trf_1881(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1881(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1881(t0,t1,t2,t3);}

C_noret_decl(trf_1844)
static void C_fcall trf_1844(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1844(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1844(t0,t1,t2);}

C_noret_decl(trf_1799)
static void C_fcall trf_1799(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1799(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1799(t0,t1,t2,t3);}

C_noret_decl(trf_1516)
static void C_fcall trf_1516(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1516(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1516(t0,t1,t2,t3);}

C_noret_decl(trf_1510)
static void C_fcall trf_1510(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1510(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1510(t0,t1);}

C_noret_decl(trf_1377)
static void C_fcall trf_1377(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1377(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1377(t0,t1);}

C_noret_decl(trf_1372)
static void C_fcall trf_1372(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1372(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1372(t0,t1,t2);}

C_noret_decl(trf_1271)
static void C_fcall trf_1271(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1271(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1271(t0,t1,t2,t3);}

C_noret_decl(trf_1305)
static void C_fcall trf_1305(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1305(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1305(t0,t1);}

C_noret_decl(trf_1327)
static void C_fcall trf_1327(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1327(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1327(t0,t1);}

C_noret_decl(trf_953)
static void C_fcall trf_953(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_953(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_953(t0,t1);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(1840)){
C_save(t1);
C_rereclaim2(1840*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,364);
lf[1]=C_static_string(C_heaptop,27,"too many optional arguments");
lf[3]=C_h_intern(&lf[3],18,"\003syscurrent-thread");
lf[4]=C_static_lambda_info(C_heaptop,6,"(a735)");
lf[5]=C_h_intern(&lf[5],12,"\003sysschedule");
lf[6]=C_static_lambda_info(C_heaptop,14,"(a726 return0)");
lf[7]=C_static_lambda_info(C_heaptop,7,"(yield)");
lf[8]=C_h_intern(&lf[8],8,"pipe/buf");
lf[9]=C_h_intern(&lf[9],11,"open/rdonly");
lf[10]=C_h_intern(&lf[10],11,"open/wronly");
lf[11]=C_h_intern(&lf[11],9,"open/rdwr");
lf[12]=C_h_intern(&lf[12],9,"open/read");
lf[13]=C_h_intern(&lf[13],10,"open/write");
lf[14]=C_h_intern(&lf[14],10,"open/creat");
lf[15]=C_h_intern(&lf[15],11,"open/append");
lf[16]=C_h_intern(&lf[16],9,"open/excl");
lf[17]=C_h_intern(&lf[17],10,"open/trunc");
lf[18]=C_h_intern(&lf[18],11,"open/binary");
lf[19]=C_h_intern(&lf[19],9,"open/text");
lf[20]=C_h_intern(&lf[20],10,"perm/irusr");
lf[21]=C_h_intern(&lf[21],10,"perm/iwusr");
lf[22]=C_h_intern(&lf[22],10,"perm/ixusr");
lf[23]=C_h_intern(&lf[23],10,"perm/irgrp");
lf[24]=C_h_intern(&lf[24],10,"perm/iwgrp");
lf[25]=C_h_intern(&lf[25],10,"perm/ixgrp");
lf[26]=C_h_intern(&lf[26],10,"perm/iroth");
lf[27]=C_h_intern(&lf[27],10,"perm/iwoth");
lf[28]=C_h_intern(&lf[28],10,"perm/ixoth");
lf[29]=C_h_intern(&lf[29],10,"perm/irwxu");
lf[30]=C_h_intern(&lf[30],10,"perm/irwxg");
lf[31]=C_h_intern(&lf[31],10,"perm/irwxo");
lf[32]=C_h_intern(&lf[32],9,"file-open");
lf[33]=C_h_intern(&lf[33],15,"\003syssignal-hook");
lf[34]=C_h_intern(&lf[34],11,"\000file-error");
lf[35]=C_static_string(C_heaptop,17,"can not open file");
lf[36]=C_h_intern(&lf[36],16,"\003sysupdate-errno");
lf[37]=C_h_intern(&lf[37],17,"\003sysmake-c-string");
lf[38]=C_h_intern(&lf[38],20,"\003sysexpand-home-path");
lf[39]=C_static_lambda_info(C_heaptop,36,"(file-open filename4 flags5 . mode6)");
lf[40]=C_h_intern(&lf[40],10,"file-close");
lf[41]=C_static_string(C_heaptop,18,"can not close file");
lf[42]=C_static_lambda_info(C_heaptop,17,"(file-close fd14)");
lf[43]=C_h_intern(&lf[43],11,"make-string");
lf[44]=C_h_intern(&lf[44],9,"file-read");
lf[45]=C_static_string(C_heaptop,22,"can not read from file");
lf[46]=C_h_intern(&lf[46],11,"\000type-error");
lf[47]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[48]=C_static_lambda_info(C_heaptop,34,"(file-read fd18 size19 . buffer20)");
lf[49]=C_h_intern(&lf[49],10,"file-write");
lf[50]=C_static_string(C_heaptop,21,"can not write to file");
lf[51]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[52]=C_static_lambda_info(C_heaptop,35,"(file-write fd28 buffer29 . size30)");
lf[53]=C_h_intern(&lf[53],13,"string-length");
lf[54]=C_h_intern(&lf[54],12,"file-mkstemp");
lf[55]=C_h_intern(&lf[55],13,"\003syssubstring");
lf[56]=C_static_string(C_heaptop,29,"can not create temporary file");
lf[57]=C_static_lambda_info(C_heaptop,25,"(file-mkstemp template39)");
lf[58]=C_h_intern(&lf[58],8,"seek/set");
lf[59]=C_h_intern(&lf[59],8,"seek/end");
lf[60]=C_h_intern(&lf[60],8,"seek/cur");
lf[62]=C_static_string(C_heaptop,19,"can not access file");
lf[63]=C_static_string(C_heaptop,42,"bad argument type - not a fixnum or string");
lf[64]=C_static_lambda_info(C_heaptop,19,"(##sys#stat file46)");
lf[65]=C_h_intern(&lf[65],9,"file-stat");
lf[66]=C_h_intern(&lf[66],9,"\003syserror");
lf[67]=C_static_lambda_info(C_heaptop,23,"(file-stat f50 . g4951)");
lf[68]=C_h_intern(&lf[68],9,"file-size");
lf[69]=C_static_lambda_info(C_heaptop,15,"(file-size f57)");
lf[70]=C_h_intern(&lf[70],22,"file-modification-time");
lf[71]=C_static_lambda_info(C_heaptop,28,"(file-modification-time f59)");
lf[72]=C_h_intern(&lf[72],16,"file-access-time");
lf[73]=C_static_lambda_info(C_heaptop,22,"(file-access-time f61)");
lf[74]=C_h_intern(&lf[74],16,"file-change-time");
lf[75]=C_static_lambda_info(C_heaptop,22,"(file-change-time f63)");
lf[76]=C_h_intern(&lf[76],10,"file-owner");
lf[77]=C_static_lambda_info(C_heaptop,16,"(file-owner f65)");
lf[78]=C_h_intern(&lf[78],16,"file-permissions");
lf[79]=C_static_lambda_info(C_heaptop,22,"(file-permissions f67)");
lf[80]=C_h_intern(&lf[80],13,"regular-file\077");
lf[81]=C_h_intern(&lf[81],13,"\003sysfile-info");
lf[82]=C_static_lambda_info(C_heaptop,23,"(regular-file\077 fname69)");
lf[83]=C_h_intern(&lf[83],14,"symbolic-link\077");
lf[84]=C_static_lambda_info(C_heaptop,24,"(symbolic-link\077 fname72)");
lf[85]=C_h_intern(&lf[85],13,"file-position");
lf[86]=C_static_string(C_heaptop,38,"can not retrieve file position of port");
lf[87]=C_h_intern(&lf[87],6,"stream");
lf[88]=C_static_string(C_heaptop,12,"invalid file");
lf[89]=C_h_intern(&lf[89],5,"port\077");
lf[90]=C_static_lambda_info(C_heaptop,22,"(file-position port74)");
lf[91]=C_h_intern(&lf[91],18,"set-file-position!");
lf[92]=C_static_string(C_heaptop,25,"can not set file position");
lf[93]=C_static_string(C_heaptop,12,"invalid file");
lf[94]=C_h_intern(&lf[94],13,"\000bounds-error");
lf[95]=C_static_string(C_heaptop,30,"invalid negative port position");
lf[96]=C_static_lambda_info(C_heaptop,44,"(set-file-position! port78 pos79 . whence80)");
lf[97]=C_h_intern(&lf[97],16,"create-directory");
lf[98]=C_static_string(C_heaptop,24,"can not create directory");
lf[99]=C_static_lambda_info(C_heaptop,25,"(create-directory name86)");
lf[100]=C_h_intern(&lf[100],16,"change-directory");
lf[101]=C_static_string(C_heaptop,32,"can not change current directory");
lf[102]=C_static_lambda_info(C_heaptop,25,"(change-directory name89)");
lf[103]=C_h_intern(&lf[103],16,"delete-directory");
lf[104]=C_static_string(C_heaptop,24,"can not delete directory");
lf[105]=C_static_lambda_info(C_heaptop,25,"(delete-directory name92)");
lf[106]=C_h_intern(&lf[106],13,"string-append");
lf[107]=C_h_intern(&lf[107],6,"string");
lf[108]=C_h_intern(&lf[108],9,"directory");
lf[109]=C_static_string(C_heaptop,22,"can not open directory");
lf[110]=C_static_lambda_info(C_heaptop,6,"(loop)");
lf[111]=C_h_intern(&lf[111],16,"\003sysmake-pointer");
lf[112]=C_static_lambda_info(C_heaptop,35,"(body102 spec108 show-dotfiles\077109)");
lf[113]=C_static_lambda_info(C_heaptop,35,"(def-show-dotfiles\077105 %spec100129)");
lf[114]=C_h_intern(&lf[114],17,"current-directory");
lf[115]=C_static_lambda_info(C_heaptop,13,"(def-spec104)");
lf[116]=C_static_lambda_info(C_heaptop,19,"(directory . g9899)");
lf[117]=C_h_intern(&lf[117],10,"directory\077");
lf[118]=C_static_lambda_info(C_heaptop,21,"(directory\077 fname135)");
lf[119]=C_static_string(C_heaptop,34,"can not retrieve current directory");
lf[120]=C_static_lambda_info(C_heaptop,29,"(current-directory . g139140)");
lf[121]=C_h_intern(&lf[121],5,"\000text");
lf[122]=C_static_lambda_info(C_heaptop,6,"(mode)");
lf[123]=C_static_string(C_heaptop,35,"illegal input/output mode specifier");
lf[124]=C_static_lambda_info(C_heaptop,14,"(badmode m151)");
lf[125]=C_static_string(C_heaptop,17,"can not open pipe");
lf[126]=C_h_intern(&lf[126],13,"\003sysmake-port");
lf[127]=C_h_intern(&lf[127],21,"\003sysstream-port-class");
lf[128]=C_static_string(C_heaptop,6,"(pipe)");
lf[129]=C_static_lambda_info(C_heaptop,26,"(check cmd152 inp153 r154)");
lf[130]=C_h_intern(&lf[130],15,"open-input-pipe");
lf[131]=C_h_intern(&lf[131],7,"\000binary");
lf[132]=C_static_lambda_info(C_heaptop,31,"(open-input-pipe cmd158 . m159)");
lf[133]=C_h_intern(&lf[133],16,"open-output-pipe");
lf[134]=C_static_lambda_info(C_heaptop,32,"(open-output-pipe cmd164 . m165)");
lf[135]=C_h_intern(&lf[135],16,"close-input-pipe");
lf[136]=C_static_string(C_heaptop,24,"error while closing pipe");
lf[137]=C_h_intern(&lf[137],14,"\003syscheck-port");
lf[138]=C_static_lambda_info(C_heaptop,26,"(close-input-pipe port170)");
lf[139]=C_h_intern(&lf[139],17,"close-output-pipe");
lf[140]=C_h_intern(&lf[140],20,"call-with-input-pipe");
lf[141]=C_static_lambda_info(C_heaptop,7,"(a1633)");
lf[142]=C_static_lambda_info(C_heaptop,20,"(a1639 . results188)");
lf[143]=C_static_lambda_info(C_heaptop,47,"(call-with-input-pipe cmd184 proc185 . mode186)");
lf[144]=C_h_intern(&lf[144],21,"call-with-output-pipe");
lf[145]=C_static_lambda_info(C_heaptop,7,"(a1657)");
lf[146]=C_static_lambda_info(C_heaptop,20,"(a1663 . results194)");
lf[147]=C_static_lambda_info(C_heaptop,48,"(call-with-output-pipe cmd190 proc191 . mode192)");
lf[148]=C_h_intern(&lf[148],20,"with-input-from-pipe");
lf[149]=C_h_intern(&lf[149],18,"\003sysstandard-input");
lf[150]=C_static_lambda_info(C_heaptop,20,"(a1682 . results201)");
lf[151]=C_static_lambda_info(C_heaptop,48,"(with-input-from-pipe cmd196 thunk197 . mode198)");
lf[152]=C_h_intern(&lf[152],19,"with-output-to-pipe");
lf[153]=C_h_intern(&lf[153],19,"\003sysstandard-output");
lf[154]=C_static_lambda_info(C_heaptop,20,"(a1702 . results210)");
lf[155]=C_static_lambda_info(C_heaptop,47,"(with-output-to-pipe cmd205 thunk206 . mode207)");
lf[156]=C_h_intern(&lf[156],11,"create-pipe");
lf[157]=C_static_string(C_heaptop,19,"can not create pipe");
lf[158]=C_static_lambda_info(C_heaptop,13,"(create-pipe)");
lf[159]=C_h_intern(&lf[159],10,"errno/perm");
lf[160]=C_h_intern(&lf[160],11,"errno/noent");
lf[161]=C_h_intern(&lf[161],10,"errno/srch");
lf[162]=C_h_intern(&lf[162],10,"errno/intr");
lf[163]=C_h_intern(&lf[163],8,"errno/io");
lf[164]=C_h_intern(&lf[164],12,"errno/noexec");
lf[165]=C_h_intern(&lf[165],10,"errno/badf");
lf[166]=C_h_intern(&lf[166],11,"errno/child");
lf[167]=C_h_intern(&lf[167],11,"errno/nomem");
lf[168]=C_h_intern(&lf[168],11,"errno/acces");
lf[169]=C_h_intern(&lf[169],11,"errno/fault");
lf[170]=C_h_intern(&lf[170],10,"errno/busy");
lf[171]=C_h_intern(&lf[171],11,"errno/exist");
lf[172]=C_h_intern(&lf[172],12,"errno/notdir");
lf[173]=C_h_intern(&lf[173],11,"errno/isdir");
lf[174]=C_h_intern(&lf[174],11,"errno/inval");
lf[175]=C_h_intern(&lf[175],11,"errno/mfile");
lf[176]=C_h_intern(&lf[176],11,"errno/nospc");
lf[177]=C_h_intern(&lf[177],11,"errno/spipe");
lf[178]=C_h_intern(&lf[178],10,"errno/pipe");
lf[179]=C_h_intern(&lf[179],11,"errno/again");
lf[180]=C_h_intern(&lf[180],10,"errno/rofs");
lf[181]=C_h_intern(&lf[181],10,"errno/nxio");
lf[182]=C_h_intern(&lf[182],10,"errno/2big");
lf[183]=C_h_intern(&lf[183],10,"errno/xdev");
lf[184]=C_h_intern(&lf[184],11,"errno/nodev");
lf[185]=C_h_intern(&lf[185],11,"errno/nfile");
lf[186]=C_h_intern(&lf[186],11,"errno/notty");
lf[187]=C_h_intern(&lf[187],10,"errno/fbig");
lf[188]=C_h_intern(&lf[188],11,"errno/mlink");
lf[189]=C_h_intern(&lf[189],9,"errno/dom");
lf[190]=C_h_intern(&lf[190],11,"errno/range");
lf[191]=C_h_intern(&lf[191],12,"errno/deadlk");
lf[192]=C_h_intern(&lf[192],17,"errno/nametoolong");
lf[193]=C_h_intern(&lf[193],11,"errno/nolck");
lf[194]=C_h_intern(&lf[194],11,"errno/nosys");
lf[195]=C_h_intern(&lf[195],14,"errno/notempty");
lf[196]=C_h_intern(&lf[196],11,"errno/ilseq");
lf[197]=C_h_intern(&lf[197],16,"change-file-mode");
lf[198]=C_static_string(C_heaptop,24,"can not change file mode");
lf[199]=C_static_lambda_info(C_heaptop,32,"(change-file-mode fname219 m220)");
lf[200]=C_static_lambda_info(C_heaptop,33,"(check filename225 acc226 loc227)");
lf[201]=C_h_intern(&lf[201],17,"file-read-access\077");
lf[202]=C_static_lambda_info(C_heaptop,31,"(file-read-access\077 filename231)");
lf[203]=C_h_intern(&lf[203],18,"file-write-access\077");
lf[204]=C_static_lambda_info(C_heaptop,32,"(file-write-access\077 filename232)");
lf[205]=C_h_intern(&lf[205],20,"file-execute-access\077");
lf[206]=C_static_lambda_info(C_heaptop,34,"(file-execute-access\077 filename233)");
lf[207]=C_h_intern(&lf[207],12,"fileno/stdin");
lf[208]=C_h_intern(&lf[208],13,"fileno/stdout");
lf[209]=C_h_intern(&lf[209],13,"fileno/stderr");
lf[210]=C_h_intern(&lf[210],7,"\000append");
lf[211]=C_static_string(C_heaptop,27,"invalid mode for input file");
lf[212]=C_static_string(C_heaptop,1,"a");
lf[213]=C_static_string(C_heaptop,21,"invalid mode argument");
lf[214]=C_static_string(C_heaptop,1,"r");
lf[215]=C_static_string(C_heaptop,1,"w");
lf[216]=C_static_lambda_info(C_heaptop,18,"(mode inp239 m240)");
lf[217]=C_static_string(C_heaptop,17,"can not open file");
lf[218]=C_static_string(C_heaptop,8,"(fdport)");
lf[219]=C_static_lambda_info(C_heaptop,25,"(check fd244 inp245 r246)");
lf[220]=C_h_intern(&lf[220],16,"open-input-file*");
lf[221]=C_static_lambda_info(C_heaptop,31,"(open-input-file* fd250 . m251)");
lf[222]=C_h_intern(&lf[222],17,"open-output-file*");
lf[223]=C_static_lambda_info(C_heaptop,32,"(open-output-file* fd253 . m254)");
lf[224]=C_h_intern(&lf[224],12,"port->fileno");
lf[225]=C_static_string(C_heaptop,25,"port has no attached file");
lf[226]=C_static_string(C_heaptop,38,"can not access file-descriptor of port");
lf[227]=C_h_intern(&lf[227],25,"\003syspeek-unsigned-integer");
lf[228]=C_static_lambda_info(C_heaptop,22,"(port->fileno port259)");
lf[229]=C_h_intern(&lf[229],16,"duplicate-fileno");
lf[230]=C_static_string(C_heaptop,33,"can not duplicate file descriptor");
lf[231]=C_static_lambda_info(C_heaptop,34,"(duplicate-fileno old264 . new265)");
lf[232]=C_h_intern(&lf[232],6,"setenv");
lf[233]=C_static_lambda_info(C_heaptop,22,"(setenv var272 val273)");
lf[234]=C_h_intern(&lf[234],8,"unsetenv");
lf[235]=C_static_lambda_info(C_heaptop,17,"(unsetenv var277)");
lf[236]=C_h_intern(&lf[236],9,"substring");
lf[237]=C_h_intern(&lf[237],19,"current-environment");
lf[238]=C_static_lambda_info(C_heaptop,11,"(scan j291)");
lf[239]=C_h_intern(&lf[239],17,"\003syspeek-c-string");
lf[240]=C_static_lambda_info(C_heaptop,11,"(loop i288)");
lf[241]=C_static_lambda_info(C_heaptop,21,"(current-environment)");
lf[242]=C_h_intern(&lf[242],19,"seconds->local-time");
lf[243]=C_h_intern(&lf[243],18,"\003sysdecode-seconds");
lf[244]=C_static_lambda_info(C_heaptop,29,"(seconds->local-time secs294)");
lf[245]=C_h_intern(&lf[245],17,"seconds->utc-time");
lf[246]=C_static_lambda_info(C_heaptop,27,"(seconds->utc-time secs296)");
lf[247]=C_h_intern(&lf[247],15,"seconds->string");
lf[248]=C_static_string(C_heaptop,33,"can not convert seconds to string");
lf[249]=C_static_lambda_info(C_heaptop,25,"(seconds->string secs304)");
lf[250]=C_h_intern(&lf[250],12,"time->string");
lf[251]=C_static_string(C_heaptop,29,"can not time vector to string");
lf[252]=C_static_string(C_heaptop,21,"time vector too short");
lf[253]=C_static_lambda_info(C_heaptop,20,"(time->string tm313)");
lf[254]=C_h_intern(&lf[254],19,"local-time->seconds");
lf[255]=C_h_intern(&lf[255],15,"\003syscons-flonum");
lf[256]=C_static_string(C_heaptop,38,"can not convert time vector to seconds");
lf[257]=C_static_string(C_heaptop,21,"time vector too short");
lf[258]=C_static_lambda_info(C_heaptop,27,"(local-time->seconds tm318)");
lf[259]=C_h_intern(&lf[259],5,"_exit");
lf[260]=C_h_intern(&lf[260],23,"\003syscleanup-before-exit");
lf[261]=C_static_lambda_info(C_heaptop,17,"(_exit . code326)");
lf[262]=C_h_intern(&lf[262],19,"set-buffering-mode!");
lf[263]=C_static_string(C_heaptop,26,"can not set buffering mode");
lf[264]=C_h_intern(&lf[264],5,"\000full");
lf[265]=C_h_intern(&lf[265],5,"\000line");
lf[266]=C_h_intern(&lf[266],5,"\000none");
lf[267]=C_static_string(C_heaptop,22,"invalid buffering-mode");
lf[268]=C_static_lambda_info(C_heaptop,47,"(set-buffering-mode! port328 mode329 . size330)");
lf[269]=C_h_intern(&lf[269],12,"glob->regexp");
lf[270]=C_h_intern(&lf[270],13,"make-pathname");
lf[271]=C_h_intern(&lf[271],18,"decompose-pathname");
lf[272]=C_h_intern(&lf[272],4,"glob");
lf[273]=C_static_lambda_info(C_heaptop,7,"(a2299)");
lf[274]=C_h_intern(&lf[274],12,"string-match");
lf[275]=C_static_lambda_info(C_heaptop,11,"(loop f358)");
lf[276]=C_static_string(C_heaptop,1,".");
lf[277]=C_static_string(C_heaptop,1,"*");
lf[278]=C_static_lambda_info(C_heaptop,38,"(a2305 dir345348 file346349 ext347350)");
lf[279]=C_static_lambda_info(C_heaptop,15,"(conc paths343)");
lf[280]=C_static_lambda_info(C_heaptop,17,"(glob . paths341)");
lf[281]=C_h_intern(&lf[281],13,"spawn/overlay");
lf[282]=C_h_intern(&lf[282],10,"spawn/wait");
lf[283]=C_h_intern(&lf[283],12,"spawn/nowait");
lf[284]=C_h_intern(&lf[284],13,"spawn/nowaito");
lf[285]=C_h_intern(&lf[285],12,"spawn/detach");
lf[286]=C_static_lambda_info(C_heaptop,24,"(setarg a370376 a369377)");
lf[287]=C_h_intern(&lf[287],24,"pathname-strip-directory");
lf[288]=C_h_intern(&lf[288],15,"process-execute");
lf[289]=C_static_string(C_heaptop,23,"can not execute process");
lf[290]=C_static_lambda_info(C_heaptop,18,"(do396 al398 i399)");
lf[291]=C_static_lambda_info(C_heaptop,20,"(body386 arglist392)");
lf[292]=C_static_lambda_info(C_heaptop,31,"(def-envlist389 %arglist384412)");
lf[293]=C_static_lambda_info(C_heaptop,16,"(def-arglist388)");
lf[294]=C_static_lambda_info(C_heaptop,39,"(process-execute filename382 . g381383)");
lf[295]=C_static_lambda_info(C_heaptop,24,"(setarg a422428 a421429)");
lf[296]=C_h_intern(&lf[296],13,"process-spawn");
lf[297]=C_static_string(C_heaptop,23,"can not execute process");
lf[298]=C_static_lambda_info(C_heaptop,18,"(do438 al440 i441)");
lf[299]=C_static_lambda_info(C_heaptop,48,"(process-spawn mode433 filename434 . arglist435)");
lf[300]=C_h_intern(&lf[300],18,"current-process-id");
lf[301]=C_static_lambda_info(C_heaptop,20,"(current-process-id)");
lf[302]=C_h_intern(&lf[302],9,"get-shell");
lf[303]=C_static_lambda_info(C_heaptop,11,"(get-shell)");
lf[304]=C_h_intern(&lf[304],6,"getenv");
lf[305]=C_h_intern(&lf[305],11,"process-run");
lf[306]=C_static_string(C_heaptop,2,"/c");
lf[307]=C_static_lambda_info(C_heaptop,28,"(process-run f462 . args463)");
lf[309]=C_static_lambda_info(C_heaptop,14,"(close-handle)");
lf[310]=C_h_intern(&lf[310],15,"make-input-port");
lf[311]=C_h_intern(&lf[311],16,"make-output-port");
lf[312]=C_h_intern(&lf[312],7,"process");
lf[313]=C_static_string(C_heaptop,23,"could not write to pipe");
lf[314]=C_static_lambda_info(C_heaptop,12,"(a2731 s490)");
lf[315]=C_static_lambda_info(C_heaptop,7,"(a2744)");
lf[316]=C_static_string(C_heaptop,24,"could not read from pipe");
lf[317]=C_static_lambda_info(C_heaptop,7,"(a2750)");
lf[318]=C_static_lambda_info(C_heaptop,7,"(a2774)");
lf[319]=C_static_lambda_info(C_heaptop,7,"(a2777)");
lf[320]=C_static_string(C_heaptop,24,"could not create process");
lf[321]=C_h_intern(&lf[321],14,"C_close_handle");
lf[322]=C_static_string(C_heaptop,4," /c ");
lf[323]=C_static_string(C_heaptop,1,"\000");
lf[324]=C_static_string(C_heaptop,22,"could not redirect I/O");
lf[325]=C_static_lambda_info(C_heaptop,9,"(body476)");
lf[326]=C_static_lambda_info(C_heaptop,12,"(def-env479)");
lf[327]=C_static_lambda_info(C_heaptop,13,"(def-args478)");
lf[328]=C_static_lambda_info(C_heaptop,26,"(process cmd472 . g471473)");
lf[329]=C_h_intern(&lf[329],12,"process-wait");
lf[330]=C_static_lambda_info(C_heaptop,31,"(process-wait pid501 . args502)");
lf[331]=C_h_intern(&lf[331],5,"sleep");
lf[332]=C_static_lambda_info(C_heaptop,12,"(sleep t509)");
lf[333]=C_h_intern(&lf[333],13,"get-host-name");
lf[334]=C_static_string(C_heaptop,26,"can not retrieve host-name");
lf[335]=C_static_lambda_info(C_heaptop,15,"(get-host-name)");
lf[336]=C_h_intern(&lf[336],18,"system-information");
lf[337]=C_static_string(C_heaptop,7,"windows");
lf[338]=C_static_string(C_heaptop,35,"can not retrieve system-information");
lf[339]=C_static_lambda_info(C_heaptop,20,"(system-information)");
lf[340]=C_h_intern(&lf[340],10,"find-files");
lf[341]=C_static_lambda_info(C_heaptop,13,"(f_3069 x537)");
lf[342]=C_static_string(C_heaptop,1,".");
lf[343]=C_static_string(C_heaptop,2,"..");
lf[344]=C_h_intern(&lf[344],8,"\003sysvoid");
lf[345]=C_static_lambda_info(C_heaptop,7,"(a3009)");
lf[346]=C_static_string(C_heaptop,1,"*");
lf[347]=C_static_lambda_info(C_heaptop,7,"(a3017)");
lf[348]=C_static_lambda_info(C_heaptop,7,"(a3031)");
lf[349]=C_h_intern(&lf[349],16,"\003sysdynamic-wind");
lf[350]=C_h_intern(&lf[350],13,"pathname-file");
lf[351]=C_static_lambda_info(C_heaptop,17,"(loop fs539 r540)");
lf[352]=C_static_string(C_heaptop,1,"*");
lf[353]=C_static_lambda_info(C_heaptop,15,"(f_3085 . _535)");
lf[354]=C_static_lambda_info(C_heaptop,15,"(f_3077 . _534)");
lf[355]=C_static_lambda_info(C_heaptop,34,"(body522 action529 id530 limit531)");
lf[356]=C_static_lambda_info(C_heaptop,38,"(def-limit526 %action519554 %id520555)");
lf[357]=C_static_lambda_info(C_heaptop,25,"(def-id525 %action519557)");
lf[358]=C_static_lambda_info(C_heaptop,17,"(a3105 x559 y560)");
lf[359]=C_static_lambda_info(C_heaptop,15,"(def-action524)");
lf[360]=C_static_lambda_info(C_heaptop,48,"(find-files dir516 pred517 . action-id-limit518)");
lf[361]=C_h_intern(&lf[361],17,"register-feature!");
lf[362]=C_h_intern(&lf[362],5,"posix");
lf[363]=C_static_lambda_info(C_heaptop,10,"(toplevel)");
C_register_lf2(lf,364,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_707,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k705 */
static void C_ccall f_707(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_707,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_710,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k708 in k705 */
static void C_ccall f_710(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_710,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_713,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k711 in k708 in k705 */
static void C_ccall f_713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_713,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_716,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k714 in k711 in k708 in k705 */
static void C_ccall f_716(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_716,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_719,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 619  register-feature! */
t3=*((C_word*)lf[361]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[362]);}

/* k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_719(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word ab[259],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_719,2,t0,t1);}
t2=C_mutate(&lf[2],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_721,a[2]=lf[7],tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[8]+1,C_fix((C_word)PIPE_BUF));
t4=C_mutate((C_word*)lf[9]+1,C_fix((C_word)O_RDONLY));
t5=C_mutate((C_word*)lf[10]+1,C_fix((C_word)O_WRONLY));
t6=C_mutate((C_word*)lf[11]+1,C_fix((C_word)O_RDWR));
t7=C_mutate((C_word*)lf[12]+1,C_fix((C_word)O_RDWR));
t8=C_mutate((C_word*)lf[13]+1,C_fix((C_word)O_WRONLY));
t9=C_mutate((C_word*)lf[14]+1,C_fix((C_word)O_CREAT));
t10=C_mutate((C_word*)lf[15]+1,C_fix((C_word)O_APPEND));
t11=C_mutate((C_word*)lf[16]+1,C_fix((C_word)O_EXCL));
t12=C_mutate((C_word*)lf[17]+1,C_fix((C_word)O_TRUNC));
t13=C_mutate((C_word*)lf[18]+1,C_fix((C_word)O_BINARY));
t14=C_mutate((C_word*)lf[19]+1,C_fix((C_word)O_TEXT));
t15=C_mutate((C_word*)lf[20]+1,C_fix((C_word)S_IREAD));
t16=C_mutate((C_word*)lf[21]+1,C_fix((C_word)S_IWRITE));
t17=C_mutate((C_word*)lf[22]+1,C_fix((C_word)S_IEXEC));
t18=C_mutate((C_word*)lf[23]+1,C_fix((C_word)S_IREAD));
t19=C_mutate((C_word*)lf[24]+1,C_fix((C_word)S_IWRITE));
t20=C_mutate((C_word*)lf[25]+1,C_fix((C_word)S_IEXEC));
t21=C_mutate((C_word*)lf[26]+1,C_fix((C_word)S_IREAD));
t22=C_mutate((C_word*)lf[27]+1,C_fix((C_word)S_IWRITE));
t23=C_mutate((C_word*)lf[28]+1,C_fix((C_word)S_IEXEC));
t24=C_mutate((C_word*)lf[29]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t25=C_mutate((C_word*)lf[30]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t26=C_mutate((C_word*)lf[31]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t27=(C_word)C_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IREAD));
t28=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC),t27);
t29=C_mutate((C_word*)lf[32]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_769,a[2]=t28,a[3]=lf[39],tmp=(C_word)a,a+=4,tmp));
t30=C_mutate((C_word*)lf[40]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_810,a[2]=lf[42],tmp=(C_word)a,a+=3,tmp));
t31=*((C_word*)lf[43]+1);
t32=C_mutate((C_word*)lf[44]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_828,a[2]=t31,a[3]=lf[48],tmp=(C_word)a,a+=4,tmp));
t33=C_mutate((C_word*)lf[49]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_873,a[2]=lf[52],tmp=(C_word)a,a+=3,tmp));
t34=*((C_word*)lf[53]+1);
t35=C_mutate((C_word*)lf[54]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_915,a[2]=t34,a[3]=lf[57],tmp=(C_word)a,a+=4,tmp));
t36=C_mutate((C_word*)lf[58]+1,C_fix((C_word)SEEK_SET));
t37=C_mutate((C_word*)lf[59]+1,C_fix((C_word)SEEK_END));
t38=C_mutate((C_word*)lf[60]+1,C_fix((C_word)SEEK_CUR));
t39=C_mutate(&lf[61],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_953,a[2]=lf[64],tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[65]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_991,a[2]=lf[67],tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[68]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1022,a[2]=lf[69],tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[70]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1028,a[2]=lf[71],tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[72]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1034,a[2]=lf[73],tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[74]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1040,a[2]=lf[75],tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[76]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1046,a[2]=lf[77],tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[78]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1052,a[2]=lf[79],tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[80]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1058,a[2]=lf[82],tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[83]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1081,a[2]=lf[84],tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[85]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1087,a[2]=lf[90],tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[91]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1127,a[2]=lf[96],tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[97]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1188,a[2]=lf[99],tmp=(C_word)a,a+=3,tmp));
t52=C_mutate((C_word*)lf[100]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1215,a[2]=lf[102],tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[103]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1242,a[2]=lf[105],tmp=(C_word)a,a+=3,tmp));
t54=*((C_word*)lf[106]+1);
t55=*((C_word*)lf[43]+1);
t56=*((C_word*)lf[107]+1);
t57=C_mutate((C_word*)lf[108]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1269,a[2]=t55,a[3]=lf[116],tmp=(C_word)a,a+=4,tmp));
t58=C_mutate((C_word*)lf[117]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1429,a[2]=lf[118],tmp=(C_word)a,a+=3,tmp));
t59=*((C_word*)lf[43]+1);
t60=C_mutate((C_word*)lf[114]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1452,a[2]=t59,a[3]=lf[120],tmp=(C_word)a,a+=4,tmp));
t61=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1498,a[2]=lf[122],tmp=(C_word)a,a+=3,tmp);
t62=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1510,a[2]=lf[124],tmp=(C_word)a,a+=3,tmp);
t63=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1516,a[2]=lf[129],tmp=(C_word)a,a+=3,tmp);
t64=C_mutate((C_word*)lf[130]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1534,a[2]=t62,a[3]=t63,a[4]=t61,a[5]=lf[132],tmp=(C_word)a,a+=6,tmp));
t65=C_mutate((C_word*)lf[133]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1570,a[2]=t62,a[3]=t63,a[4]=t61,a[5]=lf[134],tmp=(C_word)a,a+=6,tmp));
t66=C_mutate((C_word*)lf[135]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1606,a[2]=lf[138],tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[139]+1,*((C_word*)lf[135]+1));
t68=*((C_word*)lf[130]+1);
t69=*((C_word*)lf[133]+1);
t70=*((C_word*)lf[135]+1);
t71=*((C_word*)lf[139]+1);
t72=C_mutate((C_word*)lf[140]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1625,a[2]=t68,a[3]=t70,a[4]=lf[143],tmp=(C_word)a,a+=5,tmp));
t73=C_mutate((C_word*)lf[144]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1649,a[2]=t69,a[3]=t71,a[4]=lf[147],tmp=(C_word)a,a+=5,tmp));
t74=C_mutate((C_word*)lf[148]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1673,a[2]=t68,a[3]=t70,a[4]=lf[151],tmp=(C_word)a,a+=5,tmp));
t75=C_mutate((C_word*)lf[152]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1693,a[2]=t69,a[3]=t71,a[4]=lf[155],tmp=(C_word)a,a+=5,tmp));
t76=C_mutate((C_word*)lf[156]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1713,a[2]=lf[158],tmp=(C_word)a,a+=3,tmp));
t77=C_mutate((C_word*)lf[159]+1,C_fix((C_word)EPERM));
t78=C_mutate((C_word*)lf[160]+1,C_fix((C_word)ENOENT));
t79=C_mutate((C_word*)lf[161]+1,C_fix((C_word)ESRCH));
t80=C_mutate((C_word*)lf[162]+1,C_fix((C_word)EINTR));
t81=C_mutate((C_word*)lf[163]+1,C_fix((C_word)EIO));
t82=C_mutate((C_word*)lf[164]+1,C_fix((C_word)ENOEXEC));
t83=C_mutate((C_word*)lf[165]+1,C_fix((C_word)EBADF));
t84=C_mutate((C_word*)lf[166]+1,C_fix((C_word)ECHILD));
t85=C_mutate((C_word*)lf[167]+1,C_fix((C_word)ENOMEM));
t86=C_mutate((C_word*)lf[168]+1,C_fix((C_word)EACCES));
t87=C_mutate((C_word*)lf[169]+1,C_fix((C_word)EFAULT));
t88=C_mutate((C_word*)lf[170]+1,C_fix((C_word)EBUSY));
t89=C_mutate((C_word*)lf[171]+1,C_fix((C_word)EEXIST));
t90=C_mutate((C_word*)lf[172]+1,C_fix((C_word)ENOTDIR));
t91=C_mutate((C_word*)lf[173]+1,C_fix((C_word)EISDIR));
t92=C_mutate((C_word*)lf[174]+1,C_fix((C_word)EINVAL));
t93=C_mutate((C_word*)lf[175]+1,C_fix((C_word)EMFILE));
t94=C_mutate((C_word*)lf[176]+1,C_fix((C_word)ENOSPC));
t95=C_mutate((C_word*)lf[177]+1,C_fix((C_word)ESPIPE));
t96=C_mutate((C_word*)lf[178]+1,C_fix((C_word)EPIPE));
t97=C_mutate((C_word*)lf[179]+1,C_fix((C_word)EAGAIN));
t98=C_mutate((C_word*)lf[180]+1,C_fix((C_word)EROFS));
t99=C_mutate((C_word*)lf[181]+1,C_fix((C_word)ENXIO));
t100=C_mutate((C_word*)lf[182]+1,C_fix((C_word)E2BIG));
t101=C_mutate((C_word*)lf[183]+1,C_fix((C_word)EXDEV));
t102=C_mutate((C_word*)lf[184]+1,C_fix((C_word)ENODEV));
t103=C_mutate((C_word*)lf[185]+1,C_fix((C_word)ENFILE));
t104=C_mutate((C_word*)lf[186]+1,C_fix((C_word)ENOTTY));
t105=C_mutate((C_word*)lf[187]+1,C_fix((C_word)EFBIG));
t106=C_mutate((C_word*)lf[188]+1,C_fix((C_word)EMLINK));
t107=C_mutate((C_word*)lf[189]+1,C_fix((C_word)EDOM));
t108=C_mutate((C_word*)lf[190]+1,C_fix((C_word)ERANGE));
t109=C_mutate((C_word*)lf[191]+1,C_fix((C_word)EDEADLK));
t110=C_mutate((C_word*)lf[192]+1,C_fix((C_word)ENAMETOOLONG));
t111=C_mutate((C_word*)lf[193]+1,C_fix((C_word)ENOLCK));
t112=C_mutate((C_word*)lf[194]+1,C_fix((C_word)ENOSYS));
t113=C_mutate((C_word*)lf[195]+1,C_fix((C_word)ENOTEMPTY));
t114=C_mutate((C_word*)lf[196]+1,C_fix((C_word)EILSEQ));
t115=C_mutate((C_word*)lf[197]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1769,a[2]=lf[199],tmp=(C_word)a,a+=3,tmp));
t116=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1799,a[2]=lf[200],tmp=(C_word)a,a+=3,tmp);
t117=C_mutate((C_word*)lf[201]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1823,a[2]=t116,a[3]=lf[202],tmp=(C_word)a,a+=4,tmp));
t118=C_mutate((C_word*)lf[203]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1829,a[2]=t116,a[3]=lf[204],tmp=(C_word)a,a+=4,tmp));
t119=C_mutate((C_word*)lf[205]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1835,a[2]=t116,a[3]=lf[206],tmp=(C_word)a,a+=4,tmp));
t120=C_mutate((C_word*)lf[207]+1,C_fix((C_word)0));
t121=C_mutate((C_word*)lf[208]+1,C_fix((C_word)1));
t122=C_mutate((C_word*)lf[209]+1,C_fix((C_word)2));
t123=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1844,a[2]=lf[216],tmp=(C_word)a,a+=3,tmp);
t124=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1881,a[2]=lf[219],tmp=(C_word)a,a+=3,tmp);
t125=C_mutate((C_word*)lf[220]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1899,a[2]=t123,a[3]=t124,a[4]=lf[221],tmp=(C_word)a,a+=5,tmp));
t126=C_mutate((C_word*)lf[222]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1913,a[2]=t123,a[3]=t124,a[4]=lf[223],tmp=(C_word)a,a+=5,tmp));
t127=C_mutate((C_word*)lf[224]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1927,a[2]=lf[228],tmp=(C_word)a,a+=3,tmp));
t128=C_mutate((C_word*)lf[229]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1962,a[2]=lf[231],tmp=(C_word)a,a+=3,tmp));
t129=C_mutate((C_word*)lf[232]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1992,a[2]=lf[233],tmp=(C_word)a,a+=3,tmp));
t130=C_mutate((C_word*)lf[234]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2009,a[2]=lf[235],tmp=(C_word)a,a+=3,tmp));
t131=*((C_word*)lf[236]+1);
t132=C_mutate((C_word*)lf[237]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2029,a[2]=t131,a[3]=lf[241],tmp=(C_word)a,a+=4,tmp));
t133=C_mutate((C_word*)lf[242]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2094,a[2]=lf[244],tmp=(C_word)a,a+=3,tmp));
t134=C_mutate((C_word*)lf[245]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2103,a[2]=lf[246],tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[247]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2122,a[2]=lf[249],tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[250]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2139,a[2]=lf[253],tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[254]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2167,a[2]=lf[258],tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[259]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2201,a[2]=lf[261],tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[262]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2220,a[2]=lf[268],tmp=(C_word)a,a+=3,tmp));
t140=*((C_word*)lf[269]+1);
t141=*((C_word*)lf[108]+1);
t142=*((C_word*)lf[270]+1);
t143=*((C_word*)lf[271]+1);
t144=C_mutate((C_word*)lf[272]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2279,a[2]=t140,a[3]=t141,a[4]=t142,a[5]=t143,a[6]=lf[280],tmp=(C_word)a,a+=7,tmp));
t145=C_mutate((C_word*)lf[281]+1,C_fix((C_word)P_OVERLAY));
t146=C_mutate((C_word*)lf[282]+1,C_fix((C_word)P_WAIT));
t147=C_mutate((C_word*)lf[283]+1,C_fix((C_word)P_NOWAIT));
t148=C_mutate((C_word*)lf[284]+1,C_fix((C_word)P_NOWAITO));
t149=C_mutate((C_word*)lf[285]+1,C_fix((C_word)P_DETACH));
t150=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2388,a[2]=lf[286],tmp=(C_word)a,a+=3,tmp);
t151=*((C_word*)lf[287]+1);
t152=C_mutate((C_word*)lf[288]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2407,a[2]=t151,a[3]=t150,a[4]=lf[294],tmp=(C_word)a,a+=5,tmp));
t153=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2551,a[2]=lf[295],tmp=(C_word)a,a+=3,tmp);
t154=*((C_word*)lf[287]+1);
t155=C_mutate((C_word*)lf[296]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2570,a[2]=t154,a[3]=t153,a[4]=lf[299],tmp=(C_word)a,a+=5,tmp));
t156=C_mutate((C_word*)lf[300]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2663,a[2]=lf[301],tmp=(C_word)a,a+=3,tmp));
t157=C_mutate((C_word*)lf[302]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2666,a[2]=lf[303],tmp=(C_word)a,a+=3,tmp));
t158=*((C_word*)lf[296]+1);
t159=*((C_word*)lf[304]+1);
t160=C_mutate((C_word*)lf[305]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2672,a[2]=t158,a[3]=lf[307],tmp=(C_word)a,a+=4,tmp));
t161=C_mutate(&lf[308],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2701,a[2]=lf[309],tmp=(C_word)a,a+=3,tmp));
t162=*((C_word*)lf[310]+1);
t163=*((C_word*)lf[311]+1);
t164=C_mutate((C_word*)lf[312]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2704,a[2]=t162,a[3]=t163,a[4]=lf[328],tmp=(C_word)a,a+=5,tmp));
t165=C_mutate((C_word*)lf[329]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2855,a[2]=lf[330],tmp=(C_word)a,a+=3,tmp));
t166=C_mutate((C_word*)lf[331]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2897,a[2]=lf[332],tmp=(C_word)a,a+=3,tmp));
t167=C_mutate((C_word*)lf[333]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2900,a[2]=lf[335],tmp=(C_word)a,a+=3,tmp));
t168=C_mutate((C_word*)lf[336]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2912,a[2]=lf[339],tmp=(C_word)a,a+=3,tmp));
t169=*((C_word*)lf[272]+1);
t170=*((C_word*)lf[274]+1);
t171=*((C_word*)lf[270]+1);
t172=*((C_word*)lf[117]+1);
t173=C_mutate((C_word*)lf[340]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2943,a[2]=t172,a[3]=t171,a[4]=t169,a[5]=t170,a[6]=lf[360],tmp=(C_word)a,a+=7,tmp));
t174=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t174+1)))(2,t174,C_SCHEME_UNDEFINED);}

/* find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2943(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+21)){
C_save_and_reclaim((void*)tr4r,(void*)f_2943r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2943r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2943r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(21);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2945,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,a[8]=lf[355],tmp=(C_word)a,a+=9,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3090,a[2]=t5,a[3]=lf[356],tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3095,a[2]=t6,a[3]=lf[357],tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3100,a[2]=t7,a[3]=lf[359],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action524558 */
t9=t8;
f_3100(t9,t1);}
else{
t9=(C_word)C_i_car(t4);
t10=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id525556 */
t11=t7;
f_3095(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit526553 */
t13=t6;
f_3090(t13,t1,t9,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* body522528 */
t15=t5;
f_2945(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}}}}

/* def-action524 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_3100(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3100,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3106,a[2]=lf[358],tmp=(C_word)a,a+=3,tmp);
/* def-id525556 */
t3=((C_word*)t0)[2];
f_3095(t3,t1,t2);}

/* a3105 in def-action524 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3106(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3106,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id525 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_3095(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3095,NULL,3,t0,t1,t2);}
/* def-limit526553 */
t3=((C_word*)t0)[2];
f_3090(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit526 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_3090(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3090,NULL,4,t0,t1,t2,t3);}
/* body522528 */
t4=((C_word*)t0)[2];
f_2945(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2945(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2945,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[340]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_2952,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_2952(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3085,a[2]=t4,a[3]=t7,a[4]=lf[353],tmp=(C_word)a,a+=5,tmp):t4));}
else{
t10=t8;
f_2952(t10,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3077,a[2]=lf[354],tmp=(C_word)a,a+=3,tmp));}}

/* f_3077 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3077(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3077,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_3085 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3085(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3085,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2952(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2952,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3069,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],a[4]=lf[341],tmp=(C_word)a,a+=5,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2962,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3065,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1464 make-pathname */
t6=((C_word*)t0)[7];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],lf[352]);}

/* k3063 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1464 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2962(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2962,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2964,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,a[10]=lf[351],tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_2964(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2964(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2964,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_2983,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixwin.scm: 1470 directory? */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t4);}}

/* k2981 in loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2983(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2983,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3045,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 1471 pathname-file */
t3=*((C_word*)lf[350]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3051,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 1477 pproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}}

/* k3049 in k2981 in loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3051(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3051,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3058,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1477 action */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixwin.scm: 1478 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_2964(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k3056 in k3049 in k2981 in loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1477 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2964(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k3043 in k2981 in loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3045(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3045,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[342]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[343]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixwin.scm: 1471 loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_2964(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2998,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posixwin.scm: 1472 lproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[3]);}}

/* k2996 in k3043 in k2981 in loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2998(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2998,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3008,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3010,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,a[5]=lf[345],tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3018,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=lf[347],tmp=(C_word)a,a+=8,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3032,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,a[5]=lf[348],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1474 ##sys#dynamic-wind */
t11=*((C_word*)lf[349]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
/* posixwin.scm: 1476 loop */
t2=((C_word*)((C_word*)t0)[8])[1];
f_2964(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a3031 in k2996 in k3043 in k2981 in loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3032(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3032,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
/* posixwin.scm: 1474 ##sys#void */
t4=*((C_word*)lf[344]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t1);}

/* a3017 in k2996 in k3043 in k2981 in loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3018(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3018,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3026,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3030,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1475 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[2],lf[346]);}

/* k3028 in a3017 in k2996 in k3043 in k2981 in loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3030(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1475 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3024 in a3017 in k2996 in k3043 in k2981 in loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3026(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1475 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2964(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a3009 in k2996 in k3043 in k2981 in loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3010,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
/* posixwin.scm: 1474 ##sys#void */
t4=*((C_word*)lf[344]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t1);}

/* k3006 in k2996 in k3043 in k2981 in loop in k2960 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3008(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1473 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2964(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_3069 in k2950 in body522 in find-files in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_3069(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3069,3,t0,t1,t2);}
/* posixwin.scm: 1462 string-match */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[2],t2);}

/* system-information in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2912(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2912,2,t0,t1);}
if(C_truep((C_word)C_sysinfo())){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2923,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[239]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2938,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1439 ##sys#update-errno */
t3=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k2936 in system-information in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2938(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1440 ##sys#error */
t2=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[336],lf[338]);}

/* k2921 in system-information in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2923(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2923,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2927,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[239]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osrel),C_fix(0));}

/* k2925 in k2921 in system-information in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2927(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2927,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2931,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[239]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osver),C_fix(0));}

/* k2929 in k2925 in k2921 in system-information in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2931(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2931,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2935,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[239]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_processor),C_fix(0));}

/* k2933 in k2929 in k2925 in k2921 in system-information in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2935(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2935,2,t0,t1);}
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,lf[337],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* get-host-name in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2900(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2900,2,t0,t1);}
if(C_truep((C_word)C_get_hostname())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[239]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
/* posixwin.scm: 1432 ##sys#error */
t2=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[333],lf[334]);}}

/* sleep in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2897(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2897,3,t0,t1,t2);}
t3=(C_word)C_sleep(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_fix(0));}

/* process-wait in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2855(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_2855r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2855r(t0,t1,t2,t3);}}

static void C_ccall f_2855r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t4=(C_word)C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_i_car(t3));
t6=(C_word)C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t3));
if(C_truep((C_word)C_i_nullp(t7))){
if(C_truep((C_word)C_process_wait(t2,t5))){
/* posixwin.scm: 1413 values */
C_values(5,0,t1,t2,C_SCHEME_TRUE,C_fix((C_word)C_exstatus));}
else{
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2877,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1415 ##sys#update-errno */
t9=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}}
else{
/* ##sys#error */
t8=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t1,lf[0],t7);}}

/* k2875 in process-wait in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1416 values */
C_values(5,0,((C_word*)t0)[2],C_fix(0),C_SCHEME_FALSE,C_fix(0));}

/* process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2704(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+14)){
C_save_and_reclaim((void*)tr3r,(void*)f_2704r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2704r(t0,t1,t2,t3);}}

static void C_ccall f_2704r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(14);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2706,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=lf[325],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2802,a[2]=t4,a[3]=lf[326],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2807,a[2]=t5,a[3]=lf[327],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args478496 */
t7=t6;
f_2807(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env479494 */
t9=t5;
f_2802(t9,t1);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body476481 */
t11=t4;
f_2706(t11,t1);}
else{
/* ##sys#error */
t11=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-args478 in process in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2807(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2807,NULL,2,t0,t1);}
/* def-env479494 */
t2=((C_word*)t0)[2];
f_2802(t2,t1);}

/* def-env479 in process in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2802(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2802,NULL,2,t0,t1);}
/* body476481 */
t2=((C_word*)t0)[2];
f_2706(t2,t1);}

/* body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2706(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2706,NULL,2,t0,t1);}
if(C_truep((C_word)C_redir_io())){
t2=C_fix((C_word)C_wr0_);
t3=C_fix((C_word)C_rd1_);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2713,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2798,a[2]=((C_word*)t0)[2],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1374 get-shell */
t6=*((C_word*)lf[302]+1);
((C_proc2)C_retrieve_proc(t6))(2,t6,t5);}
else{
/* posixwin.scm: 1405 ##sys#error */
t2=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[312],lf[324]);}}

/* k2796 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2798(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1374 string-append */
t2=*((C_word*)lf[106]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],t1,lf[322],((C_word*)t0)[2],lf[323]);}

/* k2711 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2713,2,t0,t1);}
t2=(C_word)C_run_process(t1);
if(C_truep((C_word)C_fixnum_greaterp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2726,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t2,a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2751,a[2]=((C_word*)t0)[3],a[3]=lf[317],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2775,a[2]=((C_word*)t0)[3],a[3]=lf[318],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2778,a[2]=((C_word*)t0)[3],a[3]=lf[319],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1378 make-input-port */
t7=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t7))(5,t7,t3,t4,t5,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2785,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1400 ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2783 in k2711 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2785(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2785,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2788,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1401 C_close_handle */
t3=*((C_word*)lf[321]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k2786 in k2783 in k2711 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2788(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2788,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2791,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1402 C_close_handle */
t3=*((C_word*)lf[321]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k2789 in k2786 in k2783 in k2711 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2791(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1403 ##sys#error */
t2=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[312],lf[320]);}

/* a2777 in k2711 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2778,2,t0,t1);}
/* posixwin.scm: 1387 close-handle */
t2=t1;
((C_proc2)C_retrieve_proc(t2))(2,t2,f_2701(((C_word*)t0)[2]));}

/* a2774 in k2711 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2775(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2775,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_pipe_ready(((C_word*)t0)[2]));}

/* a2750 in k2711 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2751(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2751,2,t0,t1);}
t2=(C_word)C_pipe_read(((C_word*)t0)[2]);
switch(t2){
case C_fix(-1):
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_FILE);
case C_fix(0):
/* posixwin.scm: 1382 ##sys#error */
t3=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[312],lf[316]);
default:
t3=(C_word)C_eqp(t2,C_fix(1));
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_make_character((C_word)C_rdbuf):C_SCHEME_UNDEFINED));}}

/* k2724 in k2711 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2726(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2726,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2730,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2732,a[2]=((C_word*)t0)[3],a[3]=lf[314],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2745,a[2]=((C_word*)t0)[3],a[3]=lf[315],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1391 make-output-port */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t2,t3,t4);}

/* a2744 in k2724 in k2711 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2745(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2745,2,t0,t1);}
/* posixwin.scm: 1396 close-handle */
t2=t1;
((C_proc2)C_retrieve_proc(t2))(2,t2,f_2701(((C_word*)t0)[2]));}

/* a2731 in k2724 in k2711 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2732(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2732,3,t0,t1,t2);}
t3=(C_word)C_i_string_length(t2);
if(C_truep((C_word)C_pipe_write(((C_word*)t0)[2],t2,t3))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1394 ##sys#error */
t4=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,lf[312],lf[313]);}}

/* k2728 in k2724 in k2711 in body476 in process in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2730(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1377 values */
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* close-handle in k717 in k714 in k711 in k708 in k705 */
static C_word C_fcall f_2701(C_word t1){
C_word tmp;
C_word t2;
C_stack_check;
return((C_word)stub466(C_SCHEME_UNDEFINED,t1));}

/* process-run in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2672(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_2672r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_2672r(t0,t1,t2,t3);}}

static void C_ccall f_2672r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t5)){
/* posixwin.scm: 1356 process-spawn */
t6=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t6))(5,t6,t1,*((C_word*)lf[283]+1),t2,t5);}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2689,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1357 get-shell */
t7=*((C_word*)lf[302]+1);
((C_proc2)C_retrieve_proc(t7))(2,t7,t6);}}

/* k2687 in process-run in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2689,2,t0,t1);}
t2=(C_word)C_a_i_list(&a,2,lf[306],((C_word*)t0)[4]);
/* posixwin.scm: 1357 process-spawn */
t3=((C_word*)t0)[3];
((C_proc5)C_retrieve_proc(t3))(5,t3,((C_word*)t0)[2],*((C_word*)lf[283]+1),t1,t2);}

/* get-shell in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2666(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2666,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[239]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub457(t2),C_fix(0));}

/* current-process-id in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2663(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2663,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub455(C_SCHEME_UNDEFINED));}

/* process-spawn in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2570(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2570r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2570r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2570r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(7);
t5=(C_word)C_i_check_exact_2(t2,lf[296]);
t6=(C_word)C_i_check_string_2(t3,lf[296]);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_SCHEME_END_OF_LIST);
t9=(C_word)C_i_check_list_2(t8,lf[296]);
t10=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2586,a[2]=t8,a[3]=t1,a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1315 pathname-strip-directory */
t11=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t11))(3,t11,t10,t3);}

/* k2584 in process-spawn in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2586(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2586,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_2551(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2594,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=lf[298],tmp=(C_word)a,a+=7,tmp));
t7=((C_word*)t5)[1];
f_2594(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do438 in k2584 in process-spawn in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2594(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2594,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_2551(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2608,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2627,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1322 ##sys#expand-home-path */
t7=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[3]);}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[296]);
t6=(C_word)C_block_size(t4);
t7=f_2551(t3,t4,t6);
t8=(C_word)C_i_cdr(t2);
t9=(C_word)C_fixnum_plus(t3,C_fix(1));
t14=t1;
t15=t8;
t16=t9;
t1=t14;
t2=t15;
t3=t16;
goto loop;}}

/* k2625 in do438 in k2584 in process-spawn in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2627(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1322 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2606 in do438 in k2584 in process-spawn in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2608(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2608,2,t0,t1);}
t2=(C_word)C_spawnvp(((C_word*)t0)[4],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2611,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1323 ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2609 in k2606 in do438 in k2584 in process-spawn in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2611(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2611,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2614,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_eqp(((C_word*)t0)[3],C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub431(C_SCHEME_UNDEFINED);
/* posixwin.scm: 1326 ##sys#error */
t5=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,lf[296],lf[297],((C_word*)t0)[2]);}
else{
t4=t2;
f_2614(2,t4,C_SCHEME_UNDEFINED);}}

/* k2612 in k2609 in k2606 in do438 in k2584 in process-spawn in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* setarg in k717 in k714 in k711 in k708 in k705 */
static C_word C_fcall f_2551(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub424(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* process-execute in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2407(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+14)){
C_save_and_reclaim((void*)tr3r,(void*)f_2407r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2407r(t0,t1,t2,t3);}}

static void C_ccall f_2407r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(14);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2409,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=lf[291],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2498,a[2]=t4,a[3]=lf[292],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2503,a[2]=t5,a[3]=lf[293],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist388413 */
t7=t6;
f_2503(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist389411 */
t9=t5;
f_2498(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body386391 */
t11=t4;
f_2409(t11,t1,t7);}
else{
/* ##sys#error */
t11=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-arglist388 in process-execute in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2503(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2503,NULL,2,t0,t1);}
/* def-envlist389411 */
t2=((C_word*)t0)[2];
f_2498(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist389 in process-execute in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2498(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2498,NULL,3,t0,t1,t2);}
/* body386391 */
t3=((C_word*)t0)[2];
f_2409(t3,t1,t2);}

/* body386 in process-execute in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2409(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2409,NULL,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(((C_word*)t0)[4],lf[288]);
t4=(C_word)C_i_pairp(t2);
t5=(C_truep(t4)?(C_word)C_i_car(t2):C_SCHEME_END_OF_LIST);
t6=(C_word)C_i_check_list_2(t5,lf[288]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2422,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1291 pathname-strip-directory */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,((C_word*)t0)[4]);}

/* k2420 in body386 in process-execute in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2422(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2422,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_2388(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2430,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=lf[290],tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_2430(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do396 in k2420 in body386 in process-execute in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2430(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2430,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_2388(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2444,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2463,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1297 ##sys#expand-home-path */
t7=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[3]);}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[288]);
t6=(C_word)C_block_size(t4);
t7=f_2388(t3,t4,t6);
t8=(C_word)C_i_cdr(t2);
t9=(C_word)C_fixnum_plus(t3,C_fix(1));
t14=t1;
t15=t8;
t16=t9;
t1=t14;
t2=t15;
t3=t16;
goto loop;}}

/* k2461 in do396 in k2420 in body386 in process-execute in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2463(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1297 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2442 in do396 in k2420 in body386 in process-execute in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2444(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2444,2,t0,t1);}
t2=(C_word)C_execvp(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2447,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1298 ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2445 in k2442 in do396 in k2420 in body386 in process-execute in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2447(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[4],C_fix(-1));
if(C_truep(t2)){
t3=(C_word)stub379(C_SCHEME_UNDEFINED);
/* posixwin.scm: 1301 ##sys#error */
t4=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],lf[288],lf[289],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* setarg in k717 in k714 in k711 in k708 in k705 */
static C_word C_fcall f_2388(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub372(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* glob in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2279(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr2r,(void*)f_2279r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2279r(t0,t1,t2);}}

static void C_ccall f_2279r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(10);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2285,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],a[7]=lf[279],tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_2285(t6,t1,t2);}

/* conc in glob in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2285(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2285,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2300,a[2]=t3,a[3]=((C_word*)t0)[6],a[4]=lf[273],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2306,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=lf[278],tmp=(C_word)a,a+=8,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* a2305 in conc in glob in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2306(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_2306,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2310,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2377,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[277]);
/* posixwin.scm: 1261 make-pathname */
t8=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k2375 in a2305 in conc in glob in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2377(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1261 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k2308 in a2305 in conc in glob in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2310(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2310,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2317,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[276]);
/* posixwin.scm: 1262 directory */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t2,t3);}

/* k2315 in k2308 in a2305 in conc in glob in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2317(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2317,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2319,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=lf[275],tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_2319(t5,((C_word*)t0)[2],t1);}

/* loop in k2315 in k2308 in a2305 in conc in glob in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2319(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2319,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_i_cdr(((C_word*)t0)[7]);
/* posixwin.scm: 1263 conc */
t4=((C_word*)((C_word*)t0)[6])[1];
f_2285(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2336,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_i_car(t2);
/* posixwin.scm: 1264 string-match */
t5=*((C_word*)lf[274]+1);
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k2334 in loop in k2315 in k2308 in a2305 in conc in glob in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2336(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2336,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2346,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(t1);
/* posixwin.scm: 1265 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
/* posixwin.scm: 1266 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2319(t3,((C_word*)t0)[6],t2);}}

/* k2344 in k2334 in loop in k2315 in k2308 in a2305 in conc in glob in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2346(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2346,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2350,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_cdr(((C_word*)t0)[3]);
/* posixwin.scm: 1265 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_2319(t4,t2,t3);}

/* k2348 in k2344 in k2334 in loop in k2315 in k2308 in a2305 in conc in glob in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2350(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2350,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a2299 in conc in glob in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2300(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2300,2,t0,t1);}
/* posixwin.scm: 1260 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* set-buffering-mode! in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2220(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2220r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2220r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2220r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2224,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1234 ##sys#check-port */
t6=*((C_word*)lf[137]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[262]);}

/* k2222 in set-buffering-mode! in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2224(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2224,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2230,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[264]);
if(C_truep(t6)){
t7=t5;
f_2230(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[265]);
if(C_truep(t7)){
t8=t5;
f_2230(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[266]);
if(C_truep(t8)){
t9=t5;
f_2230(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixwin.scm: 1240 ##sys#error */
t9=*((C_word*)lf[66]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[262],lf[267],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k2228 in k2222 in set-buffering-mode! in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2230(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[262]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[87],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixwin.scm: 1246 ##sys#error */
t6=*((C_word*)lf[66]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[262],lf[263],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* _exit in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2201(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2rv,(void*)f_2201r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_2201r(t0,t1,t2);}}

static void C_ccall f_2201r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2205,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1224 ##sys#cleanup-before-exit */
t4=*((C_word*)lf[260]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

/* k2203 in _exit in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2205(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=t4;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub323(C_SCHEME_UNDEFINED,t5));}

/* local-time->seconds in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2167(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2167,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[254]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2174,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixwin.scm: 1212 ##sys#error */
t6=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[254],lf[257],t2);}
else{
t6=t4;
f_2174(2,t6,C_SCHEME_UNDEFINED);}}

/* k2172 in local-time->seconds in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2174(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixwin.scm: 1214 ##sys#cons-flonum */
t2=*((C_word*)lf[255]+1);
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}
else{
/* posixwin.scm: 1215 ##sys#error */
t2=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[254],lf[256],((C_word*)t0)[3]);}}

/* time->string in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2139(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2139,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[250]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2146,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixwin.scm: 1205 ##sys#error */
t6=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[250],lf[252],t2);}
else{
t6=t4;
f_2146(2,t6,C_SCHEME_UNDEFINED);}}

/* k2144 in time->string in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2146(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2146,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2149,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[239]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub309(t4,t3),C_fix(0));}

/* k2147 in k2144 in time->string in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2149(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2149,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2152,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_2152(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1207 ##sys#error */
t3=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[250],lf[251],((C_word*)t0)[2]);}}

/* k2150 in k2147 in k2144 in time->string in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->string in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2122(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2122,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2126,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_integer_argumentp(t4);
t7=(C_word)stub300(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[239]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k2124 in seconds->string in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2126(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2126,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2129,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_2129(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1198 ##sys#error */
t3=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[247],lf[248],((C_word*)t0)[2]);}}

/* k2127 in k2124 in seconds->string in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2129(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->utc-time in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2103(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2103,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[245]);
/* posixwin.scm: 1192 ##sys#decode-seconds */
t4=*((C_word*)lf[243]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2094(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2094,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[242]);
/* posixwin.scm: 1188 ##sys#decode-seconds */
t4=*((C_word*)lf[243]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* current-environment in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2029,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2035,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=lf[240],tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_2035(t5,t1,C_fix(0));}

/* loop in current-environment in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2035(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2035,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2039,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub283(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[239]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k2037 in loop in current-environment in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2039,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2047,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=lf[238],tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_2047(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k2037 in loop in current-environment in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_2047(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2047,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2073,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 1180 substring */
t5=((C_word*)t0)[3];
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posixwin.scm: 1181 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k2071 in scan in k2037 in loop in current-environment in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2073(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2073,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2077,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[3]);
/* posixwin.scm: 1180 substring */
t5=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t5))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

/* k2075 in k2071 in scan in k2037 in loop in current-environment in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2077,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2065,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1180 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_2035(t5,t3,t4);}

/* k2063 in k2075 in k2071 in scan in k2037 in loop in current-environment in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2065,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2009(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2009,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[234]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2017,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1168 ##sys#make-c-string */
t5=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2015 in unsetenv in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2017(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1992(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_1992,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[232]);
t5=(C_word)C_i_check_string_2(t3,lf[232]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2003,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1163 ##sys#make-c-string */
t7=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k2001 in setenv in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2003(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2003,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2007,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1163 ##sys#make-c-string */
t3=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k2005 in k2001 in setenv in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_2007(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* duplicate-fileno in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1962(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_1962r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_1962r(t0,t1,t2,t3);}}

static void C_ccall f_1962r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[229]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1969,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_1969(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_i_vector_ref(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[229]);
t8=t5;
f_1969(t8,(C_word)C_dup2(t2,t6));}}

/* k1967 in duplicate-fileno in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_1969(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1969,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1972,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1978,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1153 ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_1972(2,t3,C_SCHEME_UNDEFINED);}}

/* k1976 in k1967 in duplicate-fileno in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1978(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1154 ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[34],lf[229],lf[230],((C_word*)t0)[2]);}

/* k1970 in k1967 in duplicate-fileno in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1972(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1927(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1927,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1931,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1135 ##sys#check-port */
t4=*((C_word*)lf[137]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[224]);}

/* k1929 in port->fileno in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1931(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1931,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1960,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1136 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[227]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k1958 in k1929 in port->fileno in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1960(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1960,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixwin.scm: 1142 ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[46],lf[224],lf[225],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1940,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1946,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1139 ##sys#update-errno */
t5=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_1940(2,t4,C_SCHEME_UNDEFINED);}}}

/* k1944 in k1958 in k1929 in port->fileno in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1946(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1140 ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[34],lf[224],lf[226],((C_word*)t0)[2]);}

/* k1938 in k1958 in k1929 in port->fileno in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1913(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_1913r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1913r(t0,t1,t2,t3);}}

static void C_ccall f_1913r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[222]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1925,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1131 mode */
f_1844(t5,C_SCHEME_FALSE,t3);}

/* k1923 in open-output-file* in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1925(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1925,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1131 check */
f_1881(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1899(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_1899r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1899r(t0,t1,t2,t3);}}

static void C_ccall f_1899r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[220]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1911,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1127 mode */
f_1844(t5,C_SCHEME_TRUE,t3);}

/* k1909 in open-input-file* in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1911(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1911,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1127 check */
f_1881(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_1881(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1881,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1885,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1118 ##sys#update-errno */
t6=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k1883 in check in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1885,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1120 ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[34],lf[217],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1897,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1121 ##sys#make-port */
t3=*((C_word*)lf[126]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[127]+1),lf[218],lf[87]);}}

/* k1895 in k1883 in check in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1897(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_1844(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1844,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1852,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_i_car(t3);
t6=(C_word)C_eqp(t5,lf[210]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixwin.scm: 1113 ##sys#error */
t8=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[211],t5);}
else{
t8=t4;
f_1852(2,t8,lf[212]);}}
else{
/* posixwin.scm: 1114 ##sys#error */
t7=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[213],t5);}}
else{
t5=t4;
f_1852(2,t5,(C_truep(t2)?lf[214]:lf[215]));}}

/* k1850 in mode in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1852(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1109 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-execute-access? in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1835(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1835,3,t0,t1,t2);}
/* posixwin.scm: 1093 check */
f_1799(t1,t2,C_fix((C_word)2),lf[205]);}

/* file-write-access? in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1829(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1829,3,t0,t1,t2);}
/* posixwin.scm: 1092 check */
f_1799(t1,t2,C_fix((C_word)4),lf[203]);}

/* file-read-access? in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1823(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1823,3,t0,t1,t2);}
/* posixwin.scm: 1091 check */
f_1799(t1,t2,C_fix((C_word)2),lf[201]);}

/* check in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_1799(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1799,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1817,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1821,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1088 ##sys#expand-home-path */
t8=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}

/* k1819 in check in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1821(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1088 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1815 in check in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1817(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1817,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1809,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_1809(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1089 ##sys#update-errno */
t5=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k1807 in k1815 in check in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1809(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-mode in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1769(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_1769,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[197]);
t5=(C_word)C_i_check_exact_2(t3,lf[197]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1793,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1797,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1077 ##sys#expand-home-path */
t8=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}

/* k1795 in change-file-mode in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1797(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1077 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1791 in change-file-mode in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1793(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1793,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1785,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1078 ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k1783 in k1791 in change-file-mode in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1785(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1079 ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[34],lf[197],lf[198],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* create-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1713,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1717,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1726,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 985  ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_1717(2,t3,C_SCHEME_UNDEFINED);}}

/* k1724 in create-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1726(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 986  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[34],lf[156],lf[157]);}

/* k1715 in create-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1717(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 987  values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1693(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_1693r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1693r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1693r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[153]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1697,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k1695 in with-output-to-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1697(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1697,2,t0,t1);}
t2=C_mutate((C_word*)lf[153]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1703,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=lf[154],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 970  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a1702 in k1695 in with-output-to-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1703(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_1703r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1703r(t0,t1,t2);}}

static void C_ccall f_1703r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1707,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 972  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k1705 in a1702 in k1695 in with-output-to-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1707(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[153]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1673(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_1673r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1673r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1673r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[149]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1677,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k1675 in with-input-from-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1677(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1677,2,t0,t1);}
t2=C_mutate((C_word*)lf[149]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1683,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=lf[150],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 960  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a1682 in k1675 in with-input-from-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1683(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_1683r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1683r(t0,t1,t2);}}

static void C_ccall f_1683r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1687,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 962  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k1685 in a1682 in k1675 in with-input-from-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1687(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[149]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1649(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_1649r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1649r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1649r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1653,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k1651 in call-with-output-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1653(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1653,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1658,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=lf[145],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1664,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=lf[146],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 950  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a1663 in k1651 in call-with-output-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1664(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_1664r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1664r(t0,t1,t2);}}

static void C_ccall f_1664r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1668,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 953  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k1666 in a1663 in k1651 in call-with-output-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a1657 in k1651 in call-with-output-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1658(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1658,2,t0,t1);}
/* posixwin.scm: 951  proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1625(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_1625r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1625r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1625r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1629,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k1627 in call-with-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1629(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1629,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1634,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=lf[141],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1640,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=lf[142],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 942  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a1639 in k1627 in call-with-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1640(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_1640r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1640r(t0,t1,t2);}}

static void C_ccall f_1640r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1644,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 945  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k1642 in a1639 in k1627 in call-with-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a1633 in k1627 in call-with-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1634,2,t0,t1);}
/* posixwin.scm: 943  proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1606(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1606,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1610,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 929  ##sys#check-port */
t4=*((C_word*)lf[137]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[135]);}

/* k1608 in close-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1610(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1610,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1613,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 931  ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k1611 in k1608 in close-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1613(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
/* posixwin.scm: 932  ##sys#signal-hook */
t3=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[34],lf[135],lf[136],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* open-output-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1570(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_1570r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1570r(t0,t1,t2,t3);}}

static void C_ccall f_1570r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[133]);
t5=f_1498(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1584,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[121]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1591,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 924  ##sys#make-c-string */
t9=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[131]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1601,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 925  ##sys#make-c-string */
t10=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixwin.scm: 926  badmode */
f_1510(t6,t5);}}}

/* k1599 in open-output-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1601(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1601,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1584(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k1589 in open-output-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1591(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1591,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1584(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k1582 in open-output-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1584(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 921  check */
f_1516(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1534(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_1534r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1534r(t0,t1,t2,t3);}}

static void C_ccall f_1534r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[130]);
t5=f_1498(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1548,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[121]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1555,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 914  ##sys#make-c-string */
t9=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[131]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1565,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 915  ##sys#make-c-string */
t10=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixwin.scm: 916  badmode */
f_1510(t6,t5);}}}

/* k1563 in open-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1565(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1565,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1548(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k1553 in open-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1555,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1548(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k1546 in open-input-pipe in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1548(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 911  check */
f_1516(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_1516(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1516,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1520,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 901  ##sys#update-errno */
t6=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k1518 in check in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1520(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1520,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 903  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[34],lf[125],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1532,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 904  ##sys#make-port */
t3=*((C_word*)lf[126]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[127]+1),lf[128],lf[87]);}}

/* k1530 in k1518 in check in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1532(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_1510(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1510,NULL,2,t1,t2);}
/* posixwin.scm: 899  ##sys#error */
t3=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[123],t2);}

/* mode in k717 in k714 in k711 in k708 in k705 */
static C_word C_fcall f_1498(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[121]));}

/* current-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1452(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_1452r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1452r(t0,t1,t2);}}

static void C_ccall f_1452r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1456,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_1456(2,t4,C_SCHEME_FALSE);}
else{
t4=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t3;
f_1456(2,t5,(C_word)C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[0],t2);}}}

/* k1454 in current-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1456(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1456,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 886  change-directory */
t2=*((C_word*)lf[100]+1);
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1465,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 887  make-string */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}}

/* k1463 in k1454 in current-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1465(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1465,2,t0,t1);}
t2=(C_word)C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1468,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 889  ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k1466 in k1463 in k1454 in current-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1468(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
/* posixwin.scm: 891  ##sys#substring */
t2=*((C_word*)lf[55]+1);
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[4]);}
else{
/* posixwin.scm: 892  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[34],lf[114],lf[119]);}}

/* directory? in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1429(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1429,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[117]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1436,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1450,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 879  ##sys#expand-home-path */
t6=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1448 in directory? in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1450(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 879  ##sys#file-info */
t2=*((C_word*)lf[81]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1434 in directory? in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1436(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1269(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_1269r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1269r(t0,t1,t2);}}

static void C_ccall f_1269r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(12);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1271,a[2]=((C_word*)t0)[2],a[3]=lf[112],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1372,a[2]=t3,a[3]=lf[113],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1377,a[2]=t4,a[3]=lf[115],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec104130 */
t6=t5;
f_1377(t6,t1);}
else{
t6=(C_word)C_i_car(t2);
t7=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?105128 */
t8=t4;
f_1372(t8,t1,t6);}
else{
t8=(C_word)C_i_car(t7);
t9=(C_word)C_i_cdr(t7);
if(C_truep((C_word)C_i_nullp(t9))){
/* body102107 */
t10=t3;
f_1271(t10,t1,t6,t8);}
else{
/* ##sys#error */
t10=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t1,lf[0],t9);}}}}

/* def-spec104 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_1377(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1377,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1385,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 850  current-directory */
t3=*((C_word*)lf[114]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k1383 in def-spec104 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1385(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?105128 */
t2=((C_word*)t0)[3];
f_1372(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?105 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_1372(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1372,NULL,3,t0,t1,t2);}
/* body102107 */
t3=((C_word*)t0)[2];
f_1271(t3,t1,t2,C_SCHEME_FALSE);}

/* body102 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_1271(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1271,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[108]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1278,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 852  make-string */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,C_fix(256));}

/* k1276 in body102 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1278(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1278,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1281,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 853  ##sys#make-pointer */
t3=*((C_word*)lf[111]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k1279 in k1276 in body102 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1281(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1281,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1284,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 854  ##sys#make-pointer */
t3=*((C_word*)lf[111]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k1282 in k1279 in k1276 in body102 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1284(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1284,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1288,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1371,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 855  ##sys#expand-home-path */
t4=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k1369 in k1282 in k1279 in k1276 in body102 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1371(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 855  ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1286 in k1282 in k1279 in k1276 in body102 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1288(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1288,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1297,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 858  ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1305,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=lf[110],tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_1305(t6,((C_word*)t0)[6]);}}

/* loop in k1286 in k1282 in k1279 in k1276 in body102 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_1305(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1305,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1315,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 867  ##sys#substring */
t5=*((C_word*)lf[55]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k1313 in loop in k1286 in k1282 in k1279 in k1276 in body102 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1315(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1315,2,t0,t1);}
t2=(C_word)C_i_string_ref(t1,C_fix(0));
t3=(C_word)C_i_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?(C_word)C_i_string_ref(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1327,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=(C_word)C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_1327(t8,t7);}
else{
t8=(C_word)C_eqp(t4,C_make_character(46));
t9=(C_truep(t8)?(C_word)C_eqp(((C_word*)t0)[5],C_fix(2)):C_SCHEME_FALSE);
t10=t5;
f_1327(t10,(C_truep(t9)?t9:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t7=t5;
f_1327(t7,C_SCHEME_FALSE);}}

/* k1325 in k1313 in loop in k1286 in k1282 in k1279 in k1276 in body102 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_1327(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1327,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 874  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_1305(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1337,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 875  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_1305(t3,t2);}}

/* k1335 in k1325 in k1313 in loop in k1286 in k1282 in k1279 in k1276 in body102 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1337,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k1295 in k1286 in k1282 in k1279 in k1276 in body102 in directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1297(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 859  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[34],lf[108],lf[109],((C_word*)t0)[2]);}

/* delete-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1242(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1242,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[103]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1263,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1267,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 842  ##sys#expand-home-path */
t6=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1265 in delete-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1267(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 842  ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1261 in delete-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1263(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1263,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1255,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 843  ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1253 in k1261 in delete-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1255(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 844  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[34],lf[103],lf[104],((C_word*)t0)[2]);}

/* change-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1215(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1215,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[100]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1236,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1240,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 835  ##sys#expand-home-path */
t6=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1238 in change-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1240(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 835  ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1234 in change-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1236(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1236,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1228,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 836  ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1226 in k1234 in change-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1228(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 837  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[34],lf[100],lf[101],((C_word*)t0)[2]);}

/* create-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1188(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1188,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[97]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1209,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1213,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 828  ##sys#expand-home-path */
t6=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1211 in create-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1213(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 828  ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1207 in create-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1209(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1209,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1201,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 829  ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1199 in k1207 in create-directory in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1201(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 830  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[34],lf[97],lf[98],((C_word*)t0)[2]);}

/* set-file-position! in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1127(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1127r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1127r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1127r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[91]);
t8=(C_word)C_i_check_exact_2(t6,lf[91]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1140,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixwin.scm: 813  ##sys#signal-hook */
t10=*((C_word*)lf[33]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[94],lf[91],lf[95],t3,t2);}
else{
t10=t9;
f_1140(2,t10,C_SCHEME_UNDEFINED);}}

/* k1138 in set-file-position! in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1140(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1140,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1146,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1155,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 814  port? */
t4=*((C_word*)lf[89]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k1153 in k1138 in set-file-position! in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1155(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[87]);
t4=((C_word*)t0)[4];
f_1146(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_1146(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixwin.scm: 818  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[46],lf[91],lf[93],((C_word*)t0)[5]);}}}

/* k1144 in k1138 in set-file-position! in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1146(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1146,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1149,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 819  ##sys#update-errno */
t3=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k1147 in k1144 in k1138 in set-file-position! in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1149(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 820  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[34],lf[91],lf[92],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-position in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1087(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1087,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1091,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1106,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 797  port? */
t5=*((C_word*)lf[89]+1);
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t2);}

/* k1104 in file-position in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1106(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[87]);
t4=((C_word*)t0)[2];
f_1091(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_1091(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixwin.scm: 802  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[46],lf[85],lf[88],((C_word*)t0)[3]);}}}

/* k1089 in file-position in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1091(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1091,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1094,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1100,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 804  ##sys#update-errno */
t4=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_1094(2,t3,C_SCHEME_UNDEFINED);}}

/* k1098 in k1089 in file-position in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1100(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 805  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[34],lf[85],lf[86],((C_word*)t0)[2]);}

/* k1092 in k1089 in file-position in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1094(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* symbolic-link? in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1081(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1081,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[83]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* regular-file? in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1058(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1058,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[80]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1065,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1079,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 788  ##sys#expand-home-path */
t6=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1077 in regular-file? in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1079(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 788  ##sys#file-info */
t2=*((C_word*)lf[81]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1063 in regular-file? in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(0),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* file-permissions in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1052(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1052,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1056,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 784  ##sys#stat */
f_953(t3,t2);}

/* k1054 in file-permissions in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1046(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1046,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1050,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 783  ##sys#stat */
f_953(t3,t2);}

/* k1048 in file-owner in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1050(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1040(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1040,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1044,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 782  ##sys#stat */
f_953(t3,t2);}

/* k1042 in file-change-time in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1044,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1034(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1034,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1038,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 781  ##sys#stat */
f_953(t3,t2);}

/* k1036 in file-access-time in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1038,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1028(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1028,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1032,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 780  ##sys#stat */
f_953(t3,t2);}

/* k1030 in file-modification-time in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1032(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1032,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1022(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1022,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1026,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 779  ##sys#stat */
f_953(t3,t2);}

/* k1024 in file-size in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_1026(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_991(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_991r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_991r(t0,t1,t2,t3);}}

static void C_ccall f_991r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_995,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_995(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_995(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k993 in file-stat in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_995(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_995,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_998,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 774  ##sys#stat */
f_953(t2,((C_word*)t0)[2]);}

/* k996 in k993 in file-stat in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_998(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_998,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,9,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime)));}

/* ##sys#stat in k717 in k714 in k711 in k708 in k705 */
static void C_fcall f_953(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_953,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_957,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_957(2,t4,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_982,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_986,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 767  ##sys#expand-home-path */
t6=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posixwin.scm: 768  ##sys#signal-hook */
t4=*((C_word*)lf[33]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[46],lf[63],t2);}}}

/* k984 in ##sys#stat in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_986(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 767  ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k980 in ##sys#stat in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_982(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_957(2,t2,(C_word)C_stat(t1));}

/* k955 in ##sys#stat in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_957(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_957,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_966,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 770  ##sys#update-errno */
t3=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k964 in k955 in ##sys#stat in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_966(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 771  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[34],lf[62],((C_word*)t0)[2]);}

/* file-mkstemp in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_915(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_915,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[54]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_922,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 736  ##sys#make-c-string */
t5=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k920 in file-mkstemp in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_922(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_922,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_925,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 738  string-length */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,t1);}

/* k923 in k920 in file-mkstemp in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_925(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_925,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_928,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_945,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 740  ##sys#update-errno */
t5=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_928(2,t4,C_SCHEME_UNDEFINED);}}

/* k943 in k923 in k920 in file-mkstemp in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_945(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 741  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[34],lf[54],lf[56],((C_word*)t0)[2]);}

/* k926 in k923 in k920 in file-mkstemp in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_928(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_928,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_935,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 742  ##sys#substring */
t4=*((C_word*)lf[55]+1);
((C_proc5)C_retrieve_proc(t4))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k933 in k926 in k923 in k920 in file-mkstemp in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_935(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 742  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_873(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_873r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_873r(t0,t1,t2,t3,t4);}}

static void C_ccall f_873r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[49]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_880,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_880(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 723  ##sys#signal-hook */
t8=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[46],lf[49],lf[51],t3);}}

/* k878 in file-write in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_880(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_880,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[49]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_889,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_895,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 728  ##sys#update-errno */
t9=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}
else{
t8=t6;
f_889(2,t8,C_SCHEME_UNDEFINED);}}

/* k893 in k878 in file-write in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_895(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 729  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[34],lf[49],lf[50],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k887 in k878 in file-write in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_889(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_828(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_828r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_828r(t0,t1,t2,t3,t4);}}

static void C_ccall f_828r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[44]);
t6=(C_word)C_i_check_exact_2(t3,lf[44]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_838,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_838(2,t8,(C_word)C_i_vector_ref(t4,C_fix(0)));}
else{
/* posixwin.scm: 710  make-string */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k836 in file-read in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_838(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_838,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_841,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_841(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 712  ##sys#signal-hook */
t4=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[46],lf[44],lf[47],t1);}}

/* k839 in k836 in file-read in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_841,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_844,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_853,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 715  ##sys#update-errno */
t6=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_844(2,t5,C_SCHEME_UNDEFINED);}}

/* k851 in k839 in k836 in file-read in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_853(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 716  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[34],lf[44],lf[45],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k842 in k839 in k836 in file-read in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_844(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_844,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_810(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_810,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[40]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_823,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 702  ##sys#update-errno */
t5=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k821 in file-close in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_823(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 703  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[34],lf[40],lf[41],((C_word*)t0)[2]);}

/* file-open in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_769(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_769r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_769r(t0,t1,t2,t3,t4);}}

static void C_ccall f_769r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[32]);
t8=(C_word)C_i_check_exact_2(t3,lf[32]);
t9=(C_word)C_i_check_exact_2(t6,lf[32]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_786,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_802,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 692  ##sys#expand-home-path */
t12=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t12))(3,t12,t11,t2);}

/* k800 in file-open in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_802(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 692  ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k784 in file-open in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_786,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_789,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_795,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 694  ##sys#update-errno */
t6=*((C_word*)lf[36]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_789(2,t5,C_SCHEME_UNDEFINED);}}

/* k793 in k784 in file-open in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_795(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 695  ##sys#signal-hook */
t2=*((C_word*)lf[33]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[34],lf[32],lf[35],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k787 in k784 in file-open in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_789(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* yield in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_721(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_721,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_727,a[2]=lf[6],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 624  ##sys#call-with-current-continuation */
C_call_cc(3,0,t1,t2);}

/* a726 in yield in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_727(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_727,3,t0,t1,t2);}
t3=*((C_word*)lf[3]+1);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_736,a[2]=t2,a[3]=lf[4],tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_i_setslot(t3,C_fix(1),t4);
/* posixwin.scm: 628  ##sys#schedule */
t6=*((C_word*)lf[5]+1);
((C_proc2)C_retrieve_proc(t6))(2,t6,t1);}

/* a735 in a726 in yield in k717 in k714 in k711 in k708 in k705 */
static void C_ccall f_736(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_736,2,t0,t1);}
/* posixwin.scm: 627  return */
t2=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,C_SCHEME_UNDEFINED);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[278] = {
{"toplevelposixwin.scm",(void*)C_posix_toplevel},
{"f_707posixwin.scm",(void*)f_707},
{"f_710posixwin.scm",(void*)f_710},
{"f_713posixwin.scm",(void*)f_713},
{"f_716posixwin.scm",(void*)f_716},
{"f_719posixwin.scm",(void*)f_719},
{"f_2943posixwin.scm",(void*)f_2943},
{"f_3100posixwin.scm",(void*)f_3100},
{"f_3106posixwin.scm",(void*)f_3106},
{"f_3095posixwin.scm",(void*)f_3095},
{"f_3090posixwin.scm",(void*)f_3090},
{"f_2945posixwin.scm",(void*)f_2945},
{"f_3077posixwin.scm",(void*)f_3077},
{"f_3085posixwin.scm",(void*)f_3085},
{"f_2952posixwin.scm",(void*)f_2952},
{"f_3065posixwin.scm",(void*)f_3065},
{"f_2962posixwin.scm",(void*)f_2962},
{"f_2964posixwin.scm",(void*)f_2964},
{"f_2983posixwin.scm",(void*)f_2983},
{"f_3051posixwin.scm",(void*)f_3051},
{"f_3058posixwin.scm",(void*)f_3058},
{"f_3045posixwin.scm",(void*)f_3045},
{"f_2998posixwin.scm",(void*)f_2998},
{"f_3032posixwin.scm",(void*)f_3032},
{"f_3018posixwin.scm",(void*)f_3018},
{"f_3030posixwin.scm",(void*)f_3030},
{"f_3026posixwin.scm",(void*)f_3026},
{"f_3010posixwin.scm",(void*)f_3010},
{"f_3008posixwin.scm",(void*)f_3008},
{"f_3069posixwin.scm",(void*)f_3069},
{"f_2912posixwin.scm",(void*)f_2912},
{"f_2938posixwin.scm",(void*)f_2938},
{"f_2923posixwin.scm",(void*)f_2923},
{"f_2927posixwin.scm",(void*)f_2927},
{"f_2931posixwin.scm",(void*)f_2931},
{"f_2935posixwin.scm",(void*)f_2935},
{"f_2900posixwin.scm",(void*)f_2900},
{"f_2897posixwin.scm",(void*)f_2897},
{"f_2855posixwin.scm",(void*)f_2855},
{"f_2877posixwin.scm",(void*)f_2877},
{"f_2704posixwin.scm",(void*)f_2704},
{"f_2807posixwin.scm",(void*)f_2807},
{"f_2802posixwin.scm",(void*)f_2802},
{"f_2706posixwin.scm",(void*)f_2706},
{"f_2798posixwin.scm",(void*)f_2798},
{"f_2713posixwin.scm",(void*)f_2713},
{"f_2785posixwin.scm",(void*)f_2785},
{"f_2788posixwin.scm",(void*)f_2788},
{"f_2791posixwin.scm",(void*)f_2791},
{"f_2778posixwin.scm",(void*)f_2778},
{"f_2775posixwin.scm",(void*)f_2775},
{"f_2751posixwin.scm",(void*)f_2751},
{"f_2726posixwin.scm",(void*)f_2726},
{"f_2745posixwin.scm",(void*)f_2745},
{"f_2732posixwin.scm",(void*)f_2732},
{"f_2730posixwin.scm",(void*)f_2730},
{"f_2701posixwin.scm",(void*)f_2701},
{"f_2672posixwin.scm",(void*)f_2672},
{"f_2689posixwin.scm",(void*)f_2689},
{"f_2666posixwin.scm",(void*)f_2666},
{"f_2663posixwin.scm",(void*)f_2663},
{"f_2570posixwin.scm",(void*)f_2570},
{"f_2586posixwin.scm",(void*)f_2586},
{"f_2594posixwin.scm",(void*)f_2594},
{"f_2627posixwin.scm",(void*)f_2627},
{"f_2608posixwin.scm",(void*)f_2608},
{"f_2611posixwin.scm",(void*)f_2611},
{"f_2614posixwin.scm",(void*)f_2614},
{"f_2551posixwin.scm",(void*)f_2551},
{"f_2407posixwin.scm",(void*)f_2407},
{"f_2503posixwin.scm",(void*)f_2503},
{"f_2498posixwin.scm",(void*)f_2498},
{"f_2409posixwin.scm",(void*)f_2409},
{"f_2422posixwin.scm",(void*)f_2422},
{"f_2430posixwin.scm",(void*)f_2430},
{"f_2463posixwin.scm",(void*)f_2463},
{"f_2444posixwin.scm",(void*)f_2444},
{"f_2447posixwin.scm",(void*)f_2447},
{"f_2388posixwin.scm",(void*)f_2388},
{"f_2279posixwin.scm",(void*)f_2279},
{"f_2285posixwin.scm",(void*)f_2285},
{"f_2306posixwin.scm",(void*)f_2306},
{"f_2377posixwin.scm",(void*)f_2377},
{"f_2310posixwin.scm",(void*)f_2310},
{"f_2317posixwin.scm",(void*)f_2317},
{"f_2319posixwin.scm",(void*)f_2319},
{"f_2336posixwin.scm",(void*)f_2336},
{"f_2346posixwin.scm",(void*)f_2346},
{"f_2350posixwin.scm",(void*)f_2350},
{"f_2300posixwin.scm",(void*)f_2300},
{"f_2220posixwin.scm",(void*)f_2220},
{"f_2224posixwin.scm",(void*)f_2224},
{"f_2230posixwin.scm",(void*)f_2230},
{"f_2201posixwin.scm",(void*)f_2201},
{"f_2205posixwin.scm",(void*)f_2205},
{"f_2167posixwin.scm",(void*)f_2167},
{"f_2174posixwin.scm",(void*)f_2174},
{"f_2139posixwin.scm",(void*)f_2139},
{"f_2146posixwin.scm",(void*)f_2146},
{"f_2149posixwin.scm",(void*)f_2149},
{"f_2152posixwin.scm",(void*)f_2152},
{"f_2122posixwin.scm",(void*)f_2122},
{"f_2126posixwin.scm",(void*)f_2126},
{"f_2129posixwin.scm",(void*)f_2129},
{"f_2103posixwin.scm",(void*)f_2103},
{"f_2094posixwin.scm",(void*)f_2094},
{"f_2029posixwin.scm",(void*)f_2029},
{"f_2035posixwin.scm",(void*)f_2035},
{"f_2039posixwin.scm",(void*)f_2039},
{"f_2047posixwin.scm",(void*)f_2047},
{"f_2073posixwin.scm",(void*)f_2073},
{"f_2077posixwin.scm",(void*)f_2077},
{"f_2065posixwin.scm",(void*)f_2065},
{"f_2009posixwin.scm",(void*)f_2009},
{"f_2017posixwin.scm",(void*)f_2017},
{"f_1992posixwin.scm",(void*)f_1992},
{"f_2003posixwin.scm",(void*)f_2003},
{"f_2007posixwin.scm",(void*)f_2007},
{"f_1962posixwin.scm",(void*)f_1962},
{"f_1969posixwin.scm",(void*)f_1969},
{"f_1978posixwin.scm",(void*)f_1978},
{"f_1972posixwin.scm",(void*)f_1972},
{"f_1927posixwin.scm",(void*)f_1927},
{"f_1931posixwin.scm",(void*)f_1931},
{"f_1960posixwin.scm",(void*)f_1960},
{"f_1946posixwin.scm",(void*)f_1946},
{"f_1940posixwin.scm",(void*)f_1940},
{"f_1913posixwin.scm",(void*)f_1913},
{"f_1925posixwin.scm",(void*)f_1925},
{"f_1899posixwin.scm",(void*)f_1899},
{"f_1911posixwin.scm",(void*)f_1911},
{"f_1881posixwin.scm",(void*)f_1881},
{"f_1885posixwin.scm",(void*)f_1885},
{"f_1897posixwin.scm",(void*)f_1897},
{"f_1844posixwin.scm",(void*)f_1844},
{"f_1852posixwin.scm",(void*)f_1852},
{"f_1835posixwin.scm",(void*)f_1835},
{"f_1829posixwin.scm",(void*)f_1829},
{"f_1823posixwin.scm",(void*)f_1823},
{"f_1799posixwin.scm",(void*)f_1799},
{"f_1821posixwin.scm",(void*)f_1821},
{"f_1817posixwin.scm",(void*)f_1817},
{"f_1809posixwin.scm",(void*)f_1809},
{"f_1769posixwin.scm",(void*)f_1769},
{"f_1797posixwin.scm",(void*)f_1797},
{"f_1793posixwin.scm",(void*)f_1793},
{"f_1785posixwin.scm",(void*)f_1785},
{"f_1713posixwin.scm",(void*)f_1713},
{"f_1726posixwin.scm",(void*)f_1726},
{"f_1717posixwin.scm",(void*)f_1717},
{"f_1693posixwin.scm",(void*)f_1693},
{"f_1697posixwin.scm",(void*)f_1697},
{"f_1703posixwin.scm",(void*)f_1703},
{"f_1707posixwin.scm",(void*)f_1707},
{"f_1673posixwin.scm",(void*)f_1673},
{"f_1677posixwin.scm",(void*)f_1677},
{"f_1683posixwin.scm",(void*)f_1683},
{"f_1687posixwin.scm",(void*)f_1687},
{"f_1649posixwin.scm",(void*)f_1649},
{"f_1653posixwin.scm",(void*)f_1653},
{"f_1664posixwin.scm",(void*)f_1664},
{"f_1668posixwin.scm",(void*)f_1668},
{"f_1658posixwin.scm",(void*)f_1658},
{"f_1625posixwin.scm",(void*)f_1625},
{"f_1629posixwin.scm",(void*)f_1629},
{"f_1640posixwin.scm",(void*)f_1640},
{"f_1644posixwin.scm",(void*)f_1644},
{"f_1634posixwin.scm",(void*)f_1634},
{"f_1606posixwin.scm",(void*)f_1606},
{"f_1610posixwin.scm",(void*)f_1610},
{"f_1613posixwin.scm",(void*)f_1613},
{"f_1570posixwin.scm",(void*)f_1570},
{"f_1601posixwin.scm",(void*)f_1601},
{"f_1591posixwin.scm",(void*)f_1591},
{"f_1584posixwin.scm",(void*)f_1584},
{"f_1534posixwin.scm",(void*)f_1534},
{"f_1565posixwin.scm",(void*)f_1565},
{"f_1555posixwin.scm",(void*)f_1555},
{"f_1548posixwin.scm",(void*)f_1548},
{"f_1516posixwin.scm",(void*)f_1516},
{"f_1520posixwin.scm",(void*)f_1520},
{"f_1532posixwin.scm",(void*)f_1532},
{"f_1510posixwin.scm",(void*)f_1510},
{"f_1498posixwin.scm",(void*)f_1498},
{"f_1452posixwin.scm",(void*)f_1452},
{"f_1456posixwin.scm",(void*)f_1456},
{"f_1465posixwin.scm",(void*)f_1465},
{"f_1468posixwin.scm",(void*)f_1468},
{"f_1429posixwin.scm",(void*)f_1429},
{"f_1450posixwin.scm",(void*)f_1450},
{"f_1436posixwin.scm",(void*)f_1436},
{"f_1269posixwin.scm",(void*)f_1269},
{"f_1377posixwin.scm",(void*)f_1377},
{"f_1385posixwin.scm",(void*)f_1385},
{"f_1372posixwin.scm",(void*)f_1372},
{"f_1271posixwin.scm",(void*)f_1271},
{"f_1278posixwin.scm",(void*)f_1278},
{"f_1281posixwin.scm",(void*)f_1281},
{"f_1284posixwin.scm",(void*)f_1284},
{"f_1371posixwin.scm",(void*)f_1371},
{"f_1288posixwin.scm",(void*)f_1288},
{"f_1305posixwin.scm",(void*)f_1305},
{"f_1315posixwin.scm",(void*)f_1315},
{"f_1327posixwin.scm",(void*)f_1327},
{"f_1337posixwin.scm",(void*)f_1337},
{"f_1297posixwin.scm",(void*)f_1297},
{"f_1242posixwin.scm",(void*)f_1242},
{"f_1267posixwin.scm",(void*)f_1267},
{"f_1263posixwin.scm",(void*)f_1263},
{"f_1255posixwin.scm",(void*)f_1255},
{"f_1215posixwin.scm",(void*)f_1215},
{"f_1240posixwin.scm",(void*)f_1240},
{"f_1236posixwin.scm",(void*)f_1236},
{"f_1228posixwin.scm",(void*)f_1228},
{"f_1188posixwin.scm",(void*)f_1188},
{"f_1213posixwin.scm",(void*)f_1213},
{"f_1209posixwin.scm",(void*)f_1209},
{"f_1201posixwin.scm",(void*)f_1201},
{"f_1127posixwin.scm",(void*)f_1127},
{"f_1140posixwin.scm",(void*)f_1140},
{"f_1155posixwin.scm",(void*)f_1155},
{"f_1146posixwin.scm",(void*)f_1146},
{"f_1149posixwin.scm",(void*)f_1149},
{"f_1087posixwin.scm",(void*)f_1087},
{"f_1106posixwin.scm",(void*)f_1106},
{"f_1091posixwin.scm",(void*)f_1091},
{"f_1100posixwin.scm",(void*)f_1100},
{"f_1094posixwin.scm",(void*)f_1094},
{"f_1081posixwin.scm",(void*)f_1081},
{"f_1058posixwin.scm",(void*)f_1058},
{"f_1079posixwin.scm",(void*)f_1079},
{"f_1065posixwin.scm",(void*)f_1065},
{"f_1052posixwin.scm",(void*)f_1052},
{"f_1056posixwin.scm",(void*)f_1056},
{"f_1046posixwin.scm",(void*)f_1046},
{"f_1050posixwin.scm",(void*)f_1050},
{"f_1040posixwin.scm",(void*)f_1040},
{"f_1044posixwin.scm",(void*)f_1044},
{"f_1034posixwin.scm",(void*)f_1034},
{"f_1038posixwin.scm",(void*)f_1038},
{"f_1028posixwin.scm",(void*)f_1028},
{"f_1032posixwin.scm",(void*)f_1032},
{"f_1022posixwin.scm",(void*)f_1022},
{"f_1026posixwin.scm",(void*)f_1026},
{"f_991posixwin.scm",(void*)f_991},
{"f_995posixwin.scm",(void*)f_995},
{"f_998posixwin.scm",(void*)f_998},
{"f_953posixwin.scm",(void*)f_953},
{"f_986posixwin.scm",(void*)f_986},
{"f_982posixwin.scm",(void*)f_982},
{"f_957posixwin.scm",(void*)f_957},
{"f_966posixwin.scm",(void*)f_966},
{"f_915posixwin.scm",(void*)f_915},
{"f_922posixwin.scm",(void*)f_922},
{"f_925posixwin.scm",(void*)f_925},
{"f_945posixwin.scm",(void*)f_945},
{"f_928posixwin.scm",(void*)f_928},
{"f_935posixwin.scm",(void*)f_935},
{"f_873posixwin.scm",(void*)f_873},
{"f_880posixwin.scm",(void*)f_880},
{"f_895posixwin.scm",(void*)f_895},
{"f_889posixwin.scm",(void*)f_889},
{"f_828posixwin.scm",(void*)f_828},
{"f_838posixwin.scm",(void*)f_838},
{"f_841posixwin.scm",(void*)f_841},
{"f_853posixwin.scm",(void*)f_853},
{"f_844posixwin.scm",(void*)f_844},
{"f_810posixwin.scm",(void*)f_810},
{"f_823posixwin.scm",(void*)f_823},
{"f_769posixwin.scm",(void*)f_769},
{"f_802posixwin.scm",(void*)f_802},
{"f_786posixwin.scm",(void*)f_786},
{"f_795posixwin.scm",(void*)f_795},
{"f_789posixwin.scm",(void*)f_789},
{"f_721posixwin.scm",(void*)f_721},
{"f_727posixwin.scm",(void*)f_727},
{"f_736posixwin.scm",(void*)f_736},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
