/* Generated from posix.scm by the Chicken compiler
   2006-02-17 19:01
   Version 2, Build 216 - linux-unix-gnu-x86 - [ libffi dload ptables ]
   command line: posix.scm -quiet -no-trace -optimize-level 2 -include-path . -output-file posix.c -explicit-use
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>

#ifdef ECOS
#include <cyg/posix/signal.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else 
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
#ifndef ECOS
static C_TLS struct passwd *C_user;
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
#endif
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)   	(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name),	C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#ifndef ECOS
#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#endif
#define C_uname             C_fix(uname(&C_utsname))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#define C_islink            ((C_statbuf.st_mode & S_IFMT) == S_IFLNK)
#define C_isreg             ((C_statbuf.st_mode & S_IFMT) == S_IFREG)

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);				       
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_exec_args() {
  char **a = C_exec_args;
  while((*a) != NULL) C_free(*(a++));
}

static void C_fcall C_free_exec_env() {
  char **a = C_exec_env;
  while((*a) != NULL) C_free(*(a++));
}

#define C_set_exec_arg(i, a, len)      C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)      C_set_arg_string(C_exec_env, i, a, len)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigprocmask(d)    C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)    FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd) FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd) FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_timeval.tv_sec = C_unfix(t), C_timeval.tv_usec = 0, C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__CYGWIN__)
/* timegm code from Linux manpages */
time_t timegm (struct tm *tm)
{
   time_t ret;
   char *tz;

   tz = getenv("TZ");
   setenv("TZ", "", 1);
   tzset();
   ret = mktime(tm);
   if (tz)
      setenv("TZ", tz, 1);
   else
      unsetenv("TZ");
   tzset();
   return ret;
}
#endif

#if !defined(C_GNU_ENV) || defined(__CYGWIN__)
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
# define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = mktime(&C_tm)) != -1)
# define C_timegm(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = timegm(&C_tm)) != -1)
#else
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), asctime(&C_tm) )
# define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), (C_temporary_flonum = mktime(&C_tm)) != -1)
# define C_timegm(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), (C_temporary_flonum = timegm(&C_tm)) != -1)
#endif

#ifndef ECOS
static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))
#endif

static C_PTABLE_ENTRY *create_ptable(void);
C_externimport void C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[546];


/* from k5197 in set-root-directory! in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall stub1006(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1006(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from k4637 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub857(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub857(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_return:
#undef return

return C_r;}

/* from k4559 */
static C_word C_fcall stub825(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub825(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall stub822(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub822(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall stub820(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub820(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub756(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub756(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k4287 */
static C_word C_fcall stub749(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub749(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub744(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub744(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k4268 */
static C_word C_fcall stub737(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub737(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k4244 */
static C_word C_fcall stub725(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub725(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub720(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub720(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub683(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub683(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);
              else return(C_hostbuf);
C_return:
#undef return

return C_r;}

/* from k4064 */
static C_word C_fcall stub675(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub675(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k3975 */
static C_word C_fcall stub658(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub658(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k3950 */
static C_word C_fcall stub652(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub652(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub647(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub647(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#ifndef __CYGWIN__
time_t clock = (time_t)0;struct tm *ltm = C_localtime(&clock);char *z = ltm ? ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
return(z);
C_return:
#undef return

return C_r;}

/* from asctime */
static C_word C_fcall stub632(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub632(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k3837 */
static C_word C_fcall stub623(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub623(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k3756 */
static C_word C_fcall stub592(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub592(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k3694 */
static C_word C_fcall stub567(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub567(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k3594 */
static C_word C_fcall stub545(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub545(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k3086 in k3082 in file-link in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall stub426(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub426(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from current-effective-group-id in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall stub381(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub381(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from current-effective-user-id in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall stub379(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub379(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from current-group-id in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall stub377(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub377(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from current-user-id in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall stub375(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub375(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from k2762 */
static C_word C_fcall stub346(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub346(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

/* from k2631 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub319(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub319(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) return(0);else return(1);
C_return:
#undef return

return C_r;}

/* from k2624 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub315(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub315(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
return(getgroups(n, C_groups));
C_return:
#undef return

return C_r;}

/* from k2563 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub303(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub303(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_return:
#undef return

return C_r;}

/* from k1458 */
static C_word C_fcall stub74(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub74(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from k1448 */
static C_word C_fcall stub68(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub68(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from k1438 */
static C_word C_fcall stub63(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub63(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from k1194 */
static C_word C_fcall stub9(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub9(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

/* from k1183 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub3(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_return:
#undef return

return C_r;}

C_externexport void C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
static void f_1166(C_word c,C_word t0,C_word t1) C_noret;
static void f_1169(C_word c,C_word t0,C_word t1) C_noret;
static void f_1172(C_word c,C_word t0,C_word t1) C_noret;
static void f_1175(C_word c,C_word t0,C_word t1) C_noret;
static void f_1178(C_word c,C_word t0,C_word t1) C_noret;
static void f_2416(C_word c,C_word t0,C_word t1) C_noret;
static void f_5230(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2474(C_word c,C_word t0,C_word t1) C_noret;
static void f_3052(C_word c,C_word t0,C_word t1) C_noret;
static void f_5207(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_5199(C_word c,C_word t0,C_word t1) C_noret;
static void f_4974(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_4974r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void C_fcall f_5125(C_word t0,C_word t1) C_noret;
static void f_5131(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void C_fcall f_5120(C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_5115(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void C_fcall f_4976(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_5102(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_5110(C_word c,C_word t0,C_word t1,...) C_noret;
static void C_fcall f_4983(C_word t0,C_word t1) C_noret;
static void f_5090(C_word c,C_word t0,C_word t1) C_noret;
static void f_4993(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_4995(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_5014(C_word c,C_word t0,C_word t1) C_noret;
static void f_5076(C_word c,C_word t0,C_word t1) C_noret;
static void f_5083(C_word c,C_word t0,C_word t1) C_noret;
static void f_5070(C_word c,C_word t0,C_word t1) C_noret;
static void f_5029(C_word c,C_word t0,C_word t1) C_noret;
static void f_5060(C_word c,C_word t0,C_word t1) C_noret;
static void f_5046(C_word c,C_word t0,C_word t1) C_noret;
static void f_5058(C_word c,C_word t0,C_word t1) C_noret;
static void f_5054(C_word c,C_word t0,C_word t1) C_noret;
static void f_5041(C_word c,C_word t0,C_word t1) C_noret;
static void f_5039(C_word c,C_word t0,C_word t1) C_noret;
static void f_5094(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_4660(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_4660r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f_4926(C_word t0,C_word t1) C_noret;
static void C_fcall f_4921(C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_4662(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_4677(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_4689(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_4870(C_word c,C_word t0,C_word t1) C_noret;
static void f_4874(C_word c,C_word t0,C_word t1) C_noret;
static void f_4877(C_word c,C_word t0,C_word t1) C_noret;
static void f_4917(C_word c,C_word t0,C_word t1) C_noret;
static void f_4880(C_word c,C_word t0,C_word t1) C_noret;
static void f_4908(C_word c,C_word t0,C_word t1) C_noret;
static void f_4883(C_word c,C_word t0,C_word t1) C_noret;
static void f_4892(C_word c,C_word t0,C_word t1) C_noret;
static void f_4693(C_word c,C_word t0,C_word t1) C_noret;
static void f_4696(C_word c,C_word t0,C_word t1) C_noret;
static void f_4699(C_word c,C_word t0,C_word t1) C_noret;
static void f_4712(C_word c,C_word t0,C_word t1) C_noret;
static void f_4857(C_word c,C_word t0,C_word t1) C_noret;
static void f_4861(C_word c,C_word t0,C_word t1) C_noret;
static void f_4841(C_word c,C_word t0,C_word t1) C_noret;
static void f_4825(C_word c,C_word t0,C_word t1) C_noret;
static void f_4829(C_word c,C_word t0,C_word t1) C_noret;
static void f_4756(C_word c,C_word t0,C_word t1) C_noret;
static void f_4812(C_word c,C_word t0,C_word t1) C_noret;
static void f_4816(C_word c,C_word t0,C_word t1) C_noret;
static void f_4762(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_4771(C_word t0,C_word t1) C_noret;
static void f_4803(C_word c,C_word t0,C_word t1) C_noret;
static void f_4787(C_word c,C_word t0,C_word t1) C_noret;
static void f_4760(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_4714(C_word t0,C_word t1) C_noret;
static void C_fcall f_4728(C_word t0,C_word t1) C_noret;
static void f_4744(C_word c,C_word t0,C_word t1) C_noret;
static void f_4747(C_word c,C_word t0,C_word t1) C_noret;
static void f_4724(C_word c,C_word t0,C_word t1) C_noret;
static void f_4683(C_word c,C_word t0,C_word t1) C_noret;
static void f_4671(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_4640(C_word t0,C_word t1,C_word t2) C_noret;
static void f_4652(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_4646(C_word c,C_word t0,C_word t1) C_noret;
static void f_4590(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_4590r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_4597(C_word c,C_word t0,C_word t1) C_noret;
static void f_4612(C_word c,C_word t0,C_word t1) C_noret;
static void f_4563(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_4563r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_4556(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_4553(C_word c,C_word t0,C_word t1) C_noret;
static void f_4550(C_word c,C_word t0,C_word t1) C_noret;
static void f_4474(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_4474r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_4295(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_4295r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f_4426(C_word t0,C_word t1) C_noret;
static void C_fcall f_4421(C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_4297(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_4307(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_4315(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static C_word C_fcall f_4358(C_word t0,C_word t1,C_word t2);
static void C_fcall f_4328(C_word t0,C_word t1) C_noret;
static void f_4353(C_word c,C_word t0,C_word t1) C_noret;
static void f_4331(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f_4276(C_word t0,C_word t1,C_word t2);
static C_word C_fcall f_4257(C_word t0,C_word t1,C_word t2);
static void f_4215(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_4215r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_4237(C_word c,C_word t0,C_word t1) C_noret;
static void f_4241(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_4109(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_4109r(C_word t0,C_word t1,C_word t3) C_noret;
static void C_fcall f_4115(C_word t0,C_word t1,C_word t2) C_noret;
static void f_4136(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_4207(C_word c,C_word t0,C_word t1) C_noret;
static void f_4140(C_word c,C_word t0,C_word t1) C_noret;
static void f_4147(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_4149(C_word t0,C_word t1,C_word t2) C_noret;
static void f_4166(C_word c,C_word t0,C_word t1) C_noret;
static void f_4176(C_word c,C_word t0,C_word t1) C_noret;
static void f_4180(C_word c,C_word t0,C_word t1) C_noret;
static void f_4130(C_word c,C_word t0,C_word t1) C_noret;
static void f_4097(C_word c,C_word t0,C_word t1) C_noret;
static void f_4101(C_word c,C_word t0,C_word t1) C_noret;
static void f_4104(C_word c,C_word t0,C_word t1) C_noret;
static void f_4067(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_4071(C_word c,C_word t0,C_word t1) C_noret;
static void f_4074(C_word c,C_word t0,C_word t1) C_noret;
static void f_4038(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_4042(C_word c,C_word t0,C_word t1) C_noret;
static void f_4045(C_word c,C_word t0,C_word t1) C_noret;
static void f_3979(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_3979r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_3983(C_word c,C_word t0,C_word t1) C_noret;
static void f_3989(C_word c,C_word t0,C_word t1) C_noret;
static void f_3972(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3953(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_3953r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_3957(C_word c,C_word t0,C_word t1) C_noret;
static void f_3941(C_word c,C_word t0,C_word t1) C_noret;
static void f_3913(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3920(C_word c,C_word t0,C_word t1) C_noret;
static void f_3885(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3892(C_word c,C_word t0,C_word t1) C_noret;
static void f_3857(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3864(C_word c,C_word t0,C_word t1) C_noret;
static void f_3867(C_word c,C_word t0,C_word t1) C_noret;
static void f_3870(C_word c,C_word t0,C_word t1) C_noret;
static void f_3840(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3844(C_word c,C_word t0,C_word t1) C_noret;
static void f_3847(C_word c,C_word t0,C_word t1) C_noret;
static void f_3821(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3812(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3806(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3797(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3762(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3762r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3700(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
static void f_3700r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
static void f_3704(C_word c,C_word t0,C_word t1) C_noret;
static void f_3710(C_word c,C_word t0,C_word t1) C_noret;
static void f_3729(C_word c,C_word t0,C_word t1) C_noret;
static void f_3716(C_word c,C_word t0,C_word t1) C_noret;
static void f_3597(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3603(C_word t0,C_word t1,C_word t2) C_noret;
static void f_3607(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3615(C_word t0,C_word t1,C_word t2) C_noret;
static void f_3641(C_word c,C_word t0,C_word t1) C_noret;
static void f_3645(C_word c,C_word t0,C_word t1) C_noret;
static void f_3633(C_word c,C_word t0,C_word t1) C_noret;
static void f_3577(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3585(C_word c,C_word t0,C_word t1) C_noret;
static void f_3560(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_3571(C_word c,C_word t0,C_word t1) C_noret;
static void f_3575(C_word c,C_word t0,C_word t1) C_noret;
static void f_3534(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3558(C_word c,C_word t0,C_word t1) C_noret;
static void f_3541(C_word c,C_word t0,C_word t1) C_noret;
static void f_3491(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3491r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f_3498(C_word t0,C_word t1) C_noret;
static void f_3519(C_word c,C_word t0,C_word t1) C_noret;
static void f_3515(C_word c,C_word t0,C_word t1) C_noret;
static void f_3463(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3441(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3441r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3445(C_word c,C_word t0,C_word t1) C_noret;
static void f_3426(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3426r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3430(C_word c,C_word t0,C_word t1) C_noret;
static void f_3411(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3411r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3415(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3393(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void C_fcall f_3319(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_3341(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3347(C_word t0,C_word t1) C_noret;
static void f_3280(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_3308(C_word c,C_word t0,C_word t1) C_noret;
static void f_3304(C_word c,C_word t0,C_word t1) C_noret;
static void f_3297(C_word c,C_word t0,C_word t1) C_noret;
static void f_3253(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3253r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f_3260(C_word t0,C_word t1) C_noret;
static void f_3263(C_word c,C_word t0,C_word t1) C_noret;
static void f_3208(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3212(C_word c,C_word t0,C_word t1) C_noret;
static void f_3247(C_word c,C_word t0,C_word t1) C_noret;
static void f_3230(C_word c,C_word t0,C_word t1) C_noret;
static void f_3194(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3194r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3206(C_word c,C_word t0,C_word t1) C_noret;
static void f_3180(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3180r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3192(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3165(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_3178(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3128(C_word t0,C_word t1,C_word t2) C_noret;
static void f_3136(C_word c,C_word t0,C_word t1) C_noret;
static void f_3103(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_3084(C_word c,C_word t0,C_word t1) C_noret;
static void f_3088(C_word c,C_word t0,C_word t1) C_noret;
static void f_3053(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3077(C_word c,C_word t0,C_word t1) C_noret;
static void f_3061(C_word c,C_word t0,C_word t1) C_noret;
static void f_3064(C_word c,C_word t0,C_word t1) C_noret;
static void f_3015(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_3048(C_word c,C_word t0,C_word t1) C_noret;
static void f_3036(C_word c,C_word t0,C_word t1) C_noret;
static void f_3044(C_word c,C_word t0,C_word t1) C_noret;
static void f_3040(C_word c,C_word t0,C_word t1) C_noret;
static void f_2994(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_3010(C_word c,C_word t0,C_word t1) C_noret;
static void f_2976(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2989(C_word c,C_word t0,C_word t1) C_noret;
static void f_2983(C_word c,C_word t0,C_word t1) C_noret;
static void f_2961(C_word c,C_word t0,C_word t1) C_noret;
static void f_2971(C_word c,C_word t0,C_word t1) C_noret;
static void f_2965(C_word c,C_word t0,C_word t1) C_noret;
static void f_2955(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2949(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2943(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_2919(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2941(C_word c,C_word t0,C_word t1) C_noret;
static void f_2937(C_word c,C_word t0,C_word t1) C_noret;
static void f_2929(C_word c,C_word t0,C_word t1) C_noret;
static void f_2904(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2914(C_word c,C_word t0,C_word t1) C_noret;
static void f_2889(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2899(C_word c,C_word t0,C_word t1) C_noret;
static void f_2886(C_word c,C_word t0,C_word t1) C_noret;
static void f_2883(C_word c,C_word t0,C_word t1) C_noret;
static void f_2880(C_word c,C_word t0,C_word t1) C_noret;
static void f_2877(C_word c,C_word t0,C_word t1) C_noret;
static void f_2847(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_2875(C_word c,C_word t0,C_word t1) C_noret;
static void f_2871(C_word c,C_word t0,C_word t1) C_noret;
static void f_2820(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2845(C_word c,C_word t0,C_word t1) C_noret;
static void f_2841(C_word c,C_word t0,C_word t1) C_noret;
static void f_2772(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2760(C_word c,C_word t0,C_word t1) C_noret;
static void f_2788(C_word c,C_word t0,C_word t1) C_noret;
static void f_2698(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2702(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2707(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2723(C_word c,C_word t0,C_word t1) C_noret;
static void f_2635(C_word c,C_word t0,C_word t1) C_noret;
static void f_2693(C_word c,C_word t0,C_word t1) C_noret;
static void f_2639(C_word c,C_word t0,C_word t1) C_noret;
static void f_2642(C_word c,C_word t0,C_word t1) C_noret;
static void f_2674(C_word c,C_word t0,C_word t1) C_noret;
static void f_2645(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2650(C_word t0,C_word t1,C_word t2) C_noret;
static void f_2664(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f_2628(C_word t0);
static void f_2567(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2619(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2571(C_word t0,C_word t1) C_noret;
static void f_2581(C_word c,C_word t0,C_word t1) C_noret;
static void f_2585(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2591(C_word t0,C_word t1,C_word t2) C_noret;
static void f_2595(C_word c,C_word t0,C_word t1) C_noret;
static void f_2605(C_word c,C_word t0,C_word t1) C_noret;
static void f_2589(C_word c,C_word t0,C_word t1) C_noret;
static void f_2514(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2554(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2518(C_word t0,C_word t1) C_noret;
static void f_2528(C_word c,C_word t0,C_word t1) C_noret;
static void f_2532(C_word c,C_word t0,C_word t1) C_noret;
static void f_2536(C_word c,C_word t0,C_word t1) C_noret;
static void f_2540(C_word c,C_word t0,C_word t1) C_noret;
static void f_2544(C_word c,C_word t0,C_word t1) C_noret;
static void f_2476(C_word c,C_word t0,C_word t1) C_noret;
static void f_2509(C_word c,C_word t0,C_word t1) C_noret;
static void f_2480(C_word c,C_word t0,C_word t1) C_noret;
static void f_2487(C_word c,C_word t0,C_word t1) C_noret;
static void f_2491(C_word c,C_word t0,C_word t1) C_noret;
static void f_2495(C_word c,C_word t0,C_word t1) C_noret;
static void f_2499(C_word c,C_word t0,C_word t1) C_noret;
static void f_2503(C_word c,C_word t0,C_word t1) C_noret;
static void f_2449(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2467(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2456(C_word c,C_word t0,C_word t1) C_noret;
static void f_2431(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2441(C_word c,C_word t0,C_word t1) C_noret;
static void f_2418(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2375(C_word c,C_word t0,C_word t1) C_noret;
static void f_2379(C_word c,C_word t0,C_word t1) C_noret;
static void f_2355(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_2355r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_2359(C_word c,C_word t0,C_word t1) C_noret;
static void f_2365(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2365r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2369(C_word c,C_word t0,C_word t1) C_noret;
static void f_2335(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_2335r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_2339(C_word c,C_word t0,C_word t1) C_noret;
static void f_2345(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2345r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2349(C_word c,C_word t0,C_word t1) C_noret;
static void f_2311(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_2311r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_2315(C_word c,C_word t0,C_word t1) C_noret;
static void f_2326(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2326r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2330(C_word c,C_word t0,C_word t1) C_noret;
static void f_2320(C_word c,C_word t0,C_word t1) C_noret;
static void f_2287(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_2287r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_2291(C_word c,C_word t0,C_word t1) C_noret;
static void f_2302(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2302r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2306(C_word c,C_word t0,C_word t1) C_noret;
static void f_2296(C_word c,C_word t0,C_word t1) C_noret;
static void f_2271(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2275(C_word c,C_word t0,C_word t1) C_noret;
static void f_2278(C_word c,C_word t0,C_word t1) C_noret;
static void f_2235(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_2235r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_2266(C_word c,C_word t0,C_word t1) C_noret;
static void f_2256(C_word c,C_word t0,C_word t1) C_noret;
static void f_2249(C_word c,C_word t0,C_word t1) C_noret;
static void f_2199(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_2199r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_2230(C_word c,C_word t0,C_word t1) C_noret;
static void f_2220(C_word c,C_word t0,C_word t1) C_noret;
static void f_2213(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2184(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_2197(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2178(C_word t0,C_word t1) C_noret;
static C_word C_fcall f_2166(C_word t0);
static void f_2123(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2123r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2127(C_word c,C_word t0,C_word t1) C_noret;
static void f_2136(C_word c,C_word t0,C_word t1) C_noret;
static void f_2100(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2121(C_word c,C_word t0,C_word t1) C_noret;
static void f_2107(C_word c,C_word t0,C_word t1) C_noret;
static void f_1943(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_1943r(C_word t0,C_word t1,C_word t3) C_noret;
static void C_fcall f_2048(C_word t0,C_word t1) C_noret;
static void f_2056(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2043(C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_1945(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_1952(C_word c,C_word t0,C_word t1) C_noret;
static void f_1955(C_word c,C_word t0,C_word t1) C_noret;
static void f_1958(C_word c,C_word t0,C_word t1) C_noret;
static void f_2042(C_word c,C_word t0,C_word t1) C_noret;
static void f_1962(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1976(C_word t0,C_word t1) C_noret;
static void f_1986(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1998(C_word t0,C_word t1) C_noret;
static void f_2008(C_word c,C_word t0,C_word t1) C_noret;
static void f_1919(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1941(C_word c,C_word t0,C_word t1) C_noret;
static void f_1937(C_word c,C_word t0,C_word t1) C_noret;
static void f_1895(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1917(C_word c,C_word t0,C_word t1) C_noret;
static void f_1913(C_word c,C_word t0,C_word t1) C_noret;
static void f_1871(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1893(C_word c,C_word t0,C_word t1) C_noret;
static void f_1889(C_word c,C_word t0,C_word t1) C_noret;
static void f_1813(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1813r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1826(C_word c,C_word t0,C_word t1) C_noret;
static void f_1838(C_word c,C_word t0,C_word t1) C_noret;
static void f_1832(C_word c,C_word t0,C_word t1) C_noret;
static void f_1776(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1792(C_word c,C_word t0,C_word t1) C_noret;
static void f_1780(C_word c,C_word t0,C_word t1) C_noret;
static void f_1783(C_word c,C_word t0,C_word t1) C_noret;
static void f_1767(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1774(C_word c,C_word t0,C_word t1) C_noret;
static void f_1758(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1765(C_word c,C_word t0,C_word t1) C_noret;
static void f_1752(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1756(C_word c,C_word t0,C_word t1) C_noret;
static void f_1746(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1750(C_word c,C_word t0,C_word t1) C_noret;
static void f_1740(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1744(C_word c,C_word t0,C_word t1) C_noret;
static void f_1734(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1738(C_word c,C_word t0,C_word t1) C_noret;
static void f_1728(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1732(C_word c,C_word t0,C_word t1) C_noret;
static void f_1722(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1726(C_word c,C_word t0,C_word t1) C_noret;
static void f_1690(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_1690r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_1701(C_word c,C_word t0,C_word t1) C_noret;
static void f_1694(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1653(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_1685(C_word c,C_word t0,C_word t1) C_noret;
static void f_1678(C_word c,C_word t0,C_word t1) C_noret;
static void f_1657(C_word c,C_word t0,C_word t1) C_noret;
static void f_1461(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1461r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1634(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1477(C_word c,C_word t0,C_word t1) C_noret;
static void f_1608(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1483(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1486(C_word t0,C_word t1) C_noret;
static void f_1568(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1566(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1525(C_word t0,C_word t1) C_noret;
static void f_1543(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1541(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1529(C_word t0,C_word t1) C_noret;
static C_word C_fcall f_1451(C_word t0,C_word t1);
static C_word C_fcall f_1441(C_word t0,C_word t1);
static C_word C_fcall f_1435(C_word t0);
static void f_1403(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1410(C_word c,C_word t0,C_word t1) C_noret;
static void f_1413(C_word c,C_word t0,C_word t1) C_noret;
static void f_1416(C_word c,C_word t0,C_word t1) C_noret;
static void f_1423(C_word c,C_word t0,C_word t1) C_noret;
static void f_1364(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1364r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1371(C_word c,C_word t0,C_word t1) C_noret;
static void f_1380(C_word c,C_word t0,C_word t1) C_noret;
static void f_1322(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1322r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1332(C_word c,C_word t0,C_word t1) C_noret;
static void f_1335(C_word c,C_word t0,C_word t1) C_noret;
static void f_1338(C_word c,C_word t0,C_word t1) C_noret;
static void f_1307(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1269(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1269r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1299(C_word c,C_word t0,C_word t1) C_noret;
static void f_1286(C_word c,C_word t0,C_word t1) C_noret;
static void f_1289(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1214(C_word t0) C_noret;
static void f_1220(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1229(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1197(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
static void f_1201(C_word c,C_word t0,C_word t1) C_noret;
static void f_1212(C_word c,C_word t0,C_word t1) C_noret;
static void f_1208(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f_1180(C_word t0);

static void C_fcall trf_5125(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5125(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5125(t0,t1);}

static void C_fcall trf_5120(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5120(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5120(t0,t1,t2);}

static void C_fcall trf_5115(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5115(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5115(t0,t1,t2,t3);}

static void C_fcall trf_4976(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4976(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4976(t0,t1,t2,t3,t4);}

static void C_fcall trf_4983(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4983(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4983(t0,t1);}

static void C_fcall trf_4995(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4995(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4995(t0,t1,t2,t3);}

static void C_fcall trf_4926(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4926(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4926(t0,t1);}

static void C_fcall trf_4921(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4921(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4921(t0,t1,t2);}

static void C_fcall trf_4662(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4662(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4662(t0,t1,t2,t3);}

static void C_fcall trf_4771(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4771(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4771(t0,t1);}

static void C_fcall trf_4714(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4714(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4714(t0,t1);}

static void C_fcall trf_4728(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4728(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4728(t0,t1);}

static void C_fcall trf_4640(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4640(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4640(t0,t1,t2);}

static void C_fcall trf_4426(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4426(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4426(t0,t1);}

static void C_fcall trf_4421(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4421(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4421(t0,t1,t2);}

static void C_fcall trf_4297(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4297(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4297(t0,t1,t2,t3);}

static void C_fcall trf_4315(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4315(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4315(t0,t1,t2,t3);}

static void C_fcall trf_4328(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4328(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4328(t0,t1);}

static void C_fcall trf_4115(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4115(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4115(t0,t1,t2);}

static void C_fcall trf_4149(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4149(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4149(t0,t1,t2);}

static void C_fcall trf_3603(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3603(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3603(t0,t1,t2);}

static void C_fcall trf_3615(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3615(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3615(t0,t1,t2);}

static void C_fcall trf_3498(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3498(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3498(t0,t1);}

static void C_fcall trf_3393(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3393(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3393(t0,t1,t2,t3);}

static void C_fcall trf_3319(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3319(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3319(t0,t1,t2,t3);}

static void C_fcall trf_3347(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3347(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3347(t0,t1);}

static void C_fcall trf_3260(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3260(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3260(t0,t1);}

static void C_fcall trf_3165(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3165(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3165(t0,t1,t2,t3,t4);}

static void C_fcall trf_3128(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3128(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3128(t0,t1,t2);}

static void C_fcall trf_2919(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2919(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2919(t0,t1,t2,t3);}

static void C_fcall trf_2707(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2707(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2707(t0,t1,t2,t3);}

static void C_fcall trf_2650(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2650(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2650(t0,t1,t2);}

static void C_fcall trf_2571(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2571(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2571(t0,t1);}

static void C_fcall trf_2591(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2591(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2591(t0,t1,t2);}

static void C_fcall trf_2518(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2518(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2518(t0,t1);}

static void C_fcall trf_2184(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2184(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2184(t0,t1,t2,t3,t4);}

static void C_fcall trf_2178(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2178(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2178(t0,t1);}

static void C_fcall trf_2048(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2048(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2048(t0,t1);}

static void C_fcall trf_2043(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2043(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2043(t0,t1,t2);}

static void C_fcall trf_1945(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1945(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1945(t0,t1,t2,t3);}

static void C_fcall trf_1976(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1976(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1976(t0,t1);}

static void C_fcall trf_1998(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1998(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1998(t0,t1);}

static void C_fcall trf_1653(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1653(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1653(t0,t1,t2,t3);}

static void C_fcall trf_1486(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1486(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1486(t0,t1);}

static void C_fcall trf_1525(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1525(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1525(t0,t1);}

static void C_fcall trf_1529(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1529(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1529(t0,t1);}

static void C_fcall trf_1214(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1214(void *dummy){
C_word t0=C_pick(0);
C_adjust_stack(-1);
f_1214(t0);}

static void C_fcall trf_1197(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1197(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_1197(t0,t1,t2,t3,t4,t5);}

static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(2340)){
C_save(t1);
C_rereclaim2(2340*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,546);
lf[1]=C_static_string(C_heaptop,27,"too many optional arguments");
lf[3]=C_static_lambda_info(C_heaptop,18,"(make-nonblocking)");
lf[4]=C_h_intern(&lf[4],13,"string-append");
lf[6]=C_h_intern(&lf[6],15,"\003syssignal-hook");
lf[7]=C_static_string(C_heaptop,3," - ");
lf[8]=C_h_intern(&lf[8],17,"\003syspeek-c-string");
lf[9]=C_h_intern(&lf[9],16,"\003sysupdate-errno");
lf[10]=C_static_lambda_info(C_heaptop,39,"(posix-error type13 loc14 msg15 args16)");
lf[12]=C_h_intern(&lf[12],18,"\003syscurrent-thread");
lf[13]=C_static_lambda_info(C_heaptop,7,"(a1228)");
lf[14]=C_h_intern(&lf[14],12,"\003sysschedule");
lf[15]=C_static_lambda_info(C_heaptop,16,"(a1219 return18)");
lf[16]=C_static_lambda_info(C_heaptop,7,"(yield)");
lf[17]=C_h_intern(&lf[17],8,"pipe/buf");
lf[18]=C_h_intern(&lf[18],11,"open/rdonly");
lf[19]=C_h_intern(&lf[19],11,"open/wronly");
lf[20]=C_h_intern(&lf[20],9,"open/rdwr");
lf[21]=C_h_intern(&lf[21],9,"open/read");
lf[22]=C_h_intern(&lf[22],10,"open/write");
lf[23]=C_h_intern(&lf[23],10,"open/creat");
lf[24]=C_h_intern(&lf[24],11,"open/append");
lf[25]=C_h_intern(&lf[25],9,"open/excl");
lf[26]=C_h_intern(&lf[26],11,"open/noctty");
lf[27]=C_h_intern(&lf[27],13,"open/nonblock");
lf[28]=C_h_intern(&lf[28],10,"open/trunc");
lf[29]=C_h_intern(&lf[29],9,"open/sync");
lf[30]=C_h_intern(&lf[30],10,"open/fsync");
lf[31]=C_h_intern(&lf[31],11,"open/binary");
lf[32]=C_h_intern(&lf[32],9,"open/text");
lf[33]=C_h_intern(&lf[33],10,"perm/irusr");
lf[34]=C_h_intern(&lf[34],10,"perm/iwusr");
lf[35]=C_h_intern(&lf[35],10,"perm/ixusr");
lf[36]=C_h_intern(&lf[36],10,"perm/irgrp");
lf[37]=C_h_intern(&lf[37],10,"perm/iwgrp");
lf[38]=C_h_intern(&lf[38],10,"perm/ixgrp");
lf[39]=C_h_intern(&lf[39],10,"perm/iroth");
lf[40]=C_h_intern(&lf[40],10,"perm/iwoth");
lf[41]=C_h_intern(&lf[41],10,"perm/ixoth");
lf[42]=C_h_intern(&lf[42],10,"perm/irwxu");
lf[43]=C_h_intern(&lf[43],10,"perm/irwxg");
lf[44]=C_h_intern(&lf[44],10,"perm/irwxo");
lf[45]=C_h_intern(&lf[45],10,"perm/isvtx");
lf[46]=C_h_intern(&lf[46],10,"perm/isuid");
lf[47]=C_h_intern(&lf[47],10,"perm/isgid");
lf[48]=C_h_intern(&lf[48],9,"file-open");
lf[49]=C_h_intern(&lf[49],11,"\000file-error");
lf[50]=C_static_string(C_heaptop,17,"can not open file");
lf[51]=C_h_intern(&lf[51],17,"\003sysmake-c-string");
lf[52]=C_h_intern(&lf[52],20,"\003sysexpand-home-path");
lf[53]=C_static_lambda_info(C_heaptop,39,"(file-open filename22 flags23 . mode24)");
lf[54]=C_h_intern(&lf[54],10,"file-close");
lf[55]=C_static_string(C_heaptop,18,"can not close file");
lf[56]=C_static_lambda_info(C_heaptop,17,"(file-close fd31)");
lf[57]=C_h_intern(&lf[57],11,"make-string");
lf[58]=C_h_intern(&lf[58],9,"file-read");
lf[59]=C_static_string(C_heaptop,22,"can not read from file");
lf[60]=C_h_intern(&lf[60],11,"\000type-error");
lf[61]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[62]=C_static_lambda_info(C_heaptop,34,"(file-read fd34 size35 . buffer36)");
lf[63]=C_h_intern(&lf[63],10,"file-write");
lf[64]=C_static_string(C_heaptop,21,"can not write to file");
lf[65]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[66]=C_static_lambda_info(C_heaptop,35,"(file-write fd43 buffer44 . size45)");
lf[67]=C_h_intern(&lf[67],13,"string-length");
lf[68]=C_h_intern(&lf[68],12,"file-mkstemp");
lf[69]=C_h_intern(&lf[69],13,"\003syssubstring");
lf[70]=C_static_string(C_heaptop,29,"can not create temporary file");
lf[71]=C_static_lambda_info(C_heaptop,25,"(file-mkstemp template53)");
lf[72]=C_static_lambda_info(C_heaptop,9,"(fd_zero)");
lf[73]=C_static_lambda_info(C_heaptop,14,"(fd_set a6671)");
lf[74]=C_static_lambda_info(C_heaptop,15,"(fd_test a7277)");
lf[75]=C_h_intern(&lf[75],11,"file-select");
lf[76]=C_static_string(C_heaptop,6,"failed");
lf[77]=C_static_lambda_info(C_heaptop,13,"(a1542 fd103)");
lf[78]=C_h_intern(&lf[78],12,"\003sysfor-each");
lf[79]=C_static_lambda_info(C_heaptop,13,"(a1567 fd100)");
lf[80]=C_static_lambda_info(C_heaptop,12,"(a1607 fd93)");
lf[81]=C_static_lambda_info(C_heaptop,12,"(a1633 fd86)");
lf[82]=C_static_lambda_info(C_heaptop,39,"(file-select fdsr78 fdsw79 . timeout80)");
lf[83]=C_h_intern(&lf[83],8,"seek/set");
lf[84]=C_h_intern(&lf[84],8,"seek/end");
lf[85]=C_h_intern(&lf[85],8,"seek/cur");
lf[87]=C_static_string(C_heaptop,19,"can not access file");
lf[88]=C_static_string(C_heaptop,42,"bad argument type - not a fixnum or string");
lf[89]=C_static_lambda_info(C_heaptop,35,"(##sys#stat file109 link110 loc111)");
lf[90]=C_h_intern(&lf[90],9,"file-stat");
lf[91]=C_h_intern(&lf[91],9,"\003syserror");
lf[92]=C_static_lambda_info(C_heaptop,26,"(file-stat f114 . link115)");
lf[93]=C_h_intern(&lf[93],9,"file-size");
lf[94]=C_static_lambda_info(C_heaptop,16,"(file-size f120)");
lf[95]=C_h_intern(&lf[95],22,"file-modification-time");
lf[96]=C_static_lambda_info(C_heaptop,29,"(file-modification-time f122)");
lf[97]=C_h_intern(&lf[97],16,"file-access-time");
lf[98]=C_static_lambda_info(C_heaptop,23,"(file-access-time f124)");
lf[99]=C_h_intern(&lf[99],16,"file-change-time");
lf[100]=C_static_lambda_info(C_heaptop,23,"(file-change-time f126)");
lf[101]=C_h_intern(&lf[101],10,"file-owner");
lf[102]=C_static_lambda_info(C_heaptop,17,"(file-owner f128)");
lf[103]=C_h_intern(&lf[103],16,"file-permissions");
lf[104]=C_static_lambda_info(C_heaptop,23,"(file-permissions f130)");
lf[105]=C_h_intern(&lf[105],13,"regular-file\077");
lf[106]=C_static_lambda_info(C_heaptop,24,"(regular-file\077 fname132)");
lf[107]=C_h_intern(&lf[107],14,"symbolic-link\077");
lf[108]=C_static_lambda_info(C_heaptop,25,"(symbolic-link\077 fname136)");
lf[109]=C_h_intern(&lf[109],13,"file-position");
lf[110]=C_static_string(C_heaptop,38,"can not retrieve file position of port");
lf[111]=C_h_intern(&lf[111],6,"stream");
lf[112]=C_static_string(C_heaptop,12,"invalid file");
lf[113]=C_h_intern(&lf[113],5,"port\077");
lf[114]=C_static_lambda_info(C_heaptop,23,"(file-position port140)");
lf[115]=C_h_intern(&lf[115],18,"set-file-position!");
lf[116]=C_static_string(C_heaptop,25,"can not set file position");
lf[117]=C_static_string(C_heaptop,12,"invalid file");
lf[118]=C_h_intern(&lf[118],13,"\000bounds-error");
lf[119]=C_static_string(C_heaptop,30,"invalid negative port position");
lf[120]=C_static_lambda_info(C_heaptop,47,"(set-file-position! port143 pos144 . whence145)");
lf[121]=C_h_intern(&lf[121],16,"create-directory");
lf[122]=C_static_string(C_heaptop,24,"can not create directory");
lf[123]=C_static_lambda_info(C_heaptop,26,"(create-directory name150)");
lf[124]=C_h_intern(&lf[124],16,"change-directory");
lf[125]=C_static_string(C_heaptop,32,"can not change current directory");
lf[126]=C_static_lambda_info(C_heaptop,26,"(change-directory name152)");
lf[127]=C_h_intern(&lf[127],16,"delete-directory");
lf[128]=C_static_string(C_heaptop,24,"can not delete directory");
lf[129]=C_static_lambda_info(C_heaptop,26,"(delete-directory name154)");
lf[130]=C_h_intern(&lf[130],6,"string");
lf[131]=C_h_intern(&lf[131],9,"directory");
lf[132]=C_static_string(C_heaptop,22,"can not open directory");
lf[133]=C_static_lambda_info(C_heaptop,6,"(loop)");
lf[134]=C_h_intern(&lf[134],16,"\003sysmake-pointer");
lf[135]=C_static_lambda_info(C_heaptop,35,"(body163 spec169 show-dotfiles\077170)");
lf[136]=C_static_lambda_info(C_heaptop,35,"(def-show-dotfiles\077166 %spec161189)");
lf[137]=C_h_intern(&lf[137],17,"current-directory");
lf[138]=C_static_lambda_info(C_heaptop,13,"(def-spec165)");
lf[139]=C_static_lambda_info(C_heaptop,21,"(directory . g159160)");
lf[140]=C_h_intern(&lf[140],10,"directory\077");
lf[141]=C_h_intern(&lf[141],13,"\003sysfile-info");
lf[142]=C_static_lambda_info(C_heaptop,21,"(directory\077 fname195)");
lf[143]=C_static_string(C_heaptop,34,"can not retrieve current directory");
lf[144]=C_static_lambda_info(C_heaptop,29,"(current-directory . g199200)");
lf[145]=C_h_intern(&lf[145],5,"\000text");
lf[146]=C_static_lambda_info(C_heaptop,6,"(mode)");
lf[147]=C_static_string(C_heaptop,35,"illegal input/output mode specifier");
lf[148]=C_static_lambda_info(C_heaptop,14,"(badmode m210)");
lf[149]=C_static_string(C_heaptop,17,"can not open pipe");
lf[150]=C_h_intern(&lf[150],13,"\003sysmake-port");
lf[151]=C_h_intern(&lf[151],21,"\003sysstream-port-class");
lf[152]=C_static_string(C_heaptop,6,"(pipe)");
lf[153]=C_static_lambda_info(C_heaptop,33,"(check loc211 cmd212 inp213 r214)");
lf[154]=C_h_intern(&lf[154],15,"open-input-pipe");
lf[155]=C_h_intern(&lf[155],7,"\000binary");
lf[156]=C_static_lambda_info(C_heaptop,31,"(open-input-pipe cmd217 . m218)");
lf[157]=C_h_intern(&lf[157],16,"open-output-pipe");
lf[158]=C_static_lambda_info(C_heaptop,32,"(open-output-pipe cmd223 . m224)");
lf[159]=C_h_intern(&lf[159],16,"close-input-pipe");
lf[160]=C_h_intern(&lf[160],23,"close-input/output-pipe");
lf[161]=C_static_string(C_heaptop,24,"error while closing pipe");
lf[162]=C_h_intern(&lf[162],14,"\003syscheck-port");
lf[163]=C_static_lambda_info(C_heaptop,26,"(close-input-pipe port229)");
lf[164]=C_h_intern(&lf[164],17,"close-output-pipe");
lf[165]=C_h_intern(&lf[165],20,"call-with-input-pipe");
lf[166]=C_static_lambda_info(C_heaptop,7,"(a2295)");
lf[167]=C_static_lambda_info(C_heaptop,20,"(a2301 . results247)");
lf[168]=C_static_lambda_info(C_heaptop,47,"(call-with-input-pipe cmd243 proc244 . mode245)");
lf[169]=C_h_intern(&lf[169],21,"call-with-output-pipe");
lf[170]=C_static_lambda_info(C_heaptop,7,"(a2319)");
lf[171]=C_static_lambda_info(C_heaptop,20,"(a2325 . results253)");
lf[172]=C_static_lambda_info(C_heaptop,48,"(call-with-output-pipe cmd249 proc250 . mode251)");
lf[173]=C_h_intern(&lf[173],20,"with-input-from-pipe");
lf[174]=C_h_intern(&lf[174],18,"\003sysstandard-input");
lf[175]=C_static_lambda_info(C_heaptop,20,"(a2344 . results260)");
lf[176]=C_static_lambda_info(C_heaptop,48,"(with-input-from-pipe cmd255 thunk256 . mode257)");
lf[177]=C_h_intern(&lf[177],19,"with-output-to-pipe");
lf[178]=C_h_intern(&lf[178],19,"\003sysstandard-output");
lf[179]=C_static_lambda_info(C_heaptop,20,"(a2364 . results269)");
lf[180]=C_static_lambda_info(C_heaptop,47,"(with-output-to-pipe cmd264 thunk265 . mode266)");
lf[181]=C_h_intern(&lf[181],11,"create-pipe");
lf[182]=C_static_string(C_heaptop,19,"can not create pipe");
lf[183]=C_static_lambda_info(C_heaptop,13,"(create-pipe)");
lf[184]=C_h_intern(&lf[184],11,"signal/term");
lf[185]=C_h_intern(&lf[185],11,"signal/kill");
lf[186]=C_h_intern(&lf[186],10,"signal/int");
lf[187]=C_h_intern(&lf[187],10,"signal/hup");
lf[188]=C_h_intern(&lf[188],10,"signal/fpe");
lf[189]=C_h_intern(&lf[189],10,"signal/ill");
lf[190]=C_h_intern(&lf[190],11,"signal/segv");
lf[191]=C_h_intern(&lf[191],11,"signal/abrt");
lf[192]=C_h_intern(&lf[192],11,"signal/trap");
lf[193]=C_h_intern(&lf[193],11,"signal/quit");
lf[194]=C_h_intern(&lf[194],11,"signal/alrm");
lf[195]=C_h_intern(&lf[195],13,"signal/vtalrm");
lf[196]=C_h_intern(&lf[196],11,"signal/prof");
lf[197]=C_h_intern(&lf[197],9,"signal/io");
lf[198]=C_h_intern(&lf[198],10,"signal/urg");
lf[199]=C_h_intern(&lf[199],11,"signal/chld");
lf[200]=C_h_intern(&lf[200],11,"signal/cont");
lf[201]=C_h_intern(&lf[201],11,"signal/stop");
lf[202]=C_h_intern(&lf[202],11,"signal/tstp");
lf[203]=C_h_intern(&lf[203],11,"signal/pipe");
lf[204]=C_h_intern(&lf[204],11,"signal/xcpu");
lf[205]=C_h_intern(&lf[205],11,"signal/xfsz");
lf[206]=C_h_intern(&lf[206],11,"signal/usr1");
lf[207]=C_h_intern(&lf[207],11,"signal/usr2");
lf[208]=C_h_intern(&lf[208],12,"signal/winch");
lf[209]=C_h_intern(&lf[209],18,"\003sysinterrupt-hook");
lf[210]=C_h_intern(&lf[210],19,"set-signal-handler!");
lf[211]=C_static_lambda_info(C_heaptop,36,"(set-signal-handler! sig281 proc282)");
lf[212]=C_h_intern(&lf[212],18,"\003syscontext-switch");
lf[213]=C_static_lambda_info(C_heaptop,41,"(##sys#interrupt-hook reason285 state286)");
lf[214]=C_h_intern(&lf[214],16,"set-signal-mask!");
lf[215]=C_h_intern(&lf[215],14,"\000process-error");
lf[216]=C_static_string(C_heaptop,23,"can not set signal mask");
lf[217]=C_static_lambda_info(C_heaptop,12,"(a2466 s291)");
lf[218]=C_static_lambda_info(C_heaptop,26,"(set-signal-mask! sigs290)");
lf[219]=C_h_intern(&lf[219],18,"system-information");
lf[220]=C_h_intern(&lf[220],25,"\003syspeek-nonnull-c-string");
lf[221]=C_static_string(C_heaptop,35,"can not retrieve system information");
lf[222]=C_static_lambda_info(C_heaptop,20,"(system-information)");
lf[223]=C_h_intern(&lf[223],16,"user-information");
lf[224]=C_static_lambda_info(C_heaptop,26,"(user-information user299)");
lf[225]=C_h_intern(&lf[225],17,"group-information");
lf[226]=C_static_lambda_info(C_heaptop,10,"(rec i311)");
lf[227]=C_static_lambda_info(C_heaptop,28,"(group-information group307)");
lf[229]=C_static_lambda_info(C_heaptop,16,"(_ensure-groups)");
lf[230]=C_h_intern(&lf[230],10,"get-groups");
lf[231]=C_static_lambda_info(C_heaptop,11,"(loop i327)");
lf[232]=C_static_string(C_heaptop,40,"can not retrieve supplementary group ids");
lf[233]=C_static_string(C_heaptop,13,"out of memory");
lf[234]=C_static_string(C_heaptop,40,"can not retrieve supplementary group ids");
lf[235]=C_static_lambda_info(C_heaptop,12,"(get-groups)");
lf[236]=C_h_intern(&lf[236],11,"set-groups!");
lf[237]=C_static_string(C_heaptop,35,"can not set supplementary group ids");
lf[238]=C_static_lambda_info(C_heaptop,19,"(do333 lst335 i336)");
lf[239]=C_static_string(C_heaptop,13,"out of memory");
lf[240]=C_static_lambda_info(C_heaptop,21,"(set-groups! lst0332)");
lf[241]=C_h_intern(&lf[241],17,"initialize-groups");
lf[242]=C_static_string(C_heaptop,42,"can not initialize supplementary group ids");
lf[243]=C_static_lambda_info(C_heaptop,33,"(initialize-groups user352 id353)");
lf[244]=C_h_intern(&lf[244],10,"errno/perm");
lf[245]=C_h_intern(&lf[245],11,"errno/noent");
lf[246]=C_h_intern(&lf[246],10,"errno/srch");
lf[247]=C_h_intern(&lf[247],10,"errno/intr");
lf[248]=C_h_intern(&lf[248],8,"errno/io");
lf[249]=C_h_intern(&lf[249],12,"errno/noexec");
lf[250]=C_h_intern(&lf[250],10,"errno/badf");
lf[251]=C_h_intern(&lf[251],11,"errno/child");
lf[252]=C_h_intern(&lf[252],11,"errno/nomem");
lf[253]=C_h_intern(&lf[253],11,"errno/acces");
lf[254]=C_h_intern(&lf[254],11,"errno/fault");
lf[255]=C_h_intern(&lf[255],10,"errno/busy");
lf[256]=C_h_intern(&lf[256],12,"errno/notdir");
lf[257]=C_h_intern(&lf[257],11,"errno/isdir");
lf[258]=C_h_intern(&lf[258],11,"errno/inval");
lf[259]=C_h_intern(&lf[259],11,"errno/mfile");
lf[260]=C_h_intern(&lf[260],11,"errno/nospc");
lf[261]=C_h_intern(&lf[261],11,"errno/spipe");
lf[262]=C_h_intern(&lf[262],10,"errno/pipe");
lf[263]=C_h_intern(&lf[263],11,"errno/again");
lf[264]=C_h_intern(&lf[264],10,"errno/rofs");
lf[265]=C_h_intern(&lf[265],11,"errno/exist");
lf[266]=C_h_intern(&lf[266],16,"errno/wouldblock");
lf[267]=C_h_intern(&lf[267],16,"change-file-mode");
lf[268]=C_static_string(C_heaptop,24,"can not change file mode");
lf[269]=C_static_lambda_info(C_heaptop,32,"(change-file-mode fname365 m366)");
lf[270]=C_h_intern(&lf[270],17,"change-file-owner");
lf[271]=C_static_string(C_heaptop,25,"can not change file owner");
lf[272]=C_static_lambda_info(C_heaptop,39,"(change-file-owner fn369 uid370 gid371)");
lf[273]=C_h_intern(&lf[273],15,"current-user-id");
lf[274]=C_static_lambda_info(C_heaptop,17,"(current-user-id)");
lf[275]=C_h_intern(&lf[275],16,"current-group-id");
lf[276]=C_static_lambda_info(C_heaptop,18,"(current-group-id)");
lf[277]=C_h_intern(&lf[277],25,"current-effective-user-id");
lf[278]=C_static_lambda_info(C_heaptop,27,"(current-effective-user-id)");
lf[279]=C_h_intern(&lf[279],26,"current-effective-group-id");
lf[280]=C_static_lambda_info(C_heaptop,28,"(current-effective-group-id)");
lf[281]=C_h_intern(&lf[281],12,"set-user-id!");
lf[282]=C_static_string(C_heaptop,19,"can not set user ID");
lf[283]=C_static_lambda_info(C_heaptop,20,"(set-user-id! id383)");
lf[284]=C_h_intern(&lf[284],13,"set-group-id!");
lf[285]=C_static_string(C_heaptop,20,"can not set group ID");
lf[286]=C_static_lambda_info(C_heaptop,21,"(set-group-id! id385)");
lf[287]=C_static_lambda_info(C_heaptop,33,"(check filename388 acc389 loc390)");
lf[288]=C_h_intern(&lf[288],17,"file-read-access\077");
lf[289]=C_static_lambda_info(C_heaptop,31,"(file-read-access\077 filename394)");
lf[290]=C_h_intern(&lf[290],18,"file-write-access\077");
lf[291]=C_static_lambda_info(C_heaptop,32,"(file-write-access\077 filename395)");
lf[292]=C_h_intern(&lf[292],20,"file-execute-access\077");
lf[293]=C_static_lambda_info(C_heaptop,34,"(file-execute-access\077 filename396)");
lf[294]=C_h_intern(&lf[294],14,"create-session");
lf[295]=C_static_string(C_heaptop,22,"can not create session");
lf[296]=C_static_lambda_info(C_heaptop,16,"(create-session)");
lf[297]=C_h_intern(&lf[297],16,"process-group-id");
lf[298]=C_static_string(C_heaptop,33,"can not retrieve process group ID");
lf[299]=C_static_lambda_info(C_heaptop,25,"(process-group-id pid403)");
lf[300]=C_h_intern(&lf[300],21,"set-process-group-id!");
lf[301]=C_static_string(C_heaptop,28,"can not set process group ID");
lf[302]=C_static_lambda_info(C_heaptop,38,"(set-process-group-id! pid408 pgid409)");
lf[303]=C_h_intern(&lf[303],20,"create-symbolic-link");
lf[304]=C_h_intern(&lf[304],18,"create-symbol-link");
lf[305]=C_static_string(C_heaptop,28,"can not create symbolic link");
lf[306]=C_static_lambda_info(C_heaptop,36,"(create-symbolic-link old413 new414)");
lf[307]=C_h_intern(&lf[307],9,"substring");
lf[308]=C_h_intern(&lf[308],18,"read-symbolic-link");
lf[309]=C_static_string(C_heaptop,26,"can not read symbolic link");
lf[310]=C_static_lambda_info(C_heaptop,29,"(read-symbolic-link fname419)");
lf[311]=C_h_intern(&lf[311],9,"file-link");
lf[312]=C_h_intern(&lf[312],9,"hard-link");
lf[313]=C_static_string(C_heaptop,26,"could not create hard link");
lf[314]=C_static_lambda_info(C_heaptop,25,"(file-link old434 new435)");
lf[315]=C_h_intern(&lf[315],12,"fileno/stdin");
lf[316]=C_h_intern(&lf[316],13,"fileno/stdout");
lf[317]=C_h_intern(&lf[317],13,"fileno/stderr");
lf[318]=C_h_intern(&lf[318],7,"\000append");
lf[319]=C_static_string(C_heaptop,27,"invalid mode for input file");
lf[320]=C_static_string(C_heaptop,1,"a");
lf[321]=C_static_string(C_heaptop,21,"invalid mode argument");
lf[322]=C_static_string(C_heaptop,1,"r");
lf[323]=C_static_string(C_heaptop,1,"w");
lf[324]=C_static_lambda_info(C_heaptop,18,"(mode inp454 m455)");
lf[325]=C_static_string(C_heaptop,17,"can not open file");
lf[326]=C_static_string(C_heaptop,8,"(fdport)");
lf[327]=C_static_lambda_info(C_heaptop,32,"(check loc459 fd460 inp461 r462)");
lf[328]=C_h_intern(&lf[328],16,"open-input-file*");
lf[329]=C_static_lambda_info(C_heaptop,31,"(open-input-file* fd465 . m466)");
lf[330]=C_h_intern(&lf[330],17,"open-output-file*");
lf[331]=C_static_lambda_info(C_heaptop,32,"(open-output-file* fd468 . m469)");
lf[332]=C_h_intern(&lf[332],12,"port->fileno");
lf[333]=C_h_intern(&lf[333],6,"socket");
lf[334]=C_h_intern(&lf[334],20,"\003systcp-port->fileno");
lf[335]=C_static_string(C_heaptop,25,"port has no attached file");
lf[336]=C_static_string(C_heaptop,38,"can not access file-descriptor of port");
lf[337]=C_h_intern(&lf[337],25,"\003syspeek-unsigned-integer");
lf[338]=C_static_lambda_info(C_heaptop,22,"(port->fileno port474)");
lf[339]=C_h_intern(&lf[339],16,"duplicate-fileno");
lf[340]=C_static_string(C_heaptop,33,"can not duplicate file descriptor");
lf[341]=C_static_lambda_info(C_heaptop,34,"(duplicate-fileno old478 . new479)");
lf[342]=C_h_intern(&lf[342],13,"file-truncate");
lf[343]=C_static_string(C_heaptop,21,"can not truncate file");
lf[344]=C_static_string(C_heaptop,12,"invalid file");
lf[345]=C_static_lambda_info(C_heaptop,31,"(file-truncate fname485 off486)");
lf[346]=C_h_intern(&lf[346],4,"lock");
lf[347]=C_static_lambda_info(C_heaptop,30,"(setup port490 args491 loc492)");
lf[348]=C_static_lambda_info(C_heaptop,27,"(err msg505 lock506 loc507)");
lf[349]=C_h_intern(&lf[349],9,"file-lock");
lf[350]=C_static_string(C_heaptop,17,"can not lock file");
lf[351]=C_static_lambda_info(C_heaptop,29,"(file-lock port508 . args509)");
lf[352]=C_h_intern(&lf[352],18,"file-lock/blocking");
lf[353]=C_static_string(C_heaptop,17,"can not lock file");
lf[354]=C_static_lambda_info(C_heaptop,38,"(file-lock/blocking port511 . args512)");
lf[355]=C_h_intern(&lf[355],14,"file-test-lock");
lf[356]=C_static_string(C_heaptop,19,"can not unlock file");
lf[357]=C_static_lambda_info(C_heaptop,34,"(file-test-lock port514 . args515)");
lf[358]=C_h_intern(&lf[358],11,"file-unlock");
lf[359]=C_static_string(C_heaptop,19,"can not unlock file");
lf[360]=C_static_lambda_info(C_heaptop,21,"(file-unlock lock524)");
lf[361]=C_h_intern(&lf[361],11,"create-fifo");
lf[362]=C_static_string(C_heaptop,19,"can not create FIFO");
lf[363]=C_static_lambda_info(C_heaptop,32,"(create-fifo fname527 . mode528)");
lf[364]=C_h_intern(&lf[364],5,"fifo\077");
lf[365]=C_static_string(C_heaptop,19,"file does not exist");
lf[366]=C_static_lambda_info(C_heaptop,19,"(fifo\077 filename532)");
lf[367]=C_h_intern(&lf[367],6,"setenv");
lf[368]=C_static_lambda_info(C_heaptop,22,"(setenv var535 val536)");
lf[369]=C_h_intern(&lf[369],8,"unsetenv");
lf[370]=C_static_lambda_info(C_heaptop,17,"(unsetenv var540)");
lf[371]=C_h_intern(&lf[371],19,"current-environment");
lf[372]=C_static_lambda_info(C_heaptop,11,"(scan j553)");
lf[373]=C_static_lambda_info(C_heaptop,11,"(loop i550)");
lf[374]=C_static_lambda_info(C_heaptop,21,"(current-environment)");
lf[375]=C_h_intern(&lf[375],9,"prot/read");
lf[376]=C_h_intern(&lf[376],10,"prot/write");
lf[377]=C_h_intern(&lf[377],9,"prot/exec");
lf[378]=C_h_intern(&lf[378],9,"prot/none");
lf[379]=C_h_intern(&lf[379],9,"map/fixed");
lf[380]=C_h_intern(&lf[380],10,"map/shared");
lf[381]=C_h_intern(&lf[381],11,"map/private");
lf[382]=C_h_intern(&lf[382],13,"map/anonymous");
lf[383]=C_h_intern(&lf[383],8,"map/file");
lf[384]=C_h_intern(&lf[384],18,"map-file-to-memory");
lf[385]=C_h_intern(&lf[385],4,"mmap");
lf[386]=C_static_string(C_heaptop,26,"can not map file to memory");
lf[387]=C_h_intern(&lf[387],20,"\003syspointer->address");
lf[388]=C_static_string(C_heaptop,41,"bad argument type - not a foreign pointer");
lf[389]=C_h_intern(&lf[389],16,"\003sysnull-pointer");
lf[390]=C_static_lambda_info(C_heaptop,66,"(map-file-to-memory addr578 len579 prot580 flag581 fd582 . off583)");
lf[391]=C_h_intern(&lf[391],22,"unmap-file-from-memory");
lf[392]=C_static_string(C_heaptop,30,"can not unmap file from memory");
lf[393]=C_static_lambda_info(C_heaptop,41,"(unmap-file-from-memory mmap598 . len599)");
lf[394]=C_h_intern(&lf[394],26,"memory-mapped-file-pointer");
lf[395]=C_static_lambda_info(C_heaptop,36,"(memory-mapped-file-pointer mmap602)");
lf[396]=C_h_intern(&lf[396],19,"memory-mapped-file\077");
lf[397]=C_static_lambda_info(C_heaptop,26,"(memory-mapped-file\077 x604)");
lf[398]=C_h_intern(&lf[398],19,"seconds->local-time");
lf[399]=C_h_intern(&lf[399],18,"\003sysdecode-seconds");
lf[400]=C_static_lambda_info(C_heaptop,29,"(seconds->local-time secs617)");
lf[401]=C_h_intern(&lf[401],17,"seconds->utc-time");
lf[402]=C_static_lambda_info(C_heaptop,27,"(seconds->utc-time secs619)");
lf[403]=C_h_intern(&lf[403],15,"seconds->string");
lf[404]=C_static_string(C_heaptop,33,"can not convert seconds to string");
lf[405]=C_static_lambda_info(C_heaptop,25,"(seconds->string secs627)");
lf[406]=C_h_intern(&lf[406],12,"time->string");
lf[407]=C_static_string(C_heaptop,37,"can not convert time vector to string");
lf[408]=C_static_string(C_heaptop,21,"time vector too short");
lf[409]=C_static_lambda_info(C_heaptop,20,"(time->string tm636)");
lf[410]=C_h_intern(&lf[410],19,"local-time->seconds");
lf[411]=C_h_intern(&lf[411],15,"\003syscons-flonum");
lf[412]=C_static_string(C_heaptop,38,"can not convert time vector to seconds");
lf[413]=C_static_string(C_heaptop,21,"time vector too short");
lf[414]=C_static_lambda_info(C_heaptop,27,"(local-time->seconds tm641)");
lf[415]=C_h_intern(&lf[415],17,"utc-time->seconds");
lf[416]=C_static_string(C_heaptop,38,"can not convert time vector to seconds");
lf[417]=C_static_string(C_heaptop,21,"time vector too short");
lf[418]=C_static_lambda_info(C_heaptop,25,"(utc-time->seconds tm644)");
lf[419]=C_h_intern(&lf[419],27,"local-timezone-abbreviation");
lf[420]=C_static_lambda_info(C_heaptop,29,"(local-timezone-abbreviation)");
lf[421]=C_h_intern(&lf[421],5,"_exit");
lf[422]=C_h_intern(&lf[422],23,"\003syscleanup-before-exit");
lf[423]=C_static_lambda_info(C_heaptop,17,"(_exit . code655)");
lf[424]=C_h_intern(&lf[424],10,"set-alarm!");
lf[425]=C_static_lambda_info(C_heaptop,20,"(set-alarm! a657660)");
lf[426]=C_h_intern(&lf[426],19,"set-buffering-mode!");
lf[427]=C_static_string(C_heaptop,26,"can not set buffering mode");
lf[428]=C_h_intern(&lf[428],5,"\000full");
lf[429]=C_h_intern(&lf[429],5,"\000line");
lf[430]=C_h_intern(&lf[430],5,"\000none");
lf[431]=C_static_string(C_heaptop,22,"invalid buffering-mode");
lf[432]=C_static_lambda_info(C_heaptop,47,"(set-buffering-mode! port661 mode662 . size663)");
lf[433]=C_h_intern(&lf[433],14,"terminal-port\077");
lf[434]=C_static_lambda_info(C_heaptop,24,"(terminal-port\077 port670)");
lf[435]=C_h_intern(&lf[435],13,"terminal-name");
lf[436]=C_static_string(C_heaptop,35,"port is not connected to a terminal");
lf[437]=C_static_lambda_info(C_heaptop,23,"(terminal-name port679)");
lf[438]=C_h_intern(&lf[438],13,"get-host-name");
lf[439]=C_h_intern(&lf[439],6,"\000error");
lf[440]=C_static_string(C_heaptop,26,"can not retrieve host-name");
lf[441]=C_static_lambda_info(C_heaptop,15,"(get-host-name)");
lf[442]=C_h_intern(&lf[442],12,"glob->regexp");
lf[443]=C_h_intern(&lf[443],13,"make-pathname");
lf[444]=C_h_intern(&lf[444],18,"decompose-pathname");
lf[445]=C_h_intern(&lf[445],4,"glob");
lf[446]=C_static_lambda_info(C_heaptop,7,"(a4129)");
lf[447]=C_h_intern(&lf[447],12,"string-match");
lf[448]=C_static_lambda_info(C_heaptop,11,"(loop f711)");
lf[449]=C_static_string(C_heaptop,1,".");
lf[450]=C_static_string(C_heaptop,1,"*");
lf[451]=C_static_lambda_info(C_heaptop,38,"(a4135 dir698701 file699702 ext700703)");
lf[452]=C_static_lambda_info(C_heaptop,15,"(conc paths696)");
lf[453]=C_static_lambda_info(C_heaptop,17,"(glob . paths694)");
lf[454]=C_h_intern(&lf[454],12,"process-fork");
lf[455]=C_static_string(C_heaptop,28,"can not create child process");
lf[456]=C_static_lambda_info(C_heaptop,16,"(f_4241 a724727)");
lf[457]=C_static_lambda_info(C_heaptop,25,"(process-fork . thunk722)");
lf[458]=C_static_lambda_info(C_heaptop,24,"(setarg a735741 a734742)");
lf[459]=C_static_lambda_info(C_heaptop,24,"(setenv a747753 a746754)");
lf[460]=C_h_intern(&lf[460],24,"pathname-strip-directory");
lf[461]=C_h_intern(&lf[461],15,"process-execute");
lf[462]=C_static_string(C_heaptop,23,"can not execute process");
lf[463]=C_static_lambda_info(C_heaptop,12,"(do776 i779)");
lf[464]=C_static_lambda_info(C_heaptop,18,"(do772 al774 i775)");
lf[465]=C_static_lambda_info(C_heaptop,31,"(body763 arglist769 envlist770)");
lf[466]=C_static_lambda_info(C_heaptop,31,"(def-envlist766 %arglist761798)");
lf[467]=C_static_lambda_info(C_heaptop,16,"(def-arglist765)");
lf[468]=C_static_lambda_info(C_heaptop,39,"(process-execute filename759 . g758760)");
lf[469]=C_h_intern(&lf[469],12,"process-wait");
lf[470]=C_static_string(C_heaptop,32,"waiting for child process failed");
lf[471]=C_static_lambda_info(C_heaptop,24,"(process-wait . args804)");
lf[472]=C_h_intern(&lf[472],18,"current-process-id");
lf[473]=C_static_lambda_info(C_heaptop,20,"(current-process-id)");
lf[474]=C_h_intern(&lf[474],17,"parent-process-id");
lf[475]=C_static_lambda_info(C_heaptop,19,"(parent-process-id)");
lf[476]=C_h_intern(&lf[476],5,"sleep");
lf[477]=C_static_lambda_info(C_heaptop,15,"(sleep a824827)");
lf[478]=C_h_intern(&lf[478],14,"process-signal");
lf[479]=C_static_string(C_heaptop,32,"could not send signal to process");
lf[480]=C_static_lambda_info(C_heaptop,31,"(process-signal id828 . sig829)");
lf[481]=C_h_intern(&lf[481],6,"getenv");
lf[482]=C_h_intern(&lf[482],11,"process-run");
lf[483]=C_static_string(C_heaptop,7,"/bin/sh");
lf[484]=C_static_string(C_heaptop,2,"-c");
lf[485]=C_static_string(C_heaptop,5,"SHELL");
lf[486]=C_static_lambda_info(C_heaptop,28,"(process-run f837 . args838)");
lf[487]=C_h_intern(&lf[487],15,"make-input-port");
lf[488]=C_h_intern(&lf[488],16,"make-output-port");
lf[489]=C_static_lambda_info(C_heaptop,7,"(a4645)");
lf[490]=C_h_intern(&lf[490],7,"process");
lf[491]=C_static_string(C_heaptop,25,"process exited abnormally");
lf[492]=C_static_lambda_info(C_heaptop,22,"(a4651 _862 f863 s864)");
lf[493]=C_static_lambda_info(C_heaptop,13,"(wait pid861)");
lf[494]=C_static_lambda_info(C_heaptop,7,"(a4670)");
lf[495]=C_static_lambda_info(C_heaptop,7,"(a4682)");
lf[496]=C_h_intern(&lf[496],25,"\003systhread-block-for-i/o!");
lf[497]=C_static_string(C_heaptop,22,"can not read from pipe");
lf[498]=C_static_lambda_info(C_heaptop,6,"(loop)");
lf[499]=C_static_lambda_info(C_heaptop,7,"(fetch)");
lf[500]=C_static_string(C_heaptop,21,"can not write to pipe");
lf[501]=C_static_lambda_info(C_heaptop,6,"(loop)");
lf[502]=C_static_lambda_info(C_heaptop,12,"(a4761 s921)");
lf[503]=C_static_lambda_info(C_heaptop,7,"(a4811)");
lf[504]=C_static_lambda_info(C_heaptop,7,"(a4824)");
lf[505]=C_static_lambda_info(C_heaptop,7,"(a4840)");
lf[506]=C_static_lambda_info(C_heaptop,7,"(a4856)");
lf[507]=C_static_string(C_heaptop,7,"/bin/sh");
lf[508]=C_static_string(C_heaptop,2,"-c");
lf[509]=C_static_string(C_heaptop,5,"SHELL");
lf[510]=C_static_lambda_info(C_heaptop,7,"(a4869)");
lf[511]=C_static_lambda_info(C_heaptop,28,"(a4688 in2884886 out2885887)");
lf[512]=C_static_lambda_info(C_heaptop,28,"(a4676 in1878880 out1879881)");
lf[513]=C_static_lambda_info(C_heaptop,24,"(body870 args876 env877)");
lf[514]=C_static_lambda_info(C_heaptop,24,"(def-env873 %args868937)");
lf[515]=C_static_lambda_info(C_heaptop,13,"(def-args872)");
lf[516]=C_static_lambda_info(C_heaptop,26,"(process cmd866 . g865867)");
lf[517]=C_h_intern(&lf[517],10,"find-files");
lf[518]=C_static_lambda_info(C_heaptop,13,"(f_5094 x976)");
lf[519]=C_static_string(C_heaptop,1,".");
lf[520]=C_static_string(C_heaptop,2,"..");
lf[521]=C_static_lambda_info(C_heaptop,7,"(a5040)");
lf[522]=C_static_string(C_heaptop,1,"*");
lf[523]=C_static_lambda_info(C_heaptop,7,"(a5045)");
lf[524]=C_static_lambda_info(C_heaptop,7,"(a5059)");
lf[525]=C_h_intern(&lf[525],16,"\003sysdynamic-wind");
lf[526]=C_h_intern(&lf[526],13,"pathname-file");
lf[527]=C_static_lambda_info(C_heaptop,17,"(loop fs978 r979)");
lf[528]=C_static_string(C_heaptop,1,"*");
lf[529]=C_static_lambda_info(C_heaptop,15,"(f_5110 . _974)");
lf[530]=C_static_lambda_info(C_heaptop,15,"(f_5102 . _973)");
lf[531]=C_static_lambda_info(C_heaptop,34,"(body961 action968 id969 limit970)");
lf[532]=C_static_lambda_info(C_heaptop,38,"(def-limit965 %action958991 %id959992)");
lf[533]=C_static_lambda_info(C_heaptop,25,"(def-id964 %action958994)");
lf[534]=C_static_lambda_info(C_heaptop,17,"(a5130 x996 y997)");
lf[535]=C_static_lambda_info(C_heaptop,15,"(def-action963)");
lf[536]=C_static_lambda_info(C_heaptop,48,"(find-files dir955 pred956 . action-id-limit957)");
lf[537]=C_h_intern(&lf[537],19,"set-root-directory!");
lf[538]=C_static_string(C_heaptop,31,"unable to change root directory");
lf[539]=C_static_lambda_info(C_heaptop,29,"(set-root-directory! dir1011)");
lf[540]=C_h_intern(&lf[540],23,"\003sysuser-interrupt-hook");
lf[541]=C_static_lambda_info(C_heaptop,12,"(a5229 n296)");
lf[542]=C_h_intern(&lf[542],11,"make-vector");
lf[543]=C_h_intern(&lf[543],17,"register-feature!");
lf[544]=C_h_intern(&lf[544],5,"posix");
lf[545]=C_static_lambda_info(C_heaptop,10,"(toplevel)");
C_register_lf2(lf,546,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1166,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k1164 */
static void f_1166(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1166,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1169,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1167 in k1164 */
static void f_1169(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1169,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1172,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1170 in k1167 in k1164 */
static void f_1172(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1172,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1175,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1173 in k1170 in k1167 in k1164 */
static void f_1175(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1175,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1178,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 365  register-feature! */
t3=*((C_word*)lf[543]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[544]);}

/* k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1178(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word ab[158],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1178,2,t0,t1);}
t2=C_mutate(&lf[2],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1180,a[2]=lf[3],tmp=(C_word)a,a+=3,tmp));
t3=*((C_word*)lf[4]+1);
t4=C_mutate(&lf[5],(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1197,a[2]=t3,a[3]=lf[10],tmp=(C_word)a,a+=4,tmp));
t5=C_mutate(&lf[11],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1214,a[2]=lf[16],tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[17]+1,C_fix((C_word)PIPE_BUF));
t7=C_mutate((C_word*)lf[18]+1,C_fix((C_word)O_RDONLY));
t8=C_mutate((C_word*)lf[19]+1,C_fix((C_word)O_WRONLY));
t9=C_mutate((C_word*)lf[20]+1,C_fix((C_word)O_RDWR));
t10=C_mutate((C_word*)lf[21]+1,C_fix((C_word)O_RDONLY));
t11=C_mutate((C_word*)lf[22]+1,C_fix((C_word)O_WRONLY));
t12=C_mutate((C_word*)lf[23]+1,C_fix((C_word)O_CREAT));
t13=C_mutate((C_word*)lf[24]+1,C_fix((C_word)O_APPEND));
t14=C_mutate((C_word*)lf[25]+1,C_fix((C_word)O_EXCL));
t15=C_mutate((C_word*)lf[26]+1,C_fix((C_word)O_NOCTTY));
t16=C_mutate((C_word*)lf[27]+1,C_fix((C_word)O_NONBLOCK));
t17=C_mutate((C_word*)lf[28]+1,C_fix((C_word)O_TRUNC));
t18=C_mutate((C_word*)lf[29]+1,C_fix((C_word)O_FSYNC));
t19=C_mutate((C_word*)lf[30]+1,C_fix((C_word)O_FSYNC));
t20=C_mutate((C_word*)lf[31]+1,C_fix((C_word)O_BINARY));
t21=C_mutate((C_word*)lf[32]+1,C_fix((C_word)O_TEXT));
t22=C_mutate((C_word*)lf[33]+1,C_fix((C_word)S_IRUSR));
t23=C_mutate((C_word*)lf[34]+1,C_fix((C_word)S_IWUSR));
t24=C_mutate((C_word*)lf[35]+1,C_fix((C_word)S_IXUSR));
t25=C_mutate((C_word*)lf[36]+1,C_fix((C_word)S_IRGRP));
t26=C_mutate((C_word*)lf[37]+1,C_fix((C_word)S_IWGRP));
t27=C_mutate((C_word*)lf[38]+1,C_fix((C_word)S_IXGRP));
t28=C_mutate((C_word*)lf[39]+1,C_fix((C_word)S_IROTH));
t29=C_mutate((C_word*)lf[40]+1,C_fix((C_word)S_IWOTH));
t30=C_mutate((C_word*)lf[41]+1,C_fix((C_word)S_IXOTH));
t31=C_mutate((C_word*)lf[42]+1,C_fix((C_word)S_IRWXU));
t32=C_mutate((C_word*)lf[43]+1,C_fix((C_word)S_IRWXG));
t33=C_mutate((C_word*)lf[44]+1,C_fix((C_word)S_IRWXO));
t34=C_mutate((C_word*)lf[45]+1,C_fix((C_word)S_ISVTX));
t35=C_mutate((C_word*)lf[46]+1,C_fix((C_word)S_ISUID));
t36=C_mutate((C_word*)lf[47]+1,C_fix((C_word)S_ISGID));
t37=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t38=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t37);
t39=C_mutate((C_word*)lf[48]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1269,a[2]=t38,a[3]=lf[53],tmp=(C_word)a,a+=4,tmp));
t40=C_mutate((C_word*)lf[54]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1307,a[2]=lf[56],tmp=(C_word)a,a+=3,tmp));
t41=*((C_word*)lf[57]+1);
t42=C_mutate((C_word*)lf[58]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1322,a[2]=t41,a[3]=lf[62],tmp=(C_word)a,a+=4,tmp));
t43=C_mutate((C_word*)lf[63]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1364,a[2]=lf[66],tmp=(C_word)a,a+=3,tmp));
t44=*((C_word*)lf[67]+1);
t45=C_mutate((C_word*)lf[68]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1403,a[2]=t44,a[3]=lf[71],tmp=(C_word)a,a+=4,tmp));
t46=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1435,a[2]=lf[72],tmp=(C_word)a,a+=3,tmp);
t47=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1441,a[2]=lf[73],tmp=(C_word)a,a+=3,tmp);
t48=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1451,a[2]=lf[74],tmp=(C_word)a,a+=3,tmp);
t49=C_mutate((C_word*)lf[75]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1461,a[2]=t47,a[3]=t48,a[4]=t46,a[5]=lf[82],tmp=(C_word)a,a+=6,tmp));
t50=C_mutate((C_word*)lf[83]+1,C_fix((C_word)SEEK_SET));
t51=C_mutate((C_word*)lf[84]+1,C_fix((C_word)SEEK_END));
t52=C_mutate((C_word*)lf[85]+1,C_fix((C_word)SEEK_CUR));
t53=C_mutate(&lf[86],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1653,a[2]=lf[89],tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[90]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1690,a[2]=lf[92],tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[93]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1722,a[2]=lf[94],tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[95]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1728,a[2]=lf[96],tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[97]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1734,a[2]=lf[98],tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[99]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1740,a[2]=lf[100],tmp=(C_word)a,a+=3,tmp));
t59=C_mutate((C_word*)lf[101]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1746,a[2]=lf[102],tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[103]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1752,a[2]=lf[104],tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[105]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1758,a[2]=lf[106],tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[107]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1767,a[2]=lf[108],tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[109]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1776,a[2]=lf[114],tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[115]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1813,a[2]=lf[120],tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[121]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1871,a[2]=lf[123],tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[124]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1895,a[2]=lf[126],tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[127]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1919,a[2]=lf[129],tmp=(C_word)a,a+=3,tmp));
t68=*((C_word*)lf[4]+1);
t69=*((C_word*)lf[57]+1);
t70=*((C_word*)lf[130]+1);
t71=C_mutate((C_word*)lf[131]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1943,a[2]=t69,a[3]=lf[139],tmp=(C_word)a,a+=4,tmp));
t72=C_mutate((C_word*)lf[140]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2100,a[2]=lf[142],tmp=(C_word)a,a+=3,tmp));
t73=*((C_word*)lf[57]+1);
t74=C_mutate((C_word*)lf[137]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2123,a[2]=t73,a[3]=lf[144],tmp=(C_word)a,a+=4,tmp));
t75=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2166,a[2]=lf[146],tmp=(C_word)a,a+=3,tmp);
t76=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2178,a[2]=lf[148],tmp=(C_word)a,a+=3,tmp);
t77=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2184,a[2]=lf[153],tmp=(C_word)a,a+=3,tmp);
t78=C_mutate((C_word*)lf[154]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2199,a[2]=t76,a[3]=t77,a[4]=t75,a[5]=lf[156],tmp=(C_word)a,a+=6,tmp));
t79=C_mutate((C_word*)lf[157]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2235,a[2]=t76,a[3]=t77,a[4]=t75,a[5]=lf[158],tmp=(C_word)a,a+=6,tmp));
t80=C_mutate((C_word*)lf[159]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2271,a[2]=lf[163],tmp=(C_word)a,a+=3,tmp));
t81=C_mutate((C_word*)lf[164]+1,*((C_word*)lf[159]+1));
t82=*((C_word*)lf[154]+1);
t83=*((C_word*)lf[157]+1);
t84=*((C_word*)lf[159]+1);
t85=*((C_word*)lf[164]+1);
t86=C_mutate((C_word*)lf[165]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2287,a[2]=t82,a[3]=t84,a[4]=lf[168],tmp=(C_word)a,a+=5,tmp));
t87=C_mutate((C_word*)lf[169]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2311,a[2]=t83,a[3]=t85,a[4]=lf[172],tmp=(C_word)a,a+=5,tmp));
t88=C_mutate((C_word*)lf[173]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2335,a[2]=t82,a[3]=t84,a[4]=lf[176],tmp=(C_word)a,a+=5,tmp));
t89=C_mutate((C_word*)lf[177]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2355,a[2]=t83,a[3]=t85,a[4]=lf[180],tmp=(C_word)a,a+=5,tmp));
t90=C_mutate((C_word*)lf[181]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2375,a[2]=lf[183],tmp=(C_word)a,a+=3,tmp));
t91=C_mutate((C_word*)lf[184]+1,C_fix((C_word)SIGTERM));
t92=C_mutate((C_word*)lf[185]+1,C_fix((C_word)SIGKILL));
t93=C_mutate((C_word*)lf[186]+1,C_fix((C_word)SIGINT));
t94=C_mutate((C_word*)lf[187]+1,C_fix((C_word)SIGHUP));
t95=C_mutate((C_word*)lf[188]+1,C_fix((C_word)SIGFPE));
t96=C_mutate((C_word*)lf[189]+1,C_fix((C_word)SIGILL));
t97=C_mutate((C_word*)lf[190]+1,C_fix((C_word)SIGSEGV));
t98=C_mutate((C_word*)lf[191]+1,C_fix((C_word)SIGABRT));
t99=C_mutate((C_word*)lf[192]+1,C_fix((C_word)SIGTRAP));
t100=C_mutate((C_word*)lf[193]+1,C_fix((C_word)SIGQUIT));
t101=C_mutate((C_word*)lf[194]+1,C_fix((C_word)SIGALRM));
t102=C_mutate((C_word*)lf[195]+1,C_fix((C_word)SIGVTALRM));
t103=C_mutate((C_word*)lf[196]+1,C_fix((C_word)SIGPROF));
t104=C_mutate((C_word*)lf[197]+1,C_fix((C_word)SIGIO));
t105=C_mutate((C_word*)lf[198]+1,C_fix((C_word)SIGURG));
t106=C_mutate((C_word*)lf[199]+1,C_fix((C_word)SIGCHLD));
t107=C_mutate((C_word*)lf[200]+1,C_fix((C_word)SIGCONT));
t108=C_mutate((C_word*)lf[201]+1,C_fix((C_word)SIGSTOP));
t109=C_mutate((C_word*)lf[202]+1,C_fix((C_word)SIGTSTP));
t110=C_mutate((C_word*)lf[203]+1,C_fix((C_word)SIGPIPE));
t111=C_mutate((C_word*)lf[204]+1,C_fix((C_word)SIGXCPU));
t112=C_mutate((C_word*)lf[205]+1,C_fix((C_word)SIGXFSZ));
t113=C_mutate((C_word*)lf[206]+1,C_fix((C_word)SIGUSR1));
t114=C_mutate((C_word*)lf[207]+1,C_fix((C_word)SIGUSR2));
t115=C_mutate((C_word*)lf[208]+1,C_fix((C_word)SIGWINCH));
t116=*((C_word*)lf[209]+1);
t117=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2416,a[2]=((C_word*)t0)[2],a[3]=t116,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 883  make-vector */
t118=*((C_word*)lf[542]+1);
((C_proc4)C_retrieve_proc(t118))(4,t118,t117,C_fix(256),C_SCHEME_FALSE);}

/* k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2416(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2416,2,t0,t1);}
t2=C_mutate((C_word*)lf[210]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2418,a[2]=t1,a[3]=lf[211],tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[209]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2431,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=lf[213],tmp=(C_word)a,a+=5,tmp));
t4=C_mutate((C_word*)lf[214]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2449,a[2]=lf[218],tmp=(C_word)a,a+=3,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2474,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5230,a[2]=lf[541],tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 913  set-signal-handler! */
t7=*((C_word*)lf[210]+1);
((C_proc4)C_retrieve_proc(t7))(4,t7,t5,*((C_word*)lf[186]+1),t6);}

/* a5229 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5230(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5230,3,t0,t1,t2);}
/* posix.scm: 915  ##sys#user-interrupt-hook */
t3=*((C_word*)lf[540]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t1);}

/* k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word ab[76],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2474,2,t0,t1);}
t2=C_mutate((C_word*)lf[219]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2476,a[2]=lf[222],tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[223]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2514,a[2]=lf[224],tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[225]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2567,a[2]=lf[227],tmp=(C_word)a,a+=3,tmp));
t5=C_mutate(&lf[228],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2628,a[2]=lf[229],tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[230]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2635,a[2]=lf[235],tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[236]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2698,a[2]=lf[240],tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[241]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2772,a[2]=lf[243],tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[244]+1,C_fix((C_word)EPERM));
t10=C_mutate((C_word*)lf[245]+1,C_fix((C_word)ENOENT));
t11=C_mutate((C_word*)lf[246]+1,C_fix((C_word)ESRCH));
t12=C_mutate((C_word*)lf[247]+1,C_fix((C_word)EINTR));
t13=C_mutate((C_word*)lf[248]+1,C_fix((C_word)EIO));
t14=C_mutate((C_word*)lf[249]+1,C_fix((C_word)ENOEXEC));
t15=C_mutate((C_word*)lf[250]+1,C_fix((C_word)EBADF));
t16=C_mutate((C_word*)lf[251]+1,C_fix((C_word)ECHILD));
t17=C_mutate((C_word*)lf[252]+1,C_fix((C_word)ENOMEM));
t18=C_mutate((C_word*)lf[253]+1,C_fix((C_word)EACCES));
t19=C_mutate((C_word*)lf[254]+1,C_fix((C_word)EFAULT));
t20=C_mutate((C_word*)lf[255]+1,C_fix((C_word)EBUSY));
t21=C_mutate((C_word*)lf[256]+1,C_fix((C_word)ENOTDIR));
t22=C_mutate((C_word*)lf[257]+1,C_fix((C_word)EISDIR));
t23=C_mutate((C_word*)lf[258]+1,C_fix((C_word)EINVAL));
t24=C_mutate((C_word*)lf[259]+1,C_fix((C_word)EMFILE));
t25=C_mutate((C_word*)lf[260]+1,C_fix((C_word)ENOSPC));
t26=C_mutate((C_word*)lf[261]+1,C_fix((C_word)ESPIPE));
t27=C_mutate((C_word*)lf[262]+1,C_fix((C_word)EPIPE));
t28=C_mutate((C_word*)lf[263]+1,C_fix((C_word)EAGAIN));
t29=C_mutate((C_word*)lf[264]+1,C_fix((C_word)EROFS));
t30=C_mutate((C_word*)lf[265]+1,C_fix((C_word)EEXIST));
t31=C_mutate((C_word*)lf[266]+1,C_fix((C_word)EWOULDBLOCK));
t32=C_mutate((C_word*)lf[267]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2820,a[2]=lf[269],tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[270]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2847,a[2]=lf[272],tmp=(C_word)a,a+=3,tmp));
t34=C_mutate((C_word*)lf[273]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2877,a[2]=lf[274],tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[275]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2880,a[2]=lf[276],tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[277]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2883,a[2]=lf[278],tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[279]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2886,a[2]=lf[280],tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[281]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2889,a[2]=lf[283],tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[284]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2904,a[2]=lf[286],tmp=(C_word)a,a+=3,tmp));
t40=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2919,a[2]=lf[287],tmp=(C_word)a,a+=3,tmp);
t41=C_mutate((C_word*)lf[288]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2943,a[2]=t40,a[3]=lf[289],tmp=(C_word)a,a+=4,tmp));
t42=C_mutate((C_word*)lf[290]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2949,a[2]=t40,a[3]=lf[291],tmp=(C_word)a,a+=4,tmp));
t43=C_mutate((C_word*)lf[292]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2955,a[2]=t40,a[3]=lf[293],tmp=(C_word)a,a+=4,tmp));
t44=C_mutate((C_word*)lf[294]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2961,a[2]=lf[296],tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[297]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2976,a[2]=lf[299],tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[300]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2994,a[2]=lf[302],tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[303]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3015,a[2]=lf[306],tmp=(C_word)a,a+=3,tmp));
t48=*((C_word*)lf[307]+1);
t49=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3052,a[2]=((C_word*)t0)[2],a[3]=t48,tmp=(C_word)a,a+=4,tmp);
t50=(C_word)C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* posix.scm: 1185 make-string */
t51=*((C_word*)lf[57]+1);
((C_proc3)C_retrieve_proc(t51))(3,t51,t49,t50);}

/* k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3052(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word ab[191],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3052,2,t0,t1);}
t2=C_mutate((C_word*)lf[308]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3053,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=lf[310],tmp=(C_word)a,a+=5,tmp));
t3=C_mutate((C_word*)lf[311]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3103,a[2]=lf[314],tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[315]+1,C_fix((C_word)STDIN_FILENO));
t5=C_mutate((C_word*)lf[316]+1,C_fix((C_word)STDOUT_FILENO));
t6=C_mutate((C_word*)lf[317]+1,C_fix((C_word)STDERR_FILENO));
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3128,a[2]=lf[324],tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3165,a[2]=lf[327],tmp=(C_word)a,a+=3,tmp);
t9=C_mutate((C_word*)lf[328]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3180,a[2]=t7,a[3]=t8,a[4]=lf[329],tmp=(C_word)a,a+=5,tmp));
t10=C_mutate((C_word*)lf[330]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3194,a[2]=t7,a[3]=t8,a[4]=lf[331],tmp=(C_word)a,a+=5,tmp));
t11=C_mutate((C_word*)lf[332]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3208,a[2]=lf[338],tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[339]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3253,a[2]=lf[341],tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[342]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3280,a[2]=lf[345],tmp=(C_word)a,a+=3,tmp));
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3319,a[2]=lf[347],tmp=(C_word)a,a+=3,tmp);
t15=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3393,a[2]=lf[348],tmp=(C_word)a,a+=3,tmp);
t16=C_mutate((C_word*)lf[349]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3411,a[2]=t14,a[3]=t15,a[4]=lf[351],tmp=(C_word)a,a+=5,tmp));
t17=C_mutate((C_word*)lf[352]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3426,a[2]=t14,a[3]=t15,a[4]=lf[354],tmp=(C_word)a,a+=5,tmp));
t18=C_mutate((C_word*)lf[355]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3441,a[2]=t14,a[3]=t15,a[4]=lf[357],tmp=(C_word)a,a+=5,tmp));
t19=C_mutate((C_word*)lf[358]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3463,a[2]=lf[360],tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[361]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3491,a[2]=lf[363],tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[364]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3534,a[2]=lf[366],tmp=(C_word)a,a+=3,tmp));
t22=C_mutate((C_word*)lf[367]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3560,a[2]=lf[368],tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[369]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3577,a[2]=lf[370],tmp=(C_word)a,a+=3,tmp));
t24=C_mutate((C_word*)lf[371]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3597,a[2]=lf[374],tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[375]+1,C_fix((C_word)PROT_READ));
t26=C_mutate((C_word*)lf[376]+1,C_fix((C_word)PROT_WRITE));
t27=C_mutate((C_word*)lf[377]+1,C_fix((C_word)PROT_EXEC));
t28=C_mutate((C_word*)lf[378]+1,C_fix((C_word)PROT_NONE));
t29=C_mutate((C_word*)lf[379]+1,C_fix((C_word)MAP_FIXED));
t30=C_mutate((C_word*)lf[380]+1,C_fix((C_word)MAP_SHARED));
t31=C_mutate((C_word*)lf[381]+1,C_fix((C_word)MAP_PRIVATE));
t32=C_mutate((C_word*)lf[382]+1,C_fix((C_word)MAP_ANON));
t33=C_mutate((C_word*)lf[383]+1,C_fix((C_word)MAP_FILE));
t34=C_mutate((C_word*)lf[384]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3700,a[2]=lf[390],tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[391]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3762,a[2]=lf[393],tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[394]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3797,a[2]=lf[395],tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[396]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3806,a[2]=lf[397],tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[398]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3812,a[2]=lf[400],tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[401]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3821,a[2]=lf[402],tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[403]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3840,a[2]=lf[405],tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[406]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3857,a[2]=lf[409],tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[410]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3885,a[2]=lf[414],tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[415]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3913,a[2]=lf[418],tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[419]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3941,a[2]=lf[420],tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[421]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3953,a[2]=lf[423],tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[424]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3972,a[2]=lf[425],tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[426]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3979,a[2]=lf[432],tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[433]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4038,a[2]=lf[434],tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[435]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4067,a[2]=lf[437],tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[438]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4097,a[2]=lf[441],tmp=(C_word)a,a+=3,tmp));
t51=*((C_word*)lf[442]+1);
t52=*((C_word*)lf[131]+1);
t53=*((C_word*)lf[443]+1);
t54=*((C_word*)lf[444]+1);
t55=C_mutate((C_word*)lf[445]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4109,a[2]=t51,a[3]=t52,a[4]=t53,a[5]=t54,a[6]=lf[453],tmp=(C_word)a,a+=7,tmp));
t56=C_mutate((C_word*)lf[454]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4215,a[2]=lf[457],tmp=(C_word)a,a+=3,tmp));
t57=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4257,a[2]=lf[458],tmp=(C_word)a,a+=3,tmp);
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4276,a[2]=lf[459],tmp=(C_word)a,a+=3,tmp);
t59=*((C_word*)lf[460]+1);
t60=C_mutate((C_word*)lf[461]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4295,a[2]=t59,a[3]=t58,a[4]=t57,a[5]=lf[468],tmp=(C_word)a,a+=6,tmp));
t61=C_mutate((C_word*)lf[469]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4474,a[2]=lf[471],tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[472]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4550,a[2]=lf[473],tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[474]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4553,a[2]=lf[475],tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[476]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4556,a[2]=lf[477],tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[478]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4563,a[2]=lf[480],tmp=(C_word)a,a+=3,tmp));
t66=*((C_word*)lf[454]+1);
t67=*((C_word*)lf[461]+1);
t68=*((C_word*)lf[481]+1);
t69=C_mutate((C_word*)lf[482]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4590,a[2]=t66,a[3]=t68,a[4]=t67,a[5]=lf[486],tmp=(C_word)a,a+=6,tmp));
t70=*((C_word*)lf[181]+1);
t71=*((C_word*)lf[454]+1);
t72=*((C_word*)lf[339]+1);
t73=*((C_word*)lf[54]+1);
t74=*((C_word*)lf[482]+1);
t75=*((C_word*)lf[57]+1);
t76=*((C_word*)lf[58]+1);
t77=*((C_word*)lf[487]+1);
t78=*((C_word*)lf[488]+1);
t79=*((C_word*)lf[63]+1);
t80=*((C_word*)lf[469]+1);
t81=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4640,a[2]=t80,a[3]=lf[493],tmp=(C_word)a,a+=4,tmp);
t82=C_mutate((C_word*)lf[490]+1,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4660,a[2]=t71,a[3]=t72,a[4]=t75,a[5]=t77,a[6]=t78,a[7]=t73,a[8]=t81,a[9]=t70,a[10]=lf[516],tmp=(C_word)a,a+=11,tmp));
t83=*((C_word*)lf[445]+1);
t84=*((C_word*)lf[447]+1);
t85=*((C_word*)lf[443]+1);
t86=*((C_word*)lf[140]+1);
t87=C_mutate((C_word*)lf[517]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4974,a[2]=t86,a[3]=t85,a[4]=t83,a[5]=t84,a[6]=lf[536],tmp=(C_word)a,a+=7,tmp));
t88=C_mutate((C_word*)lf[537]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5207,a[2]=lf[539],tmp=(C_word)a,a+=3,tmp));
t89=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t89+1)))(2,t89,C_SCHEME_UNDEFINED);}

/* set-root-directory! in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5207(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5207,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[537]);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5199,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=(C_word)C_i_foreign_string_argumentp(t4);
/* ##sys#make-c-string */
t7=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}
else{
t6=t5;
f_5199(2,t6,C_SCHEME_FALSE);}}

/* k5197 in set-root-directory! in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5199(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5199,2,t0,t1);}
t2=(C_word)stub1006(C_SCHEME_UNDEFINED,t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1811 posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[3],lf[49],lf[537],lf[538],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4974(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+21)){
C_save_and_reclaim((void*)tr4r,(void*)f_4974r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4974r(t0,t1,t2,t3,t4);}}

static void f_4974r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(21);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4976,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,a[8]=lf[531],tmp=(C_word)a,a+=9,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5115,a[2]=t5,a[3]=lf[532],tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5120,a[2]=t6,a[3]=lf[533],tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5125,a[2]=t7,a[3]=lf[535],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action963995 */
t9=t8;
f_5125(t9,t1);}
else{
t9=(C_word)C_i_car(t4);
t10=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id964993 */
t11=t7;
f_5120(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit965990 */
t13=t6;
f_5115(t13,t1,t9,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* body961967 */
t15=t5;
f_4976(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}}}}

/* def-action963 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_5125(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5125,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5131,a[2]=lf[534],tmp=(C_word)a,a+=3,tmp);
/* def-id964993 */
t3=((C_word*)t0)[2];
f_5120(t3,t1,t2);}

/* a5130 in def-action963 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5131(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5131,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id964 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_5120(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5120,NULL,3,t0,t1,t2);}
/* def-limit965990 */
t3=((C_word*)t0)[2];
f_5115(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit965 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_5115(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5115,NULL,4,t0,t1,t2,t3);}
/* body961967 */
t4=((C_word*)t0)[2];
f_4976(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4976(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4976,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[517]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4983,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_4983(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5110,a[2]=t4,a[3]=t7,a[4]=lf[529],tmp=(C_word)a,a+=5,tmp):t4));}
else{
t10=t8;
f_4983(t10,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5102,a[2]=lf[530],tmp=(C_word)a,a+=3,tmp));}}

/* f_5102 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5102(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5102,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_5110 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5110(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5110,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4983(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4983,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5094,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],a[4]=lf[518],tmp=(C_word)a,a+=5,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4993,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5090,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1783 make-pathname */
t6=((C_word*)t0)[7];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],lf[528]);}

/* k5088 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5090(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1783 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4993(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4993,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4995,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,a[10]=lf[527],tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_4995(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4995(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4995,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_5014,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posix.scm: 1789 directory? */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t4);}}

/* k5012 in loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5014(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5014,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5070,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
/* posix.scm: 1790 pathname-file */
t3=*((C_word*)lf[526]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5076,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posix.scm: 1796 pproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}}

/* k5074 in k5012 in loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5076(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5076,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5083,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1796 action */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posix.scm: 1797 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_4995(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k5081 in k5074 in k5012 in loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5083(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1796 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4995(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k5068 in k5012 in loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5070(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5070,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[519]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[520]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posix.scm: 1790 loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_4995(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5029,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posix.scm: 1791 lproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[3]);}}

/* k5027 in k5068 in k5012 in loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5029,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5039,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5041,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,a[5]=lf[521],tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5046,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=lf[523],tmp=(C_word)a,a+=8,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5060,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,a[5]=lf[524],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 1793 ##sys#dynamic-wind */
t11=*((C_word*)lf[525]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
/* posix.scm: 1795 loop */
t2=((C_word*)((C_word*)t0)[8])[1];
f_4995(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a5059 in k5027 in k5068 in k5012 in loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5060,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a5045 in k5027 in k5068 in k5012 in loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5046(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5046,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5054,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5058,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1794 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[2],lf[522]);}

/* k5056 in a5045 in k5027 in k5068 in k5012 in loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1794 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k5052 in a5045 in k5027 in k5068 in k5012 in loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5054(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1794 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4995(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a5040 in k5027 in k5068 in k5012 in loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5041,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k5037 in k5027 in k5068 in k5012 in loop in k4991 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1792 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4995(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_5094 in k4981 in body961 in find-files in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_5094(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5094,3,t0,t1,t2);}
/* posix.scm: 1781 string-match */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[2],t2);}

/* process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4660(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+20)){
C_save_and_reclaim((void*)tr3r,(void*)f_4660r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4660r(t0,t1,t2,t3);}}

static void f_4660r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(20);
t4=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4662,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=t2,a[11]=lf[513],tmp=(C_word)a,a+=12,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4921,a[2]=t4,a[3]=lf[514],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4926,a[2]=t5,a[3]=lf[515],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args872938 */
t7=t6;
f_4926(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env873936 */
t9=t5;
f_4921(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body870875 */
t11=t4;
f_4662(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-args872 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4926(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4926,NULL,2,t0,t1);}
/* def-env873936 */
t2=((C_word*)t0)[2];
f_4921(t2,t1,C_SCHEME_FALSE);}

/* def-env873 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4921(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4921,NULL,3,t0,t1,t2);}
/* body870875 */
t3=((C_word*)t0)[2];
f_4662(t3,t1,t2,C_SCHEME_FALSE);}

/* body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4662(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4662,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(((C_word*)t0)[10],lf[490]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4671,a[2]=((C_word*)t0)[9],a[3]=lf[494],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4677,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[9],a[13]=lf[512],tmp=(C_word)a,a+=14,tmp);
/* posix.scm: 1684 ##sys#call-with-values */
C_call_with_values(4,0,t1,t5,t6);}

/* a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4677(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4677,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4683,a[2]=((C_word*)t0)[12],a[3]=lf[495],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_4689,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],a[13]=t3,a[14]=lf[511],tmp=(C_word)a,a+=15,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}

/* a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4689(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[25],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4689,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4693,a[2]=((C_word*)t0)[6],a[3]=t3,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=t1,a[10]=((C_word*)t0)[12],a[11]=((C_word*)t0)[13],a[12]=t2,tmp=(C_word)a,a+=13,tmp);
t5=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4870,a[2]=((C_word*)t0)[13],a[3]=t2,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[10],a[7]=t3,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[12],a[10]=((C_word*)t0)[5],a[11]=lf[510],tmp=(C_word)a,a+=12,tmp);
/* posix.scm: 1687 process-fork */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t4,t5);}

/* a4869 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4870(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4870,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4874,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=t1,a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
/* posix.scm: 1689 file-close */
t3=((C_word*)t0)[6];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4872 in a4869 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4874(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4874,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4877,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
/* posix.scm: 1690 file-close */
t3=((C_word*)t0)[5];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4875 in k4872 in a4869 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4877,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4880,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[315]+1),((C_word*)t0)[2]);
if(C_truep(t3)){
t4=t2;
f_4880(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4917,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1692 duplicate-fileno */
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[2],*((C_word*)lf[315]+1));}}

/* k4915 in k4875 in k4872 in a4869 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4917(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1693 file-close */
t2=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4878 in k4875 in k4872 in a4869 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4880(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4880,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4883,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[316]+1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=t2;
f_4883(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4908,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1695 duplicate-fileno */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[4],*((C_word*)lf[316]+1));}}

/* k4906 in k4878 in k4875 in k4872 in a4869 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4908(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1696 file-close */
t2=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4881 in k4878 in k4875 in k4872 in a4869 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4883(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4883,2,t0,t1);}
if(C_truep(((C_word*)t0)[5])){
/* posix.scm: 1698 process-execute */
t2=*((C_word*)lf[461]+1);
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[5],((C_word*)t0)[2]);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4892,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1699 getenv */
t3=*((C_word*)lf[481]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[509]);}}

/* k4890 in k4881 in k4878 in k4875 in k4872 in a4869 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4892(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4892,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[507]);
t3=(C_word)C_a_i_list(&a,2,lf[508],((C_word*)t0)[4]);
/* posix.scm: 1700 process-execute */
t4=*((C_word*)lf[461]+1);
((C_proc5)C_retrieve_proc(t4))(5,t4,((C_word*)t0)[3],t2,t3,((C_word*)t0)[2]);}

/* k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4693,2,t0,t1);}
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_4696,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t3,a[9]=t5,a[10]=t1,a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=((C_word*)t0)[11],a[14]=((C_word*)t0)[12],tmp=(C_word)a,a+=15,tmp);
/* posix.scm: 1703 file-close */
t7=((C_word*)t0)[7];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[2]);}

/* k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4696(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4696,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4699,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
/* posix.scm: 1704 file-close */
t3=((C_word*)t0)[6];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4699(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4699,2,t0,t1);}
t2=f_1180(((C_word*)t0)[13]);
t3=f_1180(((C_word*)t0)[12]);
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4712,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[12],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
/* posix.scm: 1708 make-string */
t5=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,C_fix(256));}

/* k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4712(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[45],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4712,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4714,a[2]=((C_word*)t0)[11],a[3]=t1,a[4]=((C_word*)t0)[12],a[5]=t3,a[6]=t5,a[7]=lf[499],tmp=(C_word)a,a+=8,tmp);
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4756,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4825,a[2]=t6,a[3]=t1,a[4]=t3,a[5]=t5,a[6]=lf[504],tmp=(C_word)a,a+=7,tmp);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4841,a[2]=((C_word*)t0)[12],a[3]=t3,a[4]=t5,a[5]=lf[505],tmp=(C_word)a,a+=6,tmp);
t10=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4857,a[2]=((C_word*)t0)[12],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],a[8]=lf[506],tmp=(C_word)a,a+=9,tmp);
/* posix.scm: 1727 make-input-port */
t11=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t11))(5,t11,t7,t8,t9,t10);}

/* a4856 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4857(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4857,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4861,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posix.scm: 1737 file-close */
t3=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4859 in a4856 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
/* posix.scm: 1739 wait */
t3=((C_word*)t0)[4];
f_4640(t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4840 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4841,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t3=((C_word*)t0)[2];
t4=(C_word)C_i_foreign_fixnum_argumentp(t3);
t5=(C_word)stub857(C_SCHEME_UNDEFINED,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)C_eqp(C_fix(1),t5));}}

/* a4824 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4825(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4825,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4829,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 1729 fetch */
t3=((C_word*)t0)[2];
f_4714(t3,t2);}

/* k4827 in a4824 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4829(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_truep((C_word)C_i_greater_or_equalp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]))){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}
else{
t2=((C_word*)((C_word*)t0)[5])[1];
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[5])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[5])+1,t3);
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_subchar(((C_word*)t0)[2],t2));}}

/* k4754 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4756(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4756,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4760,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4762,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=lf[502],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4812,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=lf[503],tmp=(C_word)a,a+=9,tmp);
/* posix.scm: 1740 make-output-port */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t2,t3,t4);}

/* a4811 in k4754 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4812,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4816,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posix.scm: 1756 file-close */
t3=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4814 in a4811 in k4754 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4816(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
/* posix.scm: 1758 wait */
t3=((C_word*)t0)[4];
f_4640(t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4761 in k4754 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4762(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[14],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4762,3,t0,t1,t2);}
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(C_word)C_block_size(((C_word*)t3)[1]);
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4771,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=t6,a[5]=t3,a[6]=((C_word*)t0)[3],a[7]=lf[501],tmp=(C_word)a,a+=8,tmp));
t10=((C_word*)t8)[1];
f_4771(t10,t1);}

/* loop in a4761 in k4754 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4771(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4771,NULL,2,t0,t1);}
t2=(C_word)C_write(((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
t3=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4787,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1748 yield */
f_1214(t5);}
else{
/* posix.scm: 1750 posix-error */
t5=lf[5];
f_1197(t5,t1,lf[49],lf[500],((C_word*)t0)[2],(C_word)C_a_i_list(&a,1,((C_word*)t0)[6]));}}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,((C_word*)((C_word*)t0)[4])[1]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4803,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 1752 substring */
t5=*((C_word*)lf[307]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)((C_word*)t0)[5])[1],t2,((C_word*)((C_word*)t0)[4])[1]);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4801 in loop in a4761 in k4754 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4803(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(C_word)C_block_size(((C_word*)((C_word*)t0)[5])[1]);
t4=C_mutate(((C_word *)((C_word*)t0)[4])+1,t3);
/* posix.scm: 1754 loop */
t5=((C_word*)((C_word*)t0)[3])[1];
f_4771(t5,((C_word*)t0)[2]);}

/* k4785 in loop in a4761 in k4754 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4787(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1749 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4771(t2,((C_word*)t0)[2]);}

/* k4758 in k4754 in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4760(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1707 values */
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* fetch in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4714(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4714,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4724,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4728,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=lf[498],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_4728(t6,t2);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4728(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4728,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],C_fix(256));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4744,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1718 ##sys#thread-block-for-i/o! */
t6=*((C_word*)lf[496]+1);
((C_proc5)C_retrieve_proc(t6))(5,t6,t5,*((C_word*)lf[12]+1),((C_word*)t0)[5],C_SCHEME_TRUE);}
else{
/* posix.scm: 1721 posix-error */
t5=lf[5];
f_1197(t5,t1,lf[49],lf[490],lf[497],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[5]));}}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k4742 in loop in fetch in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4744(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4744,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4747,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1719 yield */
f_1214(t2);}

/* k4745 in k4742 in loop in fetch in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4747(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1720 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4728(t2,((C_word*)t0)[2]);}

/* k4722 in fetch in k4710 in k4697 in k4694 in k4691 in a4688 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4724(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a4682 in a4676 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4683(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4683,2,t0,t1);}
/* posix.scm: 1685 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* a4670 in body870 in process in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4671(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4671,2,t0,t1);}
/* posix.scm: 1684 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* wait in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4640(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4640,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4646,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=lf[489],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4652,a[2]=t2,a[3]=lf[492],tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t3,t4);}

/* a4651 in wait in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4652(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4652,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1681 ##sys#error */
t5=*((C_word*)lf[91]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t1,lf[490],lf[491],((C_word*)t0)[2],t4);}}

/* a4645 in wait in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4646(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4646,2,t0,t1);}
/* posix.scm: 1679 process-wait */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4590(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4590r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4590r(t0,t1,t2,t3);}}

static void f_4590r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4597,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* posix.scm: 1646 process-fork */
t7=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t7))(2,t7,t6);}

/* k4595 in process-run in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4597,2,t0,t1);}
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[6])){
/* posix.scm: 1648 process-execute */
t3=((C_word*)t0)[5];
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[6]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4612,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1650 getenv */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,lf[485]);}}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k4610 in k4595 in process-run in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4612(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4612,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[483]);
t3=(C_word)C_a_i_list(&a,2,lf[484],((C_word*)t0)[4]);
/* posix.scm: 1651 process-execute */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,((C_word*)t0)[2],t2,t3);}

/* process-signal in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4563(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4563r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4563r(t0,t1,t2,t3);}}

static void f_4563r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_i_check_exact_2(t2,lf[478]);
t7=(C_word)C_i_check_exact_2(t5,lf[478]);
t8=(C_word)C_kill(t2,t5);
t9=(C_word)C_eqp(t8,C_fix(-1));
if(C_truep(t9)){
/* posix.scm: 1638 posix-error */
t10=lf[5];
f_1197(t10,t1,lf[215],lf[478],lf[479],(C_word)C_a_i_list(&a,2,t2,t5));}
else{
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,C_SCHEME_UNDEFINED);}}

/* sleep in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4556(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4556,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub825(C_SCHEME_UNDEFINED,t3));}

/* parent-process-id in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4553(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4553,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub822(C_SCHEME_UNDEFINED));}

/* current-process-id in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4550(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4550,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub820(C_SCHEME_UNDEFINED));}

/* process-wait in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4474(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_4474r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4474r(t0,t1,t2);}}

static void f_4474r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word *a=C_alloc(3);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t2));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t6));
if(C_truep((C_word)C_i_nullp(t10))){
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_truep(t8)?C_fix((C_word)WNOHANG):C_fix(0));
t13=(C_word)C_i_check_exact_2(t11,lf[469]);
t14=(C_word)C_waitpid(t11,t12);
t15=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t16=(C_word)C_eqp(t14,C_fix(-1));
if(C_truep(t16)){
/* posix.scm: 1618 posix-error */
t17=lf[5];
f_1197(t17,t1,lf[215],lf[469],lf[470],(C_word)C_a_i_list(&a,1,t11));}
else{
t17=(C_truep(t15)?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
/* posix.scm: 1619 values */
C_values(5,0,t1,t14,t15,t17);}}
else{
/* ##sys#error */
t11=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}

/* process-execute in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4295(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr3r,(void*)f_4295r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4295r(t0,t1,t2,t3);}}

static void f_4295r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4297,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=lf[465],tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4421,a[2]=t4,a[3]=lf[466],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4426,a[2]=t5,a[3]=lf[467],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist765799 */
t7=t6;
f_4426(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist766797 */
t9=t5;
f_4421(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body763768 */
t11=t4;
f_4297(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-arglist765 in process-execute in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4426(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4426,NULL,2,t0,t1);}
/* def-envlist766797 */
t2=((C_word*)t0)[2];
f_4421(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist766 in process-execute in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4421(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4421,NULL,3,t0,t1,t2);}
/* body763768 */
t3=((C_word*)t0)[2];
f_4297(t3,t1,t2,C_SCHEME_FALSE);}

/* body763 in process-execute in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4297(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4297,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(((C_word*)t0)[5],lf[461]);
t5=(C_word)C_i_check_list_2(t2,lf[461]);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4307,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posix.scm: 1581 pathname-strip-directory */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[5]);}

/* k4305 in body763 in process-execute in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4307(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4307,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_4257(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4315,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=lf[464],tmp=(C_word)a,a+=8,tmp));
t7=((C_word*)t5)[1];
f_4315(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do772 in k4305 in body763 in process-execute in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4315(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(9);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4315,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_4257(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4328,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4358,a[2]=((C_word*)t0)[3],a[3]=lf[463],tmp=(C_word)a,a+=4,tmp);
t7=t5;
f_4328(t7,f_4358(t6,((C_word*)t0)[5],C_fix(0)));}
else{
t6=t5;
f_4328(t6,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[461]);
t6=(C_word)C_block_size(t4);
t7=f_4257(t3,t4,t6);
t8=(C_word)C_i_cdr(t2);
t9=(C_word)C_fixnum_plus(t3,C_fix(1));
t14=t1;
t15=t8;
t16=t9;
t1=t14;
t2=t15;
t3=t16;
goto loop;}}

/* do776 in do772 in k4305 in body763 in process-execute in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall f_4358(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
loop:
C_stack_check;
if(C_truep((C_word)C_i_nullp(t1))){
return(f_4276(t2,C_SCHEME_FALSE,C_fix(0)));}
else{
t3=(C_word)C_i_car(t1);
t4=(C_word)C_i_check_string_2(t3,lf[461]);
t5=(C_word)C_block_size(t3);
t6=f_4276(t2,t3,t5);
t7=(C_word)C_i_cdr(t1);
t8=(C_word)C_fixnum_plus(t2,C_fix(1));
t10=t7;
t11=t8;
t1=t10;
t2=t11;
goto loop;}}

/* k4326 in do772 in k4305 in body763 in process-execute in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4328(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4328,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4331,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4353,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1594 ##sys#expand-home-path */
t4=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k4351 in k4326 in do772 in k4305 in body763 in process-execute in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4353(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1594 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4329 in k4326 in do772 in k4305 in body763 in process-execute in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4331(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4331,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub744(C_SCHEME_UNDEFINED);
t5=(C_word)stub756(C_SCHEME_UNDEFINED);
/* posix.scm: 1601 posix-error */
t6=lf[5];
f_1197(t6,((C_word*)t0)[3],lf[215],lf[461],lf[462],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* setenv in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall f_4276(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub749(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* setarg in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall f_4257(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub737(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* process-fork in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4215(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_4215r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_4215r(t0,t1,t2);}}

static void f_4215r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t3=(C_word)stub720(C_SCHEME_UNDEFINED);
t4=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t4)){
/* posix.scm: 1566 posix-error */
t5=lf[5];
f_1197(t5,t1,lf[215],lf[454],lf[455],C_SCHEME_END_OF_LIST);}
else{
t5=(C_word)C_notvemptyp(t2);
t6=(C_truep(t5)?(C_word)C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4237,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=(C_word)C_i_vector_ref(t2,C_fix(0));
t9=t8;
((C_proc2)C_retrieve_proc(t9))(2,t9,t7);}
else{
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t3);}}}

/* k4235 in process-fork in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4237(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4237,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4241,a[2]=lf[456],tmp=(C_word)a,a+=3,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f_4241 in k4235 in process-fork in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4241(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4241,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub725(C_SCHEME_UNDEFINED,t3));}

/* glob in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4109(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr2r,(void*)f_4109r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4109r(t0,t1,t2);}}

static void f_4109r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(10);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4115,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],a[7]=lf[452],tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_4115(t6,t1,t2);}

/* conc in glob in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4115(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4115,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4130,a[2]=t3,a[3]=((C_word*)t0)[6],a[4]=lf[446],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4136,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=lf[451],tmp=(C_word)a,a+=8,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* a4135 in conc in glob in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4136(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4136,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4140,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4207,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[450]);
/* posix.scm: 1550 make-pathname */
t8=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k4205 in a4135 in conc in glob in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4207(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1550 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4138 in a4135 in conc in glob in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4140(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4140,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4147,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[449]);
/* posix.scm: 1551 directory */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t2,t3);}

/* k4145 in k4138 in a4135 in conc in glob in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4147(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4147,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4149,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=lf[448],tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_4149(t5,((C_word*)t0)[2],t1);}

/* loop in k4145 in k4138 in a4135 in conc in glob in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_4149(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4149,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_i_cdr(((C_word*)t0)[7]);
/* posix.scm: 1552 conc */
t4=((C_word*)((C_word*)t0)[6])[1];
f_4115(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4166,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_i_car(t2);
/* posix.scm: 1553 string-match */
t5=*((C_word*)lf[447]+1);
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k4164 in loop in k4145 in k4138 in a4135 in conc in glob in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4166(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4166,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4176,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(t1);
/* posix.scm: 1554 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
/* posix.scm: 1555 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4149(t3,((C_word*)t0)[6],t2);}}

/* k4174 in k4164 in loop in k4145 in k4138 in a4135 in conc in glob in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4176(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4176,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4180,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_cdr(((C_word*)t0)[3]);
/* posix.scm: 1554 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4149(t4,t2,t3);}

/* k4178 in k4174 in k4164 in loop in k4145 in k4138 in a4135 in conc in glob in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4180,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a4129 in conc in glob in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4130(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4130,2,t0,t1);}
/* posix.scm: 1549 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4097(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4097,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4101,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub683(t3),C_fix(0));}

/* k4099 in get-host-name in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4101(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4101,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4104,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_4104(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1533 posix-error */
t3=lf[5];
f_1197(t3,t2,lf[439],lf[438],lf[440],C_SCHEME_END_OF_LIST);}}

/* k4102 in k4099 in get-host-name in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4104(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-name in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4067(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4067,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4071,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1519 ##sys#check-port */
t4=*((C_word*)lf[162]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[435]);}

/* k4069 in terminal-name in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4071(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4071,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4074,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[2],C_fix(7));
t4=(C_word)C_eqp(lf[111],t3);
t5=(C_truep(t4)?(C_word)C_tty_portp(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t2;
f_4074(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1522 ##sys#error */
t6=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t2,lf[435],lf[436],((C_word*)t0)[2]);}}

/* k4072 in k4069 in terminal-name in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4074(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4074,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=(C_word)stub675(t4,t5);
/* ##sys#peek-nonnull-c-string */
t7=*((C_word*)lf[220]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t2,t6,C_fix(0));}

/* terminal-port? in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4038(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4038,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4042,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1512 ##sys#check-port */
t4=*((C_word*)lf[162]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[433]);}

/* k4040 in terminal-port? in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4042(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4042,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4045,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1513 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[337]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k4043 in k4040 in terminal-port? in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_4045(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(t1,C_fix(0));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3979(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3979r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3979r(t0,t1,t2,t3,t4);}}

static void f_3979r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3983,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 1494 ##sys#check-port */
t6=*((C_word*)lf[162]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[426]);}

/* k3981 in set-buffering-mode! in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3983(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3983,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3989,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[428]);
if(C_truep(t6)){
t7=t5;
f_3989(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[429]);
if(C_truep(t7)){
t8=t5;
f_3989(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[430]);
if(C_truep(t8)){
t9=t5;
f_3989(2,t9,C_fix((C_word)_IONBF));}
else{
/* posix.scm: 1500 ##sys#error */
t9=*((C_word*)lf[91]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[426],lf[431],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k3987 in k3981 in set-buffering-mode! in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3989(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[426]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[111],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posix.scm: 1506 ##sys#error */
t6=*((C_word*)lf[91]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[426],lf[427],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3972(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3972,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub658(C_SCHEME_UNDEFINED,t3));}

/* _exit in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3953(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2rv,(void*)f_3953r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_3953r(t0,t1,t2);}}

static void f_3953r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3957,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1482 ##sys#cleanup-before-exit */
t4=*((C_word*)lf[422]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

/* k3955 in _exit in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3957(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=t4;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub652(C_SCHEME_UNDEFINED,t5));}

/* local-timezone-abbreviation in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3941(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3941,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub647(t2),C_fix(0));}

/* utc-time->seconds in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3913(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3913,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[415]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3920,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posix.scm: 1460 ##sys#error */
t6=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[415],lf[417],t2);}
else{
t6=t4;
f_3920(2,t6,C_SCHEME_UNDEFINED);}}

/* k3918 in utc-time->seconds in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3920(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_timegm(((C_word*)t0)[3]))){
/* posix.scm: 1462 ##sys#cons-flonum */
t2=*((C_word*)lf[411]+1);
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}
else{
/* posix.scm: 1463 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[415],lf[416],((C_word*)t0)[3]);}}

/* local-time->seconds in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3885(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3885,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[410]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3892,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posix.scm: 1453 ##sys#error */
t6=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[410],lf[413],t2);}
else{
t6=t4;
f_3892(2,t6,C_SCHEME_UNDEFINED);}}

/* k3890 in local-time->seconds in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3892(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posix.scm: 1455 ##sys#cons-flonum */
t2=*((C_word*)lf[411]+1);
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}
else{
/* posix.scm: 1456 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[410],lf[412],((C_word*)t0)[3]);}}

/* time->string in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3857(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3857,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[406]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3864,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posix.scm: 1446 ##sys#error */
t6=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[406],lf[408],t2);}
else{
t6=t4;
f_3864(2,t6,C_SCHEME_UNDEFINED);}}

/* k3862 in time->string in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3864(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3864,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3867,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub632(t4,t3),C_fix(0));}

/* k3865 in k3862 in time->string in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3867(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3867,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3870,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3870(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1448 ##sys#error */
t3=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[406],lf[407],((C_word*)t0)[2]);}}

/* k3868 in k3865 in k3862 in time->string in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3870(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->string in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3840(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3840,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3844,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_integer_argumentp(t4);
t7=(C_word)stub623(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3842 in seconds->string in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3844(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3844,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3847,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3847(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1439 ##sys#error */
t3=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[403],lf[404],((C_word*)t0)[2]);}}

/* k3845 in k3842 in seconds->string in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3847(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->utc-time in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3821(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3821,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[401]);
/* posix.scm: 1433 ##sys#decode-seconds */
t4=*((C_word*)lf[399]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3812(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3812,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[398]);
/* posix.scm: 1429 ##sys#decode-seconds */
t4=*((C_word*)lf[399]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* memory-mapped-file? in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3806(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3806,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_structurep(t2,lf[385]));}

/* memory-mapped-file-pointer in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3797(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3797,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[385],lf[394]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3762(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3762r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3762r(t0,t1,t2,t3);}}

static void f_3762r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(6);
t4=(C_word)C_i_check_structure_2(t2,lf[385],lf[391]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_truep(t7)?(C_word)C_i_foreign_pointer_argumentp(t7):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t6);
t10=(C_word)stub592(C_SCHEME_UNDEFINED,t8,t9);
t11=(C_word)C_eqp(C_fix(0),t10);
if(C_truep(t11)){
t12=t1;
((C_proc2)(void*)(*((C_word*)t12+1)))(2,t12,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1416 posix-error */
t12=lf[5];
f_1197(t12,t1,lf[49],lf[391],lf[392],(C_word)C_a_i_list(&a,2,t2,t6));}}

/* map-file-to-memory in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3700(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc_2(c,7,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f_3700r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f_3700r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void f_3700r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3704,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_3704(2,t10,t2);}
else{
/* posix.scm: 1401 ##sys#null-pointer */
t10=*((C_word*)lf[389]+1);
((C_proc2)C_retrieve_proc(t10))(2,t10,t8);}}

/* k3702 in map-file-to-memory in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3704,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3710,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f_3710(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1404 ##sys#signal-hook */
t6=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[60],lf[384],lf[388],t1);}}

/* k3708 in k3702 in map-file-to-memory in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3710(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3710,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t3);
t10=(C_word)C_i_foreign_fixnum_argumentp(t4);
t11=(C_word)C_i_foreign_fixnum_argumentp(t5);
t12=(C_word)C_i_foreign_fixnum_argumentp(t6);
t13=(C_word)C_i_foreign_integer_argumentp(((C_word*)t0)[3]);
t14=(C_word)stub567(t7,t8,t9,t10,t11,t12,t13);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3716,a[2]=((C_word*)t0)[7],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3729,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t15,tmp=(C_word)a,a+=9,tmp);
/* posix.scm: 1406 ##sys#pointer->address */
t17=*((C_word*)lf[387]+1);
((C_proc3)C_retrieve_proc(t17))(3,t17,t16,t14);}

/* k3727 in k3708 in k3702 in map-file-to-memory in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3729(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3729,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posix.scm: 1407 posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[8],lf[49],lf[384],lf[386],(C_word)C_a_i_list(&a,6,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[8];
f_3716(2,t3,C_SCHEME_UNDEFINED);}}

/* k3714 in k3708 in k3702 in map-file-to-memory in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3716(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3716,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[385],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* current-environment in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3597,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3603,a[2]=t3,a[3]=lf[373],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3603(t5,t1,C_fix(0));}

/* loop in current-environment in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_3603(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3603,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3607,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub545(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3605 in loop in current-environment in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3607(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3607,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3615,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=lf[372],tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_3615(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k3605 in loop in current-environment in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_3615(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3615,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[5],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3641,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posix.scm: 1365 ##sys#substring */
t5=*((C_word*)lf[69]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t2);}
else{
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posix.scm: 1368 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k3639 in scan in k3605 in loop in current-environment in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3641(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3641,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3645,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[2]);
/* posix.scm: 1366 ##sys#substring */
t5=*((C_word*)lf[69]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t2,((C_word*)t0)[2],t3,t4);}

/* k3643 in k3639 in scan in k3605 in loop in current-environment in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3645(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3645,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3633,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posix.scm: 1367 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_3603(t5,t3,t4);}

/* k3631 in k3643 in k3639 in scan in k3605 in loop in current-environment in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3633(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3633,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3577(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3577,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[369]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3585,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1354 ##sys#make-c-string */
t5=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3583 in unsetenv in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3585(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3560(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3560,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[367]);
t5=(C_word)C_i_check_string_2(t3,lf[367]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3571,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1349 ##sys#make-c-string */
t7=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k3569 in setenv in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3571(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3571,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3575,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1349 ##sys#make-c-string */
t3=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3573 in k3569 in setenv in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3575(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3534(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3534,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[364]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3541,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3558,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1338 ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k3556 in fifo? in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3558(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1338 ##sys#file-info */
t2=*((C_word*)lf[141]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3539 in fifo? in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3541(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3541,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
/* posix.scm: 1341 posix-error */
t2=lf[5];
f_1197(t2,((C_word*)t0)[3],lf[49],lf[364],lf[365],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* create-fifo in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3491(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3491r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3491r(t0,t1,t2,t3);}}

static void f_3491r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_string_2(t2,lf[361]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3498,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t6=t5;
f_3498(t6,(C_word)C_i_vector_ref(t3,C_fix(0)));}
else{
t6=(C_word)C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_3498(t7,(C_word)C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k3496 in create-fifo in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_3498(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3498,NULL,2,t0,t1);}
t2=(C_word)C_i_check_exact_2(t1,lf[361]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3515,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3519,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1332 ##sys#expand-home-path */
t5=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,((C_word*)t0)[2]);}

/* k3517 in k3496 in create-fifo in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3519(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1332 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3513 in k3496 in create-fifo in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3515(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3515,2,t0,t1);}
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1333 posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[3],lf[49],lf[361],lf[362],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-unlock in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3463(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3463,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[346],lf[358]);
t4=(C_word)C_slot(t2,C_fix(2));
t5=(C_word)C_slot(t2,C_fix(3));
t6=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_flock_lock(t7);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(0)))){
/* posix.scm: 1318 posix-error */
t9=lf[5];
f_1197(t9,t1,lf[49],lf[358],lf[359],(C_word)C_a_i_list(&a,1,t2));}
else{
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,C_SCHEME_UNDEFINED);}}

/* file-test-lock in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3441(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3441r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3441r(t0,t1,t2,t3);}}

static void f_3441r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3445,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1309 setup */
f_3319(t4,t2,t3,lf[355]);}

/* k3443 in file-test-lock in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3445(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
/* posix.scm: 1311 err */
f_3393(((C_word*)t0)[3],lf[356],t1,lf[355]);}}

/* file-lock/blocking in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3426(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3426r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3426r(t0,t1,t2,t3);}}

static void f_3426r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3430,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1303 setup */
f_3319(t4,t2,t3,lf[352]);}

/* k3428 in file-lock/blocking in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3430(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
/* posix.scm: 1305 err */
f_3393(((C_word*)t0)[2],lf[353],t1,lf[352]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3411(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3411r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3411r(t0,t1,t2,t3);}}

static void f_3411r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3415,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1297 setup */
f_3319(t4,t2,t3,lf[349]);}

/* k3413 in file-lock in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
/* posix.scm: 1299 err */
f_3393(((C_word*)t0)[2],lf[350],t1,lf[349]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* err in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_3393(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3393,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_slot(t3,C_fix(1));
t6=(C_word)C_slot(t3,C_fix(2));
t7=(C_word)C_slot(t3,C_fix(3));
/* posix.scm: 1294 posix-error */
t8=lf[5];
f_1197(t8,t1,lf[49],t4,t2,(C_word)C_a_i_list(&a,3,t5,t6,t7));}

/* setup in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_3319(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3319,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):(C_word)C_i_car(t3));
t7=(C_word)C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t3));
t9=(C_word)C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:(C_word)C_i_car(t8));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(C_word)C_i_nullp(t8);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t8));
if(C_truep((C_word)C_i_nullp(t14))){
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3341,a[2]=t1,a[3]=t12,a[4]=t2,a[5]=t4,a[6]=t6,tmp=(C_word)a,a+=7,tmp);
/* posix.scm: 1286 ##sys#check-port */
t16=*((C_word*)lf[162]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t15,t2,t4);}
else{
/* ##sys#error */
t15=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}

/* k3339 in setup in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3341(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3341,2,t0,t1);}
t2=(C_word)C_i_check_number_2(((C_word*)t0)[6],((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3347,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f_3347(t6,t5);}
else{
t5=t3;
f_3347(t5,(C_word)C_i_check_number_2(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[5]));}}

/* k3345 in k3339 in setup in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_3347(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3347,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[346],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3280(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3280,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_number_2(t3,lf[342]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3297,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3304,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3308,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1269 ##sys#expand-home-path */
t8=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_3297(2,t6,(C_word)C_ftruncate(t2,t3));}
else{
/* posix.scm: 1271 ##sys#error */
t6=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[342],lf[344],t2);}}}

/* k3306 in file-truncate in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3308(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1269 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3302 in file-truncate in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3304(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_3297(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k3295 in file-truncate in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3297(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3297,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posix.scm: 1273 posix-error */
t2=lf[5];
f_1197(t2,((C_word*)t0)[4],lf[49],lf[342],lf[343],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* duplicate-fileno in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3253(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3253r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3253r(t0,t1,t2,t3);}}

static void f_3253r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[339]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3260,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_3260(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_i_vector_ref(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[339]);
t8=t5;
f_3260(t8,(C_word)C_dup2(t2,t6));}}

/* k3258 in duplicate-fileno in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_3260(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3260,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3263,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posix.scm: 1257 posix-error */
t3=lf[5];
f_1197(t3,t2,lf[49],lf[339],lf[340],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=t2;
f_3263(2,t3,C_SCHEME_UNDEFINED);}}

/* k3261 in k3258 in duplicate-fileno in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3263(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3208(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3208,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3212,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1239 ##sys#check-port */
t4=*((C_word*)lf[162]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[332]);}

/* k3210 in port->fileno in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3212(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3212,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(lf[333],t2);
if(C_truep(t3)){
/* posix.scm: 1240 ##sys#tcp-port->fileno */
t4=*((C_word*)lf[334]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3247,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1241 ##sys#peek-unsigned-integer */
t5=*((C_word*)lf[337]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[3],C_fix(0));}}

/* k3245 in k3210 in port->fileno in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3247,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posix.scm: 1246 posix-error */
t2=lf[5];
f_1197(t2,((C_word*)t0)[3],lf[60],lf[332],lf[335],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3230,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1244 posix-error */
t4=lf[5];
f_1197(t4,t3,lf[49],lf[332],lf[336],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=t3;
f_3230(2,t4,C_SCHEME_UNDEFINED);}}}

/* k3228 in k3245 in k3210 in port->fileno in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3230(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3194(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3194r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3194r(t0,t1,t2,t3);}}

static void f_3194r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[330]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3206,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1235 mode */
f_3128(t5,C_SCHEME_FALSE,t3);}

/* k3204 in open-output-file* in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3206,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posix.scm: 1235 check */
f_3165(((C_word*)t0)[2],lf[330],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3180(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3180r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3180r(t0,t1,t2,t3);}}

static void f_3180r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[328]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3192,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1231 mode */
f_3128(t5,C_SCHEME_TRUE,t3);}

/* k3190 in open-input-file* in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3192(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3192,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posix.scm: 1231 check */
f_3165(((C_word*)t0)[2],lf[328],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_3165(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3165,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posix.scm: 1224 posix-error */
t6=lf[5];
f_1197(t6,t1,lf[49],t2,lf[325],(C_word)C_a_i_list(&a,1,t3));}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3178,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1225 ##sys#make-port */
t7=*((C_word*)lf[150]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[151]+1),lf[326],lf[111]);}}

/* k3176 in check in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3178(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_3128(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3128,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3136,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_i_car(t3);
t6=(C_word)C_eqp(t5,lf[318]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posix.scm: 1218 ##sys#error */
t8=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[319],t5);}
else{
t8=t4;
f_3136(2,t8,lf[320]);}}
else{
/* posix.scm: 1219 ##sys#error */
t7=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[321],t5);}}
else{
t5=t4;
f_3136(2,t5,(C_truep(t2)?lf[322]:lf[323]));}}

/* k3134 in mode in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3136(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1214 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-link in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3103(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3103,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[311]);
t5=(C_word)C_i_check_string_2(t3,lf[311]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3084,a[2]=t7,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=(C_word)C_i_foreign_string_argumentp(t6);
/* ##sys#make-c-string */
t10=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_3084(2,t9,C_SCHEME_FALSE);}}

/* k3082 in file-link in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3084(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3084,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3088,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=(C_word)C_i_foreign_string_argumentp(((C_word*)t0)[2]);
/* ##sys#make-c-string */
t4=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}
else{
t3=t2;
f_3088(2,t3,C_SCHEME_FALSE);}}

/* k3086 in k3082 in file-link in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3088(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3088,2,t0,t1);}
t2=(C_word)stub426(C_SCHEME_UNDEFINED,((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1199 posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[4],lf[49],lf[312],lf[313],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* read-symbolic-link in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3053(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3053,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[308]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3061,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3077,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1188 ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k3075 in read-symbolic-link in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1188 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3059 in read-symbolic-link in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3061,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3064,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1190 posix-error */
t4=lf[5];
f_1197(t4,t3,lf[49],lf[308],lf[309],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=t3;
f_3064(2,t4,C_SCHEME_UNDEFINED);}}

/* k3062 in k3059 in read-symbolic-link in k3050 in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3064(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1191 substring */
t2=((C_word*)t0)[5];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* create-symbolic-link in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3015(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3015,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[303]);
t5=(C_word)C_i_check_string_2(t3,lf[303]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3036,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3048,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1176 ##sys#expand-home-path */
t8=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}

/* k3046 in create-symbolic-link in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3048(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1176 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3034 in create-symbolic-link in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3036(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3036,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3040,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3044,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1177 ##sys#expand-home-path */
t4=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3042 in k3034 in create-symbolic-link in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1177 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3038 in k3034 in create-symbolic-link in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3040(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3040,2,t0,t1);}
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1179 posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[4],lf[49],lf[304],lf[305],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* set-process-group-id! in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2994(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2994,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[300]);
t5=(C_word)C_i_check_exact_2(t3,lf[300]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setpgid(t2,t3),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3010,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1164 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* k3008 in set-process-group-id! in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_3010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1165 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[300],lf[301],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* process-group-id in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2976(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2976,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[297]);
t4=(C_word)C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2983,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2989,a[2]=t2,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1156 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t5;
f_2983(2,t6,C_SCHEME_UNDEFINED);}}

/* k2987 in process-group-id in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2989(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1157 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[297],lf[298],((C_word*)t0)[2]);}

/* k2981 in process-group-id in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2983(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* create-session in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2961(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2961,2,t0,t1);}
t2=(C_word)C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2965,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2971,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1148 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2965(2,t4,C_SCHEME_UNDEFINED);}}

/* k2969 in create-session in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2971(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1149 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[294],lf[295]);}

/* k2963 in create-session in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2965(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-execute-access? in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2955(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2955,3,t0,t1,t2);}
/* posix.scm: 1143 check */
f_2919(t1,t2,C_fix((C_word)X_OK),lf[292]);}

/* file-write-access? in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2949(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2949,3,t0,t1,t2);}
/* posix.scm: 1142 check */
f_2919(t1,t2,C_fix((C_word)W_OK),lf[290]);}

/* file-read-access? in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2943(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2943,3,t0,t1,t2);}
/* posix.scm: 1141 check */
f_2919(t1,t2,C_fix((C_word)R_OK),lf[288]);}

/* check in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_2919(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2919,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2937,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2941,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1138 ##sys#expand-home-path */
t8=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}

/* k2939 in check in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2941(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1138 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2935 in check in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2937(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2937,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2929,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_2929(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1139 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2927 in k2935 in check in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2929(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* set-group-id! in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2904(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2904,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setgid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2914,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1128 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2912 in set-group-id! in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2914(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1129 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[281],lf[285],((C_word*)t0)[2]);}

/* set-user-id! in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2889(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2889,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2899,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1122 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2897 in set-user-id! in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2899(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1123 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[281],lf[282],((C_word*)t0)[2]);}

/* current-effective-group-id in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2886(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2886,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub381(C_SCHEME_UNDEFINED));}

/* current-effective-user-id in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2883(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2883,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub379(C_SCHEME_UNDEFINED));}

/* current-group-id in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2880(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2880,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub377(C_SCHEME_UNDEFINED));}

/* current-user-id in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2877,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub375(C_SCHEME_UNDEFINED));}

/* change-file-owner in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2847(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_2847,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,lf[270]);
t6=(C_word)C_i_check_exact_2(t3,lf[270]);
t7=(C_word)C_i_check_exact_2(t4,lf[270]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2871,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2875,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1111 ##sys#expand-home-path */
t10=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t10))(3,t10,t9,t2);}

/* k2873 in change-file-owner in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2875(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1111 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2869 in change-file-owner in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2871(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2871,2,t0,t1);}
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1112 posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[3],lf[49],lf[270],lf[271],(C_word)C_a_i_list(&a,3,((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* change-file-mode in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2820(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2820,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[267]);
t5=(C_word)C_i_check_exact_2(t3,lf[267]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2841,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2845,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1103 ##sys#expand-home-path */
t8=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}

/* k2843 in change-file-mode in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2845(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1103 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2839 in change-file-mode in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2841,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1104 posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[3],lf[49],lf[267],lf[268],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* initialize-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2772(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2772,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[241]);
t5=(C_word)C_i_check_exact_2(t3,lf[241]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2760,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=(C_word)C_i_foreign_string_argumentp(t6);
/* ##sys#make-c-string */
t10=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_2760(2,t9,C_SCHEME_FALSE);}}

/* k2758 in initialize-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2760(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2760,2,t0,t1);}
t2=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[5]);
t3=(C_word)stub346(C_SCHEME_UNDEFINED,t1,t2);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2788,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1034 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2786 in k2758 in initialize-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2788(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1035 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[241],lf[242],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2698(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2698,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2702,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_i_length(t2);
t5=f_2628(t4);
if(C_truep(t5)){
t6=t3;
f_2702(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1017 ##sys#error */
t6=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[236],lf[239]);}}

/* k2700 in set-groups! in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2702(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2702,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2707,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=lf[238],tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_2707(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* do333 in k2700 in set-groups! in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_2707(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2707,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
if(C_truep((C_word)C_fixnum_lessp((C_word)C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2723,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1022 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_i_check_exact_2(t4,lf[236]);
t6=(C_word)C_set_gid(t3,t4);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_fixnum_plus(t3,C_fix(1));
t11=t1;
t12=t7;
t13=t8;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}

/* k2721 in do333 in k2700 in set-groups! in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2723(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1023 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[236],lf[237],((C_word*)t0)[2]);}

/* get-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2635(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2635,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2639,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2693,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1003 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2639(2,t4,C_SCHEME_UNDEFINED);}}

/* k2691 in get-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1004 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[230],lf[234]);}

/* k2637 in get-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2639(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2639,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2642,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=f_2628(((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t2;
f_2642(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1006 ##sys#error */
t4=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[230],lf[233]);}}

/* k2640 in k2637 in get-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2642(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2642,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2645,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=(C_word)stub315(C_SCHEME_UNDEFINED,t3);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2674,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1008 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t2;
f_2645(2,t5,C_SCHEME_UNDEFINED);}}

/* k2672 in k2640 in k2637 in get-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2674(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1009 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[230],lf[232]);}

/* k2643 in k2640 in k2637 in get-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2645(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2645,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2650,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=lf[231],tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_2650(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k2643 in k2640 in k2637 in get-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_2650(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2650,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2664,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posix.scm: 1013 loop */
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k2662 in loop in k2643 in k2640 in k2637 in get-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2664(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2664,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,(C_word)C_get_gid(((C_word*)t0)[2]),t1));}

/* _ensure-groups in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall f_2628(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub319(C_SCHEME_UNDEFINED,t2));}

/* group-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2567(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2567,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2571,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2571(t4,(C_word)C_getgrgid(t2));}
else{
t4=(C_word)C_i_check_string_2(t2,lf[225]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2619,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 978  ##sys#make-c-string */
t6=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}}

/* k2617 in group-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2571(t2,(C_word)C_getgrnam(t1));}

/* k2569 in group-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_2571(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2571,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2581,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[220]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2579 in k2569 in group-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2581(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2581,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2585,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[220]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k2583 in k2579 in k2569 in group-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2585(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2585,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2589,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2591,a[2]=t4,a[3]=lf[226],tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_2591(t6,t2,C_fix(0));}

/* rec in k2583 in k2579 in k2569 in group-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_2591(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2591,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2595,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub303(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k2593 in rec in k2583 in k2579 in k2569 in group-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2595(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2595,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2605,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posix.scm: 986  rec */
t4=((C_word*)((C_word*)t0)[2])[1];
f_2591(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k2603 in k2593 in rec in k2583 in k2579 in k2569 in group-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2605(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2605,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k2587 in k2583 in k2579 in k2569 in group-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2589,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,4,((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1));}

/* user-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2514(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2514,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2518,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2518(t4,(C_word)C_getpwuid(t2));}
else{
t4=(C_word)C_i_check_string_2(t2,lf[223]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2554,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 955  ##sys#make-c-string */
t6=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}}

/* k2552 in user-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2518(t2,(C_word)C_getpwnam(t1));}

/* k2516 in user-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_2518(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2518,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2528,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[220]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2526 in k2516 in user-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2528,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2532,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[220]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k2530 in k2526 in k2516 in user-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2532(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2532,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2536,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[220]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k2534 in k2530 in k2526 in k2516 in user-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2536(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2536,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2540,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k2538 in k2534 in k2530 in k2526 in k2516 in user-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2540(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2540,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2544,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k2542 in k2538 in k2534 in k2530 in k2526 in k2516 in user-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2544(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2544,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,7,((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* system-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2476,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2480,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2509,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 934  ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_2480(2,t3,C_SCHEME_UNDEFINED);}}

/* k2507 in system-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2509(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 935  ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[219],lf[221]);}

/* k2478 in system-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2480(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2480,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2487,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[220]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k2485 in k2478 in system-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2487(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2487,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2491,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[220]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k2489 in k2485 in k2478 in system-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2491(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2491,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2495,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[220]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k2493 in k2489 in k2485 in k2478 in system-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2495(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2495,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2499,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[220]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k2497 in k2493 in k2489 in k2485 in k2478 in system-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2499(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2499,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2503,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[220]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k2501 in k2497 in k2493 in k2489 in k2485 in k2478 in system-information in k2472 in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2503(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2503,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* set-signal-mask! in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2449(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2449,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,lf[214]);
t4=(C_word)C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2456,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2467,a[2]=lf[217],tmp=(C_word)a,a+=3,tmp);
/* for-each */
t7=*((C_word*)lf[78]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t2);}

/* a2466 in set-signal-mask! in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2467(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2467,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[214]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigaddset(t2));}

/* k2454 in set-signal-mask! in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2456(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask(C_fix(0)),C_fix(0)))){
/* posix.scm: 908  posix-error */
t2=lf[5];
f_1197(t2,((C_word*)t0)[2],lf[215],lf[214],lf[216],C_SCHEME_END_OF_LIST);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#interrupt-hook in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2431(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2431,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2441,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 894  h */
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posix.scm: 896  oldhook */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k2439 in ##sys#interrupt-hook in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2441(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 895  ##sys#context-switch */
t2=*((C_word*)lf[212]+1);
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k2414 in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2418(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2418,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[210]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_vector_set(((C_word*)t0)[2],t2,t3));}

/* create-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2375(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2375,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2379,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posix.scm: 820  posix-error */
t3=lf[5];
f_1197(t3,t2,lf[49],lf[181],lf[182],C_SCHEME_END_OF_LIST);}
else{
t3=t2;
f_2379(2,t3,C_SCHEME_UNDEFINED);}}

/* k2377 in create-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2379(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 821  values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2355(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2355r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2355r(t0,t1,t2,t3,t4);}}

static void f_2355r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[178]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2359,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2357 in with-output-to-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2359(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2359,2,t0,t1);}
t2=C_mutate((C_word*)lf[178]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2365,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=lf[179],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 808  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2364 in k2357 in with-output-to-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2365(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2365r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2365r(t0,t1,t2);}}

static void f_2365r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2369,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 810  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2367 in a2364 in k2357 in with-output-to-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2369(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[178]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2335(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2335r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2335r(t0,t1,t2,t3,t4);}}

static void f_2335r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[174]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2339,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2337 in with-input-from-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2339(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2339,2,t0,t1);}
t2=C_mutate((C_word*)lf[174]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2345,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=lf[175],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 798  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2344 in k2337 in with-input-from-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2345(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2345r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2345r(t0,t1,t2);}}

static void f_2345r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2349,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 800  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2347 in a2344 in k2337 in with-input-from-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2349(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[174]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2311(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2311r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2311r(t0,t1,t2,t3,t4);}}

static void f_2311r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2315,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2313 in call-with-output-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2315(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2315,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2320,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=lf[170],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2326,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=lf[171],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 788  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2325 in k2313 in call-with-output-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2326(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2326r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2326r(t0,t1,t2);}}

static void f_2326r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2330,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 791  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2328 in a2325 in k2313 in call-with-output-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2330(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2319 in k2313 in call-with-output-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2320(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2320,2,t0,t1);}
/* posix.scm: 789  proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2287(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2287r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2287r(t0,t1,t2,t3,t4);}}

static void f_2287r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2291,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2289 in call-with-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2291(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2291,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2296,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=lf[166],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2302,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=lf[167],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 780  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2301 in k2289 in call-with-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2302(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2302r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2302r(t0,t1,t2);}}

static void f_2302r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2306,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 783  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2304 in a2301 in k2289 in call-with-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2306(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2295 in k2289 in call-with-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2296(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2296,2,t0,t1);}
/* posix.scm: 781  proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2271(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2271,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2275,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 767  ##sys#check-port */
t4=*((C_word*)lf[162]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[159]);}

/* k2273 in close-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2275(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2275,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2278,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posix.scm: 769  posix-error */
t5=lf[5];
f_1197(t5,t3,lf[49],lf[160],lf[161],(C_word)C_a_i_list(&a,1,((C_word*)t0)[3]));}
else{
t5=t3;
f_2278(2,t5,C_SCHEME_UNDEFINED);}}

/* k2276 in k2273 in close-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2278(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2235(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2235r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2235r(t0,t1,t2,t3);}}

static void f_2235r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[157]);
t5=f_2166(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2249,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[145]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2256,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 762  ##sys#make-c-string */
t9=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[155]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2266,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 763  ##sys#make-c-string */
t10=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posix.scm: 764  badmode */
f_2178(t6,t5);}}}

/* k2264 in open-output-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2266(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2266,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2249(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k2254 in open-output-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2256(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2256,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2249(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k2247 in open-output-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2249(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 758  check */
f_2184(((C_word*)t0)[3],lf[157],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2199(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2199r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2199r(t0,t1,t2,t3);}}

static void f_2199r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[154]);
t5=f_2166(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2213,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[145]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2220,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 751  ##sys#make-c-string */
t9=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[155]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2230,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 752  ##sys#make-c-string */
t10=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posix.scm: 753  badmode */
f_2178(t6,t5);}}}

/* k2228 in open-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2230(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2230,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2213(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k2218 in open-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2220(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2220,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2213(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k2211 in open-input-pipe in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2213(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 747  check */
f_2184(((C_word*)t0)[3],lf[154],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_2184(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2184,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posix.scm: 739  posix-error */
t6=lf[5];
f_1197(t6,t1,lf[49],t2,lf[149],(C_word)C_a_i_list(&a,1,t3));}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2197,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 740  ##sys#make-port */
t7=*((C_word*)lf[150]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[151]+1),lf[152],lf[111]);}}

/* k2195 in check in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2197(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_2178(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2178,NULL,2,t1,t2);}
/* posix.scm: 736  ##sys#error */
t3=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[147],t2);}

/* mode in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall f_2166(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[145]));}

/* current-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2123(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2123r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2123r(t0,t1,t2);}}

static void f_2123r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2127,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_2127(2,t4,C_SCHEME_FALSE);}
else{
t4=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t3;
f_2127(2,t5,(C_word)C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[0],t2);}}}

/* k2125 in current-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2127(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2127,2,t0,t1);}
if(C_truep(t1)){
/* posix.scm: 719  change-directory */
t2=*((C_word*)lf[124]+1);
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2136,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 720  make-string */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}}

/* k2134 in k2125 in current-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2136(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_curdir(t1);
if(C_truep(t2)){
/* posix.scm: 723  ##sys#substring */
t3=*((C_word*)lf[69]+1);
((C_proc5)C_retrieve_proc(t3))(5,t3,((C_word*)t0)[2],t1,C_fix(0),t2);}
else{
/* posix.scm: 724  posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[2],lf[49],lf[137],lf[143],C_SCHEME_END_OF_LIST);}}

/* directory? in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2100(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2100,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[140]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2107,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2121,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 712  ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k2119 in directory? in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2121(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 712  ##sys#file-info */
t2=*((C_word*)lf[141]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2105 in directory? in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2107(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1943(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_1943r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1943r(t0,t1,t2);}}

static void f_1943r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(12);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1945,a[2]=((C_word*)t0)[2],a[3]=lf[135],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2043,a[2]=t3,a[3]=lf[136],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2048,a[2]=t4,a[3]=lf[138],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec165190 */
t6=t5;
f_2048(t6,t1);}
else{
t6=(C_word)C_i_car(t2);
t7=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?166188 */
t8=t4;
f_2043(t8,t1,t6);}
else{
t8=(C_word)C_i_car(t7);
t9=(C_word)C_i_cdr(t7);
if(C_truep((C_word)C_i_nullp(t9))){
/* body163168 */
t10=t3;
f_1945(t10,t1,t6,t8);}
else{
/* ##sys#error */
t10=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t1,lf[0],t9);}}}}

/* def-spec165 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_2048(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2048,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2056,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 685  current-directory */
t3=*((C_word*)lf[137]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k2054 in def-spec165 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?166188 */
t2=((C_word*)t0)[3];
f_2043(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?166 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_2043(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2043,NULL,3,t0,t1,t2);}
/* body163168 */
t3=((C_word*)t0)[2];
f_1945(t3,t1,t2,C_SCHEME_FALSE);}

/* body163 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_1945(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1945,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[131]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1952,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 687  make-string */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,C_fix(256));}

/* k1950 in body163 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1952(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1952,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1955,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 688  ##sys#make-pointer */
t3=*((C_word*)lf[134]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k1953 in k1950 in body163 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1955(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1955,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1958,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posix.scm: 689  ##sys#make-pointer */
t3=*((C_word*)lf[134]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k1956 in k1953 in k1950 in body163 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1958(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1958,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1962,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2042,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 690  ##sys#expand-home-path */
t4=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k2040 in k1956 in k1953 in k1950 in body163 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2042(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 690  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1960 in k1956 in k1953 in k1950 in body163 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1962(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1962,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
/* posix.scm: 692  posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[6],lf[49],lf[131],lf[132],(C_word)C_a_i_list(&a,1,((C_word*)t0)[5]));}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1976,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=lf[133],tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_1976(t6,((C_word*)t0)[6]);}}

/* loop in k1960 in k1956 in k1953 in k1950 in body163 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_1976(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1976,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1986,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 700  ##sys#substring */
t5=*((C_word*)lf[69]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k1984 in loop in k1960 in k1956 in k1953 in k1950 in body163 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1986(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1986,2,t0,t1);}
t2=(C_word)C_i_string_ref(t1,C_fix(0));
t3=(C_word)C_fixnum_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?(C_word)C_i_string_ref(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1998,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=(C_word)C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_1998(t8,t7);}
else{
t8=(C_word)C_eqp(t4,C_make_character(46));
t9=(C_truep(t8)?(C_word)C_eqp(((C_word*)t0)[5],C_fix(2)):C_SCHEME_FALSE);
t10=t5;
f_1998(t10,(C_truep(t9)?t9:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t7=t5;
f_1998(t7,C_SCHEME_FALSE);}}

/* k1996 in k1984 in loop in k1960 in k1956 in k1953 in k1950 in body163 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_1998(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1998,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posix.scm: 707  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_1976(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2008,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 708  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_1976(t3,t2);}}

/* k2006 in k1996 in k1984 in loop in k1960 in k1956 in k1953 in k1950 in body163 in directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_2008(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2008,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1919(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1919,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[127]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1937,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1941,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 678  ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1939 in delete-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1941(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 678  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1935 in delete-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1937(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1937,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 679  posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[3],lf[49],lf[127],lf[128],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* change-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1895(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1895,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[124]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1913,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1917,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 672  ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1915 in change-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1917(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 672  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1911 in change-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1913(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1913,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 673  posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[3],lf[49],lf[124],lf[125],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* create-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1871(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1871,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[121]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1889,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1893,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 666  ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1891 in create-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1893(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 666  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1887 in create-directory in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1889(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1889,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 667  posix-error */
t3=lf[5];
f_1197(t3,((C_word*)t0)[3],lf[49],lf[121],lf[122],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* set-file-position! in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1813(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1813r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1813r(t0,t1,t2,t3,t4);}}

static void f_1813r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[115]);
t8=(C_word)C_i_check_exact_2(t6,lf[115]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1826,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posix.scm: 652  ##sys#signal-hook */
t10=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[118],lf[115],lf[119],t3,t2);}
else{
t10=t9;
f_1826(2,t10,C_SCHEME_UNDEFINED);}}

/* k1824 in set-file-position! in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1826(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1826,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1832,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1838,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 653  port? */
t4=*((C_word*)lf[113]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k1836 in k1824 in set-file-position! in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1838(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[111]);
t4=((C_word*)t0)[4];
f_1832(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_1832(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posix.scm: 657  ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[60],lf[115],lf[117],((C_word*)t0)[5]);}}}

/* k1830 in k1824 in set-file-position! in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1832(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1832,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 658  posix-error */
t2=lf[5];
f_1197(t2,((C_word*)t0)[4],lf[49],lf[115],lf[116],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}}

/* file-position in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1776(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1776,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1780,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1792,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 637  port? */
t5=*((C_word*)lf[113]+1);
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t2);}

/* k1790 in file-position in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1792(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[111]);
t4=((C_word*)t0)[2];
f_1780(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_1780(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posix.scm: 642  ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[60],lf[109],lf[112],((C_word*)t0)[3]);}}}

/* k1778 in file-position in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1780(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1780,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1783,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posix.scm: 644  posix-error */
t3=lf[5];
f_1197(t3,t2,lf[49],lf[109],lf[110],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=t2;
f_1783(2,t3,C_SCHEME_UNDEFINED);}}

/* k1781 in k1778 in file-position in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1783(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* symbolic-link? in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1767(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1767,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[107]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1774,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 632  ##sys#stat */
f_1653(t4,t2,C_SCHEME_TRUE,lf[107]);}

/* k1772 in symbolic-link? in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1774(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* regular-file? in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1758(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1758,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[105]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1765,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 627  ##sys#stat */
f_1653(t4,t2,C_SCHEME_TRUE,lf[105]);}

/* k1763 in regular-file? in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1765(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* file-permissions in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1752(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1752,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1756,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 623  ##sys#stat */
f_1653(t3,t2,C_SCHEME_FALSE,lf[103]);}

/* k1754 in file-permissions in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1756(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1746(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1746,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1750,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 622  ##sys#stat */
f_1653(t3,t2,C_SCHEME_FALSE,lf[101]);}

/* k1748 in file-owner in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1750(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1740(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1740,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1744,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 621  ##sys#stat */
f_1653(t3,t2,C_SCHEME_FALSE,lf[99]);}

/* k1742 in file-change-time in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1744(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1744,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1734(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1734,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1738,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 620  ##sys#stat */
f_1653(t3,t2,C_SCHEME_FALSE,lf[97]);}

/* k1736 in file-access-time in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1738(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1738,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1728(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1728,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1732,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 619  ##sys#stat */
f_1653(t3,t2,C_SCHEME_FALSE,lf[95]);}

/* k1730 in file-modification-time in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1732(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1732,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1722(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1722,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1726,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 618  ##sys#stat */
f_1653(t3,t2,C_SCHEME_FALSE,lf[93]);}

/* k1724 in file-size in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1726(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1690(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_1690r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1690r(t0,t1,t2,t3);}}

static void f_1690r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1694,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1701,a[2]=t2,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t6=t5;
f_1701(2,t6,C_SCHEME_FALSE);}
else{
t6=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t6))){
t7=t5;
f_1701(2,t7,(C_word)C_i_car(t3));}
else{
/* posix.scm: 613  ##sys#error */
t7=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,lf[0],t3);}}}

/* k1699 in file-stat in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1701(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 613  ##sys#stat */
f_1653(((C_word*)t0)[3],((C_word*)t0)[2],t1,lf[90]);}

/* k1692 in file-stat in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1694(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1694,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,9,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime)));}

/* ##sys#stat in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_1653(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1653,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1657,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_1657(2,t6,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1678,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1685,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 600  ##sys#expand-home-path */
t8=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}
else{
/* posix.scm: 608  ##sys#signal-hook */
t6=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[60],lf[88],t2);}}}

/* k1683 in ##sys#stat in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1685(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 600  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1676 in ##sys#stat in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1678(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1657(2,t2,(C_truep(((C_word*)t0)[2])?(C_word)C_lstat(t1):(C_word)C_stat(t1)));}

/* k1655 in ##sys#stat in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1657(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1657,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posix.scm: 610  posix-error */
t2=lf[5];
f_1197(t2,((C_word*)t0)[4],lf[49],((C_word*)t0)[3],lf[87],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1461(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1461r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1461r(t0,t1,t2,t3,t4);}}

static void f_1461r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(16);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f_1435(C_fix(0));
t10=f_1435(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1477,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t11)){
t13=t12;
f_1477(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
/* posix.scm: 533  fd_set */
t14=t12;
f_1477(2,t14,f_1441(C_fix(0),t2));}
else{
t13=(C_word)C_i_check_list_2(t2,lf[75]);
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1634,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=lf[81],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t15=*((C_word*)lf[78]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t12,t14,t2);}}}

/* a1633 in file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1634(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1634,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[75]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posix.scm: 540  fd_set */
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_1441(C_fix(0),t2));}

/* k1475 in file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1477,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1483,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_1483(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[8]))){
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[8]);
/* posix.scm: 545  fd_set */
t5=t3;
f_1483(2,t5,f_1441(C_fix(1),((C_word*)t0)[8]));}
else{
t4=(C_word)C_i_check_list_2(((C_word*)t0)[8],lf[75]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1608,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=lf[80],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t6=*((C_word*)lf[78]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t5,((C_word*)t0)[8]);}}}

/* a1607 in k1475 in file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1608(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1608,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[75]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posix.scm: 552  fd_set */
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_1441(C_fix(1),t2));}

/* k1481 in k1475 in file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1483(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1483,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1486,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_i_check_exact_2(((C_word*)t0)[3],lf[75]);
t4=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f_1486(t5,(C_word)C_C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_1486(t4,(C_word)C_C_select(t3));}}

/* k1484 in k1481 in k1475 in file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_1486(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1486,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posix.scm: 559  posix-error */
t2=lf[5];
f_1197(t2,((C_word*)t0)[5],lf[49],lf[75],lf[76],(C_word)C_a_i_list(&a,2,((C_word*)t0)[4],((C_word*)t0)[3]));}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[4]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[3]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
/* posix.scm: 560  values */
C_values(4,0,((C_word*)t0)[5],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1525,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
/* posix.scm: 565  fd_test */
t4=t3;
f_1525(t4,f_1451(C_fix(0),((C_word*)t0)[4]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1566,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1568,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=lf[79],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t8=*((C_word*)lf[78]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[4]);}}
else{
t4=t3;
f_1525(t4,C_SCHEME_FALSE);}}}}

/* a1567 in k1484 in k1481 in k1475 in file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1568(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1568,3,t0,t1,t2);}
t3=f_1451(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1564 in k1484 in k1481 in k1475 in file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1566(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1525(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1523 in k1484 in k1481 in k1475 in file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_1525(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1525,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1529,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
/* posix.scm: 571  fd_test */
t3=t2;
f_1529(t3,f_1451(C_fix(1),((C_word*)t0)[3]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1541,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1543,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=lf[77],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t7=*((C_word*)lf[78]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[3]);}}
else{
t3=t2;
f_1529(t3,C_SCHEME_FALSE);}}

/* a1542 in k1523 in k1484 in k1481 in k1475 in file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1543(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1543,3,t0,t1,t2);}
t3=f_1451(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1539 in k1523 in k1484 in k1481 in k1475 in file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1541(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1529(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1527 in k1523 in k1484 in k1481 in k1475 in file-select in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_1529(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 562  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* fd_test in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall f_1451(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub74(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_set in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall f_1441(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub68(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_zero in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall f_1435(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub63(C_SCHEME_UNDEFINED,t2));}

/* file-mkstemp in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1403(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1403,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[68]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1410,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 511  ##sys#make-c-string */
t5=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1408 in file-mkstemp in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1410(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1410,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1413,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 513  string-length */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,t1);}

/* k1411 in k1408 in file-mkstemp in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1413(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1413,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1416,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
/* posix.scm: 515  posix-error */
t4=lf[5];
f_1197(t4,t2,lf[49],lf[68],lf[70],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=t2;
f_1416(2,t4,C_SCHEME_UNDEFINED);}}

/* k1414 in k1411 in k1408 in file-mkstemp in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1416(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1416,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1423,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posix.scm: 516  ##sys#substring */
t4=*((C_word*)lf[69]+1);
((C_proc5)C_retrieve_proc(t4))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k1421 in k1414 in k1411 in k1408 in file-mkstemp in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1423(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 516  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1364(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1364r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1364r(t0,t1,t2,t3,t4);}}

static void f_1364r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[63]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1371,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_1371(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 496  ##sys#signal-hook */
t8=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[60],lf[63],lf[65],t3);}}

/* k1369 in file-write in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1371(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1371,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[63]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1380,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posix.scm: 501  posix-error */
t8=lf[5];
f_1197(t8,t6,lf[49],lf[63],lf[64],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],t3));}
else{
t8=t6;
f_1380(2,t8,C_SCHEME_UNDEFINED);}}

/* k1378 in k1369 in file-write in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1380(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1322(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1322r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1322r(t0,t1,t2,t3,t4);}}

static void f_1322r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[58]);
t6=(C_word)C_i_check_exact_2(t3,lf[58]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1332,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_1332(2,t8,(C_word)C_i_vector_ref(t4,C_fix(0)));}
else{
/* posix.scm: 484  make-string */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k1330 in file-read in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1332(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1332,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1335,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_1335(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 486  ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[60],lf[58],lf[61],t1);}}

/* k1333 in k1330 in file-read in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1335(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1335,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1338,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posix.scm: 489  posix-error */
t5=lf[5];
f_1197(t5,t3,lf[49],lf[58],lf[59],(C_word)C_a_i_list(&a,2,((C_word*)t0)[5],((C_word*)t0)[3]));}
else{
t5=t3;
f_1338(2,t5,C_SCHEME_UNDEFINED);}}

/* k1336 in k1333 in k1330 in file-read in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1338(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1338,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1307(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1307,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[54]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
/* posix.scm: 477  posix-error */
t4=lf[5];
f_1197(t4,t1,lf[49],lf[54],lf[55],(C_word)C_a_i_list(&a,1,t2));}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* file-open in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1269(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1269r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1269r(t0,t1,t2,t3,t4);}}

static void f_1269r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[48]);
t8=(C_word)C_i_check_exact_2(t3,lf[48]);
t9=(C_word)C_i_check_exact_2(t6,lf[48]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1286,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1299,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 468  ##sys#expand-home-path */
t12=*((C_word*)lf[52]+1);
((C_proc3)C_retrieve_proc(t12))(3,t12,t11,t2);}

/* k1297 in file-open in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1299(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 468  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1284 in file-open in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1286(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1286,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1289,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posix.scm: 470  posix-error */
t5=lf[5];
f_1197(t5,t3,lf[49],lf[48],lf[50],(C_word)C_a_i_list(&a,3,((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]));}
else{
t5=t3;
f_1289(2,t5,C_SCHEME_UNDEFINED);}}

/* k1287 in k1284 in file-open in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1289(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* yield in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_1214(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1214,NULL,1,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1220,a[2]=lf[15],tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 384  ##sys#call-with-current-continuation */
C_call_cc(3,0,t1,t2);}

/* a1219 in yield in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1220(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1220,3,t0,t1,t2);}
t3=*((C_word*)lf[12]+1);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1229,a[2]=t2,a[3]=lf[13],tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_i_setslot(t3,C_fix(1),t4);
/* posix.scm: 388  ##sys#schedule */
t6=*((C_word*)lf[14]+1);
((C_proc2)C_retrieve_proc(t6))(2,t6,t1);}

/* a1228 in a1219 in yield in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1229(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1229,2,t0,t1);}
/* posix.scm: 387  return */
t2=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,C_SCHEME_UNDEFINED);}

/* posix-error in k1176 in k1173 in k1170 in k1167 in k1164 */
static void C_fcall f_1197(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1197,NULL,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1201,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posix.scm: 377  ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k1199 in posix-error in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1201(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1201,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1208,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1212,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t1);
t6=(C_word)stub9(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* k1210 in k1199 in posix-error in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1212(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 378  string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[7],t1);}

/* k1206 in k1199 in posix-error in k1176 in k1173 in k1170 in k1167 in k1164 */
static void f_1208(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[6]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* make-nonblocking in k1176 in k1173 in k1170 in k1167 in k1164 */
static C_word C_fcall f_1180(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub3(C_SCHEME_UNDEFINED,t2));}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[421] = {
{"toplevelposix.scm",(void*)C_posix_toplevel},
{"f_1166posix.scm",(void*)f_1166},
{"f_1169posix.scm",(void*)f_1169},
{"f_1172posix.scm",(void*)f_1172},
{"f_1175posix.scm",(void*)f_1175},
{"f_1178posix.scm",(void*)f_1178},
{"f_2416posix.scm",(void*)f_2416},
{"f_5230posix.scm",(void*)f_5230},
{"f_2474posix.scm",(void*)f_2474},
{"f_3052posix.scm",(void*)f_3052},
{"f_5207posix.scm",(void*)f_5207},
{"f_5199posix.scm",(void*)f_5199},
{"f_4974posix.scm",(void*)f_4974},
{"f_5125posix.scm",(void*)f_5125},
{"f_5131posix.scm",(void*)f_5131},
{"f_5120posix.scm",(void*)f_5120},
{"f_5115posix.scm",(void*)f_5115},
{"f_4976posix.scm",(void*)f_4976},
{"f_5102posix.scm",(void*)f_5102},
{"f_5110posix.scm",(void*)f_5110},
{"f_4983posix.scm",(void*)f_4983},
{"f_5090posix.scm",(void*)f_5090},
{"f_4993posix.scm",(void*)f_4993},
{"f_4995posix.scm",(void*)f_4995},
{"f_5014posix.scm",(void*)f_5014},
{"f_5076posix.scm",(void*)f_5076},
{"f_5083posix.scm",(void*)f_5083},
{"f_5070posix.scm",(void*)f_5070},
{"f_5029posix.scm",(void*)f_5029},
{"f_5060posix.scm",(void*)f_5060},
{"f_5046posix.scm",(void*)f_5046},
{"f_5058posix.scm",(void*)f_5058},
{"f_5054posix.scm",(void*)f_5054},
{"f_5041posix.scm",(void*)f_5041},
{"f_5039posix.scm",(void*)f_5039},
{"f_5094posix.scm",(void*)f_5094},
{"f_4660posix.scm",(void*)f_4660},
{"f_4926posix.scm",(void*)f_4926},
{"f_4921posix.scm",(void*)f_4921},
{"f_4662posix.scm",(void*)f_4662},
{"f_4677posix.scm",(void*)f_4677},
{"f_4689posix.scm",(void*)f_4689},
{"f_4870posix.scm",(void*)f_4870},
{"f_4874posix.scm",(void*)f_4874},
{"f_4877posix.scm",(void*)f_4877},
{"f_4917posix.scm",(void*)f_4917},
{"f_4880posix.scm",(void*)f_4880},
{"f_4908posix.scm",(void*)f_4908},
{"f_4883posix.scm",(void*)f_4883},
{"f_4892posix.scm",(void*)f_4892},
{"f_4693posix.scm",(void*)f_4693},
{"f_4696posix.scm",(void*)f_4696},
{"f_4699posix.scm",(void*)f_4699},
{"f_4712posix.scm",(void*)f_4712},
{"f_4857posix.scm",(void*)f_4857},
{"f_4861posix.scm",(void*)f_4861},
{"f_4841posix.scm",(void*)f_4841},
{"f_4825posix.scm",(void*)f_4825},
{"f_4829posix.scm",(void*)f_4829},
{"f_4756posix.scm",(void*)f_4756},
{"f_4812posix.scm",(void*)f_4812},
{"f_4816posix.scm",(void*)f_4816},
{"f_4762posix.scm",(void*)f_4762},
{"f_4771posix.scm",(void*)f_4771},
{"f_4803posix.scm",(void*)f_4803},
{"f_4787posix.scm",(void*)f_4787},
{"f_4760posix.scm",(void*)f_4760},
{"f_4714posix.scm",(void*)f_4714},
{"f_4728posix.scm",(void*)f_4728},
{"f_4744posix.scm",(void*)f_4744},
{"f_4747posix.scm",(void*)f_4747},
{"f_4724posix.scm",(void*)f_4724},
{"f_4683posix.scm",(void*)f_4683},
{"f_4671posix.scm",(void*)f_4671},
{"f_4640posix.scm",(void*)f_4640},
{"f_4652posix.scm",(void*)f_4652},
{"f_4646posix.scm",(void*)f_4646},
{"f_4590posix.scm",(void*)f_4590},
{"f_4597posix.scm",(void*)f_4597},
{"f_4612posix.scm",(void*)f_4612},
{"f_4563posix.scm",(void*)f_4563},
{"f_4556posix.scm",(void*)f_4556},
{"f_4553posix.scm",(void*)f_4553},
{"f_4550posix.scm",(void*)f_4550},
{"f_4474posix.scm",(void*)f_4474},
{"f_4295posix.scm",(void*)f_4295},
{"f_4426posix.scm",(void*)f_4426},
{"f_4421posix.scm",(void*)f_4421},
{"f_4297posix.scm",(void*)f_4297},
{"f_4307posix.scm",(void*)f_4307},
{"f_4315posix.scm",(void*)f_4315},
{"f_4358posix.scm",(void*)f_4358},
{"f_4328posix.scm",(void*)f_4328},
{"f_4353posix.scm",(void*)f_4353},
{"f_4331posix.scm",(void*)f_4331},
{"f_4276posix.scm",(void*)f_4276},
{"f_4257posix.scm",(void*)f_4257},
{"f_4215posix.scm",(void*)f_4215},
{"f_4237posix.scm",(void*)f_4237},
{"f_4241posix.scm",(void*)f_4241},
{"f_4109posix.scm",(void*)f_4109},
{"f_4115posix.scm",(void*)f_4115},
{"f_4136posix.scm",(void*)f_4136},
{"f_4207posix.scm",(void*)f_4207},
{"f_4140posix.scm",(void*)f_4140},
{"f_4147posix.scm",(void*)f_4147},
{"f_4149posix.scm",(void*)f_4149},
{"f_4166posix.scm",(void*)f_4166},
{"f_4176posix.scm",(void*)f_4176},
{"f_4180posix.scm",(void*)f_4180},
{"f_4130posix.scm",(void*)f_4130},
{"f_4097posix.scm",(void*)f_4097},
{"f_4101posix.scm",(void*)f_4101},
{"f_4104posix.scm",(void*)f_4104},
{"f_4067posix.scm",(void*)f_4067},
{"f_4071posix.scm",(void*)f_4071},
{"f_4074posix.scm",(void*)f_4074},
{"f_4038posix.scm",(void*)f_4038},
{"f_4042posix.scm",(void*)f_4042},
{"f_4045posix.scm",(void*)f_4045},
{"f_3979posix.scm",(void*)f_3979},
{"f_3983posix.scm",(void*)f_3983},
{"f_3989posix.scm",(void*)f_3989},
{"f_3972posix.scm",(void*)f_3972},
{"f_3953posix.scm",(void*)f_3953},
{"f_3957posix.scm",(void*)f_3957},
{"f_3941posix.scm",(void*)f_3941},
{"f_3913posix.scm",(void*)f_3913},
{"f_3920posix.scm",(void*)f_3920},
{"f_3885posix.scm",(void*)f_3885},
{"f_3892posix.scm",(void*)f_3892},
{"f_3857posix.scm",(void*)f_3857},
{"f_3864posix.scm",(void*)f_3864},
{"f_3867posix.scm",(void*)f_3867},
{"f_3870posix.scm",(void*)f_3870},
{"f_3840posix.scm",(void*)f_3840},
{"f_3844posix.scm",(void*)f_3844},
{"f_3847posix.scm",(void*)f_3847},
{"f_3821posix.scm",(void*)f_3821},
{"f_3812posix.scm",(void*)f_3812},
{"f_3806posix.scm",(void*)f_3806},
{"f_3797posix.scm",(void*)f_3797},
{"f_3762posix.scm",(void*)f_3762},
{"f_3700posix.scm",(void*)f_3700},
{"f_3704posix.scm",(void*)f_3704},
{"f_3710posix.scm",(void*)f_3710},
{"f_3729posix.scm",(void*)f_3729},
{"f_3716posix.scm",(void*)f_3716},
{"f_3597posix.scm",(void*)f_3597},
{"f_3603posix.scm",(void*)f_3603},
{"f_3607posix.scm",(void*)f_3607},
{"f_3615posix.scm",(void*)f_3615},
{"f_3641posix.scm",(void*)f_3641},
{"f_3645posix.scm",(void*)f_3645},
{"f_3633posix.scm",(void*)f_3633},
{"f_3577posix.scm",(void*)f_3577},
{"f_3585posix.scm",(void*)f_3585},
{"f_3560posix.scm",(void*)f_3560},
{"f_3571posix.scm",(void*)f_3571},
{"f_3575posix.scm",(void*)f_3575},
{"f_3534posix.scm",(void*)f_3534},
{"f_3558posix.scm",(void*)f_3558},
{"f_3541posix.scm",(void*)f_3541},
{"f_3491posix.scm",(void*)f_3491},
{"f_3498posix.scm",(void*)f_3498},
{"f_3519posix.scm",(void*)f_3519},
{"f_3515posix.scm",(void*)f_3515},
{"f_3463posix.scm",(void*)f_3463},
{"f_3441posix.scm",(void*)f_3441},
{"f_3445posix.scm",(void*)f_3445},
{"f_3426posix.scm",(void*)f_3426},
{"f_3430posix.scm",(void*)f_3430},
{"f_3411posix.scm",(void*)f_3411},
{"f_3415posix.scm",(void*)f_3415},
{"f_3393posix.scm",(void*)f_3393},
{"f_3319posix.scm",(void*)f_3319},
{"f_3341posix.scm",(void*)f_3341},
{"f_3347posix.scm",(void*)f_3347},
{"f_3280posix.scm",(void*)f_3280},
{"f_3308posix.scm",(void*)f_3308},
{"f_3304posix.scm",(void*)f_3304},
{"f_3297posix.scm",(void*)f_3297},
{"f_3253posix.scm",(void*)f_3253},
{"f_3260posix.scm",(void*)f_3260},
{"f_3263posix.scm",(void*)f_3263},
{"f_3208posix.scm",(void*)f_3208},
{"f_3212posix.scm",(void*)f_3212},
{"f_3247posix.scm",(void*)f_3247},
{"f_3230posix.scm",(void*)f_3230},
{"f_3194posix.scm",(void*)f_3194},
{"f_3206posix.scm",(void*)f_3206},
{"f_3180posix.scm",(void*)f_3180},
{"f_3192posix.scm",(void*)f_3192},
{"f_3165posix.scm",(void*)f_3165},
{"f_3178posix.scm",(void*)f_3178},
{"f_3128posix.scm",(void*)f_3128},
{"f_3136posix.scm",(void*)f_3136},
{"f_3103posix.scm",(void*)f_3103},
{"f_3084posix.scm",(void*)f_3084},
{"f_3088posix.scm",(void*)f_3088},
{"f_3053posix.scm",(void*)f_3053},
{"f_3077posix.scm",(void*)f_3077},
{"f_3061posix.scm",(void*)f_3061},
{"f_3064posix.scm",(void*)f_3064},
{"f_3015posix.scm",(void*)f_3015},
{"f_3048posix.scm",(void*)f_3048},
{"f_3036posix.scm",(void*)f_3036},
{"f_3044posix.scm",(void*)f_3044},
{"f_3040posix.scm",(void*)f_3040},
{"f_2994posix.scm",(void*)f_2994},
{"f_3010posix.scm",(void*)f_3010},
{"f_2976posix.scm",(void*)f_2976},
{"f_2989posix.scm",(void*)f_2989},
{"f_2983posix.scm",(void*)f_2983},
{"f_2961posix.scm",(void*)f_2961},
{"f_2971posix.scm",(void*)f_2971},
{"f_2965posix.scm",(void*)f_2965},
{"f_2955posix.scm",(void*)f_2955},
{"f_2949posix.scm",(void*)f_2949},
{"f_2943posix.scm",(void*)f_2943},
{"f_2919posix.scm",(void*)f_2919},
{"f_2941posix.scm",(void*)f_2941},
{"f_2937posix.scm",(void*)f_2937},
{"f_2929posix.scm",(void*)f_2929},
{"f_2904posix.scm",(void*)f_2904},
{"f_2914posix.scm",(void*)f_2914},
{"f_2889posix.scm",(void*)f_2889},
{"f_2899posix.scm",(void*)f_2899},
{"f_2886posix.scm",(void*)f_2886},
{"f_2883posix.scm",(void*)f_2883},
{"f_2880posix.scm",(void*)f_2880},
{"f_2877posix.scm",(void*)f_2877},
{"f_2847posix.scm",(void*)f_2847},
{"f_2875posix.scm",(void*)f_2875},
{"f_2871posix.scm",(void*)f_2871},
{"f_2820posix.scm",(void*)f_2820},
{"f_2845posix.scm",(void*)f_2845},
{"f_2841posix.scm",(void*)f_2841},
{"f_2772posix.scm",(void*)f_2772},
{"f_2760posix.scm",(void*)f_2760},
{"f_2788posix.scm",(void*)f_2788},
{"f_2698posix.scm",(void*)f_2698},
{"f_2702posix.scm",(void*)f_2702},
{"f_2707posix.scm",(void*)f_2707},
{"f_2723posix.scm",(void*)f_2723},
{"f_2635posix.scm",(void*)f_2635},
{"f_2693posix.scm",(void*)f_2693},
{"f_2639posix.scm",(void*)f_2639},
{"f_2642posix.scm",(void*)f_2642},
{"f_2674posix.scm",(void*)f_2674},
{"f_2645posix.scm",(void*)f_2645},
{"f_2650posix.scm",(void*)f_2650},
{"f_2664posix.scm",(void*)f_2664},
{"f_2628posix.scm",(void*)f_2628},
{"f_2567posix.scm",(void*)f_2567},
{"f_2619posix.scm",(void*)f_2619},
{"f_2571posix.scm",(void*)f_2571},
{"f_2581posix.scm",(void*)f_2581},
{"f_2585posix.scm",(void*)f_2585},
{"f_2591posix.scm",(void*)f_2591},
{"f_2595posix.scm",(void*)f_2595},
{"f_2605posix.scm",(void*)f_2605},
{"f_2589posix.scm",(void*)f_2589},
{"f_2514posix.scm",(void*)f_2514},
{"f_2554posix.scm",(void*)f_2554},
{"f_2518posix.scm",(void*)f_2518},
{"f_2528posix.scm",(void*)f_2528},
{"f_2532posix.scm",(void*)f_2532},
{"f_2536posix.scm",(void*)f_2536},
{"f_2540posix.scm",(void*)f_2540},
{"f_2544posix.scm",(void*)f_2544},
{"f_2476posix.scm",(void*)f_2476},
{"f_2509posix.scm",(void*)f_2509},
{"f_2480posix.scm",(void*)f_2480},
{"f_2487posix.scm",(void*)f_2487},
{"f_2491posix.scm",(void*)f_2491},
{"f_2495posix.scm",(void*)f_2495},
{"f_2499posix.scm",(void*)f_2499},
{"f_2503posix.scm",(void*)f_2503},
{"f_2449posix.scm",(void*)f_2449},
{"f_2467posix.scm",(void*)f_2467},
{"f_2456posix.scm",(void*)f_2456},
{"f_2431posix.scm",(void*)f_2431},
{"f_2441posix.scm",(void*)f_2441},
{"f_2418posix.scm",(void*)f_2418},
{"f_2375posix.scm",(void*)f_2375},
{"f_2379posix.scm",(void*)f_2379},
{"f_2355posix.scm",(void*)f_2355},
{"f_2359posix.scm",(void*)f_2359},
{"f_2365posix.scm",(void*)f_2365},
{"f_2369posix.scm",(void*)f_2369},
{"f_2335posix.scm",(void*)f_2335},
{"f_2339posix.scm",(void*)f_2339},
{"f_2345posix.scm",(void*)f_2345},
{"f_2349posix.scm",(void*)f_2349},
{"f_2311posix.scm",(void*)f_2311},
{"f_2315posix.scm",(void*)f_2315},
{"f_2326posix.scm",(void*)f_2326},
{"f_2330posix.scm",(void*)f_2330},
{"f_2320posix.scm",(void*)f_2320},
{"f_2287posix.scm",(void*)f_2287},
{"f_2291posix.scm",(void*)f_2291},
{"f_2302posix.scm",(void*)f_2302},
{"f_2306posix.scm",(void*)f_2306},
{"f_2296posix.scm",(void*)f_2296},
{"f_2271posix.scm",(void*)f_2271},
{"f_2275posix.scm",(void*)f_2275},
{"f_2278posix.scm",(void*)f_2278},
{"f_2235posix.scm",(void*)f_2235},
{"f_2266posix.scm",(void*)f_2266},
{"f_2256posix.scm",(void*)f_2256},
{"f_2249posix.scm",(void*)f_2249},
{"f_2199posix.scm",(void*)f_2199},
{"f_2230posix.scm",(void*)f_2230},
{"f_2220posix.scm",(void*)f_2220},
{"f_2213posix.scm",(void*)f_2213},
{"f_2184posix.scm",(void*)f_2184},
{"f_2197posix.scm",(void*)f_2197},
{"f_2178posix.scm",(void*)f_2178},
{"f_2166posix.scm",(void*)f_2166},
{"f_2123posix.scm",(void*)f_2123},
{"f_2127posix.scm",(void*)f_2127},
{"f_2136posix.scm",(void*)f_2136},
{"f_2100posix.scm",(void*)f_2100},
{"f_2121posix.scm",(void*)f_2121},
{"f_2107posix.scm",(void*)f_2107},
{"f_1943posix.scm",(void*)f_1943},
{"f_2048posix.scm",(void*)f_2048},
{"f_2056posix.scm",(void*)f_2056},
{"f_2043posix.scm",(void*)f_2043},
{"f_1945posix.scm",(void*)f_1945},
{"f_1952posix.scm",(void*)f_1952},
{"f_1955posix.scm",(void*)f_1955},
{"f_1958posix.scm",(void*)f_1958},
{"f_2042posix.scm",(void*)f_2042},
{"f_1962posix.scm",(void*)f_1962},
{"f_1976posix.scm",(void*)f_1976},
{"f_1986posix.scm",(void*)f_1986},
{"f_1998posix.scm",(void*)f_1998},
{"f_2008posix.scm",(void*)f_2008},
{"f_1919posix.scm",(void*)f_1919},
{"f_1941posix.scm",(void*)f_1941},
{"f_1937posix.scm",(void*)f_1937},
{"f_1895posix.scm",(void*)f_1895},
{"f_1917posix.scm",(void*)f_1917},
{"f_1913posix.scm",(void*)f_1913},
{"f_1871posix.scm",(void*)f_1871},
{"f_1893posix.scm",(void*)f_1893},
{"f_1889posix.scm",(void*)f_1889},
{"f_1813posix.scm",(void*)f_1813},
{"f_1826posix.scm",(void*)f_1826},
{"f_1838posix.scm",(void*)f_1838},
{"f_1832posix.scm",(void*)f_1832},
{"f_1776posix.scm",(void*)f_1776},
{"f_1792posix.scm",(void*)f_1792},
{"f_1780posix.scm",(void*)f_1780},
{"f_1783posix.scm",(void*)f_1783},
{"f_1767posix.scm",(void*)f_1767},
{"f_1774posix.scm",(void*)f_1774},
{"f_1758posix.scm",(void*)f_1758},
{"f_1765posix.scm",(void*)f_1765},
{"f_1752posix.scm",(void*)f_1752},
{"f_1756posix.scm",(void*)f_1756},
{"f_1746posix.scm",(void*)f_1746},
{"f_1750posix.scm",(void*)f_1750},
{"f_1740posix.scm",(void*)f_1740},
{"f_1744posix.scm",(void*)f_1744},
{"f_1734posix.scm",(void*)f_1734},
{"f_1738posix.scm",(void*)f_1738},
{"f_1728posix.scm",(void*)f_1728},
{"f_1732posix.scm",(void*)f_1732},
{"f_1722posix.scm",(void*)f_1722},
{"f_1726posix.scm",(void*)f_1726},
{"f_1690posix.scm",(void*)f_1690},
{"f_1701posix.scm",(void*)f_1701},
{"f_1694posix.scm",(void*)f_1694},
{"f_1653posix.scm",(void*)f_1653},
{"f_1685posix.scm",(void*)f_1685},
{"f_1678posix.scm",(void*)f_1678},
{"f_1657posix.scm",(void*)f_1657},
{"f_1461posix.scm",(void*)f_1461},
{"f_1634posix.scm",(void*)f_1634},
{"f_1477posix.scm",(void*)f_1477},
{"f_1608posix.scm",(void*)f_1608},
{"f_1483posix.scm",(void*)f_1483},
{"f_1486posix.scm",(void*)f_1486},
{"f_1568posix.scm",(void*)f_1568},
{"f_1566posix.scm",(void*)f_1566},
{"f_1525posix.scm",(void*)f_1525},
{"f_1543posix.scm",(void*)f_1543},
{"f_1541posix.scm",(void*)f_1541},
{"f_1529posix.scm",(void*)f_1529},
{"f_1451posix.scm",(void*)f_1451},
{"f_1441posix.scm",(void*)f_1441},
{"f_1435posix.scm",(void*)f_1435},
{"f_1403posix.scm",(void*)f_1403},
{"f_1410posix.scm",(void*)f_1410},
{"f_1413posix.scm",(void*)f_1413},
{"f_1416posix.scm",(void*)f_1416},
{"f_1423posix.scm",(void*)f_1423},
{"f_1364posix.scm",(void*)f_1364},
{"f_1371posix.scm",(void*)f_1371},
{"f_1380posix.scm",(void*)f_1380},
{"f_1322posix.scm",(void*)f_1322},
{"f_1332posix.scm",(void*)f_1332},
{"f_1335posix.scm",(void*)f_1335},
{"f_1338posix.scm",(void*)f_1338},
{"f_1307posix.scm",(void*)f_1307},
{"f_1269posix.scm",(void*)f_1269},
{"f_1299posix.scm",(void*)f_1299},
{"f_1286posix.scm",(void*)f_1286},
{"f_1289posix.scm",(void*)f_1289},
{"f_1214posix.scm",(void*)f_1214},
{"f_1220posix.scm",(void*)f_1220},
{"f_1229posix.scm",(void*)f_1229},
{"f_1197posix.scm",(void*)f_1197},
{"f_1201posix.scm",(void*)f_1201},
{"f_1212posix.scm",(void*)f_1212},
{"f_1208posix.scm",(void*)f_1208},
{"f_1180posix.scm",(void*)f_1180},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
