/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "absimg.h"

#ifdef HAVE_IMLIB2

void absimg_init()
{
}

absimg_image_t *absimg_load(filename)
char *filename;
{
	Imlib_Image *image;
	absimg_image_t *rv;

	image = imlib_load_image_immediately_without_cache(filename);

	if (!image) return NULL;

	rv = g_malloc(sizeof(absimg_image_t));
	rv->image = image;
	imlib_context_set_image(image);
	rv->rgb_height = imlib_image_get_height();
	rv->rgb_width = imlib_image_get_width();
	rv->filename = g_strdup(filename);

	return rv;
}

void absimg_flip_vertical(image)
absimg_image_t *image;
{
	imlib_context_set_image(image->image);
	imlib_image_flip_vertical();
}

void absimg_flip_horizontal(image)
absimg_image_t *image;
{
	imlib_context_set_image(image->image);
	imlib_image_flip_horizontal();
}

GdkPixmap *absimg_render(image, width, height)
absimg_image_t *image;
{
	Imlib_Image temp = NULL;
	GdkVisual *visual;
	GdkColormap *cmap;
	Pixmap pmap;
	int w,h;

	imlib_context_set_image(image->image);

        width = MAX(1, width);
        height = MAX(1, height);

	if (image->rgb_width != width || image->rgb_height != height)
	{
		temp = imlib_create_cropped_scaled_image(0, 0, image->rgb_width, image->rgb_height, width, height);
		imlib_context_set_image(temp);
	}
	else
	{
		imlib_context_set_image(image->image);
	}

	imlib_context_set_display(GDK_DISPLAY());

	visual = gdk_visual_get_best();
	imlib_context_set_visual(GDK_VISUAL_XVISUAL(visual));

	cmap = gdk_colormap_get_system();
	imlib_context_set_colormap(GDK_COLORMAP_XCOLORMAP(cmap));

	h = imlib_image_get_height();
	w = imlib_image_get_width();

	pmap = XCreatePixmap(GDK_DISPLAY(),
		GDK_WINDOW_XWINDOW(GDK_ROOT_PARENT()), w, h,
		gdk_visual_get_best_depth());

	imlib_context_set_drawable(pmap);

	imlib_context_set_anti_alias(1);
	imlib_context_set_dither(1);
	imlib_context_set_blend(1);
	imlib_context_set_color_modifier(NULL);
	imlib_context_set_operation(IMLIB_OP_COPY);

	imlib_render_image_on_drawable(0,0);

	if (temp)
		imlib_free_image();

	return gdk_pixmap_foreign_new(pmap);
}

void absimg_destroy(image)
absimg_image_t *image;
{
	imlib_context_set_image(image->image);
	imlib_free_image();
	g_free(image->filename);
	g_free(image);
}

void absimg_destroy_pixmap(pixmap)
GdkPixmap *pixmap;
{
	gdk_pixmap_unref(pixmap);
}

int absimg_have_alpha(image)
absimg_image_t *image;
{
	imlib_context_set_image(image->image);
	return imlib_image_has_alpha();
}

void absimg_render_alpha_to_pixmap(pixmap, image, width, height)
GdkPixmap *pixmap;
absimg_image_t *image;
gint width;
gint height;
{
	Imlib_Image temp = NULL;
	GdkVisual *visual;
	GdkColormap *cmap;
	int w,h,x,y;

        width = MAX(1, width);
        height = MAX(1, height);

	if (image->rgb_width != width || image->rgb_height != height)
	{
		temp = imlib_create_cropped_scaled_image(0, 0, image->rgb_width, image->rgb_height, width, height);
		imlib_context_set_image(temp);
	}
	else
	{
		imlib_context_set_image(image->image);
	}

	imlib_context_set_display(GDK_DISPLAY());

	visual = gdk_visual_get_best();
	imlib_context_set_visual(GDK_VISUAL_XVISUAL(visual));

	cmap = gdk_colormap_get_system();
	imlib_context_set_colormap(GDK_COLORMAP_XCOLORMAP(cmap));

	imlib_context_set_drawable(GDK_WINDOW_XWINDOW(pixmap));

	imlib_context_set_anti_alias(1);
	imlib_context_set_dither(1);
	imlib_context_set_blend(1);
	imlib_context_set_color_modifier(NULL);
	imlib_context_set_operation(IMLIB_OP_COPY);

        gdk_window_get_size(pixmap, &w, &h);

        x = (w - width)/2;
        y = (h - height)/2;

	imlib_render_image_on_drawable(x, y);

	if (temp)
		imlib_free_image();
}

#ifndef WORDS_BIGENDIAN
#define A_VAL(p) ((DATA8 *)(p))[3]
#define R_VAL(p) ((DATA8 *)(p))[2]
#define G_VAL(p) ((DATA8 *)(p))[1]
#define B_VAL(p) ((DATA8 *)(p))[0]
#else
#define A_VAL(p) ((DATA8 *)(p))[0]
#define R_VAL(p) ((DATA8 *)(p))[1]
#define G_VAL(p) ((DATA8 *)(p))[2]
#define B_VAL(p) ((DATA8 *)(p))[3]
#endif

void absimg_render_to_rgb(rgb, image, width, height, xpos, ypos)
absimg_rgb_t *rgb;
absimg_image_t *image;
gint width;
gint height;
gfloat xpos;
gfloat ypos;
{
	DATA32 *pb;
	Imlib_Image temp = NULL;
        int px,py;
        int rx,ry,ix,iy;
	gboolean have_alpha;

	width = MAX(1, width);
        height = MAX(1, height);

	imlib_context_set_image(image->image);

	if (image->rgb_width != width || image->rgb_height != height)
	{
		temp = imlib_create_cropped_scaled_image(0, 0, image->rgb_width, image->rgb_height, width, height);
		imlib_context_set_image(temp);
	}

	pb = imlib_image_get_data();
	have_alpha = imlib_image_has_alpha();

	px = (int) ((gfloat)(rgb->width - width) * xpos);
	py = (int) ((gfloat)(rgb->height - height) * ypos);


        for (iy = MAX(0, -py), ry = MAX(0, py);
             iy < height && ry < rgb->height;
             iy++, ry++)
        {
                for (ix = MAX(0, -px), rx = MAX(0, px);
                     ix < width && rx < rgb->width;
                     ix++, rx++)
                {
                        int ri = ry * 3 * rgb->width + 3 * rx;
                        int ii = iy * width + ix;

			if (have_alpha)
			{
				ABSIMG_ALPHA(R_VAL(pb+ii), rgb->rgb[ri], A_VAL(pb+ii));
				ABSIMG_ALPHA(G_VAL(pb+ii), rgb->rgb[ri+1], A_VAL(pb+ii));
				ABSIMG_ALPHA(B_VAL(pb+ii), rgb->rgb[ri+2], A_VAL(pb+ii));
			}
			else
			{
				rgb->rgb[ri] = R_VAL(pb+ii);
				rgb->rgb[ri+1] = G_VAL(pb+ii);
				rgb->rgb[ri+2] = B_VAL(pb+ii);
			}
 		}
	}
}

absimg_image_t *absimg_scale(img, width, height)
absimg_image_t *img;
int width;
int height;
{
	Imlib_Image *image;
	absimg_image_t *rv;

	imlib_context_set_image(img->image);
	image = imlib_create_cropped_scaled_image(0, 0, img->rgb_width,
		img->rgb_height, width, height);
	imlib_context_set_image(image);

	if (!image) return NULL;

	rv = g_malloc(sizeof(absimg_image_t));
	rv->image = image;
	imlib_context_set_image(image);
	rv->rgb_height = imlib_image_get_height();
	rv->rgb_width = imlib_image_get_width();
	rv->filename = g_strdup(img->filename);

	return rv;
}

absimg_image_t *absimg_from_pixmap(pixmap)
GdkPixmap *pixmap;
{
	Imlib_Image *image;
	absimg_image_t *rv;
	guint w,h;

	gdk_window_get_size(pixmap, &w, &h);

	imlib_context_set_drawable(GDK_WINDOW_XWINDOW(pixmap));

	image = imlib_create_image_from_drawable(None, 0, 0, w, h, FALSE);

	if (!image) return NULL;

	imlib_context_set_image(image);
	rv = g_malloc(sizeof(absimg_image_t));

	rv->image = image;
	rv->rgb_height = imlib_image_get_height();
	rv->rgb_width = imlib_image_get_width();
	rv->filename = g_strdup("pixmap");

	return rv;
}

absimg_rgb_t *absimg_to_rgba(img)
absimg_image_t *img;
{
	DATA32 *pb;
        int x,y;
	gboolean have_alpha;
	absimg_rgb_t *rgb;

	imlib_context_set_image(img->image);

	pb = imlib_image_get_data();
	have_alpha = imlib_image_has_alpha();

	rgb = absimg_rgb_new(img->rgb_width, img->rgb_height);

	if (have_alpha)
		rgb->alpha = g_malloc(img->rgb_width * img->rgb_height);

	for (y = 0; y < img->rgb_height; y++)
	{
		for (x = 0; x < img->rgb_width; x++)
                {
                        int ri = y * 3 * rgb->width + 3 * x;
                        int ii = y * img->rgb_width + x;

			rgb->rgb[ri] = R_VAL(pb+ii);
			rgb->rgb[ri+1] = G_VAL(pb+ii);
			rgb->rgb[ri+2] = B_VAL(pb+ii);

			if (have_alpha)
				rgb->alpha[y * rgb->width + x] = A_VAL(pb+ii);
 		}
	}

	return rgb;
}

#endif

