/*
 * Copyright (c) 1996-1998
 *	John-Mark Gurney.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by John-Mark Gurney
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY John-Mark Gurney AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <sys/types.h>
#include <sys/mman.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <cgi.h>

int
fcopyfile(FILE *out, const char *file)
{
	int fd, len, pos, opos;
	caddr_t map;
	char *i;
	char *buf;
	const char *tmp;

	fd = open(file, O_RDONLY, 0644);

	if (fd == -1) {
		perror(file);
		return -1;
	}

	len = lseek(fd, 0, SEEK_END);
	pos = lseek(fd, 0, SEEK_SET);

	map = mmap(0, len, PROT_READ, MAP_FILE, fd, 0);
	madvise(map, len, MADV_SEQUENTIAL);

	while (pos < len) {
		opos = pos;
		pos += (((char *)((i = memchr(map + pos, '$', len - pos - 1)) ?
		    i : map + len)) - ((char *)map + pos));
		fwrite(map + opos, sizeof(char), pos - opos, out);
		if ((pos + 1 < len) && map[pos + 1] == '{') {
			int i;
			buf = (char *)malloc((i = ((char *)memchr(map + pos + 2,
			    '}', len - pos - 2) - (char *)(map + pos + 2))) +
			    1);
			strncpy(buf, map + pos + 2, i);
			buf[i] = 0;
			pos += i + 3;
			if ((tmp = cgigetvalue(buf)))
				fprintf(out, "%s", tmp);
			free(buf);
		} else if ((pos + 2 < len) && map[pos + 1] == '\\' &&
		    map[pos + 2] == '{') {
			pos += 3;
			fputs("${", out);
		} else if (pos != len) {
			pos++;
			fputs("$", out);
		}
	}

	munmap(map, len);
	close(fd);
	return len;
}
