---------------------------------------------------------------------
-- CGI Launcher script.
-- This script is used to comunicate between the servlet and
-- CGILua
-- Author: Thiago Ponte
---------------------------------------------------------------------

---------------------------------------------------------------------
-- Loading required libraries
---------------------------------------------------------------------

if string.find (_VERSION, "Lua 5.0") and not package then
	if not LUA_PATH then
		local cgilua_luadir = cgilua_root
		LUA_PATH = cgilua_luadir.."/?.lua;"..cgilua_luadir.."/?/?.lua"
	end
	require"compat-5.1"
	local cgilua_libdir = cgilua_root
	package.cpath = cgilua_libdir.."/?LIB_EXT;"..cgilua_libdir.."/lib?LIB_EXT"
end
require"venv"
require"lfs"


----------------------------------------------------------------------------
-- Creates the implementation of the HTTP_Request and HTTP_Response tables
----------------------------------------------------------------------------
local function getRequest(request)

    return {
        getpostdata = function (n)
            return request:getPostData(n)
        end,
        
        servervariable = function (name)
            return request:serverVariable(name)
        end
    }
end

local function getResponse(response)

    return {
        write = function(text)
            return response:getWriter():write(tostring(text))
        end,

        header = function(h, v)
            response:addHeader(h,v)
        end,

        errorlog = function(msg)
            logger:error(msg)
        end,

        contenttype = function(contentType)
            response:setContentType(contentType)
        end,

        redirect = function(url)
            response:sendRedirect(url)
        end
    }
end


----------------------------------------------------------------------------
-- Main function to launch cgilua
----------------------------------------------------------------------------

function launch(request, response)

    SAPI = {
	Response = getResponse(response),
	Request = getRequest(request),
    }
    
    local f = venv (function () require"cgilua" cgilua.main() end)
    
    f()
end