---------------------------------------------------------------------
-- Main Lua script.
-- This script should be run by the executable.
-- $Id: t_cgi.lua,v 1.12 2004/11/03 15:29:46 tuler Exp $
---------------------------------------------------------------------

---------------------------------------------------------------------
-- Setting the Basic API.
local function set_api ()
	SAPI = {
		Response = {},
		Request = {},
	}
	-- Headers
	SAPI.Response.contenttype = function (s)
		io.stdout:write ("Content-type: "..s.."\n\n")
	end
	SAPI.Response.redirect = function (s)
		io.stdout:write ("Location: "..s.."\n\n")
	end
	SAPI.Response.header = function (h, v)
		io.stdout:write (string.format ("%s: %s\n", h, v))
	end
	-- Contents
	SAPI.Response.write = function (s) io.stdout:write (s) end
	SAPI.Response.errorlog = function (s) io.stderr:write (s) end
	-- Input POST data
	SAPI.Request.getpostdata = function (n) return io.stdin:read (n) end
	-- Input general information
	SAPI.Request.servervariable = function (n) return os.getenv(n) end
end

---------------------------------------------------------------------
-- Trying to load and execute the "mainscript".

set_api()

-- compatibility code for Lua version 5.0 providing 5.1 behavior
if string.find (_VERSION, "Lua 5.0") and not package then
	if not LUA_PATH then
		local cgilua_luadir = [[LUA_DIR]]
		LUA_PATH = cgilua_luadir.."/?.lua;"..cgilua_luadir.."/?/?.lua"
	end
	require"compat-5.1"
	local cgilua_libdir = [[LUA_LIBDIR]]
	package.cpath = cgilua_libdir.."/?LIB_EXT;"..cgilua_libdir.."/lib?LIB_EXT"
end
require"lfs"
require"cgilua"
cgilua.main()
