----------------------------------------------------------------------------
-- Main Lua script.
-- It executes the requested Lua script.
--
-- $Id: t_mod2.lua,v 1.23 2004/12/06 09:18:22 tomas Exp $
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- Setting the Basic API.
local function set_api()
	SAPI = {
		Response = {},
		Request = {},
	}
	-- Headers
	SAPI.Response.contenttype = ap.set_content_type
	SAPI.Response.redirect = function (url)
		ap.set_headers_out ("Location", url)
		return ap.HTTP_MOVED_TEMPORARILY
	end
	SAPI.Response.header = ap.add_err_headers_out
	-- Contents
	SAPI.Response.write = ap.rwrite
	SAPI.Response.errorlog = ap.log_error
	-- Input POST data
	local first_get_post = true
	SAPI.Request.getpostdata = function (n)
		if first_get_post then
			assert (ap.setup_client_block"REQUEST_CHUNKED_ERROR" == ap.OK)
			first_get_post = false
			if ap.should_client_block () ~= 0 then
				return ap.get_client_block (n)
			end
		else
			return ap.get_client_block (n)
		end
	end
	-- Input general information
	local ap_func = {
		AUTH_TYPE = ap.auth_type,
		CONTENT_LENGTH = function ()
			return ap.get_header"Content-length"
		end,
		CONTENT_TYPE = function ()
			return ap.get_header"Content-type"
		end,
		GATEWAY_INTERFACE = function () return "CGI/1.1" end,
		HTTP_COOKIE = function () return ap.get_header"Cookie" end,
		PATH_INFO = ap.path_info,  -- !!!!!!!!!!!!!!!! see server/util_script.c
		PATH_TRANSLATED = ap.filename,  -- !!!!!!!!!!!!!!!! see server/util_script.c
		QUERY_STRING = ap.args,
		REMOTE_ADDR = function ()
			return ap.conn_remote_addr ()
		end,
		REMOTE_HOST = ap.get_remote_host,
		REMOTE_PORT = ap.port,
		REMOTE_USER = ap.user,
		REQUEST_METHOD = ap.method,
		SCRIPT_NAME = ap.uri,  -- !!!!!!!!!!!!!!!! see server/util_script.c
		SERVER_NAME = ap.get_server_name,
		SERVER_PORT = ap.get_server_port,
		SERVER_PROTOCOL = ap.protocol,
		SERVER_SOFTWARE = ap.get_server_version,
	}
	SAPI.Request.servervariable = function (n)
		local f = ap_func[n]
		return f and f()
	end
end

----------------------------------------------------------------------------
-- Main
-- compatibility code for Lua version 5.0 providing 5.1 behavior
if string.find (_VERSION, "Lua 5.0") and not package then
	if not LUA_PATH then
		local cgilua_luadir = [[LUA_DIR]]
		LUA_PATH = cgilua_luadir.."/?.lua;"..cgilua_luadir.."/?/?.lua"
	end
	require"compat-5.1"
	local cgilua_libdir = [[LUA_LIBDIR]]
	package.cpath = cgilua_libdir.."/?LIB_EXT;"..cgilua_libdir.."/lib?LIB_EXT"
end
require"venv"
require"lfs"
require"stable"

set_api()
local f = venv (function () require"cgilua" return cgilua.main() end)
return f() or ap.OK
