---------------------------------------------------------------------
-- Main Lua script.
-- This script should be run by the FastCGI module.
-- It waits for a request and executes CGILua's main script (main.lua).
--
-- $Id: t_fastcgi.lua,v 1.22 2004/12/06 09:18:22 tomas Exp $
---------------------------------------------------------------------

---------------------------------------------------------------------
-- Redefining os.getenv
local old_osgetenv = os.getenv
os.getenv = function(param)
    return lfcgi.getenv(param) or old_osgetenv(param)
end

---------------------------------------------------------------------
-- Setting the Basic API.
local function set_api ()
	SAPI = {
		Response = {},
		Request = {},
	}
	-- Headers
	SAPI.Response.contenttype = function (s)
		lfcgi.stdout:write ("Content-type: "..s.."\n\n")
	end
	SAPI.Response.redirect = function (url)
		lfcgi.stdout:write ("Location: "..s.."\n\n")
	end
	SAPI.Response.header = function (h, v)
		lfcgi.stdout:write (string.format ("%s: %s\n", h, v))
	end
	-- Contents
	SAPI.Response.write = function (s) lfcgi.stdout:write (s) end
	SAPI.Response.errorlog = function (s) lfcgi.stderr:write (s) end
	-- Input POST data
	SAPI.Request.getpostdata = function (n) return lfcgi.stdin:read (n) end
	-- Input general information
	SAPI.Request.servervariable = function (n) return os.getenv(n) end
end

---------------------------------------------------------------------
-- Main loop

io.stdout:close()
io.stdout = lfcgi.stdout
io.stderr:close()
io.stderr = lfcgi.stderr
io.stdin:close()
io.stdin = lfcgi.stdin
set_api()

-- compatibility code for Lua version 5.0 providing 5.1 behavior
if string.find (_VERSION, "Lua 5.0") and not package then
	if not LUA_PATH then
		local cgilua_luadir = [[LUA_DIR]]
		LUA_PATH = cgilua_luadir.."/?.lua;"..cgilua_luadir.."/?/?.lua"
	end
	require"compat-5.1"
	local cgilua_libdir = [[LUA_LIBDIR]]
	package.cpath = cgilua_libdir.."/?LIB_EXT;"..cgilua_libdir.."/lib?LIB_EXT"
end
require"venv"
require"lfs"
require"stable"

while lfcgi.accept() >= 0 do
	local f = venv (function () require"cgilua" cgilua.main() end)
	f()
end
