/*
 * SNAC - Location services
 * Copyright (C) 2001 Barnaby Gray <barnaby@beedesign.co.uk>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SNAC_LOC_H
#define SNAC_LOC_H

#include "SNAC-base.h"

namespace ICQ2000 {

  // Locate (Family 0x0002)
  const unsigned short SNAC_LOC_Error = 0x0001;
  const unsigned short SNAC_LOC_RightsReq = 0x0002;
  const unsigned short SNAC_LOC_Rights = 0x0003;
  const unsigned short SNAC_LOC_SetUserInfo = 0x0004;

  // ----------------- Location (Family 0x0002) SNACs -------------

  class LOCFamilySNAC : virtual public SNAC {
   public:
    unsigned short Family() const { return SNAC_FAM_LOC; }
  };

  class SetUserInfoSNAC : public LOCFamilySNAC, public OutSNAC {
   protected:
    void OutputBody(Buffer& b) const;

   public:
    SetUserInfoSNAC() { }
    unsigned short Subtype() const { return SNAC_LOC_SetUserInfo; }
  };

}

#endif
