/*
*
* $Id: chatsession.c,v 1.3 2001/06/02 07:10:00 konst Exp $
*
* Copyright (C) 2001 by Konstantin Klyagin <konst@konst.org.ua>
* Copyright (C) 2000 Denis V. Dmitrienko <denis@null.net>
* Copyright (C) 2000 Bill Soudan <soudan@kde.org>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or (at
* your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
* USA
*
*/

#include <stdlib.h>

#include "chatsession.h"
#include "list.h"

icq_ChatSession *icq_ChatSessionNew(ICQLINK *icqlink) 
{
  icq_ChatSession *p=(icq_ChatSession *)malloc(sizeof(icq_ChatSession));

  if (p)
  {
    p->remote_handle=0L;
    p->status=0;
    p->id=0L;
    p->icqlink=icqlink;
    list_insert(icqlink->icq_ChatSessions, 0, p);
  }
	
  return p;
}

void icq_ChatSessionDelete(void *p)
{
  free(p);
}

void icq_ChatSessionClose(icq_ChatSession *p)
{
  list_remove(p->icqlink->icq_ChatSessions, p);
  icq_ChatSessionDelete(p);
}

int _icq_FindChatSession(void *p, va_list data)
{
  DWORD uin=va_arg(data, DWORD);
  return (((icq_ChatSession *)p)->remote_uin == uin);
}

icq_ChatSession *icq_FindChatSession(ICQLINK *icqlink, DWORD uin)
{
  return list_traverse(icqlink->icq_ChatSessions,
    _icq_FindChatSession, uin);
}

void icq_ChatSessionSetStatus(icq_ChatSession *p, int status)
{
  p->status=status;
  if(p->id)
    if(p->icqlink->icq_RequestNotify)
      (*p->icqlink->icq_RequestNotify)(p->icqlink, p->id, ICQ_NOTIFY_CHAT, status, 0);
}
