/*
*
* $Id: contacts.c,v 1.3 2001/06/02 07:10:45 konst Exp $
*
* Copyright (C) 2001 by Konstantin Klyagin <konst@konst.org.ua>
* Copyright (C) 2000 Denis V. Dmitrienko <denis@null.net>
* Copyright (C) 2000 Bill Soudan <soudan@kde.org>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or (at
* your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
* USA
*
*/

#include <stdlib.h>
#include <stdarg.h>

#include "icqtypes.h"
#include "util.h"
#include "icq.h"
#include "list.h"
#include "contacts.h"

icq_ContactItem *icq_ContactNew(ICQLINK *link)
{
  icq_ContactItem *pcontact=
    (icq_ContactItem *)malloc(sizeof(icq_ContactItem));

  if(pcontact)
    pcontact->icqlink=link;

  return pcontact;
}

void icq_ContactDelete(void *p)
{
  free(p);
}

void icq_ContactAdd(ICQLINK *link, DWORD cuin)
{
  icq_ContactItem *p = icq_ContactNew(link);
  p->uin = cuin;
  p->vis_list = FALSE;

  list_enqueue(link->icq_ContactList, p);
}

void icq_ContactRemove(ICQLINK *link, DWORD cuin)
{
  icq_ContactItem *pcontact=icq_ContactFind(link, cuin);

  if (pcontact)
  {
    list_remove(link->icq_ContactList, pcontact);
    icq_ContactDelete(pcontact);
  }
}

void icq_ContactClear(ICQLINK *link)
{
  list_delete(link->icq_ContactList, icq_ContactDelete);
  link->icq_ContactList=list_new();
}

int _icq_ContactFind(void *p, va_list data)
{
  DWORD uin=va_arg(data, DWORD);

  return (((icq_ContactItem *)p)->uin == uin);
}

icq_ContactItem *icq_ContactFind(ICQLINK *link, DWORD cuin)
{
  return list_traverse(link->icq_ContactList, _icq_ContactFind, cuin);
}

void icq_ContactSetVis(ICQLINK *link, DWORD cuin, BYTE vu)
{
  icq_ContactItem *p = icq_ContactFind(link, cuin);
  if(p)
    p->vis_list = vu;
}

icq_ContactItem *icq_ContactGetFirst(ICQLINK *link)
{
  return list_first(link->icq_ContactList);
}

icq_ContactItem *icq_ContactGetNext(icq_ContactItem *pcontact)
{
  list_node *p=list_find(pcontact->icqlink->icq_ContactList, pcontact);

  if (p && p->next)
    return p->next->item;
  else
    return 0L;

}
