/***************************************************************************
                          tabslots.cpp  -  description
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) 2000 by M Grant
    email                : mickgr@drahthaar.clara.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "tabdlg.hpp"
#include "mgprocess.h"
#include "mgrun.h"

void TabDialog::ConnectSlots()
{
	// main buttons
	// OK produces applyButton signal, we only want 1 button
  	connect( this, SIGNAL( applyButtonPressed() ), this, SLOT( OnExit() ) );

	// facepage
	connect( bt_makeimage, SIGNAL( clicked() ), this, SLOT( OnClickedMakeImage() ) );
	connect( bt_viewimage, SIGNAL( clicked() ), this, SLOT( OnClickedViewImage() ) );
	connect( bt_writecd, SIGNAL( clicked() ), this, SLOT( OnClickedWriteCD() ) );
	connect( bt_fly, SIGNAL( clicked() ), this, SLOT( OnClickedFly() ) );
	connect( pb_grabaudio, SIGNAL( clicked() ), this, SLOT( OnClickedGrabAudio() ) );	
	connect( pb_writeaudio, SIGNAL( clicked() ), this, SLOT( OnClickedWriteAudio() ) );	
	connect( pb_writefly, SIGNAL( clicked() ), this, SLOT( OnClickedAudioFly() ) );
	connect( bt_cancelop, SIGNAL( clicked() ), this, SLOT( OnClickedCancelOp() ) );

	connect( tb_notes, SIGNAL( backwardAvailable(bool) ), bt_back, SLOT( setEnabled(bool) ) );
	bt_back->setEnabled( FALSE );
	connect( bt_back, SIGNAL( clicked() ), tb_notes, SLOT( backward() ) );
	
	connect( tb_notes, SIGNAL( forwardAvailable(bool) ), bt_forward, SLOT( setEnabled(bool) ) );
	bt_forward->setEnabled( FALSE );
	connect( bt_forward, SIGNAL( clicked() ), tb_notes, SLOT( forward() ) );

	connect( bt_home, SIGNAL( clicked() ), this, SLOT( OnClickedHome() ) );
	// page1
	connect( rb_winlin, SIGNAL( clicked() ), this, SLOT( OnClickedWinLin() ) );
	connect( rb_win, SIGNAL( clicked() ), this, SLOT( OnClickedWin() ) );
	connect( rb_lin, SIGNAL( clicked() ), this, SLOT( OnClickedLin() ) );
	connect( rb_custom, SIGNAL( clicked() ), this, SLOT( OnClickedCustom() ) );

	connect( rb_single, SIGNAL( clicked() ), this, SLOT( OnClickedSingle() ) );
// BSD - no multi option
	connect( rb_multi, SIGNAL( clicked() ), this, SLOT( OnClickedMulti() ) );
// end BSD
	connect( bt_fetchinfo, SIGNAL( clicked() ), this, SLOT( OnClickedFetchInfo() ) );
	connect( cb_tooltips, SIGNAL( clicked() ), this, SLOT( OnClickedTooltips() ) );
	connect( cb_boot, SIGNAL( clicked() ), this, SLOT( OnClickedBootImage() ) );
	connect( cb_multimedia, SIGNAL( clicked() ), this, SLOT( OnClickedMultimedia() ) );

	connect( bt_browse4, SIGNAL( clicked() ), this, SLOT( OnClickedBrowse() ) );
	connect( bt_add, SIGNAL( clicked() ), this, SLOT( OnClickedAdd() ) );
	connect( bt_remove, SIGNAL( clicked() ), this, SLOT( OnClickedRemove() ) );

	connect( bt_browse2, SIGNAL( clicked() ), this, SLOT( OnClickedBrowse2() ) );
	connect( bt_browse3, SIGNAL( clicked() ), this, SLOT( OnClickedBrowse3() ) );

	connect( bt_add2, SIGNAL( clicked() ), this, SLOT( OnClickedAdd2() ) );
	connect( bt_remove2, SIGNAL( clicked() ), this, SLOT( OnClickedRemove2() ) );
	connect( bt_size, SIGNAL( clicked() ), this, SLOT( OnClickedTestSize() ) );

	connect( comb_devicename, SIGNAL(  highlighted( const QString & ) ),
				this, SLOT( OnComboTextChanged(const QString &) ) );
	
	connect( comb_audiodevicename, SIGNAL(  highlighted( const QString & ) ),
				this, SLOT( OnAudioComboTextChanged(const QString &) ) );
	
	connect(&m_Proc, SIGNAL(processExited(MGProcess*)),
				this, SLOT(OnProcessExited(MGProcess*)));	
	
	connect( pb_getinfo, SIGNAL( clicked() ), this, SLOT( OnClickedGetInfo() ) );
	connect( rb_index, SIGNAL( clicked() ), this, SLOT( OnClickedIndex() ) );
	connect( rb_start_end, SIGNAL( clicked() ), this, SLOT( OnClickedStartEnd() ) );
	connect( rb_duration, SIGNAL( clicked() ), this, SLOT( OnClickedDuration() ) );
	connect( rb_default, SIGNAL( clicked() ), this, SLOT( OnClickedDefault() ) );
	connect( rb_userdefined, SIGNAL( clicked() ), this, SLOT( OnClickedUserDefined() ) );	
	connect( cb_buffers, SIGNAL( clicked() ), this, SLOT( OnClickedBuffers() ) );	
	
	connect( bt_browse5, SIGNAL( clicked() ), this, SLOT( OnClickedBrowse5() ) );		
	connect( bt_add3, SIGNAL( clicked() ), this, SLOT( OnClickedAdd3() ) );		
	connect( bt_remove3, SIGNAL( clicked() ), this, SLOT( OnClickedRemove3() ) );			
	connect( rb_common_name, SIGNAL( clicked() ), this, SLOT( OnClickedCommonName()) );			
	connect( rb_list, SIGNAL( clicked() ), this, SLOT( OnClickedCommonName()) );			
		
   connect(&m_Proc, SIGNAL(receivedStdout(MGProcess*, char*, int)),
			this, SLOT(slotOnStdxxx(MGProcess*, char*, int)) );
	connect(&m_Proc, SIGNAL(receivedStderr(MGProcess*, char*, int)),
			this, SLOT(slotOnStdxxx(MGProcess*, char*, int)) );
	connect( this, SIGNAL(currentChanged(QWidget*)),
			this, SLOT(OnPageChanged(QWidget*)) );		
}



////////////////////////////////////////////////////////////////////////////////

//  APP WIDE SLOTS

////////////////////////////////////////////////////////////////////////////////

void TabDialog::OnPageChanged(QWidget* page)
{
QString cstr;
	
	if(page == tab5)
		{
		lb_audiodevice->setText(cstr = "Source Device = " + le_audiodevice->text());
		lb_device->setText(cstr = "Target Device = " + le_device->text());
		lb_speed->setText(cstr = "Speed = " + sb_speed->text());
		lb_buffers->setText(cstr = "Buffers = " + sb_buffer->text());
		cstr = "Dummy Write = ";
		cb_dummy->isChecked() ? cstr += "True" : cstr += "False";
		lb_dummy->setText(cstr);
		cstr = "Common Name = " + le_common->text();
		lb_common_name->setText(cstr);
		}
}


// only need one slot as stderr and stdout displayed in same control

void TabDialog::slotOnStdxxx(MGProcess *proc, char *buff, int len)
{
QString cstr;

	cstr = "";
	if(&m_Proc == proc)
		{
		cstr = buff;
		cstr = cstr.left(len -1); // take off newlines
		ml_notes->insertLine(cstr);
		ml_notes->setCursorPosition(ml_notes->numLines(),0);		
		}
}



void TabDialog::OnProcessExited(MGProcess* proc)
{
QString cstr;

	if(&m_Proc == proc)
		{
		ml_notes->insertLine("\nFinished\n");
		proc->normalExit() ? cstr.sprintf("Exit Status %d", proc->exitStatus()) :
								cstr = "Abnormal Exit";			
		ml_notes->insertLine(cstr + "\n");
		ml_notes->setCursorPosition(ml_notes->numLines(),0);
		ml_notes->repaint();			
		qApp->beep();

		m_Proc.clearArguments();
     	setCursor(ArrowCursor);
		OnClickedCancelOp(); // reset everything
      }
}
