/***************************************************************************
                          tabdlg.h  -  description
                             -------------------
    begin                : Thu Mar 23 2000
    copyright            : (C) 2000 by M Grant
    email                : mickgr@drahthaar.clara.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 #ifndef TABDIALOG_H
#define TABDIALOG_H

#include "qtinc.h"
#include "mgprocess.h"


#define NUM_ELEMENTS 18
#define NUM_BOXES 21
#define NUM_RADIOS 16
#define NUM_PATHS 25
#define NUM_XPATHS 25
#define NUM_WPATHS 25
#define NUM_SPIN 5
#define NUM_DIR 2
#define NUM_COMBO 2

#define TAB_WIDTH 550
#define TAB_HEIGHT 410

class TabDialog : public QTabDialog
{
Q_OBJECT

public:
	TabDialog( QWidget *parent, const char *name, const QString &_filename );
   void ReadConfigFile(bool read);
	void CollectParams(QString& str);
	void CollectParams(QStrList& list);
	void ShowOutput(QStrList& list, const char* infofile, int index);
	void GetSCSIDevices();
	void ConnectSlots();
	bool FillCommandLine(QStrList& list, bool write, bool fly = false );
	bool FillCommandLine(QString& cstr, bool write, bool fly = false );
	bool getShell(QString& str);
	bool FillAudioGrab(QString& str, bool nobulk = false);
	bool FillAudioWrite(QString& str);
	
// data members
	QString m_device, m_audiodevice;
   char m_temppath[128];
	char m_docpath[128];
	bool m_bTooltipsOn;
	bool m_bOnce;
	
public slots:
	void OnExit();
	void slotOnStdxxx(MGProcess*, char*, int);
	void OnPageChanged(QWidget*);	
// page0	
	void OnClickedMakeImage();
	void OnClickedViewImage();
	void OnClickedWriteCD();
	void OnClickedFly();
	void OnClickedGrabAudio();
	void OnClickedWriteAudio();
	void OnClickedAudioFly();

	void OnClickedCancelOp();
	
	void OnClickedBootImage();
	void OnClickedMultimedia();
   void OnClickedTooltips();
	void OnClickedWin();
   void OnClickedWinLin();
   void OnClickedLin();
   void OnClickedCustom();
   void OnClickedSingle();
	void OnClickedMulti();
   void OnClickedFetchInfo();
   void OnClickedBrowse2();
	void OnClickedBrowse3();
	void OnClickedAdd2();
	void OnClickedRemove2();
	void OnClickedTestSize();
	void OnComboTextChanged(const QString &);
	void OnAudioComboTextChanged(const QString &);
	
	void OnClickedBrowse();
	void OnClickedAdd();
	void OnClickedRemove();

	void OnClickedHome();

	void OnProcessExited(MGProcess*);
// page4
	void OnClickedGetInfo();	
	void OnClickedStartEnd();
	void OnClickedDuration();
	void OnClickedIndex();
	void OnClickedDefault();
	void OnClickedUserDefined();
	void OnClickedBuffers();
//page 5
	void OnClickedBrowse5();
	void OnClickedAdd3();
	void OnClickedRemove3();
	void OnClickedCommonName();
	

protected slots:
	virtual void done( int );
	virtual void accept();
	virtual void reject();

protected:
	QString filename;
	QFileInfo fileinfo;
   	MGProcess m_Proc;

	void setupPage0();
	void setupPage1();
	void setupPage1a();	
	void setupPage2();
	void setupPage2a();	
	void setupPage3();
	void setupPage3a();	
   	void setupPage4();	
   	void setupPage5();	
   	void setupHelp(bool enable);

public:

		// need to do this here so we can access elsewhere
	QWidget *face, *tab2, *tab3, *tab1, *tab2a, *tab3a, *tab1a, *tab4, *tab5;
		
	QGroupBox *gb_dataops;
	QPushButton *bt_makeimage;
	QPushButton *bt_viewimage;
	QPushButton *bt_writecd;
	QPushButton *bt_fly, *pb_writefly;
	QPushButton *bt_cancelop;
	QGroupBox *gb_notes;
	QMultiLineEdit *ml_notes;	
	QTextBrowser *tb_notes;
	QPushButton *bt_back;
  	QPushButton *bt_home;
  	QPushButton *bt_forward;
	QGroupBox *gb_audioops;
	QPushButton *pb_grabaudio;
  	QPushButton *pb_writeaudio;

   // page1

	QButtonGroup *gb1;
	QCheckBox *cb_all;
	QCheckBox *cb_long;
	QCheckBox *cb_joliet;
	QCheckBox *cb_rock;
	QCheckBox *cb_nodir;
	QCheckBox *cb_dot;
	QCheckBox *cb_symlink;

	QButtonGroup *gb2;
	QRadioButton *rb_win;
	QRadioButton *rb_winlin;
	QRadioButton *rb_lin;
	QRadioButton *rb_custom;

	QButtonGroup *bg3;
	QRadioButton *rb_single;
	QRadioButton *rb_multi;
  	QPushButton* bt_fetchinfo;

	QLabel *QLabel_1;
	QLabel *QLabel_2;
	QLabel *QLabel_2a;
	QLabel *QLabel_2b;

	QLineEdit *le_started;
	QLineEdit *le_ended;
	QLineEdit *le_device;
  	QLineEdit *le_audiodevice;
	
	QGroupBox *gb_4;
	QLabel *QLabel_4;
	QLabel *QLabel_5;
	QLabel *QLabel_6;
	QLabel *QLabel_7;
	QLabel *QLabel_8;
	QLineEdit *le_copy;
	QLineEdit *le_prep;
	QLineEdit *le_pub;
	QLineEdit *le_id;
	QLineEdit *le_set;
	QCheckBox *cb_configsave;
	QCheckBox *cb_tooltips;
///////////////////////////
//	tab1

	QGroupBox *gb6;
   QLabel *QLabel_13a;
	QListBox *lb_exclude;
	QLineEdit *le_exclude;
	QPushButton *bt_add;
	QPushButton *bt_remove;
   QPushButton *bt_browse4;

	QButtonGroup *bg7;
	QCheckBox *cb_boot;
	QCheckBox *cb_table;
	QCheckBox *cb_nover;
	QCheckBox *cb_data;
	QCheckBox *cb_multimedia;
	QLabel *QLabel_14b;
  	QLineEdit *le_bootimage;
	QLabel *QLabel_14a;
	QLineEdit *le_mountpoint;
	QCheckBox *cb_dummy;
	QLabel *QLabel_15a;
   QSpinBox *sb_speed;
	QLabel *QLabel_16a;
   QSpinBox *sb_buffer;
  	QLabel *QLabel_17a, *QLabel_18a;
	QLineEdit *le_dataextra, *le_audioextra;

/////////////////////////////////////////////
// tab3
	QGroupBox *gb8;
	QLabel *QLabel_11;
	QLineEdit *le_filename;
	QLabel *QLabel_12;
	QLineEdit *le_targetpath;
	QPushButton *bt_browse2;

	QGroupBox *gb9;
	QLabel *QLabel_13;
	QLineEdit *le_sourcepath;
	QPushButton *bt_browse3;
	QListBox *lb_paths;
	QPushButton *bt_add2;
	QPushButton *bt_remove2;

	QGroupBox *gb10;
	QPushButton *bt_size;
	QLineEdit *le_size;
   	
	QGroupBox *QGroupBox_4;
   	QLabel *QLabel_15;
   	QComboBox *comb_devicename;
   
   QGroupBox *QGroupBox_4a;
   QLabel *QLabel_15z;
   QComboBox *comb_audiodevicename;
   
   //QPushButton *bt_viewscsi;

/////////////////////////////
// tab4
	 QGroupBox* gb11;
    QButtonGroup* bg_channels;
    QRadioButton* rb_mono; //
    QRadioButton* rb_swap; //
    QRadioButton* rb_stereo; //
    QSpinBox* sb_CDspeed; //
    QSpinBox* sb_bits; //
    QCheckBox* cb_max; //
    QLabel* TextLabel1_2;
    QLabel* TextLabel1_3;
    QCheckBox* cb_deemphasis; //
    QCheckBox* cb_wait; //
    QCheckBox* cb_bulk; //
    QButtonGroup* bg_time;
    QLineEdit* le_index; //
    QLineEdit* le_start; //
    QLineEdit* le_end;   //
    QLineEdit* le_duration; //
    QLabel* TextLabel1;
    QRadioButton* rb_index; //
    QRadioButton* rb_start_end; //
    QRadioButton* rb_duration; //
    QButtonGroup* bg_info;
    QRadioButton* rb_dumprates; //
    QRadioButton* rb_amp; //
    QRadioButton* rb_ismono; //
    QRadioButton* rb_info; //
    QPushButton* pb_getinfo;
    QButtonGroup* bg_mode;
    QRadioButton* rb_default; //
    QRadioButton* rb_userdefined; //
    QLabel* TextLabel1x;
    QLineEdit* le_common; //
    QCheckBox* cb_buffers; //
    QSpinBox* sb_buffers; //

///////////////////////////////////

  	QGroupBox *gb6d;
   QLabel *Label1, *lb_audiodevice, *lb_device, *lb_speed, *lb_buffers, *lb_dummy, *lb_common_name;
   QCheckBox *cb_pad;
  	
  	QGroupBox *gb6c;
    QRadioButton* rb_common_name;
    QRadioButton* rb_list;

  	QGroupBox *gb6b;
  	QLineEdit *le_select;
  	QPushButton *bt_browse5;
  	QListBox *lb_select;
  	QPushButton *bt_add3;
   QPushButton *bt_remove3;
  	
};

#endif
