
#include "tabdlg.hpp"
#include "mgrun.h"


TabDialog::TabDialog( QWidget *parent, const char *name, const QString &_filename )
: QTabDialog( parent, name ), filename( _filename ), fileinfo( filename )
{
QString pkgdocpath = DATADIR;
   strcpy(m_docpath, pkgdocpath);
	strcpy(m_temppath, "/tmp");
	
	setupPage0();
	setupPage1();
	setupPage1a();
	setupPage2();
	setupPage2a();	
	setupPage3();
	setupPage3a();
   setupPage4();	
   setupPage5();	
   GetSCSIDevices();

   ReadConfigFile(true); // this will change m_docpath & m_temppath if alternates set
   
	tb_notes->mimeSourceFactory()->setFilePath( m_docpath);
	tb_notes->setSource(QString("index.html"));

	if(cb_tooltips->isChecked())
  	  setupHelp(true);
	else
	  m_bTooltipsOn = false;	
	  
	if(QString(le_device->text()).isEmpty())
		le_device->setText("Not Set");
	if(QString(le_audiodevice->text()).isEmpty())
		le_audiodevice->setText("Not Set");
	
	if(QString(le_common->text()).isEmpty())
		le_common->setText("/tmp/track");

	setOKButton(QString("E&XIT"));

	ConnectSlots();
	m_bOnce = false;
	bt_cancelop->setEnabled(false);
	// use the slots to ensure correct set up at launch
	OnClickedBuffers();
	OnClickedCommonName();
	OnClickedMultimedia();
}
//////////////////////////////////////////////////////////////////////////////////



void TabDialog::CollectParams(QString& str)
{
	if(cb_all->isChecked()) str.append(" -a");
	if(cb_long->isChecked()) str.append(" -l");
	if(cb_joliet->isChecked()) str.append(" -J");
	if(cb_rock->isChecked()) str.append(" -r");
	if(cb_nodir->isChecked()) str.append(" -D");
	if(cb_dot->isChecked()) str.append(" -L");
	if(cb_symlink->isChecked()) str.append(" -f");
	if(cb_table->isChecked()) str.append(" -T");
	if(cb_nover->isChecked()) str.append(" -N");
}

void TabDialog::CollectParams(QStrList& list)
{
	if(cb_all->isChecked()) list.append("-a");
	if(cb_long->isChecked()) list.append("-l");
	if(cb_joliet->isChecked()) list.append("-J");
	if(cb_rock->isChecked()) list.append("-r");
	if(cb_nodir->isChecked()) list.append("-D");
	if(cb_dot->isChecked()) list.append("-L");
	if(cb_symlink->isChecked()) list.append("-f");
	if(cb_table->isChecked()) list.append("-T");
	if(cb_nover->isChecked()) list.append("-N");
}




// BSD - major changes as cdrecord -scanbus does not work
void TabDialog::GetSCSIDevices()
{
QString cstr, cstr2;
FILE* fp;
QFile f;

comb_devicename->insertItem("choose");
comb_audiodevicename->insertItem("choose");

// new BSD section
QString cstr3, scname, scdev;  
int stop;
QStringList cddevs;
QString dmesg = "/var/run/dmesg.boot";
QFile g(dmesg);
    if (g.open(IO_ReadOnly)) 
      {
	while(g.readLine(cstr, 512) != -1) 
	  {
	    if(cstr.find(QRegExp("cd. at scsibus")) == 0)
	      {
		cstr = cstr.left(cstr.find(" "));
		cddevs.append(cstr);
	      }
	  }
	g.close();
      }
    else
      {
	g.close();  //just to make sure
	QMessageBox::information( this, "", "Could not open" + dmesg );
	return;
      }

    for (QStringList::Iterator it = cddevs.begin(); it != cddevs.end(); it++)
      {
	cstr = *it;
	cstr.insert(0,"/dev/r");
	cstr.insert(cstr.length(), "c");
	cstr.insert(0, "cdrecord dev=");
	cstr.insert(cstr.length(), " -scanbus");
	fp = popen(cstr, "r");
	f.open(IO_ReadOnly, fp);
	stop = 0;
	while((f.readLine(cstr2, 512) != -1) && (stop != 1))
	  {
	    cstr2 = cstr2.left(cstr2.length() -1 ); // get rid 0x0A
	    if(cstr2.find("devname:") != -1)
	      {
		cstr2.replace(QRegExp("^.*: "), "");
		cstr2.replace(QRegExp("'"), "");
		cstr2.replace(QRegExp(" "), "");
		cstr3 = cstr2;
	      }
	    else
	      {
		if((cstr2.find("scsibus") == -1) && (cstr2.find("libscg") == -1) && ( cstr2.find("scsidev:") == -1) && (cstr2.find(QString("cdrecord"),0,false) == -1))
		  {
		    if(cstr2.find("*") != 12)
		      {
			cstr2 = cstr2.simplifyWhiteSpace();
			scname = cstr2.mid(8, 55);
			scdev = cstr2.left(5);
			cstr3.insert(cstr3.length(), ":" + scdev + "  " + scname);
			comb_devicename->insertItem(cstr3);
			comb_audiodevicename->insertItem(cstr3);
			stop = 1;
		      }
		  }
	      }
	  }
	pclose(fp);
	f.close();
      }

/*
old code - was much simpler!
	cstr = "cdrecord -scanbus";
	fp = popen(cstr, "r");

	f.open(IO_ReadOnly, fp);
	while(f.readLine(cstr2, 512) != -1)
		{
		cstr2 = cstr2.left(cstr2.length() -1 ); // get rid 0x0A
		if((cstr2.find("scsibus") == -1)	&& (cstr2.find("version") == -1) &&
//this line is new
			(cstr2.find("scsidev:") == -1) && (cstr2.find("devname:") == -1) &&
//and not required if not using dev=xxx with cdrecord -scanbus			
			(cstr2.find(QString("cdrecord"),0,false) == -1))
			{
			comb_devicename->insertItem(cstr2);
			comb_audiodevicename->insertItem(cstr2);
			}
		}

	pclose(fp);
	f.close();

*/
}


void TabDialog::ShowOutput(QStrList& list, const char* infofile, int index)
{
int a;
QString cstr;

// Use array to prevent repeating code 7x
// index of 0 means doing operation not involving page0 push buttons (eg CDDA info display)
// index of 7 will never be passed, so bt_viewimage always disabled

QPushButton *pb_array[8] = {0, bt_makeimage, bt_writecd, bt_fly, 
			 	   				 pb_grabaudio,	pb_writeaudio,	pb_writefly, bt_viewimage,};

 	if(m_Proc.isRunning())
 		return;
	
	if(!m_bOnce)
		{
		for(a = 1; a < 8; a++)
			{
			if(a != index)
				(pb_array[a])->setEnabled(false);
			}

		bt_cancelop->setEnabled(true);	   	
      if(index)
			{
			tb_notes->setSource(infofile);				
			m_bOnce = true;			   			
			return;
			}
		}

	setCursor(WaitCursor);

   tb_notes->hide();
   bt_back->setEnabled(false);
   bt_forward->setEnabled(false);

	ml_notes->show();

   m_Proc.newArgList(list);

	m_Proc.start(MGProcess::NotifyOnExit, MGProcess::AllOutput);

}



///////////////////////////////////////////////////////////////////////
// cleanup

void TabDialog::OnExit()
{
	ReadConfigFile(false);
	qApp->quit();
}


// these just overide other exits and do nothing
void TabDialog::done( int )
{
}

void TabDialog::accept()
{
}

void TabDialog::reject()
{
}
/////////////////////////////////////////////////////////////////
//
// if we need a string for shell commandlines
// get the QStrList first and extract from it
//
/////////////////////////////////////////////////////////////////

bool TabDialog::FillCommandLine(QString& cstr, bool write, bool fly /* = false */ )
{
QStrList list;
char* pS;
	
	if(FillCommandLine(list,write,fly))
		{
		for (pS = list.first(); pS != 0; pS = list.next())
			{
			cstr += pS;
			cstr += " ";
			}
		cstr = cstr.left(cstr.length() - 1);
		return true;
      }
	else
		return false;
}


//
// amended 251100 to fill QStrList which can be fed direct to MGProcess
//

bool TabDialog::FillCommandLine(QStrList& list, bool write, bool fly /* = false */ )
{
QString cstr, cstr2, cstr3;
int a, b;

  	if(write)
		{
		list.append("cdrecord");
		list.append("-v");

//  BSD - rb_multi should never be checked as was disabled after creation in page1.cpp
//        so not much point doing tests for it - just ignore it

//		if(cb_dummy->isChecked() && rb_multi->isChecked())
//			{
//			QMessageBox::information( this, "",
//				"Cannot select multi-session and dummy write together\n"
//				"De-select multi-session whilst on dummy run\n"
//				"then re-select for write, de-selecting dummy" );
//			return false;
//			}
//		else
//			{

		if(cb_dummy->isChecked())
			list.append("-dummy");

//			if(rb_multi->isChecked())
//				list.append("-multi");
//				}
//      	}
// end BSD

		cstr2 = "speed=" + sb_speed->text();
		list.append(cstr2);
		cstr2 = "fs=" + sb_buffer->text() + "m";
  		list.append(cstr2);
  		
		cstr2 = (comb_devicename->currentText());
		if(cstr2.isEmpty())
			{
			QMessageBox::information( this, "",
				"No device target set, ensure CD-Writer is recognised and selected" );
			return false;
			}
// BSD - different device parsing
		if(cstr2.find(QString("choose")) != 0)
			cstr2 = cstr2.left(16);
		else
			{
			QMessageBox::information( this, "",
				"No device target set, ensure CD-Writer is recognised and selected" );
			return false;
			}
// end BSD
		cstr3 = "dev=" + cstr2;
		list.append(cstr3);
		
		cstr2 = le_dataextra->text();
		if(!(cstr2.isEmpty()))
			list.append(cstr3 = cstr2 + " ");
		
		if(fly)  // dont specify file if recording on fly!
			list.append("-");
		else
			{
			if(cb_data->isChecked())
				list.append("-data");
				
			cstr2 = (le_targetpath->text() + "/" + le_filename->text());
			if(cstr2.isEmpty())
				{
				QMessageBox::information( this, "",
					"No target file set, set target and make image first" );
				return false;
				}
			list.append(cstr2);
			}
		return true;
		}
	else
		{
		list.append("mkhybrid");
		CollectParams(cstr);
		CollectParams(list);
		
		if( (cstr.find("-J") == -1) && (cstr.find("-r") == -1) )
			{
			QMessageBox::information( this, "",
				"No file image type set, recommend Joliet /Rock Ridge" );
			return false;
			}
// BSD - -multi will never be checked, so no point testing for it
/*
		if(rb_multi->isChecked())
			{
      	if((le_started->text()).isEmpty() || (le_ended->text()).isEmpty())
				{
				switch( QMessageBox::warning( this,"",
						"Multi-Session radio button is set\n"
						"but start and end data for last track not given\n"
						"This is valid if making first track image of\na multi-session CD\n",
						"Continue?","Quit", 0, 0, 1 ) )
					{
					case 0: // Continue
							break;
					case 1: // Quit or Escape
					default:
							return false;
					}
				}
   		else
	         {
	         list.append("-C");
	         cstr2 = le_started->text() + "," + le_ended->text();
		      list.append(cstr2);
		      }
			
			if((le_device->text()).isEmpty())
				{
				switch( QMessageBox::warning( this,"",
						"Multi-Session radio button is set\n"
						"but device name (or last image name) not given\n"
						"This is valid if making first track image of\na multi-session CD\n",
						"Continue?","Quit", 0, 0, 1 ) )
					{
					case 0: // Continue
							break;
					case 1: // Quit or Escape
					default:
							return false;
					}

				}
			else
   	   	{
				if(cstr.find("-C") != -1)  // dont set unless previous session info present
					{
					list.append("-M");
					list.append(le_device->text());
					}
				}
			}

*/
		if(cb_boot->isChecked())
			{
			if((le_bootimage->text()).isEmpty())
				{	
				QMessageBox::information( this, "",
					"Bootable Cd option checked but no boot image specified");
				return false;
				}
			else
				{
				list.append("-b");
				list.append(le_bootimage->text());
				}
			}
		

		if(!(le_copy->text()).isEmpty())
			{
			cstr2 = le_copy->text();
			if(cstr2.find('\"') != 0)
				cstr2 = "\"" + cstr2;
			if(cstr2.findRev('\"') != (int)(cstr2.length()-1))
				cstr2.append("\"");
			le_copy->setText(cstr2);
			list.append("-copyright");
			list.append(cstr2 );
			}
		if(!(le_prep->text()).isEmpty())
			{
			cstr2 = le_prep->text();
			if(cstr2.find('\"') != 0)
				cstr2 = "\"" + cstr2;
			if(cstr2.findRev('\"') != (int)(cstr2.length()-1))
				cstr2.append("\"");
			le_prep->setText(cstr2);
			list.append("-p");
			list.append(cstr2 );
			}		
		if(!(le_pub->text()).isEmpty())
			{
			cstr2 = le_pub->text();
			if(cstr2.find('\"') != 0)
				cstr2 = "\"" + cstr2;
			if(cstr2.findRev('\"') != (int)(cstr2.length()-1))
				cstr2.append("\"");
			le_pub->setText(cstr2);
			list.append("-P");
			list.append(cstr2 );
			}
		if(!(le_id->text()).isEmpty())
			{
			cstr2 = le_id->text();
			if(cstr2.find('\"') != 0)
				cstr2 = "\"" + cstr2;
			if(cstr2.findRev('\"') != (int)(cstr2.length()-1))
				cstr2.append("\"");
			le_id->setText(cstr2);
			list.append("-sysid");
			list.append(cstr2 );
			}
		if(!(le_set->text()).isEmpty())
			{
			cstr2 = le_set->text();
			if(cstr2.find('\"') != 0)
				cstr2 = "\"" + cstr2;
			if(cstr2.findRev('\"') != (int)(cstr2.length()-1))
				cstr2.append("\"");
			le_set->setText(cstr2);
			list.append("-volset");
			list.append(cstr2 );
			}		
		
	   // get the exclusion parameters here next
		for(a = 0, b = lb_exclude->count(); a < NUM_XPATHS && a < b; a++)
      	{
			list.append("-x");
			list.append(lb_exclude->text(a));
     		}
	
		if(!bt_fly->isEnabled() && bt_cancelop->isEnabled()) // no filename if writing on fly
			{	
			cstr2 = (le_targetpath->text() + "/" + le_filename->text());
				if(cstr2.isEmpty())
				{
				QMessageBox::information( this, "",
					"No target file set, try default of /cdimage.raw" );
				return false;
				}
			list.append("-o");			
			list.append(cstr2);
			}


		if(!(b = lb_paths->count()))
			{
			QMessageBox::information( this, "",
				"No source paths, specify in [Source]" );
			return false;
			}

	   for(a = 0; a < NUM_PATHS && a < b; a++)
   	   list.append(lb_paths->text(a));
	
		return true;
		}
}


 	
bool TabDialog::getShell(QString& str)
{
MGRun run;
// BSD - use sh
//QString shell = "/bin/bash";
QString shell = "/bin/sh";
 
 	if(!(run.isExecutable(str = shell)))
   	str = run.searchShell(str);
 	
 	if (!str.length())
 		{
   	QMessageBox::information(0, "CDRchive",
   	"Unable to find a valid command shell\n"
   	"Most likely your $SHELL environment variable\n"
   	"is not set and you don't have a Bourne compatible\n"
   	"shell at " + shell);
	   return false;
 		}
 	return true;
}
