/***************************************************************************
                          tabconfg.cpp  -  description
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) 2000 by M Grant
    email                : mickgr@drahthaar.clara.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "tabdlg.hpp"
////////////////////////////////////////////////////////////////////////
// read text entries from /etc/cdr.conf into relevant QLineEdit controls
// in dialog
// entries in form TAGG=text   2 arrays set up matched pairs of text to
// be searched for and text parsed and control to be inserted into
// 
// 140601 - changed listbox entry handling to allow max 26 entries
// titled using caps alphabet
////////////////////////////////////////////////////////////////////////


void TabDialog::ReadConfigFile(bool read)
{
int a, b, c;
QString cstr, cstr2, cstr3;
QChar ch;
char chr;
QString conffile = SYSCONFDIR"/cdr.conf";
QFile f1(conffile);

char label_array[NUM_ELEMENTS][6] = {"COPY=", "PREP=", "PUBL=",
                          "SYSI=", "VOLS=", "TARG=", "TDIR=", "CDRW=",
                          "MONT=", "TBOT=", "INDX=", "STAR=", "AEND=",
                          "DURA=", "COMM=", "CRXT=", "CDXT=", "CDRM="};
QLineEdit *le_array[NUM_ELEMENTS] = { le_copy, le_prep, le_pub,
                           le_id, le_set,le_filename, le_targetpath, le_device,
									le_mountpoint, le_bootimage, le_index, le_start,
									le_end, le_duration, le_common, le_dataextra,le_audioextra, le_audiodevice };

char check_array[NUM_BOXES][6] = {"BALL=", "BLON=", "BJOL=", "BROC=", "BNOD=",
											"BDOT=", "BSYM=", "BOOT=", "BTAB=", "BNOV=",
											"BDUM="	, "BSAV=", "BTIP=", "BDAT=",
											"BMAX=", "BEMP=", "BWAI=", "BULK=", "BUFF=",
											"BPAD=", "BMED="};
											
QCheckBox* cb_array[NUM_BOXES] = {cb_all, cb_long, cb_joliet, cb_rock, cb_nodir,
											 cb_dot, cb_symlink, cb_boot, cb_table, cb_data,
											 cb_nover, cb_dummy , cb_configsave, cb_tooltips,
											 cb_max, cb_deemphasis, cb_wait, cb_bulk,
											 cb_buffers, cb_pad, cb_multimedia};

char radio_array[NUM_RADIOS][6] = {"RWIN=", "RWLN=", "RLIN=", "RCUS=",
											  "RSIN=", "RMUL=",
											  "RUSE=", "RDEF=", "RDUR=", "REND=",
											  "RIND=", "RSTE=", "RSWA=", "RMON=",
											  "RCOM=", "RUSR="};
QRadioButton* rb_array[NUM_RADIOS] = {rb_win, rb_winlin, rb_lin, rb_custom,
												  rb_single, rb_multi,
												  rb_userdefined, rb_default,rb_duration,
												  rb_start_end, rb_index, rb_stereo, rb_swap,
												  rb_mono, rb_common_name, rb_list};
												
char spinbox_array[NUM_SPIN][6] = {"BUF2=", "SPED=", "BUF3=", "BITS=", "CDSP=" };
QSpinBox* sb_array[NUM_SPIN] = {sb_buffer, sb_speed, sb_buffers,
											sb_bits, sb_CDspeed };

char device_array[NUM_COMBO][6] = {"DEVI=", "ADEV="};
QComboBox* comb_array[NUM_COMBO] = {comb_devicename, comb_audiodevicename};

char dir_array[NUM_DIR][6] = {"TEMP=", "DOCS="};
char* str_array[NUM_DIR] = {m_temppath, m_docpath};

/*
BSD - no need for this

//////////////////////////////////////////////////////////////
///////////////////////////////////////
//
// retain these arrays as a legacy to enable previous cdr.conf files to be seamlessly converted
//
/////////////////////////////////////////////////////////////////////////////////////////////////////

char sourcepath_array[NUM_PATHS][6] = {"LBP0=", "LBP1=", "LBP2=", "LBP3=", "LBP4=",
													"LBP5=", "LBP6=", "LBP7=", "LBP8=", "LBP9=" };

char excludepath_array[NUM_XPATHS][6] = {"LBX0=", "LBX1=", "LBX2=", "LBX3=", 
                                        "LBX4=", "LBX5=", "LBX6=", "LBX7=", 
                                        "LBX8=", "LBX9=" };
char wavpath_array[NUM_WPATHS][6] = {"WBX0=", "WBX1=", "WBX2=", "WBX3=",
                                        "WBX4=", "WBX5=", "WBX6=", "WBX7=",
                                        "WBX8=", "WBX9=" };
//////////////////////////////////////////////////////////////////////////////////////////////////
*/

   if(read)
		{
		if(f1.open(IO_ReadOnly))
			{
      	for(a = 0,
				 b = NUM_ELEMENTS + NUM_BOXES + NUM_RADIOS + NUM_PATHS + NUM_XPATHS + \
				 NUM_WPATHS +NUM_SPIN + NUM_DIR + NUM_COMBO;
             a < b; a++)
         	{
	         if(f1.readLine(cstr, 256) == -1)
   	         break;
				if(cstr.isEmpty())
         	   break;
	         cstr2.append(cstr);
   	      }
      	f1.close();

         // line edit strings
			for(a = 0, b = cstr2.length(); a < NUM_ELEMENTS ; a++)
				{
				cstr = "";
				if((c = cstr2.find(label_array[a])) != -1)
					{
					c += 5;
					while( ((ch = cstr2.at(c++)) != '\n') && c <= b)
						cstr.append((char)ch);

					(le_array[a])->setText(cstr);
					}
		      }
			// check box settings
  			for(a = 0, b = cstr2.length(); a < NUM_BOXES ; a++)
				{
				cstr = "";
				if((c = cstr2.find(check_array[a])) != -1)
					{
					ch = cstr2.at(c + 5);
					(cb_array[a])->setChecked(ch == '1' ? true : false);
					}
				}
			// radio button settings
  			for(a = 0, b = cstr2.length(); a < NUM_RADIOS ; a++)
				{
				cstr = "";
				if((c = cstr2.find(radio_array[a])) != -1)
					{
					ch = cstr2.at(c + 5);
					(rb_array[a])->setChecked(ch == '1' ? true : false);
					}
				OnClickedBootImage();
				}
         if(rb_single->isChecked())
				OnClickedSingle();

         // source paths list box contents
			chr = 'A';
			for(a = 0, b = cstr2.length(); a < NUM_PATHS; a++)
				{
				cstr = "";
				cstr3.sprintf("SP_%c=", chr++);
				if((c = cstr2.find(cstr3)) != -1)
					{
					c += 5;
					while( ((ch = cstr2.at(c++)) != '\n') && c <= b)
						cstr.append((char)ch);

					if(!cstr.isEmpty())
						lb_paths->insertItem(cstr);
					}
		      }

         // exclude paths list box contents
			chr = 'A';
         for(a = 0, b = cstr2.length(); a < NUM_XPATHS; a++)
				{
				cstr = "";
				cstr3.sprintf("XP_%c=", chr++);
            if((c = cstr2.find(cstr3)) != -1)
					{
					c += 5;
					while( ((ch = cstr2.at(c++)) != '\n') && c <= b)
						cstr.append((char)ch);

					if(!cstr.isEmpty())
	               lb_exclude->insertItem(cstr);
					}
		      }
         // .wav files to write
			chr = 'A';			
         for(a = 0, b = cstr2.length(); a < NUM_WPATHS; a++)		
				{		
				cstr = "";		
				cstr3.sprintf("WP_%c=", chr++);
            if((c = cstr2.find(cstr3)) != -1)
					{		
					c += 5;		
					while( ((ch = cstr2.at(c++)) != '\n') && c <= b)		
						cstr.append((char)ch);		
		
   				if(!cstr.isEmpty())
		            lb_select->insertItem(cstr);		
					}		
		      }		
/*
BSD - no need for this

////////////////////////////////////////////////////////////////////////////////////////////////
//
// Retain this code as a legacy to enable previous cdr.conf files to be seamlessly converted
// With the new .conf file it just does nothing
// Wastes a bit of space but simpler than trying to advise users that they will lose their
// settings first time round but they will be saved thereafter
//
////////////////////////////////////////////////////////////////////////////////////////////////



         // source paths list box contents
			for(a = 0, b = cstr2.length(); a < NUM_PATHS; a++)
				{
				cstr = "";
				if((c = cstr2.find(sourcepath_array[a])) != -1)
					{
					c += 5;
					while( ((ch = cstr2.at(c++)) != '\n') && c <= b)
						cstr.append((char)ch);

					if(!cstr.isEmpty())
						lb_paths->insertItem(cstr);
					}
		      }

         // exclude paths list box contents
         for(a = 0, b = cstr2.length(); a < NUM_XPATHS; a++)
				{
				cstr = "";
            if((c = cstr2.find(excludepath_array[a])) != -1)
					{
					c += 5;
					while( ((ch = cstr2.at(c++)) != '\n') && c <= b)
						cstr.append((char)ch);

               if(!cstr.isEmpty())
						lb_exclude->insertItem(cstr);
					}
		      }
         // .wav files to write
         for(a = 0, b = cstr2.length(); a < NUM_WPATHS; a++)		
				{		
				cstr = "";		
            if((c = cstr2.find(wavpath_array[a])) != -1)		
					{		
					c += 5;		
					while( ((ch = cstr2.at(c++)) != '\n') && c <= b)		
						cstr.append((char)ch);		
					
					if(!cstr.isEmpty())
               	lb_select->insertItem(cstr);		
					}		
		      }		

////////////////////////////////////////////////////////////////////////////////////////////////
*/
	      
			// spinbox settings
			for(a = 0, b = cstr2.length(); a < NUM_SPIN ; a++)
				{
				cstr = "";
				if((c = cstr2.find(spinbox_array[a])) != -1)
					{
					c += 5;
					while( ((ch = cstr2.at(c++)) != '\n') && c <= b)
						cstr.append((char)ch);

					(sb_array[a])->setValue(atoi(cstr));
					}
		      }

         //DEVICE SETTINGS here - get string at DEVI= then check through listed devices in
			// comb_devicename and if matched set that one as current
			for(a = 0; a < NUM_COMBO ; a++)
				{
				cstr = "";
			   b = cstr2.length();
				if((c = cstr2.find(device_array[a])) != -1)
					{
					c += 5;
					while( ((ch = cstr2.at(c++)) != '\n') && c <= b)
						cstr.append((char)ch);
					
		         for(c = 0, b = (comb_array[a])->count(); c < b; c++)
		         	{
			         cstr3 = (comb_array[a])->text(c);
						if(cstr3 == cstr)
							{
							(comb_array[a])->setCurrentItem(c);
							break;
							}
						}
					}
				}
			
			// if paths in cdr.conf are different to defaults use
			// new paths  - allows user to edit paths	
			for(a = 0, b = cstr2.length(); a < NUM_DIR ; a++)
				{
				cstr = "";
				if((c = cstr2.find(dir_array[a])) != -1)
					{
					c += 5;
					while( ((ch = cstr2.at(c++)) != '\n') && c <= b)
						cstr.append((char)ch);

					if(strcmp((char*)str_array[a], cstr) != 0)
						strcpy((char*)str_array[a], cstr);
					}
		      }

			}
		}
	else  // write config file
		{
      if(f1.open(IO_WriteOnly))
			{
         // line edit strings
	      for(a = 0; a < NUM_ELEMENTS; a++)
   	      {
				cstr = label_array[a];
				cstr.append((le_array[a])->text());
		      cstr.append(0x0A);
				f1.writeBlock((const char*) cstr, cstr.length());
         	}
	      f1.flush();
			// check box settings
  	      for(a = 0; a < NUM_BOXES; a++)
   	      {
				cstr = check_array[a];
				(cb_array[a])->isChecked() ? cstr.append("1") : cstr.append("0");
		      cstr.append(0x0A);
				f1.writeBlock((const char*) cstr, cstr.length());
         	}
	      f1.flush();
			// radio button settings
  	      for(a = 0; a < NUM_RADIOS; a++)
   	      {
				cstr = radio_array[a];
				(rb_array[a])->isChecked() ? cstr.append("1") : cstr.append("0");
		      cstr.append(0x0A);
				f1.writeBlock((const char*) cstr, cstr.length());
         	}
	      f1.flush();

			// source paths list box contents
	      chr = 'A';
			for(a = 0, b = lb_paths->count(); a < NUM_PATHS && a < b; a++)
   	      {
				cstr.sprintf("SP_%c=", chr++);
				cstr.append(lb_paths->text(a));
		      cstr.append(0x0A);
				f1.writeBlock((const char*) cstr, cstr.length());
         	}
	      f1.flush();

         // exclude paths list box contents
			chr = 'A';
         for(a = 0, b = lb_exclude->count(); a < NUM_XPATHS && a < b; a++)
   	      {
            cstr.sprintf("XP_%c=", chr++);
            cstr.append(lb_exclude->text(a));
		      cstr.append(0x0A);
				f1.writeBlock((const char*) cstr, cstr.length());
         	}
	      f1.flush();

         // WAV paths list box contents	
			chr = 'A';
         for(a = 0, b = lb_select->count(); a < NUM_WPATHS && a < b; a++)	
   	      {	
            cstr.sprintf("WP_%c=", chr++);
            cstr.append(lb_select->text(a));	
		      cstr.append(0x0A);	
				f1.writeBlock((const char*) cstr, cstr.length());	
         	}	
	      f1.flush();	
	
	      // spinbox settings
			for(a = 0; a < NUM_SPIN; a++)
   	      {
				cstr = spinbox_array[a];
				cstr.append((sb_array[a])->text());
		      cstr.append(0x0A);
				f1.writeBlock((const char*) cstr, cstr.length());
         	}
	      f1.flush();

	      for(a = 0; a < NUM_COMBO; a++)
				{
	         cstr = device_array[a];
				cstr.append((comb_array[a])->currentText());
	   	   cstr.append(0x0A);
				f1.writeBlock((const char*) cstr, cstr.length());
		      f1.flush();
				}

			// write back directory settings
	      for(a = 0; a < NUM_DIR; a++)
   	      {
				cstr = dir_array[a];
				cstr.append((char*)str_array[a]);
		      cstr.append(0x0A);
				f1.writeBlock((const char*) cstr, cstr.length());
         	}
	      f1.flush();

			f1.close();
      	}
		}
}
