/***************************************************************************
                          pagehelp.cpp  -  description
                             -------------------
    begin                : Sun Apr 23 2000
    copyright            : (C) 2000 by M Grant
    email                : mickgr@drahthaar.clara.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtooltip.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include "tabdlg.hpp"
//
// If tooltip dependant upon whether item is enabled, use add and remove
// in enabling mechanism, see OnClickSingle/Multi
//

#define NUM_TIPS 58
						  
						  
void TabDialog::setupHelp(bool enable)
{
int a;
QStringList list;

QString s0 = "Includes files with ~ and # characters in names\nwhich normally are backup or temporary files\n(Deprecated in later versions of mkisofs)";
QString s1 = "Allows 32 char filenames\n(violates ISO9660 CD may not work in DOS)";
QString s2 = "Generate Joliet directory for use by Windows systems";
QString s3 = "Generate Rock Ridge records for UNIX-like systems";
QString s4 = "Suppress deep directory re-location\n(violates ISO9660 CD may not work)" ;
QString s5 = "Omit trailing period(violates ISO9660 CD may not work)" ;
QString s6 = "Follow symbolic links without looping\nUse with great care" ;
QString s7 = "Should contain the full path of a file\non the CD containing copyright info (Max 37 chars)" ;
QString s8 = "Should describe the preparer of the CD, with\nmailing address/phone no (Max 128 chars)" ;	
QString s9 = "Should describe the publisher of the CD, with\nmailing address/phone no (Max 128 chars)" ;	
QString s10 = "System Identifier - Target operating system\nfor files on CD? (Max 32 chars)" ;
QString s11 = "Volume Set Name (Max 128 chars)" ;
QString s12 = "Save all settings, to be re-produced when next run" ;
QString s13 = "Setting for Windows only\n(long filenames - may not work under DOS)" ;
QString s14 = "Settings for image which can be shared\nbetween Windows and Unix" ;
QString s15 = "Unix only image" ;
QString s16 = "Your choice (eg DOS and/or strict ISO9660 CD)";
QString s17 = "Write image(s) to single track and close CD" ;
QString s18 = "Write images to multiple tracks (max 99)\nEach header linked and CD left open";
QString s19 = "Make bootable CD.  Not as simple as selecting\nthis checkbox. Read MAN mkisofs";
QString s20 = "Generate TRANS.TBL to assist non Unix systems\nread Rock Ridge filenames";
QString s21 = "Omit version numbers.  They are not used by\nmost systems so of little practical use";
QString s22 = "Write track in dummy mode with laser turned off\nShould do this every time to test before full write";
QString s23 = "Mount point at which to view image";
QString s24 = "CD Writer write speed.  Always test with\na dummy write when trying a different speed";
QString s25 = "fifo (ring buffer) size in MB.  Default is 16MB,\n which is the maximum.  Set as high as possible.";
QString s26 = "Paths to exclude from image.  Sometimes easier to\nspecify what you don't want than what you do want";
QString s27 = "Name for image file\ncdimage.raw is customary";
QString s28 = "Path for image file";
QString s29 = "Path(s) to be included in image file\nFully recursive, all sub-dirs included too";
QString s30 = "Get approximate size of image file for given paths\nGenerally above actual size by 3-5%";
QString s31 = "Combo-box with detected SCSI devices\nSelect your CD Writer from the list";
QString s32 = "Include -data switch to specify file as data\nor force multi-session write (see help pages)";
QString s33 = "Specify path of boot image relative to source path\nin Source\\Target tab page";
QString s34 = "Record at maximum CD quality";
QString s35 = "Select speed for CD-ROM containing CDDA\n 0 is often default speed";
QString s36 = "Should be 16 unless you are doing something special";
QString s37 = "Remove pre-emphasis";
QString s38 = "Wait for signal then start recording";
QString s39 = "Record each track to separate file\nNeed to specify common name element";
QString s40 = "Index to start recording from";
QString s41 = "Specify group of tracks to record";
QString s42 = "Specify recording of x length\nignoring track indicies";
QString s43 = "Dump sampling rates & divisors";
QString s44 = "Show amplitude extremes within recording";
QString s45 = "Displays version of cdda2wav\nand general CD information";
QString s46 = "Use default settings to make audio file";
QString s47 = "Define your own settings";
QString s48 = "Common name element to track files\nto which will be added _01.wav etc.";
QString s49 = "Use x number of ring buffers";
QString s50 = "Pad out a .wav file so that it is a\nmultiple of 2352 bytes (CDDA standard)";
QString s51 = "Use listed audio files\nWritten to disc in listed order";
QString s52 = "Use all files with common name element in index order\n"
					"eg common_01.wav common_02.wav etc.";
QString s53 = "These switches will be added to cdrecord commandline\nprior to file list";
QString s54 = "These switches will be added to cdda2wav commandline\nprior to file list";
QString s55 = "Combo-box with detected SCSI devices\nSelect your CD-ROM from the list";
QString s56 = "Reflects CD-ROM selected as Source Device\nChange it on \"Source\" tab page";
QString s57 = "Record a multimedia CD\nWrites data track first\nthen specified audio files";

QWidget *warray[NUM_TIPS] = {cb_all, cb_long, cb_joliet, cb_rock, cb_nodir,
     	  	  	  	  	   cb_dot, cb_symlink, QLabel_4, QLabel_5,  QLabel_6, QLabel_7, 
  	  	  	  	         QLabel_8, cb_configsave, rb_win,	rb_winlin, rb_lin,	
  	  	  	  	  	  	   rb_custom, rb_single, rb_multi, cb_boot, cb_table, cb_nover, cb_dummy,
							QLabel_14a, QLabel_15a, QLabel_16a, QLabel_13a,
							QLabel_11, QLabel_12, QLabel_13, bt_size, QLabel_15, cb_data, QLabel_14b,
							cb_max, TextLabel1_2, TextLabel1_3, cb_deemphasis,
							cb_wait, cb_bulk, rb_index, rb_start_end, rb_duration,
							rb_dumprates, rb_amp, rb_info, rb_default, rb_userdefined,
							TextLabel1x, cb_buffers, cb_pad, rb_list, rb_common_name,
							QLabel_17a, QLabel_18a, QLabel_15z, QLabel_2b, cb_multimedia};


list << s0 << s1 << s2 << s3 << s4 << s5 << s6 << s7 << s8 << s9 << s10 << s11 << s12 << s13 << s14 << 
  	  s15 << s16 << s17 << s18 << s19 << s20 << s21 << s22 << s23 << s24 << s25 << s26 << s27 << s28 <<
	  s29 << s30 << s31 << s32 << s33 << s34 << s35 << s36 << s37 << s38 << s39 << s40 << s41 << s42 <<
	  s43 << s44 << s45 << s46 << s47 << s48 << s49 << s50 << s51 << s52 << s53 << s54 << s55 << s56 << s57;


QStringList::Iterator it;

  if(enable)
  	  {
  	  for ( a = 0, it = list.begin(); a < NUM_TIPS && it != list.end(); ++it, a++ ) 
	  	  {
  	  	  QToolTip::add(warray[a], *it);
  	  	  }
	  m_bTooltipsOn = true;
	  }
  else
  	  {
	  for ( a = 0; a < NUM_TIPS ; a++ ) 
	  	  QToolTip::remove(warray[a]);
  	  	  	  
	  m_bTooltipsOn = false;
	  }	  


}
