#include "tabdlg.hpp"

void TabDialog::setupPage5()
{
	tab5 = new QWidget( this );

	tab5->resize(TAB_WIDTH,TAB_HEIGHT);
  	tab5->setMinimumSize(0,0);
	
  	gb6d = new QGroupBox(tab5,"NoName");
  	gb6d->setGeometry(10,10,220,290);
  	gb6d->setMinimumSize(0,0);  	
  	gb6d->setTitle("CD Writing Settings");  	  	

   Label1 = new QLabel( gb6d, "" );  	
   Label1->setGeometry( QRect( 10, 20, 130, 20 ) );  	
   Label1->setText( tr( "Existing settings:-"  ) );  	

   lb_audiodevice = new QLabel( gb6d, "" );  	
// BSD - changed size to display device name properly
   lb_audiodevice->setGeometry( QRect( 10, 50, 200, 20 ) );  	
   lb_audiodevice->setText( tr( "Source Device"  ) );  	

	lb_device = new QLabel( gb6d, "" );  	
// BSD - changed size to display device name properly
   lb_device->setGeometry( QRect( 10, 80, 200, 20 ) );  	
   lb_device->setText( tr( "Target Device"  ) );  	
// end BSD
   lb_speed = new QLabel( gb6d, "" );  	
   lb_speed->setGeometry( QRect( 10, 110, 130, 20 ) );  	
   lb_speed->setText( tr( "Speed"  ) );  	

   lb_buffers = new QLabel( gb6d, "" );  	
   lb_buffers->setGeometry( QRect( 10, 140, 130, 20 ) );  	
   lb_buffers->setText( tr( "Buffers"  ) );  	

   lb_dummy = new QLabel( gb6d, "" );  	
   lb_dummy->setGeometry( QRect( 10, 170, 130, 20 ) );  	
   lb_dummy->setText( tr( "Dummy"  ) );  	     	

   lb_common_name = new QLabel( gb6d, "" );  	
   lb_common_name->setGeometry( QRect( 10, 200, 200, 20 ) );  	
   lb_common_name->setText( tr( "Common name"  ) );  	     	

   cb_pad = new QCheckBox( gb6d, "" );
   cb_pad->setGeometry( QRect( 10, 240, 200, 20 ) );
   cb_pad->setText( tr( "Pad audio files to correct length"  ) );

//////////////////////////////////////////////////  	
  	gb6c = new QButtonGroup(tab5,"NoName");
  	gb6c->setGeometry(240,10,320,80);
  	gb6c->setMinimumSize(0,0);  	
  	gb6c->setTitle("Select Source Type");  	  	

  	rb_common_name = new QRadioButton( gb6c, "" );
  	rb_common_name->setGeometry( QRect( 11, 20, 200, 19 ) );
  	rb_common_name->setText( tr("Use common name element"  ) );
  	
  	rb_list = new QRadioButton( gb6c, "" );
  	rb_list->setGeometry( QRect( 11, 50, 160, 19 ) );
  	rb_list->setText( tr( "Specify all audio files"  ) );
  	
  	
///////////////////////////////////////////////  	
  gb6b= new QGroupBox(tab5,"NoName");
  gb6b->setGeometry(240,100,320,270);
  gb6b->setMinimumSize(0,0);
  gb6b->setTitle("Track List - paths to files");

  le_select= new QLineEdit(gb6b,"NoName");
  le_select->setGeometry(10,20,220,30);
  le_select->setMinimumSize(0,0);
  le_select->setText("");

  bt_browse5= new QPushButton(gb6b,"NoName");
  bt_browse5->setGeometry(240,20,70,30);
  bt_browse5->setMinimumSize(0,0);
  bt_browse5->setText("&Browse");

  lb_select= new QListBox(gb6b,"NoName");
  lb_select->setGeometry(10,60,220,200);
  lb_select->setMinimumSize(0,0);
	
  bt_add3= new QPushButton(gb6b,"NoName");
  bt_add3->setGeometry(240,80,70,30);
  bt_add3->setMinimumSize(0,0);
  bt_add3->setText("<-&Add");

  bt_remove3= new QPushButton(gb6b,"NoName");
  bt_remove3->setGeometry(240,130,70,30);
  bt_remove3->setMinimumSize(0,0);
  bt_remove3->setText("&Remove->");
	
	addTab( tab5, "CDDA" );

	rb_common_name->setChecked(true);
	OnClickedCommonName();
}

void TabDialog::OnClickedBrowse5()
{
QString cstr;
	cstr = QFileDialog::getOpenFileName( QString::null, "Wav files (*.wav)", this, "", 
															"Select .Wav files for Track List");
	if (!cstr.isEmpty())	
		le_select->setText(cstr);
}

void TabDialog::OnClickedAdd3()
{
	if(lb_select->count() == NUM_WPATHS + 1)
		{
		qApp->beep();
		QMessageBox::information(this, "CD-Rchive", "A maximum of 26 entries is allowed currently");
		return;
		}

	lb_select->insertItem(le_select->text());
	le_select->setText("");
}
void TabDialog::OnClickedRemove3()
{
	lb_select->removeItem(lb_select->currentItem());
}

void TabDialog::OnClickedCommonName()
{
	if(rb_common_name->isChecked())
		{
		gb6b->setEnabled(false);
		le_select->setEnabled(false);
		bt_browse5->setEnabled(false);
		lb_select->setEnabled(false);
		bt_add3->setEnabled(false);
		bt_remove3->setEnabled(false);
		}
	else
		{
		gb6b->setEnabled(true);	
		le_select->setEnabled(true);
		bt_browse5->setEnabled(true);
		lb_select->setEnabled(true);
		bt_add3->setEnabled(true);
		bt_remove3->setEnabled(true);
		}
}
