#include "tabdlg.hpp"

void TabDialog::setupPage3a()
{
	tab1a = new QWidget( this );

	tab1a->resize(TAB_WIDTH,TAB_HEIGHT);
  	tab1a->setMinimumSize(0,0);

  gb6= new QGroupBox(tab1a,"NoName");
  gb6->setGeometry(20,20,510,320);
  gb6->setMinimumSize(0,0);
  gb6->setTitle("Paths and File-types to Exclude");

  QLabel_13a= new QLabel(gb6,"NoName");
  QLabel_13a->setGeometry(10,30,50,30);
  QLabel_13a->setMinimumSize(0,0);
  QLabel_13a->setText("Path:-");

  le_exclude= new QLineEdit(gb6,"NoName");
  le_exclude->setGeometry(90,30,290,30);
  le_exclude->setMinimumSize(0,0);
  le_exclude->setText("");

  bt_browse4= new QPushButton(gb6,"NoName");
  bt_browse4->setGeometry(400,30,70,30);
  bt_browse4->setMinimumSize(0,0);
  bt_browse4->setText("&Browse");

  lb_exclude= new QListBox(gb6,"NoName");
  lb_exclude->setGeometry(90,60,290,200);
  lb_exclude->setMinimumSize(0,0);
	
  bt_add= new QPushButton(gb6,"NoName");
  bt_add->setGeometry(400,80,70,40);
  bt_add->setMinimumSize(0,0);
  bt_add->setText("<-&Add");

  bt_remove= new QPushButton(gb6,"NoName");
  bt_remove->setGeometry(400,130,70,40);
  bt_remove->setMinimumSize(0,0);
  bt_remove->setText("&Remove->");
	
	addTab( tab1a, "Exclude" );
}


void TabDialog::OnClickedAdd()
{
int a, b;
QString cstr, cstr2;

	if(lb_exclude->count() == NUM_XPATHS + 1)
		{
		qApp->beep();
		QMessageBox::information(this, "CD-Rchive", "A maximum of 26 entries is allowed currently");
		return;
		}

	// dont duplicate strings
	cstr2 = le_exclude->text();
	if(cstr2.length())
		{
	   for(a = 0, b = lb_exclude->count(); a < NUM_XPATHS && a < b; a++)
   		{
			cstr = lb_exclude->text(a);
			if(cstr == cstr2)
				{
				le_exclude->setText("");
				return;
				}
			}

		lb_exclude->insertItem(cstr2);
		le_exclude->setText("");
		}
}

void TabDialog::OnClickedRemove()
{
	if(lb_exclude->isSelected(lb_exclude->currentItem()))
		lb_exclude->removeItem(lb_exclude->currentItem());
}



void TabDialog::OnClickedBrowse()
{
QString cstr = QFileDialog::getExistingDirectory(QString("/"), this, "", 
							"Select Path to Exclude", true);

	if(!cstr.isEmpty())
		{
		if((cstr[cstr.length() - 1]) == '/')
			cstr = cstr.left(cstr.length() - 1);
		le_exclude->setText(cstr);
		}
}
