/***************************************************************************
                          page1.cpp  -  description
                             -------------------
    begin                : Fri Mar 24 2000
    copyright            : (C) 2000 by M Grant
    email                : mickgr@drahthaar.clara.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 /////////////////////////////////////////////////////////////////////////
// no support for creating pages as dialogs so easiest thing is to create
// a dialog which has features you want and copy data across
// need to use QWidget as parent, QVBox etc cause chaos

#include "tabdlg.hpp"

void TabDialog::setupPage1()
{
	tab2 = new QWidget( this );

	tab2->resize(TAB_WIDTH,TAB_HEIGHT);
  	tab2->setMinimumSize(0,0);

////////////////////////////////////////////

	gb1= new QButtonGroup(tab2,"box1");
	gb1->setGeometry(20,10,250,260);
  	gb1->setMinimumSize(0,0);
  	gb1->setTitle("Image Settings");
	gb1->setExclusive(false);

	cb_all= new QCheckBox(gb1,"NoName");
  	cb_all->setGeometry(30,20,130,30);
  	cb_all->setMinimumSize(0,0);
  	cb_all->setText("Include &All files");

	cb_long= new QCheckBox(gb1,"NoName");
  	cb_long->setGeometry(30,53,130,30);
  	cb_long->setMinimumSize(0,0);
  	cb_long->setText("&Long File Names");

  	cb_joliet= new QCheckBox(gb1,"NoName");
  	cb_joliet->setGeometry(30,86,100,30);
  	cb_joliet->setMinimumSize(0,0);
  	cb_joliet->setText("&Joliet");

  	cb_rock= new QCheckBox(gb1,"NoName");
  	cb_rock->setGeometry(30,119,100,30);
  	cb_rock->setMinimumSize(0,0);
  	cb_rock->setText("&Rock Ridge");

  	cb_nodir= new QCheckBox(gb1,"NoName");
  	cb_nodir->setGeometry(30,152,170,30);
  	cb_nodir->setMinimumSize(0,0);
  	cb_nodir->setText("No D&e&ep Dir Re-location");

  	cb_dot= new QCheckBox(gb1,"NoName");
  	cb_dot->setGeometry(30,185,180,30);
  	cb_dot->setMinimumSize(0,0);
  	cb_dot->setText("Omit trailing &Dot");

  	cb_symlink= new QCheckBox(gb1,"NoName");
  	cb_symlink->setGeometry(30,218,180,30);
  	cb_symlink->setMinimumSize(0,0);
  	cb_symlink->setText("&Follow Symlinks");

///////////////////////////////////////////////////

  	gb2= new QButtonGroup(tab2,"box2");
  	gb2->setGeometry(290,10,245,150);
  	gb2->setMinimumSize(0,0);
  	gb2->setTitle("Setting Types");
  	gb2->setExclusive(true);

  	rb_win= new QRadioButton(gb2,"NoName");
  	rb_win->setGeometry(10,20,180,30);
  	rb_win->setMinimumSize(0,0);
  	rb_win->setText("&Windows 95 / NT");

  	rb_winlin= new QRadioButton(gb2,"NoName");
  	rb_winlin->setGeometry(10,50,210,30);
  	rb_winlin->setMinimumSize(0,0);
  	rb_winlin->setText("Windows 95/&NT & Unix");

  	rb_lin= new QRadioButton(gb2,"NoName");
  	rb_lin->setGeometry(10,80,200,30);
  	rb_lin->setMinimumSize(0,0);
  	rb_lin->setText("&Unix");

  	rb_custom= new QRadioButton(gb2,"NoName");
  	rb_custom->setGeometry(10,110,220,30);
  	rb_custom->setMinimumSize(0,0);
  	rb_custom->setText("&Custom");

////////////////////////////////////////////////

	bg3= new QButtonGroup(tab2,"box3");
  	bg3->setGeometry(290,170,230,100);
  	bg3->setMinimumSize(0,0);
  	bg3->setTitle("Session Type");
  	bg3->setExclusive(true);

 	rb_single= new QRadioButton(bg3,"NoName");
  	rb_single->setGeometry(20,20,80,30);
  	rb_single->setMinimumSize(0,0);
  	rb_single->setText("&Single");

  	rb_multi= new QRadioButton(bg3,"NoName");
  	rb_multi->setGeometry(140,20,80,30);
  	rb_multi->setMinimumSize(0,0);
  	rb_multi->setText("&Multi");
// BSD it does not support multi session either
	rb_multi->setEnabled(false);
// end BSD

	bt_fetchinfo= new QPushButton(bg3,"NoName");
  	bt_fetchinfo->setGeometry(20,60,190,30);
  	bt_fetchinfo->setMinimumSize(0,0);
  	bt_fetchinfo->setText("Fetch Last Session &Info");

	QLabel_1= new QLabel(tab2,"NoName");
  	QLabel_1->setGeometry(20,285,80,30);
  	QLabel_1->setMinimumSize(0,0);
	QLabel_1->setText("Last Started:-");

  	le_started= new QLineEdit(tab2,"NoName");
  	le_started->setGeometry(110,285,70,30);
  	le_started->setMinimumSize(0,0);
  	le_started->setText("");

  	QLabel_2= new QLabel(tab2,"NoName");
  	QLabel_2->setGeometry(190,285,80,30);
  	QLabel_2->setMinimumSize(0,0);
  	QLabel_2->setText("Last Ended:-");

  	le_ended= new QLineEdit(tab2,"NoName");
  	le_ended->setGeometry(280,285,70,30);
  	le_ended->setMinimumSize(0,0);
  	le_ended->setText("");

	QLabel_2a= new QLabel(tab2,"NoName");
  	QLabel_2a->setGeometry(360,285,80,30);
  	QLabel_2a->setMinimumSize(0,0);
  	QLabel_2a->setText("Image/Device:-");

  	le_device= new QLineEdit(tab2,"NoName");
  	le_device->setGeometry(450,285,80,30);
  	le_device->setMinimumSize(0,0);
  	le_device->setText("");

  	  	
	addTab( tab2, "Image" );

}


void TabDialog::OnClickedFetchInfo()
{
QString cstr, cstr2, cstr3;
FILE* fp;
QFile f;
int a;

   cstr = le_device->text();
	if(cstr.isEmpty())
		{
		QMessageBox::information( this, "","Recording Device not set" );
		return;
		}
	cstr2 = "cdrecord -msinfo dev=" + cstr;

	fp = popen(cstr2, "r");
	f.open(IO_ReadOnly, fp);
	f.readLine(cstr2, 512);

	a = cstr2.find(',');
	le_started->setText(cstr2.left(a));
   cstr3 = cstr2.right(cstr2.length() - (a+1));
	a = cstr3.find("\n");
	if(a != -1)
		cstr3 = cstr3.left(a);
	le_ended->setText(cstr3);

	pclose(fp);
}



void TabDialog::OnClickedWin()
{
	if(rb_win->isChecked())
		{
		cb_all->setChecked(false);
		cb_long->setChecked(true);
		cb_joliet->setChecked(true);
		cb_rock->setChecked(false);
		cb_nodir->setChecked(true);
		cb_dot->setChecked(true);
		cb_symlink->setChecked(false);
		}
}

void TabDialog::OnClickedWinLin()
{
	if(rb_winlin->isChecked())
		{
		cb_all->setChecked(false);
		cb_long->setChecked(true);
		cb_joliet->setChecked(true);
		cb_rock->setChecked(true);
		cb_nodir->setChecked(true);
		cb_dot->setChecked(true);
		cb_symlink->setChecked(false);
		}
}

void TabDialog::OnClickedLin()
{
	if(rb_lin->isChecked())
		{
		cb_all->setChecked(false);
		cb_long->setChecked(true);
		cb_joliet->setChecked(false);
		cb_rock->setChecked(true);
		cb_nodir->setChecked(false);
		cb_dot->setChecked(false);
		cb_symlink->setChecked(false);
		}
}

void TabDialog::OnClickedCustom()
{
	if(rb_custom->isChecked())
		{
		cb_all->setChecked(false);
		cb_long->setChecked(false);
		cb_joliet->setChecked(false);
		cb_rock->setChecked(false);
		cb_nodir->setChecked(false);
		cb_dot->setChecked(false);
		cb_symlink->setChecked(false);
		}

}

void TabDialog::OnClickedSingle()
{
	QLabel_1->setEnabled(false);
	QLabel_2->setEnabled(false);
	QLabel_2a->setEnabled(false);
	le_started->setEnabled(false);
	le_ended->setEnabled(false);
	le_device->setEnabled(false);
	bt_fetchinfo->setEnabled(false);
	QToolTip::remove(QLabel_1);
	QToolTip::remove(QLabel_2);
	QToolTip::remove(QLabel_2a);
}

void TabDialog::OnClickedMulti()
{
	QLabel_1->setEnabled(true);
	QLabel_2->setEnabled(true);
	QLabel_2a->setEnabled(true);
	le_started->setEnabled(true);
	le_ended->setEnabled(true);
	le_device->setEnabled(true);
	bt_fetchinfo->setEnabled(true);
	if(m_bTooltipsOn)
	   {
   	QToolTip::add(QLabel_1,  "Address at which last track started\n"
								 "use [Fetch Last session Info] to fill field" );
	   QToolTip::add(QLabel_2,  "Address at which last track ended\n"
								 "use [Fetch Last session Info] to fill field" );
   	QToolTip::add(QLabel_2a, "Device which contains CD with last track written\n"
								 "or path of image file	for last track" );
		}
}
