//  page0.cpp Facing page of tab dialog

#include "tabdlg.hpp"
#include "mgprocess.h"
#include "mgrun.h"


void TabDialog::setupPage0()
{
	face = new QWidget( this );

	face->resize(TAB_WIDTH,TAB_HEIGHT);
  	face->setMinimumSize(0,0);

	gb_dataops= new QGroupBox(face,"NoName");
	gb_dataops->setGeometry(10,10,160,180);
  	gb_dataops->setMinimumSize(0,0);
  	gb_dataops->setTitle("Data Operations");

  	bt_makeimage= new QPushButton(gb_dataops,"NoName");
  	bt_makeimage->setGeometry(20,20,120,30);
  	bt_makeimage->setMinimumSize(0,0);
  	bt_makeimage->setText("&Make Image");

  	bt_viewimage= new QPushButton(gb_dataops,"NoName");
  	bt_viewimage->setGeometry(20,60,120,30);
  	bt_viewimage->setMinimumSize(0,0);
  	bt_viewimage->setText("&View Image");

  	bt_writecd= new QPushButton(gb_dataops,"NoName");
  	bt_writecd->setGeometry(20,100,120,30);
  	bt_writecd->setMinimumSize(0,0);
  	bt_writecd->setText("&Write to CD");

  	bt_fly= new QPushButton(gb_dataops,"NoName");
  	bt_fly->setGeometry(20,140,120,30);
  	bt_fly->setMinimumSize(0,0);
  	bt_fly->setText("Write on the &Fly");
//////////////////////////////////////////////////

	gb_audioops= new QGroupBox(face,"NoName");
	gb_audioops->setGeometry(10,195,160,140);
  	gb_audioops->setMinimumSize(0,0);
  	gb_audioops->setTitle("Audio Operations");
  	
  	pb_grabaudio = new QPushButton(gb_audioops,"NoName");
  	pb_grabaudio->setGeometry(20,20,120,30);
  	pb_grabaudio->setMinimumSize(0,0);
  	pb_grabaudio->setText("&CDAudio to .wav");

  	pb_writeaudio = new QPushButton(gb_audioops,"NoName");
  	pb_writeaudio->setGeometry(20,60,120,30);
  	pb_writeaudio->setMinimumSize(0,0);
  	pb_writeaudio->setText("Write &Audio CD");
  	
	pb_writefly = new QPushButton(gb_audioops,"NoName");
  	pb_writefly->setGeometry(20,100,120,30);
  	pb_writefly->setMinimumSize(0,0);
  	pb_writefly->setText("Audio CD on Fl&y");
	
  	bt_cancelop= new QPushButton(face,"NoName");
  	bt_cancelop->setGeometry(30,350,120,30);
  	bt_cancelop->setMinimumSize(0,0);
  	bt_cancelop->setText("&Cancel Operation");



////////////////////////////////////////////////////////////////

   // setup for future use and hide
   ml_notes = new QMultiLineEdit(face, "");
   ml_notes->setGeometry(190,10,380,330);
   ml_notes->setMinimumSize(0,0);
   ml_notes->setText("");
	ml_notes->hide();

   tb_notes= new QTextBrowser(face,"NoName");
  	tb_notes->setGeometry(190,10,380,330);
  	tb_notes->setMinimumSize(0,0);
  	tb_notes->setText("");
	tb_notes->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	
  	bt_back= new QPushButton(face,"NoName");
  	bt_back->setGeometry(280,355,60,25);
  	bt_back->setMinimumSize(0,0);
  	bt_back->setText("&<<");

  	bt_home= new QPushButton(face,"NoName");
  	bt_home->setGeometry(350,355,70,25);
  	bt_home->setMinimumSize(0,0);
  	bt_home->setText("&Home");

  	bt_forward= new QPushButton(face,"NoName");
  	bt_forward->setGeometry(430,355,60,25);
  	bt_forward->setMinimumSize(0,0);
  	bt_forward->setText("&>>");

	addTab( face, "Ops" );
}


// use this as trigger to clear ml_notes & hide it
// restore tb_notes and browse buttons
void TabDialog::OnClickedHome()
{
 	if(m_Proc.isRunning())
 		return;
 	if(ml_notes->isVisible())
 		{
 		ml_notes->setText("");
 		ml_notes->hide();
 		tb_notes->show();
 		bt_back->setEnabled(true);
 		bt_forward->setEnabled(true);
	 	tb_notes->setSource(QString("index.html"));
 		}		
}


void TabDialog::OnClickedMakeImage() // facepage button
{
QStrList list;

	if(FillCommandLine(list, false))
		ShowOutput(list, "imageinf.html", 1);

}


void TabDialog::OnClickedWriteCD()
{
QStrList list;
QString str, cstr, cstr2;
int a, b;

	if(cb_multimedia->isChecked())
		{
	 	if(!getShell(cstr))
 			return;
	
		list.append(cstr);
		list.append("-c");

		if(!FillCommandLine(str, true))
			return;
		str.append(" -audio ");

		if(rb_common_name->isChecked())
			{
			cstr2 = le_common->text();
	 		if(cstr2.isEmpty())
				{	
	 			QMessageBox::information( this, "",
 					"Common name element for tracks not set, do they exist?" );
	 			return;
		 		}
			cstr2 += "*.wav"; 	
		 	str.append(cstr2);		
   		}
	   else
   		{
	      for(a = 0, b = lb_select->count(); a < b; a++)	   	
   	    	str.append(lb_select->text(a) + " ");	   	
			str = str.left(cstr.length() - 1);  // get rid of last space
	   	}
		list.append(str); 	
		list.append("\0"); 	
		cstr = "mediainf.html";
		}
	else 
		{
		cstr = "writeinf.html";
		if(!FillCommandLine(list, true))
			return;
		}	

	ShowOutput(list, cstr, 2);
	
}


/////////////////////////////////////////////////////////////////

void TabDialog::OnClickedViewImage() // facepage button
{
QString cstr, cstr2;

// BSD - different loopback methods
// appears necessary to config the mountpoint /dev/svnd0a as relating to the targetdir/targetfile
// then un-config it at the end
//	cstr = "mount -r -t iso9660 -o loop ";
	cstr = "mount -r -t cd9660 /dev/svnd0a ";
	cstr2 = (le_targetpath->text() + "/" + le_filename->text());
	if(cstr2.isEmpty())
		{
		QMessageBox::information( this, "",
			"No target file set, set target and make image first" );
		return;
		}
// BSD
	system("vnconfig -c svnd0 " + cstr2);
//	cstr.append(cstr2 + " ");

	cstr2 = le_mountpoint->text();
	if(cstr2.isEmpty())
		cstr.append(cstr2 = "/mnt");
   else
		cstr.append(cstr2);

	if(system(cstr) == 0)
		{
		QFileDialog::getOpenFileName(cstr2, "All Files(*)", this, "", "View Image");

		cstr = "umount ";	
		if(cstr2.isEmpty())
			cstr.append("/mnt");
	   else
			cstr.append(cstr2);
      system(cstr);
// BSD additional
	system("vnconfig -u svnd0");
// end BSD
      }
	else
		QMessageBox::information( this, "",
			"Mount of file image failed\n"
			"The most likely cause is that the image is corrupt\n"
			"or that you are trying to view part of a multi-session\n"
			"Check the output from [Make Image] for warnings\n" );
}


// recording on the fly relies upon a pipe which is implemented from the commandline
// therefore it needs to run via a shell.  The commandline with the exception
// of the shell name and its own switch, is a single string in the QStrList
// Hence we use an overloaded version of FillCommandline which fills a QString

void TabDialog::OnClickedFly()
{
QStrList list;
QString fil = "flyinf.html", str = "", cstr;

 	if(!getShell(cstr))
 		return;
	
	list.append(cstr);
	list.append("-c");
	if(FillCommandLine(str, false, true))
		{
		str.append(" | ");
		if(FillCommandLine(str, true, true))
			{
			list.append(str);
			list.append("\0");
			ShowOutput(list, fil, 3);
			}
		}

}


void TabDialog::OnClickedGrabAudio()
{
QStrList list;
QString cstr, cstr2, cstr3, str = "";

 	if(!getShell(cstr))
 		return;
	
	list.append(cstr);
	list.append("-c");

	if(!FillAudioGrab(str))
		return;
		
	cstr = le_common->text();
	if(cstr.isEmpty())
		cstr = "track";
	
	str.append(cstr);		
	list.append(str); 	
	list.append("\0"); 	

	ShowOutput(list, "grabwav.html", 4);

}


// Recording audio relies upon a wildcard * in the common filename spec
// which is implemented by the shell from the commandline
// therefore it needs to run via a shell.  The commandline with the exception
// of the shell name and its own switch, is a single string in the QStrList
	
void TabDialog::OnClickedWriteAudio()
{
QStrList list;
QString cstr, cstr3, cstr2, str = "";
int a, b;

 	if(!getShell(cstr))
 		return;

	list.append(cstr);
 	list.append("-c");	
	
	if(!FillAudioWrite(str))
		return;

	str.append("-audio ");

	if(rb_common_name->isChecked())
		{
		cstr2 = le_common->text();
 		if(cstr2.isEmpty())
			{	
	 		QMessageBox::information( this, "",
 				"Common name element for tracks not set, do they exist?" );
 			return;
	 		}
		cstr2 += "*.wav"; 	
	 	str.append(cstr2);		
   	}
   else
   	{
      for(a = 0, b = lb_select->count(); a < b; a++)	   	
       	str.append(lb_select->text(a) + " ");	   	
		str = str.left(cstr.length() - 1);  // get rid of last space
   	}
	
	list.append(str); 	
	list.append("\0"); 	
 	
	ShowOutput(list, "writewav.html", 5);
}

////////////////////////////////////////////////////////////////////////////////////////////


void TabDialog::OnClickedAudioFly()
{
QStrList list;
QString cstr, cstr2, cstr3, str = "";

 	if(!getShell(cstr))
 		return;
	
	list.append(cstr);
	list.append("-c");

	if(!FillAudioGrab(str))
		return;
	
	str.append("- | "); // output to stdout and pipe it to cdrecord		

	if(!FillAudioWrite(str))
		return;

	str.append("-audio -");

	list.append(str); 	
	list.append("\0"); 	
 	
	ShowOutput(list, "audiofly.html", 6);
	
}


////////////////////////////////////////////////////////////////////////////////////////////
//
// Common sections assigned to sub-funcs to prevent repetition
//
////////////////////////////////////////////////////////////////////////////////////////////

bool TabDialog::FillAudioGrab(QString& str, bool nobulk /* = false*/)
{
QString cstr, cstr2, cstr3;

	str = "cdda2wav -v 1 ";

	if(rb_mono->isChecked())
		str.append("-c 1 ");
	else if(rb_swap->isChecked())
		str.append("-c s ");
	else
		str.append("-s "); // else stereo
	
	cstr = "-S " + sb_CDspeed->text() + " " ;
	str.append(cstr);
	cstr = "-b " + sb_bits->text() + " ";
	str.append(cstr);
		
	if(cb_max->isChecked())
		str.append("-x ");
	if(cb_bulk->isChecked() && !nobulk)
		str.append("-B ");
	if(cb_deemphasis->isChecked())
		str.append("-T ");
	if(cb_wait->isChecked())
		str.append("-w ");
	if(cb_buffers->isChecked())
		{
		cstr = "-l " + sb_buffers->text() + " ";
		str.append(cstr);
		}
			
	cstr = le_audiodevice->text();
		if(cstr.isEmpty())
			{
			QMessageBox::information( this, "",
				"No source device set, ensure CD-ROM is recognised and selected" );
			return false;
			}
	cstr3 = "-D " + cstr + " ";
	str.append(cstr3);	
	
	if(rb_index->isChecked())
		{
		cstr = "-i " + le_index->text() + " ";
		str.append(cstr);
		}
	else if(rb_start_end->isChecked())
		{
		cstr = "-t " + le_start->text();
		cstr2 = le_end->text();
		if(!cstr2.isEmpty())
			cstr += "+" + cstr2;
		str.append(cstr + " ");
		}
	else
		{
		cstr = "-d " + le_duration->text() = " ";
		str.append(cstr);
		}

	cstr2 = le_audioextra->text();
	if(!(cstr2.isEmpty()))
		str.append(cstr3 = cstr2 + " ");
	
	return true;
	
	
}


bool TabDialog::FillAudioWrite(QString& str)
{
QString cstr2, cstr3;

	str += "cdrecord -v ";

	if(cb_dummy->isChecked())
		str.append("-dummy ");

	cstr2 = "speed=" + sb_speed->text() + " ";
	str.append(cstr2);
	cstr2 = "fs=" + sb_buffer->text() + "m ";
	str.append(cstr2);
	
	cstr2 = le_device->text();
	if(cstr2.isEmpty())
		{
		QMessageBox::information( this, "",
			"No device target set, ensure CD-Writer is recognised and selected" );
		return false;
		}
	cstr3 = "dev=" + cstr2 + " ";
	str.append(cstr3);
	
	cstr2 = le_dataextra->text();
	if(!(cstr2.isEmpty()))
		str.append(cstr3 = cstr2 + " ");
	
	if(cb_pad->isChecked())	
		str.append("-pad ");	

	return true;
	
}

////////////////////////////////////////////////////////////////////////////////////////////


void TabDialog::OnClickedCancelOp()
{
QString cstr, cstr2;
	
	// enable killing of process if it sticks
	// eg ask for audio info when no disc in drive
	if(m_Proc.isRunning())
		m_Proc.kill(SIGKILL);

	cstr = "cdrecord ";
	cstr2 = (comb_devicename->currentText());
// BSD - different output from cdrecord requires different parsing
	if(cstr2.find(QString("choose")) != 0)
		{
		cstr2 = cstr2.left(16);
		cstr += "dev=" + cstr2;	
		cstr += " -reset 2>&1 > /dev/null"; // if it dont work we dont want to know!
		system(cstr);
		}
	
// end BSD	
	bt_makeimage->setEnabled(true);
	bt_writecd->setEnabled(true);
	bt_viewimage->setEnabled(true);
	bt_fly->setEnabled(true);
	bt_cancelop->setEnabled(false);
	pb_grabaudio->setEnabled(true);
	pb_writeaudio->setEnabled(true);
	pb_writefly->setEnabled(true);
	m_bOnce = false;

}
