/***************************************************************************
                          mgrun.cpp  -  description
                             -------------------
    begin                : Sun Jun 25 2000
    copyright            : (C) 2000 by M Grant
    email                : mickgr@drahthaar.clara.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mgrun.h"

MGRun::MGRun(){
}
MGRun::~MGRun(){
}

bool MGRun::RunChild(QStrList *arguments, bool background /* = true */)
{
uint i, n = arguments->count();
pid_t pid, retpid;
int status;
char **arglist;

  	if (n == 0)
		return FALSE;

  	arglist = (char **)malloc( (n+1)*sizeof(char *));
  	CHECK_PTR(arglist);
  	for (i=0; i < n; i++)
    	arglist[i] = arguments->at(i);
  	arglist[n]= 0;

  	pid = fork();

  	if (0 == pid) // The child process
  		{
		execvp(arglist[0], arglist);
		exit(-1);
      }
   else if (-1 == pid) // forking failed
   	{
		free(arglist);
		return FALSE;
      }
   else	// the parent continues here
   	{
     	if(!background)
   		{
   		retpid = waitpid(pid, &status, 0);
   		emit ChildExits(pid, status);
   		}
      free(arglist);
	  	return TRUE;
		}
}


bool MGRun::RunChildInShell(QStrList *args, bool background /* = true */)
{
pid_t pid, retpid;
QString cstr, cstr2;
int i, status, n = args->count();
char *arglist[4];

 	if(!n)
 		return false;
// BSD - default shell /bin/sh
//	if(!(isExecutable(cstr = "/bin/bash")))
 	if(!(isExecutable(cstr = "/bin/sh")))
   	cstr = searchShell(cstr);
// if nothing found explain what required 	
 	if (!cstr.length())
 		{
   	QMessageBox::information(0, "MGRun", "Unable to find valid command shell\n"
														"Looking for /bin/sh or $SHELL environment variable\nneither found");
	   return FALSE;
 		}
// end BSD
 	
 	for (i=0; i < n; i++)
 		{
 		cstr2 += args->at(i);
 		cstr2 += " ";
 		}
     	
	arglist[0] = strdup(cstr.data());
 	arglist[1] = "-c";
	arglist[2] = strdup(cstr2.data());
 	arglist[3] = 0x00;
                  		
  	pid = fork();

  	if (0 == pid) // The child process
  		{
		execvp(arglist[0], arglist);
		exit(-1);
      }
   else if (-1 == pid) // forking failed
   	{
   	return FALSE;
      }
   else	// the parent continues here
   	{
   	if(!background)
   		{
   		retpid = waitpid(pid, &status, 0);
   		emit ChildExits(pid, status);
   		}
   	return TRUE;
		}
}

QString MGRun::searchShell(QString str)
{
  	str = "";
  	str = getenv("SHELL");
  	if (isExecutable(str))
  	  	return str;
  	else
  		return str = "";
}




bool MGRun::isExecutable(QString & fname)
{
struct stat fileinfo;
   	// no filename
  	if (fname.length() == 0)
  		return FALSE;
  	   // cant get fileinfo
  	if (stat(fname, &fileinfo) == -1)
  		return FALSE;
  		// not an executable file type
  	if ((S_ISDIR(fileinfo.st_mode))  || (S_ISCHR(fileinfo.st_mode))  ||
       (S_ISBLK(fileinfo.st_mode))  ||
#ifdef S_ISSOCK
       // CC: SYSVR4 systems don't have that macro
       (S_ISSOCK(fileinfo.st_mode)) ||
#endif
       (S_ISFIFO(fileinfo.st_mode)) || (S_ISDIR(fileinfo.st_mode)) )
      {
	   return FALSE;
  		}

  		// permission to execute the file?
  	if (access(fname, X_OK) != 0)
  		return FALSE;

  	return TRUE;
}
