
#ifndef __MGPROCCTRL_H__
#define __MGPROCCTRL_H__


#include <qsocketnotifier.h>
#include "mgprocess.h"

/**
@short A class for internal use by MGProcess only
@author Christian Czezakte e9025461@student.tuwien.ac.at
  A class for internal use by MGProcess only. -- Exactly one instance
  of this class is generated by the first instance of MGProcess that is
  created (a pointer to it gets stored in "theMGProcessController").

  This class takes care of the actual (UN*X) signal handling.
*/
class MGProcessController : public QObject
{
  Q_OBJECT

public:
  MGProcessController();
  ~MGProcessController();
  //CC: WARNING! Destructor Not virtual (but you don't derive classes from this anyhow...)

  QList<MGProcess> *processList;

 public slots:

 void slotDoHousekeeping(int socket);

private:
#ifdef __sgi__
  static void theSigCHLDHandler();
#else
  static void theSigCHLDHandler(int signal);
#endif
  // handler for sigchld

  int fd[2];
  QSocketNotifier *notifier;

  // Disallow assignment and copy-construction
  MGProcessController( const MGProcessController& );
  MGProcessController& operator= ( const MGProcessController& );
};

extern MGProcessController *theMGProcessController;

#endif

