
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <fcntl.h>

#include <stdio.h>

#include "mgprocess.h"

#include "mgprocctrl.h"

MGProcessController *theMGProcessController = 0;

MGProcessController::MGProcessController()
{
  struct sigaction act;

  // initialize theMGProcessList
  processList = new QList<MGProcess>();
  CHECK_PTR(processList);
 
  if (0 > pipe(fd))
	printf(strerror(errno));
  
  if (-1 == fcntl(fd[0], F_SETFL, O_NONBLOCK))
	printf(strerror(errno));

  notifier = new QSocketNotifier(fd[0], QSocketNotifier::Read);
  notifier->setEnabled(TRUE);
  QObject::connect(notifier, SIGNAL(activated(int)),
				   this, SLOT(slotDoHousekeeping(int)));
 		 
  act.sa_handler=theSigCHLDHandler;
  sigemptyset(&(act.sa_mask));
  sigaddset(&(act.sa_mask), SIGCHLD);
  act.sa_flags = SA_NOCLDSTOP;

  // CC: take care of SunOS which automatically restarts interrupted system
  // calls (and thus does not have SA_RESTART)

#ifdef SA_RESTART
  act.sa_flags |= SA_RESTART;
#endif

  sigaction( SIGCHLD, &act, 0L); 
  act.sa_handler=SIG_IGN;
  sigemptyset(&(act.sa_mask));
  sigaddset(&(act.sa_mask), SIGPIPE);
  act.sa_flags = 0;
  sigaction( SIGPIPE, &act, 0L);
}

#ifdef __sgi__
void MGProcessController::theSigCHLDHandler()
#else
void MGProcessController::theSigCHLDHandler(int )
#endif
{
  int status;
  pid_t this_pid;
  int saved_errno;

  saved_errno = errno;
  // since waitpid and write change errno, we have to save it and restore it
  // (Richard Stevens, Advanced programming in the Unix Environment)

  // Waba: Check for multiple childs exiting at the same time
  do
  {
    this_pid = waitpid(-1, &status, WNOHANG);
    // J6t: theMGProcessController might be already destroyed
    if ((this_pid > 0) && (theMGProcessController != 0)) {
      ::write(theMGProcessController->fd[1], &this_pid, sizeof(this_pid));
      ::write(theMGProcessController->fd[1], &status, sizeof(status));
    }
  }
  while (this_pid > 0); 

  errno = saved_errno;
}



void MGProcessController::slotDoHousekeeping(int )
{
  MGProcess *proc;
  int bytes_read;
  pid_t pid;
  int status;

  bytes_read  = ::read(fd[0], &pid, sizeof(pid_t));
  bytes_read += ::read(fd[0], &status, sizeof(int));

  if (bytes_read != sizeof(int)+sizeof(pid_t))
	fprintf(stderr,"Error: Could not read info from signal handler!\n");
 
  proc = processList->first();

  while (0L != proc) {
	if (proc->pid == pid) {
	  // process has exited, so do emit the respective events
	  if (proc->run_mode == MGProcess::Block) {
	    // If the reads are done blocking then set the status in proc
	    // but do nothing else because MGProcess will perform the other
	    // actions of processHasExited.
	    proc->status = status;
	  } else {
	    proc->processHasExited(status);
	  }
	}
	proc = processList->next();
  }
}

MGProcessController::~MGProcessController()
{
  struct sigaction act;

  notifier->setEnabled(FALSE);

  // Turn off notification for processes that have exited
  act.sa_handler=SIG_IGN;
  sigemptyset(&(act.sa_mask));
  sigaddset(&(act.sa_mask), SIGCHLD);
  act.sa_flags = 0;
  sigaction( SIGCHLD, &act, 0L);
  
  close(fd[0]);
  close(fd[1]);
  delete processList;
  delete notifier;
}
//#include "kprocctrl.moc"
