#!/usr/local/bin/perl
#  rep-txn-by-cat.pl - Prints a report of the transactions sorted by category.
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: by-cat.pl,v 2.7 1997/04/23 18:06:23 curt Exp $
# (Log is kept at end of this file)


package CBB;

use strict;    # don't take no guff


my($tmp, $temp, $cbb_incl_dir);
my($credit_total, $debit_total);
my($subtotal);
my($result, $amt, $cmt, $lkey, $lcat);
my($tamt, $tcat, $tcom);
my($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total);
my(%ALLTRANS) = ();
my(%tmp_cat) = ();
my(@keys, @splits);
my($name, $account);


# return the directory of a file name (this is duplicated in common.pl
# but we need this to find the include directory for common.pl :-(
sub my_file_dirname {
    my($file) = @_;
    my($pos);

    $pos = rindex($file, "/");
    if ( $pos >= 0 ) {
	return substr($file, 0, ($pos + 1));
    } else { 
	return "./"; 
    }
}

# specify the installed location of the necessary pieces.
$temp = &my_file_dirname($0); chop($temp);
$cbb_incl_dir = &my_file_dirname($temp);
unshift(@INC, $cbb_incl_dir);

require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";


($#ARGV >= 0) || die "Usage: report [ -from date ] [ -to date] accounts";


# process arguments

my($fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

        $amt = $credit - $debit;

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {

            $ALLTRANS{"$key$name"} = $result;

            if ( substr($cat, 0, 1) ne "|" ) {
                $tmp_cat{$cat} .= "$key$name" . "," . $amt . ",  ,";
            } else {
                # process split

                @splits = split(/\|/, $cat);
                shift(@splits);

                $tmp = 0;
                while ( $#splits >= 0 ) {
                    $tcat = shift(@splits);
                    $tcom = shift(@splits);
                    $tamt = shift(@splits);

                    $tmp += $tamt;

                    # print "processing $tcat $tamt\n";
                    $tmp_cat{$tcat} .= "$key$name" . "," . $tamt . "," . 
			$tcom .  ",";
                }
                if ( sprintf("%.2f", $tmp) ne sprintf("%.2f", $amt) ) {
                    printf("WARNING:  Incorrect splits in $date: $desc\n");
                    printf("    %.2f != %.2f\n\n", $tmp, $amt);
                }
            }
        }

        $result = &next_trans();
    }
}


$credit_total = 0.00;
$debit_total = 0.00;

foreach $lcat (sort keys(%tmp_cat)) {
    chop($tmp_cat{$lcat});  # Delete final comma
    print "$lcat\n";

    @keys = split(/,/, $tmp_cat{$lcat});

    $subtotal = 0.00;

    while ( $#keys >= 0 ) {
        $lkey = shift(@keys);
        $amt  = shift(@keys);
        $cmt = shift(@keys);

        # print $cmt;

	$result = $ALLTRANS{$lkey};

        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

        $subtotal = $subtotal + $amt;
        if ( $amt > 0 ) {
            $credit_total = $credit_total + $amt;
        } else {
            $debit_total = $debit_total + $amt;
        }

        &format_line( $result, $amt, $cmt );
    }

    printf("                                         ---------\n" );
    printf("                              Subtotal = %9.2f\n\n", $subtotal);
}

printf("                                         ---------\n" );
printf("                         Total Credits = %9.2f\n\n", $credit_total);

printf("                                         ---------\n" );
printf("                          Total Debits = %9.2f\n\n", $debit_total);

printf("                                         ---------\n" );
printf("                               Balance = %9.2f\n\n", 
       $credit_total + $debit_total);


sub format_line {
    my($result, $amt, $cmt) = @_;
    my($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
          $total) = split(/\t/, $result);
    my($year,$mon,$day) = $date =~ /(\d\d\d\d)(\d\d)(\d\d)/;
    my($nicedate, $cutdesc, $nicecat);

    $year = substr($year, 2, 4);
    $nicedate = "$mon/$day/$year";
    $desc = "$desc $cmt";
    $cutdesc = substr($desc, 0, 20);
    if ( substr($cat, 0, 1) eq "|" ) {
        $nicecat = "-Splits-";
    }

    printf("  %5s  %-8s  %-20s  %9.2f  %-1s\n",
          $check, $nicedate, $cutdesc, $amt, $cleared);
}



# ----------------------------------------------------------------------------
# $Log: by-cat.pl,v $
# Revision 2.7  1997/04/23 18:06:23  curt
# Fixed a missing "require"
#
# Revision 2.6  1997/01/28 03:25:48  curt
# Force strict scoping in all perl scripts.
#
# Revision 2.5  1996/12/17 14:54:14  curt
# Updated copyright date.
#
# Revision 2.4  1996/12/13 01:25:52  curt
# Modified paths.  Updated to work with reports.tcl
#
# Revision 2.3  1996/07/30 14:38:01  curt
# Added splits comment to description (if room in field.)
#
# Revision 2.2  1996/07/13 02:58:44  curt
# Misc. changes.
#
# Revision 2.1  1996/02/27  05:36:22  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:43:31  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
