(* camlp4r *)
(***********************************************************************)
(*                                                                     *)
(*                             Camlp4                                  *)
(*                                                                     *)
(*        Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt     *)
(*                                                                     *)
(*  Copyright 1998 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* Id *)

type glue = LO | RO | LR | NO;;
type pretty =
    S of glue * string
  | Hbox of pretty Stream.t
  | HVbox of pretty Stream.t
  | HOVbox of pretty Stream.t
  | HOVCbox of pretty Stream.t
  | Vbox of pretty Stream.t
  | BEbox of pretty Stream.t
  | BEVbox of pretty Stream.t
;;

val print_pretty : out_channel -> string -> int -> pretty -> unit;;
val quiet : bool ref;;

(*--*)

val dt : int ref;;
val tol : int ref;;
val sp : char ref;;

type pr_fun =
  (MLast.expr -> string -> pretty Stream.t -> pretty) ->
    (MLast.patt -> string -> pretty Stream.t -> pretty) -> MLast.expr ->
    string -> pretty Stream.t -> pretty
;;
val has_pr_fun : string -> bool;;
val pr_fun : string -> pr_fun;;
val add_pr_fun : string -> pr_fun -> unit;;
