(* camlp4r pa_extend.cmo q_MLast.cmo *)
(***********************************************************************)
(*                                                                     *)
(*                             Camlp4                                  *)
(*                                                                     *)
(*        Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt     *)
(*                                                                     *)
(*  Copyright 1998 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: q_phony.ml,v 2.1 1999/04/26 12:34:03 ddr Exp $ *)

open Pcaml;

EXTEND
  expr:
    [[ "tagada"; s = STRING -> <:expr< $lid:s$ >> ]]
  ;
  patt:
    [[ "tagada"; s = STRING -> <:patt< $lid:s$ >> ]]
  ;
END;

value t = ref "";

Quotation.add ""
  (Quotation.ExStr
     (fun _ s ->
        let t = if t.val = "" then "" else ":" ^ t.val in
        "tagada \"<" ^ t ^ "<" ^ String.escaped s ^ ">>\""))
;

Quotation.default.val := "";
Quotation.translate.val := fun s -> do t.val := s; return "";
