/*
 *  calmwm - the calm window manager
 * 
 *  Copyright (c) 2004 Martin Murray <mmurray@monkey.org>
 *  All rights reserved.
 *
 * $Id: kbfunc.c,v 1.3 2004/08/19 08:37:16 marius Exp $
 */

#include "headers.h"
#include "calmwm.h"

void
kbfunc_client_lower(struct client_ctx *cc, void *arg)
{
	client_lower(cc);
}

void
kbfunc_client_raise(struct client_ctx *cc, void *arg)
{
	client_raise(cc);
}

void
kbfunc_client_search(struct client_ctx *scratch, void *arg)
{
	struct menu_q menuq;
	struct client_ctx *cc, *old_cc = client_current(); 
	struct menu *mi;
	
	TAILQ_INIT(&menuq);
	
	TAILQ_FOREACH(cc, &G_clientq, entry) {
		struct menu *mi;
		XCALLOC(mi);
		strlcpy(mi->text, cc->name, sizeof(mi->text));
		mi->ctx = cc;
		TAILQ_INSERT_TAIL(&menuq, mi, entry);
	}

	if ((mi = search_start(&menuq,
		    search_match_client, NULL, "window")) != NULL) {
		cc = mi->ctx;
		if (cc->flags & CLIENT_HIDDEN)
			client_unhide(cc);

		client_cycle(cc);

		if (old_cc)
			client_ptrsave(old_cc);
		client_ptrwarp(cc);
	}

	while ((mi = TAILQ_FIRST(&menuq)) != NULL) {
		TAILQ_REMOVE(&menuq, mi, entry);
		xfree(mi);
	}
}

void
kbfunc_menu_search(struct client_ctx *scratch, void *arg)
{
	struct menu_q menuq;
	struct menu *mi;
	struct cmd *cmd;

	TAILQ_INIT(&menuq);

	if (conf_cmd_changed(G_conf.menu_path)) {
		conf_cmd_clear(&G_conf);
		conf_cmd_populate(&G_conf, G_conf.menu_path);
	}
	TAILQ_FOREACH(cmd, &G_conf.cmdq, entry) {
		XCALLOC(mi);
		strlcpy(mi->text, cmd->label, sizeof(mi->text));
		mi->ctx = cmd;
		TAILQ_INSERT_TAIL(&menuq, mi, entry);
	}

	if ((mi = search_start(&menuq,
		    search_match_text, NULL, "application")) != NULL)
		u_spawn(((struct cmd *)mi->ctx)->image);

	while ((mi = TAILQ_FIRST(&menuq)) != NULL) {
		TAILQ_REMOVE(&menuq, mi, entry);
		xfree(mi);
	}
}

void
kbfunc_client_cycle(struct client_ctx *cc, void *arg)
{
	struct client_ctx *old_cc;
	struct screen_ctx *sc = CCTOSC(cc);

	old_cc = cc;
	if (cc != NULL)
		client_cycle(cc);
	cc = cycle_next(sc->cycle, 0, !sc->altpersist);
	if (cc != NULL) {
		if (old_cc != NULL)
			client_ptrsave(old_cc);
		client_ptrwarp(cc);
	}
	sc->altpersist = 1; /* This is reset when alt is let go... */
}

void
kbfunc_client_hide(struct client_ctx *cc, void *arg)
{
	client_hide(cc);
}

void
kbfunc_cmdexec(struct client_ctx *cc, void *arg)
{
	u_spawn(arg);
}

void
kbfunc_client_label(struct client_ctx *cc, void *arg)
{
	grab_label(cc);
}

void
kbfunc_client_delete(struct client_ctx *cc, void *arg)
{
	client_send_delete(cc);
}

void
kbfunc_client_groupselect(struct client_ctx *cc, void *arg)
{
	if (G_groupmode)
		group_done();
	else
		group_enter();
}

void
kbfunc_client_group(struct client_ctx *cc, void *arg)
{
	if (G_groupmode)
		group_select((int)arg);
	else
		group_hidetoggle((int)arg);
}

void
kbfunc_client_nextgroup(struct client_ctx *cc, void *arg)
{
	group_slide(1);
}

void
kbfunc_client_prevgroup(struct client_ctx *cc, void *arg)
{
	group_slide(0);
}

void
kbfunc_client_nogroup(struct client_ctx *cc, void *arg)
{
	if (G_groupmode)
		group_deletecurrent();
	else
		group_alltoggle();
}

void
kbfunc_client_maximize(struct client_ctx *cc, void *arg)
{
	client_maximize(cc);
}

void
kbfunc_client_vmaximize(struct client_ctx *cc, void *arg)
{
	client_vertmaximize(cc);
}
