.\" $Id: mt2ct.man,v 2.2 1991/10/30 17:45:48 billr Exp $
.\"
.\" Copyright 1988, 1989, 1991 by Tektronix, Inc. - All Rights Reserved.
.\" 
.\" Permission to use, copy, modify, and distribute this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Tektronix, Inc. not be used in
.\" advertising or publicity pertaining to distribution of the software
.\" without specific, written prior permission.
.\" 
.\" TEKTRONIX INCORPORATED MAKES NO REPRESENTATIONS ABOUT THE
.\" SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS"
.\" WITHOUT EXPRESS OR IMPLIED WARRANTY.  TEKTRONIX INCORPORATED
.\" DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  IN NO
.\" EVENT SHALL TEKTRONIX INCORPORATED BE LIABLE FOR ANY SPECIAL,
.\" INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
.\" LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
.\" OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Author: Bill Randle, Tektronix, Inc. <billr@saab.cna.tek.com>
.\" 
.TH MT2CT 1L "27 February 1991"
.SH NAME
mt2ct, month2ct, cal2ct - appointment file conversion utilities
.SH SYNOPSIS
.B mt2ct
[
.I file
]
.br
.B month2ct
[
.I file
]
.br
.B cal2ct
[
.B \-d
.I date
]
[
.B \-r
.I days
]
[
.B \-f
.I outfile
]
[
.B \-e
]
[
.I file
]
.SH DESCRIPTION
.I Calentool
uses an appointment file format that is incompatable with several
other calendar or reminder programs.  These utilities may be used
to convert from one of those formats to the format
.I calentool
uses.
.LP
.I Mt2ct
converts files maintained by
.I monthtool(1L)
to calentool's .appointment format.
.I Month2ct
converts files maintained by
.I month(1L)
to calentool's .appointment format.
.I Cal2ct
converts files maintained by
.I calendar(1)
to calentool's .appointment format.
In all cases the converted file is written to "$HOME/.appointments".
.SH OPTIONS
An optional filename may be specified for all of the tools to convert.
The default filename depends on the specific conversion.  For
.I monthtool
it is "$HOME/.monthtool".  For
.I month
it is "$HOME/.month".  For
.I calendar
it is "$HOME/.calendar".
.LP
In addition,
.I cal2ct
accepts the following arguments:
.TP 10
.BI \-d \ date
Only convert dates on or after the day
.IR date ,
which may take on several formats:
.RS
.TP
day of current week:
Tue, Th, fr, MONDAY
.TP
numeric dates:
DD (day DD of current month, for example 27 for the 27th of this month)
.br
MO/DD (day DD of month MO, for example 11/12 for November 12)
.br
MO/DD/YY (day DD of month MO, year YY, for example 9/1/88 for 1 September 1988).
(If the
.B \-e
option is used, the date format is DD/MO and DD/MO/YY.
.TP
relative dates:
+n (n days from now, for example +1 for tomorrow)
.br
-n (n days ago, for example -1 for yesterday)
.TP
special names:
.I yesterday, today, tommorrow
.RE
.TP
.BI \-r \ days
Only convert entries for
.I days
days following the starting date.  The starting date is either today's
date or the date set via the
.B \-d
option.
If
.I days
is set to 0, only entries corresponding to
.I date
will be converted.
.TP
.B \-e
Change the format for the date set via the
.B \-d
option to expect DD/MM format rather than the normal MM/DD format.
.TP
.BI \-f \ outfile
Write the converted output into
.I outfile
rather than the default $HOME/.appointments.
.SH "SEE ALSO"
calentool(1L), monthtool(1L), month(1L), calendar(1)
.SH AUTHOR
Bill Randle (Tektronix, Inc., billr@saab.CNA.TEK.COM)
.SH BUGS
.I Monthtool
and
.I month
allow any time selections.  Because
.I calentool
only has 30 minute timeslots, all times are rounded to the nearest
30 minute interval (e.g. 1:10 becomes 1:00, 1:20 becomes 1:30 and
1:50 becomes 2:00).  All
.I calendar
file entries are converted to
.I calentool
notes, since
.I calendar
does not have a standardized way of indicating times.  They can be
manually moved to the proper timeslot using
.I calentool's
.BR cut and paste
operations.  Also, the calendar file entries must have the date at
the start of the line.
.I Cal2ct
also does not invoke the C-preprocessor on the calendar file before
processing.
