/*
 * Calcoo: cpu_mem.c
 *
 * Copyright (C) 2001 Alexei Kaminski
 *
 * handles keypressings for memory operations
 *
 */


#include "const.h"
#include "codes.h"
#include "cpu.h"
#include "cpu_headers.h"
#include "io_headers.h"
#include "aux_headers.h"

void call_mem_op(int received_code)
{
	double tmp;

	input_to_x();

	switch (received_code){
	case CODE_MEM_PLUS  :  
		cpu->mem[cpu->curr_mem] += cpu->x;
		break;
	case CODE_MEM_TO_X  :  
		if (cpu->rpn_mode) {
			if (cpu->last_action == ACTION_INPUT) 
				input_to_x();
			push_stack(); 
			cpu->op = CODE_PUSH;/* it should probably be removed */
			cpu->y = cpu->x;
		}
		cpu->x = cpu->mem[cpu->curr_mem];
		break;
	case CODE_X_TO_MEM :  
		cpu->mem[cpu->curr_mem] = cpu->x;
		break;
	case CODE_EXCH_XMEM :  
		tmp = cpu->x;
		cpu->x = cpu->mem[cpu->curr_mem];
		cpu->mem[cpu->curr_mem] = tmp;
		break;
	default:
		error_occured("call_mem_op() unknown mem_op code",
			      FALSE);
  }

	cpu_to_output();
	cpu->last_action = ACTION_ENTER;
	save_for_undo();
	refresh_body();
}

void call_switch_to_mem(int m)
{
	if ( (m >= 0) && (m < NUMBER_OF_MEMS)) { /* sanity check */
		cpu->curr_mem = m;

		save_for_undo();
		refresh_body();
	} else
		error_occured("call_switch_to_mem() no such memory register",
			      FALSE);

}
