/*
 * Calcoo: body_options.c
 *
 * Copyright (C) 2001 Alexei Kaminski
 *
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "const.h"
#include "defaults.h"
#include "body_headers.h"
#include "aux_headers.h"


/* Careful with these strings! 
 * Their maximum possible length is defined below */
#define RPN_TRUE_STRING "RPN=True\n"
#define RPN_FALSE_STRING "RPN=False\n"

#define ENTER_TRADITIONAL_STRING "Enter_Mode=Traditional\n"
#define ENTER_HP28_STRING "Enter_Mode=HP-28\n"


#define MAX_OPTIONLINE_LENGTH 32
#define MAX_FILENAME_LENGTH 64

static char options_filename[MAX_FILENAME_LENGTH];

void load_options(void)
{
	char s1[MAX_OPTIONLINE_LENGTH], s2[MAX_OPTIONLINE_LENGTH];
	FILE *fp;
/*  	char read_result;  */

	strcpy(options_filename, getenv("HOME"));
	strcat(options_filename, "/.calcoo");

	strcpy(s1," ");
	strcpy(s2," ");

	fp = fopen(options_filename, "r");

	if( fp != NULL )
	{	
		fgets(s1, MAX_OPTIONLINE_LENGTH, fp);
		if (strcmp(s1, RPN_TRUE_STRING) == 0){
			set_rpn_mode(TRUE);
		} else if (strcmp(s1, RPN_FALSE_STRING) == 0){
			set_rpn_mode(FALSE);
		} else {			
			set_rpn_mode(DEFAULT_RPN_MODE);
		}

		fgets(s2, MAX_OPTIONLINE_LENGTH, fp);
		if (strcmp(s2, ENTER_TRADITIONAL_STRING) == 0){
			set_enter_mode(ENTER_MODE_TRADITIONAL);
		} else if (strcmp(s2, ENTER_HP28_STRING) == 0){
			set_enter_mode(ENTER_MODE_HP28);
		} else {			
			set_enter_mode(DEFAULT_ENTER_MODE);
		}

		fclose(fp);
	} else {
		set_rpn_mode(DEFAULT_RPN_MODE);
		set_enter_mode(DEFAULT_ENTER_MODE);
		error_occured("load_options(): could not open options file",
			      FALSE);
	}
}

void save_options(void)
{
	FILE *fp;

	fp = fopen(options_filename,"w");
	if( fp != NULL ){
		if (get_rpn_mode())
			fprintf(fp,"%s", RPN_TRUE_STRING);
		else
			fprintf(fp,"%s", RPN_FALSE_STRING);
		if (get_enter_mode() == ENTER_MODE_TRADITIONAL)
			fprintf(fp,"%s", ENTER_TRADITIONAL_STRING);
		else
			fprintf(fp,"%s", ENTER_HP28_STRING);
		fclose(fp);
	} else
		error_occured("save_options(): could not open options file",
			      FALSE);
}
