/*
 * Calcoo: displays.h
 *
 * Copyright (C) 2001 Alexei Kaminski
 *
 */

#ifndef DISPLAYS_H
#define DISPLAYS_H

#define MAIN_DISPLAY 0
#define MEM_D_N_SHIFT 1 /* the number of the first mem display */
#define REG_D_N_SHIFT (1 + NUMBER_OF_MEMS) /* ... of the first reg display */
#define NUMBER_OF_REG_DISPLAYS 3 /* if you want to change this number, you 
				  * also need to make modifications in 
				  * cpu_to_output() */
#define NUMBER_OF_DISPLAYS ( 1 + NUMBER_OF_MEMS + NUMBER_OF_REG_DISPLAYS )
#define NUMBER_OF_SIMPLE_DISPLAYS (NUMBER_OF_REG_DISPLAYS * 2 + 2)/* format and
								   * deg/rad */

/* don't forget to adjust D_G_TOTAL if you add something to
 * the set below */
/* 0-9 reserved for the digits */
#define D_E     10
#define D_PLUS  11
#define D_MINUS 12
#define D_DOT   13
#define D_TICK  14
#define D_OVERFLOW  15

#define D_G_TOTAL 16 /* this is the number of display glyths: 
		     * 0-9 plus the glyphs defined above */

#define OD_ADD  0
#define OD_SUB  1
#define OD_MUL  2
#define OD_DIV  3
#define OD_POW  4
#define OD_PAREN 5

#define OD_G_TOTAL  6 /* the number of operation display symbols */

#define LD_N_SHIFT NUMBER_OF_REG_DISPLAYS
#define LD_G_TOTAL NUMBER_OF_REG_DISPLAYS

#define DRD_DEG 0
#define DRD_RAD 1

#define DRD_G_TOTAL 2

#define I_DRD ( NUMBER_OF_REG_DISPLAYS * 2 )

#define FD_FP 0
#define FD_EXP 1
#define FD_ENG 2

#define FD_G_TOTAL 3

#define I_FD (NUMBER_OF_REG_DISPLAYS * 2 + 1)



#endif  /* DISPLAYS_H */
