/*
 * Calcoo: body.h
 *
 * Copyright (C) 2001 Alexei Kaminski
 *
 */

#ifndef BODY_H
#define BODY_H

#include "basic.h"
#include "displays.h"

#define SEPARATOR_NUMBER 10

typedef struct tbd {
	GtkWidget *minus_sign[INPUT_LENGTH];
	GtkWidget *int_digits[INPUT_LENGTH][BASE];  
	GtkWidget *frac_digits[INPUT_LENGTH][BASE]; 
	GtkWidget *int_ticks[INPUT_LENGTH];
	GtkWidget *frac_ticks[INPUT_LENGTH];
	GtkWidget *dot[INPUT_LENGTH];   
	GtkWidget *E;
	GtkWidget *exp_plus_sign, *exp_minus_sign;
	GtkWidget *exp_digits[EXP_INPUT_LENGTH][BASE]; 
	GtkWidget *error_message;
	GtkWidget *frame;
} t_body_display ;


typedef struct tbsd {
	GtkWidget *glyph[SD_G_MAX];
	GtkWidget *frame;
} t_body_simple_display;

typedef struct tcb {
	GtkWidget *main_window;
	GtkWidget *fixer; /* the parent widget of buttons and displays, 
			     to prevent their resizing */

	GtkWidget *button[MAX_BUTTON_NUMBER];
	GtkWidget *icon[MAX_BUTTON_NUMBER];
	GtkTooltips *button_tooltips;

	t_body_display *display[NUMBER_OF_DISPLAYS];
	t_body_simple_display *simple_display[NUMBER_OF_SIMPLE_DISPLAYS];

	GtkWidget *op_display_label[NUMBER_OF_REG_DISPLAYS];
	char char_display[INPUT_LENGTH + EXP_INPUT_LENGTH + 5];
	GtkWidget *deg_rad_button, *forced_e_button;
        GtkWidget *deg_rad_frame, *forced_e_frame;
	GtkWidget *deg_icon, *rad_icon, *forced_e_icon;
	GtkWidget *separator[SEPARATOR_NUMBER];

	GtkAccelGroup *accel_group;
	GtkStyle  *style;
} t_calcoo_body ;

extern t_calcoo_body *body;

#endif /* BODY_H */

