#****h* calc/rpm.mk
# NAME
#   rpm.mk -- makefile for building rpm package for calc
# SYNOPSIS
#   make -f rpm.mk
#   make -f rpm.mk test
# PURPOSE
#   Easy way to make RPM_TOOL package.
# MODIFICATION HISTORY
#   2003-02-25/chongo: Rename calc rpm to be an .i686 rpm.
#   2003-02-24/chongo: uses calc ${T} in build, has Requires & BuildRequires
#   2003-02-18/chongo: minor changes to fit local build environment
#   2003-02-16/petterik: initial RPM_TOOL build
# SEE ALSO
#   Makefile
#   calc.spec
#   http://freshrpms.net/docs/fight.html
#   http://www.rpm.org/RPM_TOOL-HOWTO/build.html
#   http://www.isthe.com/chongo/tech/comp/calc/index.html
#

# $Id: rpm.mk,v 29.9 2003/02/25 20:16:54 chongo Exp $

# setup
#
SHELL= /bin/sh
RPMBUILD_TOOL= rpmbuild
RPM_TOOL= rpm
MD5SUM= md5sum
SHA1SUM= sha1sum
SED= sed

# rpm-related parameters
#
PROJECT_NAME= calc
PROJECT_VERSION=
PROJECT_RELEASE= 1
PROJECT= $(PROJECT_NAME)-$(PROJECT_VERSION)
SPECFILE= $(PROJECT_NAME).spec
TARBALL= $(PROJECT).tar.gz
RPM386= $(PROJECT)-$(PROJECT_RELEASE).i386.rpm
RPM686= $(PROJECT)-$(PROJECT_RELEASE).i686.rpm
DRPM= $(PROJECT_NAME)-devel-$(PROJECT_VERSION)-$(PROJECT_RELEASE).i386.rpm
SRPM= $(PROJECT)-$(PROJECT_RELEASE).src.rpm
TMPDIR= /var/tmp
RHDIR= /usr/src/redhat

all: calc.spec ver_calc
	$(MAKE) -f rpm.mk PROJECT_VERSION="`./ver_calc`" rpm

pkgme: $(PROJECT_NAME)-spec.tar.gz

ver_calc:
	$(MAKE) -f Makefile ver_calc

.PHONY: vers
vers:
	$(MAKE) -f Makefile ver_calc

calc.spec: calc.spec.in ver_calc
	rm -f calc.spec
	${SED} -e 's/<<<PROJECT_VERSION>>>/'"`./ver_calc`"/g \
	       -e 's/<<<PROJECT_RELEASE>>>/${PROJECT_RELEASE}/g' \
	    calc.spec.in > calc.spec

.PHONY: srcpkg
srcpkg: make_rhdir
	find . -depth -print | egrep -v '/RCS|/CVS|/NOTES|\.gone' | \
	    cpio -dumpv $(TMPDIR)/$(PROJECT)
	(cd $(TMPDIR); tar cf - $(PROJECT) | \
	  gzip -c > $(RHDIR)/SOURCES/$(TARBALL))
	rm -fr $(TMPDIR)/$(PROJECT)

.PHONY: rpm
rpm: srcpkg calc.spec
	$(MAKE) -f Makefile clean
	cp $(SPECFILE) $(RHDIR)/SPECS/$(SPECFILE)
	rm -f $(RHDIR)/RPMS/i386/$(RPM386)
	${RPMBUILD_TOOL} -ba $(RHDIR)/SPECS/$(SPECFILE)
	@if [ ! -f "RPMS/i386/$(RPM686)" ]; then \
	    rm -f "$(RHDIR)/RPMS/i386/$(RPM686)"; \
	    echo mv -f "$(RHDIR)/RPMS/i386/$(RPM386)" \
	    	       "$(RHDIR)/RPMS/i386/$(RPM686)"; \
	    mv -f "$(RHDIR)/RPMS/i386/$(RPM386)" \
	    	  "$(RHDIR)/RPMS/i386/$(RPM686)"; \
	fi
	@echo
	@echo "RPM package sizes:"
	@echo
	@cd $(RHDIR); ls -1s RPMS/i386/$(RPM686) \
	    RPMS/i386/$(DRPM) SRPMS/$(SRPM)
	@echo
	@echo "RPM package md5 hashes:"
	@echo
	-@cd $(RHDIR); ${MD5SUM} RPMS/i386/$(RPM686) \
	    RPMS/i386/$(DRPM) SRPMS/$(SRPM)
	@echo
	@echo "RPM package sha1 hashes:"
	@echo
	-@cd $(RHDIR); ${SHA1SUM} RPMS/i386/$(RPM686) \
	    RPMS/i386/$(DRPM) SRPMS/$(SRPM)
	@echo
	@echo "RPM package locations:"
	@echo
	@ls -1 $(RHDIR)/RPMS/i386/$(RPM686) \
	    $(RHDIR)/RPMS/i386/$(DRPM) $(RHDIR)/SRPMS/$(SRPM)
	@echo
	@echo "All done! -- Jessica Noll, Age 2"


.PHONY: make_rhdir
make_rhdir:
	for i in $(RHDIR) $(RHDIR)/RPMS $(RHDIR)/SOURCES \
	  $(RHDIR)/SPECS $(RHDIR)/SRPMS $(RHDIR)/BUILD; do \
	    if [ ! -d $$i ] ; then \
		mkdir -p $$i; \
	    fi; \
	done;

# date format for spec file
.PHONY: logdate
logdate:
	echo "`date +'* %a %b %d %Y'` `whoami`"

.PHONY: chkpkg
chkpkg:
	for i in $(RHDIR)/RPMS/i386/$(RPM686) $(RHDIR)/RPMS/i386/$(DRPM) \
	  $(RHDIR)/SRPMS/$(SRPM) ; do \
	    echo "***** start $$i" ; \
		${RPM_TOOL} -qpi $$i ; \
		echo "***** files $$i" ; \
	    ${RPM_TOOL} -qpl $$i ; \
	    echo "***** end $$i" ; \
	done ;

.PHONY: chksys
chksys:
	${RPM_TOOL} -qa | grep $(PROJECT_NAME)
	${RPM_TOOL} -qa | grep $(PROJECT_NAME)-devel

.PHONY: test
test: ver_calc
	@if [ X"`id -u`" != X"0" ]; then \
	    echo "test needs to install, must be root to test" 1>&2; \
	    exit 1; \
	fi
	$(MAKE) -f rpm.mk PROJECT_VERSION="`./ver_calc`" installrpm chksys

.PHONY: installrpm
installrpm:
	@if [ X"`id -u`" != X"0" ]; then \
	    echo "must be root to install RPMs" 1>&2; \
	    exit 1; \
	fi
	${RPM_TOOL} -ivh $(RHDIR)/RPMS/i386/$(RPM686)
	${RPM_TOOL} -ivh $(RHDIR)/RPMS/i386/$(DRPM)

.PHONY: uninstallrpm
uninstallrpm:
	@if [ X"`id -u`" != X"0" ]; then \
	    echo "must be root to uninstall RPMs" 1>&2; \
	    exit 1; \
	fi
	${RPM_TOOL} -e $(PROJECT_NAME)-devel
	${RPM_TOOL} -e $(PROJECT_NAME)

$(PROJECT_NAME)-spec.tar.gz: rpm.mk $(PROJECT_NAME).spec.in
	tar cf - $^ | gzip -c > $@

#****
