/****************************************************************************
**
** $Id: main.cpp,v 1.21 2001/09/28 03:37:19 mishima Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#include <qtranslator.h>
#include <qtextcodec.h>
#include "config.h"
#include "ac_system_defs.h"

#define MAIN

#ifdef KDE2
 #include <kapp.h>
 KApplication* theApp;
#else
 #include <qapplication.h>
 QApplication* theApp;
#endif

//----------------------------------------------------------------------------

#include "globals.h"
#include "lincvs.h"

//----------------------------------------------------------------------------
ApplicationWindow  *LinMainW;

int main( int argc, char ** argv ) 
{
   determineTimeZoneDiff();

#ifdef KDE2
   KApplication a(argc,argv,"LinCVS");
#else
   QApplication a(argc,argv);
#endif

   bool bIconic = false;
   bUseSmallIcons = false;

   QString arg;
   int i;
   for (i = 0; i < a.argc(); i++) {    // a.argc() == argc
     arg = a.argv()[i];                 // a.argv()[i] == argv[i]
     if ((arg == "-i") || (arg == "--iconic")) bIconic = true;
     if ((arg == "-s") || (arg == "--small-icons")) bUseSmallIcons = true;
     if ((arg == "-v") || (arg == "--version")) {
       cout << "LinCVS version " << VERSION << "\n";
     }
     if ((arg == "-h") || (arg == "--help")) {
       cout << "Usage: LinCVS [options]\n";
       cout << "where options are:\n";
       cout << "\t-i --iconic        start iconized\n";
       cout << "\t-s --small-icons   use small icons (useful on some window managers)\n";
       cout << "\t-v --version       show version\n";
       cout << "\t-h --help          show this text\n\n";
       return 0;
     }
   }

   QString lang = QString(QTextCodec::locale()).left(2);
   QTranslator translator( 0 );
   if(lang == "ja"){
      translator.load( "lincvs", "." );
      a.installTranslator( &translator );
   }

   LinMainW = new ApplicationWindow();
#ifdef KDE2
   LinMainW->setCaption( "LinCVS - KDE2-Version" );
#else
   LinMainW->setCaption( "LinCVS - Qt Version" );
#endif

   QPoint bottomRightDesktop = QApplication::desktop()->geometry().bottomRight();
   QRect  mainWidgetGeom( GEOM_X, GEOM_Y, GEOM_WIDTH, GEOM_HEIGHT);
   QPoint topLeftMainWidget = mainWidgetGeom.topLeft();
   if( (topLeftMainWidget.x() > bottomRightDesktop.x()) ||
       (topLeftMainWidget.y() > bottomRightDesktop.y()))
      mainWidgetGeom.moveTopRight( QPoint(0,0));
   LinMainW->setGeometry( mainWidgetGeom);

   if (bIconic) LinMainW->showMinimized();
   else LinMainW->show();
   
   a.setMainWidget(LinMainW);

   a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
   return a.exec();
}
