/****************************************************************************
**
** $Id: dialogs.h,v 1.5 2001/07/18 23:10:27 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef DIALOGS_H_20010626
#define DIALOGS_H_20010626

//----------------------------------------------------------------------------

#include "config.h"
#include "ac_system_defs.h"


#include <qdialog.h>
class QLineEdit;
class QMultiLineEdit;
class QComboBox;
class QButtonGroup;
class QRadioButton;
class QCheckBox;
class QStringList;

//----------------------------------------------------------------------------

#include "globals.h"
#include "controls.h"

//----------------------------------------------------------------------------

const int MODE_PSERVER = 0;
const int MODE_RSH     = 1;
const int MODE_LOCAL   = 2;

//----------------------------------------------------------------------------

class CheckOutAndImportDlg: public QDialog
{
   Q_OBJECT
public:
   CheckOutAndImportDlg(int *lastAccessMethod,
                        QStringList *userList,
                        QStringList *moduleList,
                        QStringList *serverList,
                        QStringList *repositoryList,
                        QStringList *localDirList,
                        QStringList *profileList,
                        QStringList *vendorTagList,
                        QStringList *releaseTagList,
                        QString *lastComment,
                        QStringList *tagList, bool checkoutImport01, 
                        QString caption, QWidget *parent=0, 
                        const char *name=0, bool modal=TRUE, WFlags f=0 );
    
   QString user();
   QString module();
   QString server();
   QString repository();
   QString localDir();
   QString comment();
   QString tag1();
   QString tag2();

   //schreibe die werte der controls zurueck in die zeiger
   void adaptStatePointer();
   
   int mode()                 {return m_mode;}
   int rshMode();
   QString cvsRsh() {return m_pRshLine->text();}
   QString cvsParameter();
   
protected slots:   
   void showDirOpenDlg();
   void chooseMode(int);
   void chooseRshMethod(bool);
   void setMaximumHeightSlot();
   void getModule(void);
   void insertModule(const QString& cvsMod);
   void insertRootDir(QString rootDir);
   void updateComboBoxes(const QString &item);
   void updateComboBoxList(QStringList *plist, QComboBox *pbox);
   int findlistIndex(QStringList *list, const QString item);
   
   
   
   
                                                         
protected:
   int            *m_pLastAccessMethod;
   QStringList    *m_pUserList;
   QStringList    *m_pModuleList;
   QStringList    *m_pServerList;
   QStringList    *m_pRepositoryList;
   QStringList    *m_pLocalDirList;
   QStringList    *m_pProfileList;
   QStringList    *m_pVendorTagList;
   QStringList    *m_pReleaseTagList;
   QString        *m_pLastComment;

   QComboBox      *m_pUser;
   QComboBox      *m_pLineModule;
   QComboBox      *m_pLineServer;
   QComboBox      *m_pRepository;
   QComboBox      *m_pLineLocalDir;
   QComboBox      *m_pProfile;
   QComboBox      *m_pMode;
   QButtonGroup   *m_pRshBox;
   QRadioButton   *m_pExt;
   QRadioButton   *m_pServer;
   QLineEdit      *m_pRshLine;
   QComboBox      *m_pTag1;
   QComboBox      *m_pTag2;
   QMultiLineEdit *m_pComment;
   int             m_mode;

   TagOperationControl *m_pTagCtl;
   bool            m_checkoutImport01;


  

};


class TagUpdateDlg: public QDialog
{
   Q_OBJECT
public:
   TagUpdateDlg(QStringList *tagList, QString caption, QWidget *parent=0, 
          const char *name=0, bool modal=TRUE, WFlags f=0 );

   QString cvsParameter();

protected:
   TagOperationControl *m_pTagCtl;

protected slots:
   void setMaximumHeightSlot();
};

//----------------------------------------------------------------------------

class WarningDlg: public QDialog
{
   Q_OBJECT
public:
   WarningDlg(QString title, QString text, QWidget *parent=0);
   
   bool showWarningNextTime();

protected:
   QCheckBox *m_pCheckBox;
};   
   
//----------------------------------------------------------------------------
      
#endif   //DIALOGS_H_20010626
