#!/usr/bin/python

from distutils.core import setup

# FIXME: pull this in from a central file
VERSION = "0.3.1"

setup(name='telepathy-pinocchio',
      version=VERSION,
      package_dir={'pinocchio': 'pinocchio'},
      packages=['pinocchio',
                'pinocchio.connection',
                'pinocchio.channel',
                'pinocchio.server',
               ],
      data_files=[('bin', ['bin/pinocchio-ctl']),
                  ('share/telepathy/managers', ['data/pinocchio.manager']),
                  ('share/dbus-1/services',
                    ['data/org.freedesktop.Telepathy.ConnectionManager'
                                                   '.pinocchio.service']),
                  ('/var/lib/telepathy-pinocchio/accounts/'
                                                    'anotherdefault_40default',
                    ['data/accounts/anotherdefault_40default/contacts.xml']),
                  ('/var/lib/telepathy-pinocchio/accounts/default_40default',
                    ['data/accounts/default_40default/contacts.xml']),
                  ('/var/lib/telepathy-pinocchio/avatars',
                    ['data/avatars/a.png',
                     'data/avatars/avatar.png',
                     'data/avatars/b.png',
                     'data/avatars/c.png',
                     'data/avatars/foo_bar_baz.png',
                     'data/avatars/qux.jpg']),
                  ('lib/telepathy', ['libexec/telepathy-pinocchio']),
                  ('lib/telepathy', ['libexec/telepathy-pinocchio-wrapper.sh'])]
     )

