/*
 * ellipse.c -- $Id$
 * p_ellipse for MS Windows
 *
 * Copyright (c) 2000.  See accompanying LEGAL file for details.
 */

#include "playw.h"

/* Win9x does not support the Ellipse primitive in paths
 */

void
p_ellipse(p_win *w, int x0, int y0, int x1, int y1, int border)
{
  HDC dc;
  if (border) {
    dc = w_getdc(w, 2);
    if (dc && !(w->color_set&8)) {
      HBRUSH b = SelectObject(dc, GetStockObject(NULL_BRUSH));
      if (b) DeleteObject(b);
      w->color_set &= ~4;
      w->color_set |= 8;
    }
  } else {
    dc = w_getdc(w, 4);
    if (dc && !(w->color_set&16)) {
      HPEN pen;
      w->color_set &= ~2;
      pen = CreatePen(PS_NULL, 0, 0);
      if (!pen) return;
      pen = SelectObject(dc, pen);
      if (pen) DeleteObject(pen);
      w->color_set |= 16;
    }
  }
  if (dc)
    Ellipse(dc, x0, y0, x1+1+(!border), y1+1+(!border));
}
