%  Copyright (C) 2002-2004 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\begin{code}
module DarcsFlags ( DarcsFlag( .. ) ) where
import PatchMatchData ( PatchMatch )
\end{code}

\begin{code}
data DarcsFlag = Help | ListOptions | NoTest | Test
               | LeaveTestDir | NoLeaveTestDir
               | Verbose | NormalVerbosity | Quiet
               | Target String | Cc String | Output String
               | SendmailCmd String | Author String | PatchName String
               | OnePatch String | SeveralPatch String
               | AfterPatch String | UpToPatch String
               | TagName String | LastN Int
               | OneTag String | AfterTag String | UpToTag String
               | Context String | ModernizePatches
               | LogFile String | RmLogFile
               | DistName String | All
               | Recursive | NoRecursive | Reorder
               | AskDeps | NoAskDeps | IgnoreTimes | LookForAdds | NoLookForAdds
               | AnyOrder | CreatorHash String
               | Sign | SignAs String | NoSign | SignSSL String
               | HappyForwarding
               | Verify String | VerifySSL String | EditDescription
               | Toks String
               | EditLongComment | NoEditLongComment | PromptLongComment
               | RepoName String
               | AllowConflicts | MarkConflicts | NoAllowConflicts
               | Boring | AllowCaseOnly
               | DontGrabDeps | Compress | NoCompress | UnCompress
               | WorkDir String | RepoDir String
               | Reply String | ApplyAs String
               | MachineReadable | HumanReadable
               | Pipe | Gui | Interactive
               | ExternalMerge String | Summary | NoSummary
               | Unified | Reverse
               | CheckPoint | Partial | Complete
               | FixFilePath String | DiffFlags String
               | XMLOutput
               | ForceReplace
               | OnePattern PatchMatch | SeveralPattern PatchMatch
               | AfterPattern PatchMatch | UpToPattern PatchMatch
               | NonApply | NonVerify | NonForce
               | DryRun | SetDefault | NoSetDefault
               | FancyMoveAdd | NoFancyMoveAdd
               | Disable | SetScriptsExecutable | DontSetScriptsExecutable
               | PristinePlain | PristineNone
               | Sibling String | Relink | RelinkPristine
               | Files | NoFiles | Directories | NoDirectories
               | Pending | NoPending
               | PosthookCmd String | NoPosthook | AskPosthook | RunPosthook
               | NullFlag
                 deriving ( Eq, Show )
\end{code}

