/*
**  Copyright (c) 2006-2008 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: dkim-config.h,v 1.51 2008/03/04 22:50:22 msk Exp $
*/

#ifndef _DKIM_CONFIG_H_
#define _DKIM_CONFIG_H_

#ifndef lint
static char dkim_config_h_id[] = "@(#)$Id: dkim-config.h,v 1.51 2008/03/04 22:50:22 msk Exp $";
#endif /* !lint */

struct configdef dkimf_config[] =
{
	{ "AlwaysAddARHeader",		CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "AlwaysSignHeaders",		CONFIG_TYPE_STRING,	FALSE },
#ifdef _FFR_AUTHSERV_JOBID
	{ "AuthservIDWithJobID",	CONFIG_TYPE_BOOLEAN,	FALSE },
#endif /* _FFR_AUTHSERV_JOBID */
	{ "AutoRestart",		CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "AutoRestartCount",		CONFIG_TYPE_INTEGER,	FALSE },
	{ "AutoRestartRate",		CONFIG_TYPE_STRING,	FALSE },
	{ "Background",			CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "BodyLengths",		CONFIG_TYPE_BOOLEAN,	FALSE },
#if _FFR_BODYLENGTH_DB
	{ "BodyLengthDBFile",		CONFIG_TYPE_STRING,	FALSE },
#endif /* _FFR_BODYLENGTH_DB */
	{ "Canonicalization",		CONFIG_TYPE_STRING,	FALSE },
	{ "ClockDrift",			CONFIG_TYPE_INTEGER,	FALSE },
	{ "Diagnostics",		CONFIG_TYPE_BOOLEAN,	FALSE },
#ifdef _FFR_ZTAGS
	{ "DiagnosticDirectory",	CONFIG_TYPE_STRING,	FALSE },
#endif /* _FFR_ZTAGS */
	{ "DNSTimeout",			CONFIG_TYPE_INTEGER,	FALSE },
	{ "Domain",			CONFIG_TYPE_STRING,	FALSE },
	{ "ExternalIgnoreList",		CONFIG_TYPE_STRING,	FALSE },
	{ "FixCRLF",			CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "KeyFile",			CONFIG_TYPE_STRING,	FALSE },
	{ "KeyList",			CONFIG_TYPE_STRING,	FALSE },
	{ "Include",			CONFIG_TYPE_INCLUDE,	FALSE },
	{ "InternalHosts",		CONFIG_TYPE_STRING,	FALSE },
	{ "MaximumHeaders",		CONFIG_TYPE_INTEGER,	FALSE },
	{ "MaximumSignedBytes",		CONFIG_TYPE_INTEGER,	FALSE },
	{ "MacroList",			CONFIG_TYPE_STRING,	FALSE },
	{ "MilterDebug",		CONFIG_TYPE_INTEGER,	FALSE },
	{ "Minimum",			CONFIG_TYPE_STRING,	FALSE },
	{ "Mode",			CONFIG_TYPE_STRING,	FALSE },
	{ "MTA",			CONFIG_TYPE_STRING,	FALSE },
	{ "OmitHeaders",		CONFIG_TYPE_STRING,	FALSE },
	{ "On-BadSignature",		CONFIG_TYPE_STRING,	FALSE },
	{ "On-Default",			CONFIG_TYPE_STRING,	FALSE },
	{ "On-DNSError",		CONFIG_TYPE_STRING,	FALSE },
	{ "On-InternalError",		CONFIG_TYPE_STRING,	FALSE },
	{ "On-NoSignature",		CONFIG_TYPE_STRING,	FALSE },
	{ "On-Security",		CONFIG_TYPE_STRING,	FALSE },
	{ "On-SignatureMissing",	CONFIG_TYPE_STRING,	FALSE },
	{ "PeerList",			CONFIG_TYPE_STRING,	FALSE },
	{ "PidFile",			CONFIG_TYPE_STRING,	FALSE },
#ifdef POPAUTH
	{ "POPDBFile",			CONFIG_TYPE_STRING,	FALSE },
#endif /* POPAUTH */
	{ "TestPublicKeys",		CONFIG_TYPE_STRING,	FALSE },
	{ "Quarantine",			CONFIG_TYPE_BOOLEAN,	FALSE },
#ifdef QUERY_CACHE
	{ "QueryCache",			CONFIG_TYPE_BOOLEAN,	FALSE },
#endif /* QUERY_CACHE */
	{ "RemoveARAll",		CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "RemoveARFrom",		CONFIG_TYPE_STRING,	FALSE },
	{ "RemoveOldSignatures",	CONFIG_TYPE_BOOLEAN,	FALSE },
#ifdef _FFR_REPLACE_RULES
	{ "ReplaceRules",		CONFIG_TYPE_STRING,	FALSE },
#endif /* _FFR_REPLACE_RULES */
#ifdef _FFR_REQUIRED_HEADERS
	{ "RequiredHeaders",		CONFIG_TYPE_BOOLEAN,	FALSE },
#endif /* _FFR_REQUIRED_HEADERS */
	{ "Selector",			CONFIG_TYPE_STRING,	FALSE },
#ifdef _FFR_SELECTOR_HEADER
	{ "SelectorHeader",		CONFIG_TYPE_STRING,	FALSE },
#endif /* _FFR_SELECTOR_HEADER */
	{ "SendReports",		CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "SignatureAlgorithm",		CONFIG_TYPE_STRING,	FALSE },
	{ "SignatureTTL",		CONFIG_TYPE_INTEGER,	FALSE },
	{ "SignHeaders",		CONFIG_TYPE_STRING,	FALSE },
	{ "Socket",			CONFIG_TYPE_STRING,	FALSE },
#ifdef _FFR_STATS
	{ "Statistics",			CONFIG_TYPE_STRING,	FALSE },
#endif /* _FFR_STATS */
	{ "StrictTestMode",		CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "SubDomains",			CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "Syslog",			CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "SyslogFacility",		CONFIG_TYPE_STRING,	FALSE },
	{ "SyslogSuccess",		CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "UMask",			CONFIG_TYPE_INTEGER,	FALSE },
	{ "UseASPDiscard",		CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "UserID",			CONFIG_TYPE_STRING,	FALSE },
#ifdef _FFR_VBR
	{ "VBR-Certifiers",		CONFIG_TYPE_STRING,	FALSE },
	{ "VBR-TrustedCertifiers",	CONFIG_TYPE_STRING,	FALSE },
	{ "VBR-Type",			CONFIG_TYPE_STRING,	FALSE },
#endif /* _FFR_VBR */
	{ "X-Header",			CONFIG_TYPE_BOOLEAN,	FALSE },
	{ NULL,				-1,			FALSE }
};

#endif /* _DKIM_CONFIG_H_ */
