#include <iostream>
#include "Clo.hh"

using namespace std;
int main(int argc, char *argv[]) {
	Clo::Parser	clo;

	// wrap the command line parse in a try
	// so that you can catch bad arguments
	// and --help and --version if autohelp
	// or autoversion is turned on
	try {
		clo.parse(argc, argv);
	} catch (Clo::Exception e) {
		// autohelp will be true if the user typed --help or -h
		if (e.autohelp) {
			cout << "Usage: " << argv[0] << " [options] command [options]" << endl;
			cout << e.fancy();
			return 0;
		} else if (e.autoversion) { // autoversion is like autohelp but with --version and -v
			cout << "The Complete Example version " << VERSION << endl;
			return 0;
		} else { // otherwise the user gave a bad option or something like that
			cerr << e.fancy();
			return 1;
		}
	}

	// This is how you get standard options
	cout << "--count or -c with: " << clo.get_count_option("count") << endl;
	cout << "--flag or -f is:    " << clo.get_flag_option("flag") << endl;
	cout << "--bool or -b is:    " << clo.get_bool_option("bool") << endl;
	cout << "--int or -i is:     " << clo.get_int_option("int") << endl;
	cout << "--double or -d is:  " << clo.get_double_option("double") << endl;
	cout << "--string or -s is:  " << clo.get_string_option("string") << endl;

	// here is how to get that list item
	vector<int> int_list = clo.get_int_list("int-list");
	vector<int>::iterator int_it;
	cout << "--int-list is:";
	for (int_it=int_list.begin(); int_it!=int_list.end(); int_it++) {
		cout << " " << *int_it;
	}
	cout << endl;

	// here is hot to get a map option
	map<string, bool> bool_map = clo.get_bool_map("bool-map");
	map<string, bool>::iterator bool_it;
	cout << "--bool-map is:";
	for (bool_it=bool_map.begin(); bool_it!=bool_map.end(); bool_it++) {
		if (bool_it != bool_map.begin()) cout << " and";
		cout << " " << bool_it->first << " is set to " << bool_it->second;
	}
	cout << endl;

	// another check for a flag that shows
	// you how to get usage info from clo
	// this is avaliable even when autohelp is off
	if (clo.get_flag_option("usage"))
		cout << clo.usage() << endl;

	// here is how to find out the name of the subcommand
	// if your prorgram uses them
	cout << "Ahh, the command you used was: " << clo.get_command() << endl;

	// here is how to get option values for subcommands
	if (clo.get_command() == "remove") {
		if (clo.get_flag_option("f", "remove"))
			cout << "Hey, you gave the -f option to the remove command!" << endl;
	} else if (clo.get_command() == "water") {
		cout << "Hey, you gave the water command with --speed set to ";
		cout << clo.get_int_option("speed", "water") << endl;
	}

	// and this is how to get the list of files given to your app
	vector<string> files = clo.get_file_list();
	vector<string>::iterator file_it;
	cout << "Here are the filenames you gave:";
	for (file_it=files.begin(); file_it!=files.end(); file_it++) {
		cout << " " << *file_it;
	}
	cout << endl;

	return 0;
}
