// This file generated by clo++, do not edit.
#ifndef __Clo_Parser__
#define __Clo_Parser__
#include <exception>
#include <vector>
#include <string>
#include <cstring>
#include <map>
#include <cctype>
#include <cstdlib>
#include <climits>

// Use namespaces to keep things clean.
namespace Clo {
	using namespace std;
	bool truth_function(string test);
bool truth_function(string test) {
	if (
		(strcasecmp(test.c_str(), "true") == 0) 	|| 
		(strcasecmp(test.c_str(), "on") == 0) 		|| 
		(strcasecmp(test.c_str(), "yes") == 0)
	){
		return true;
	}

	return false;
}

	const string k_usage =
		"-B, --bool-map key=boolean"
		"  this is a test of the bool type in map format (may\n                            be repeated)\n"
		"-L, --int-list interger"
		"     this is a test of the int type in list format (may\n                            be repeated)\n"
		"-b, --bool boolean"
		"          this is a test of the Option::type_bool\n"
		"-c, --count"
		"                 this is a test of the Option::type_count\n"
		"-d, --double number"
		"         this is a test of the Option::type_double\n"
		"-f, --flag"
		"                  this is a test of the Option::type_flag\n"
		"-h, --help"
		"                  this message\n"
		"--help-aliases"
		"              print a list of commands and their aliases\n"
		"--help-commands"
		"             print a list of commands and their descriptions\n"
		"-i, --int interger"
		"          this is a test of the Option::type_int\n"
		"-s, --string somestring"
		"     this is a test of the Option::type_string\n"
		"-u, --usage"
		"                 tack this usage to the end of the output plus this\n                            option description is long and needs to be wraped.\n"
		"-v, --version"
		"               print version information\n"
		; // end of k_usage
	
	const string k_command_help =
		"remove"
		"  very fake unix rm command\n"
		"water"
		"   demonstrate mandatory options\n"
		"\n(for help with a specific command, try '<command> --help')\n"
		"(for a list of command aliases use the --help-aliases option)\n"
		; // end of k_command_help
	
	const string k_command_aliases =
		"remove"
		"  rm del trash\n"
		"water"
		"   aqua\n"
		"\n(for help with a specific command, try '<command> --help')\n"
		; // end of k_command_aliases
	
	const string k_v_remove_usage =
		"-R"
		"          Attempt to remove the file hierarchy rooted in each file argument.\n            The -R option implies the -d option. If the -i option is specified,\n            the user is prompted for confirmation before each directory's\n            contents are processed (as well as before the attempt is made to\n            remove the directory). If the user does not respond affirmatively,\n            the file hierarchy root\n"
		"-f"
		"          Attempt to remove the files without prompting for confirmation,\n            regardless of the file's permissions. If the file does not exist,\n            do not display a diagnostic message or modify the exit status to\n            reflect an error. The -f option overrides any previous -i options.\n"
		"-h, --help"
		"  this message\n"
		; // end of k_v_remove_usage
	
	const string k_v_water_usage =
		"-h, --help"
		"       this message\n"
		"-s, --speed mph"
		"  how fast should the water move in MPH (must be present on\n                 command line)\n"
		; // end of k_v_water_usage
	
	class Parser {
		public:
			void parse(int argc, char *argv[]);
			string usage(string command="") {
				if (command == "remove") {
					return k_v_remove_usage;
				} else if (command == "water") {
					return k_v_water_usage;
				} else {
					return k_usage;
				}
			}
			vector<string> &get_file_list() {return m_file_list;}
			string get_command(){return m_command;}
			bool get_flag_option(string option, string command="");
			int get_count_option(string option, string command="");
			bool get_bool_option(string option, string command="");
			map<string, bool>& get_bool_map(string option, string command="");
			int get_int_option(string option, string command="");
			vector<int>& get_int_list(string option, string command="");
			double get_double_option(string option, string command="");
			string get_string_option(string option, string command="");
		private:
			struct Values {
				bool v_flag;
				int v_count;
				bool v_bool;
				int v_int;
				double v_double;
				string v_string;
				vector<int> v_int_list;
				map<string, bool> v_bool_map;
				bool v_usage;
				bool v_R;
				bool v_f;
				int v_speed;
			};
			
			enum State {
				state_option,
				state_value
			};
			
			vector<string> m_file_list;
			Values m_values;
			string m_command;
	}; // End class
	
	class Exception : public exception {
		public:
			Exception(int argc, char *argv[], int which, string why) {
				int count=-1; size_t offset=0, length=0; m_why = why;
				while (++count < argc) {
					if (which == count) length = strlen(argv[count]);
					if (!length) offset += strlen(argv[count]) + 1;
					m_fancy += argv[count]; m_fancy += ' ';
				}
				m_fancy += '\n';
				for (count=0; count < offset; count++) m_fancy += ' ';
				for (count=0; count < length; count++) m_fancy += '^';
				m_fancy += '\n'; m_fancy += why;
				autohelp = autoversion = false;
			} // end constructor
			Exception(string why) {m_why = why; autohelp=autoversion=false;}
			const char *what() {return m_why.c_str();}
			const char *fancy() {if(m_fancy.empty()) return m_why.c_str(); else return m_fancy.c_str();}
			bool autohelp, autoversion;
		private:
			string m_why, m_fancy;
	}; // end Exception
	
	void Parser::parse(int argc, char *argv[]) {
		State  state = state_option;
		int    option_c = 0;
		string option_v;
		string option_passon;
		
		struct Found {
			bool v_flag;
			bool v_count;
			bool v_bool;
			bool v_int;
			bool v_double;
			bool v_string;
			bool v_int_list;
			bool v_bool_map;
			bool v_usage;
			bool v_R;
			bool v_f;
			bool v_speed;
		} found_list;
		
		found_list.v_flag = false;
		found_list.v_count = false;
		found_list.v_bool = false;
		found_list.v_int = false;
		found_list.v_double = false;
		found_list.v_string = false;
		found_list.v_int_list = false;
		found_list.v_bool_map = false;
		found_list.v_usage = false;
		found_list.v_R = false;
		found_list.v_f = false;
		found_list.v_speed = false;
		
		// setup defaults
		m_values.v_flag = false;
		m_values.v_count = 0;
		m_values.v_bool = false;
		m_values.v_int = 0;
		m_values.v_double = 0.0;
		m_values.v_string = "You did not give a \\t\"string\"!";
		m_values.v_usage = false;
		m_values.v_R = false;
		m_values.v_f = false;
		m_values.v_speed = 0;
		
		while (++option_c < argc) {
			if (option_v.empty()) option_v = argv[option_c];
			// a double dash will end command line processing
			// and place remaining command line options in the filename vector
			if (option_v == "--") {
				if (state == state_option) {
					while (++option_c < argc) m_file_list.push_back(argv[option_c]);
					break; // leave main while loop
				} else {
					throw Exception("missing value for '" + option_passon + "'\n");
				}
			}
			if (state == state_option) {
				if (option_v.size() > 1 && option_v.substr(0, 2) == "--") {
					option_v.erase(0, 2);
					// some temp variables
					string::size_type eq = option_v.find('=');
					string            tmp_value;
					
					if (eq != string::npos) {
						tmp_value = option_v.substr(eq + 1);
						option_v.erase(eq);
					}
					
					if (option_v == "flag") {
						if (tmp_value.size()) throw Exception(argc, argv, option_c, "--flag option does not take an argument\n");
						m_values.v_flag = true;
						option_v.erase(); continue;
						found_list.v_flag = true;
						continue;
					} else if (option_v == "count") {
						if (tmp_value.size()) throw Exception(argc, argv, option_c, "--count option does not take an argument\n");
						m_values.v_count++;
						option_v.erase(); continue;
						found_list.v_count = true;
						continue;
					} else if (option_v == "bool") {
						if (tmp_value.size()) { option_c--; option_v = tmp_value; }
						else option_v.erase();
						state = state_value;
						option_passon = "bool";
						found_list.v_bool = true;
						continue;
					} else if (option_v == "int") {
						if (tmp_value.size()) { option_c--; option_v = tmp_value; }
						else option_v.erase();
						state = state_value;
						option_passon = "int";
						found_list.v_int = true;
						continue;
					} else if (option_v == "double") {
						if (tmp_value.size()) { option_c--; option_v = tmp_value; }
						else option_v.erase();
						state = state_value;
						option_passon = "double";
						found_list.v_double = true;
						continue;
					} else if (option_v == "string") {
						if (tmp_value.size()) { option_c--; option_v = tmp_value; }
						else option_v.erase();
						state = state_value;
						option_passon = "string";
						found_list.v_string = true;
						continue;
					} else if (option_v == "int-list") {
						if (tmp_value.size()) { option_c--; option_v = tmp_value; }
						else option_v.erase();
						state = state_value;
						option_passon = "int-list";
						found_list.v_int_list = true;
						continue;
					} else if (option_v == "bool-map") {
						if (tmp_value.size()) { option_c--; option_v = tmp_value; }
						else option_v.erase();
						state = state_value;
						option_passon = "bool-map";
						found_list.v_bool_map = true;
						continue;
					} else if (option_v == "usage") {
						if (tmp_value.size()) throw Exception(argc, argv, option_c, "--usage option does not take an argument\n");
						m_values.v_usage = true;
						option_v.erase(); continue;
						found_list.v_usage = true;
						continue;
					} else if (option_v == "help") {
						Exception e(k_usage); e.autohelp=true; throw e;
					} else if (option_v == "help-commands") {
						Exception e(k_command_help); e.autohelp=true; throw e;
					} else if (option_v == "help-aliases") {
						Exception e(k_command_aliases); e.autohelp=true; throw e;
					} else if (option_v == "version") {
						Exception e(""); e.autoversion=true; throw e;
					} else {
						throw Exception(argc, argv, option_c, "option --" + option_v + " is not valid\n(for usage information try the --help option)\n");
					}
				} else if (option_v.size() > 1 && option_v[0] == '-') {
					option_v.erase(0, 1);
					while (option_v.size()) {
						if (option_v[0] == 'f') {
							found_list.v_flag = true;
							option_v.erase(0, 1);
							m_values.v_flag = true;
						} else if (option_v[0] == 'c') {
							found_list.v_count = true;
							option_v.erase(0, 1);
							m_values.v_count++;
						} else if (option_v[0] == 'b') {
							found_list.v_bool = true;
							option_v.erase(0, 1);
							if (option_v.size()) option_c--;
							state = state_value;
							option_passon = "bool";
							break;
						} else if (option_v[0] == 'i') {
							found_list.v_int = true;
							option_v.erase(0, 1);
							if (option_v.size()) option_c--;
							state = state_value;
							option_passon = "int";
							break;
						} else if (option_v[0] == 'd') {
							found_list.v_double = true;
							option_v.erase(0, 1);
							if (option_v.size()) option_c--;
							state = state_value;
							option_passon = "double";
							break;
						} else if (option_v[0] == 's') {
							found_list.v_string = true;
							option_v.erase(0, 1);
							if (option_v.size()) option_c--;
							state = state_value;
							option_passon = "string";
							break;
						} else if (option_v[0] == 'L') {
							found_list.v_int_list = true;
							option_v.erase(0, 1);
							if (option_v.size()) option_c--;
							state = state_value;
							option_passon = "int-list";
							break;
						} else if (option_v[0] == 'B') {
							found_list.v_bool_map = true;
							option_v.erase(0, 1);
							if (option_v.size()) option_c--;
							state = state_value;
							option_passon = "bool-map";
							break;
						} else if (option_v[0] == 'u') {
							found_list.v_usage = true;
							option_v.erase(0, 1);
							m_values.v_usage = true;
						} else if (option_v[0] == 'h') {
							Exception e(k_usage); e.autohelp=true; throw e;
						} else if (option_v[0] == 'v') {
							Exception e(""); e.autoversion=true; throw e;
						} else {
							option_v.erase(1);
							throw Exception(argc, argv, option_c, "option -" + option_v + " is not valid\n");
						}
					}
				} else {
					if (m_command.empty() && m_file_list.empty()) {
						if (option_v == "remove" || option_v == "rm" || option_v == "del" || option_v == "trash") {
							m_command = "remove";
							option_v.erase();
							while (++option_c < argc) {
								if (option_v.empty()) option_v = argv[option_c];
								// a double dash will end command line processing
								// and place remaining command line options in the filename vector
								if (option_v == "--") {
									if (state == state_option) {
										while (++option_c < argc) m_file_list.push_back(argv[option_c]);
										break; // leave main while loop
									} else {
										throw Exception("missing value for '" + option_passon + "'\n");
									}
								}
								if (state == state_option) {
									if (option_v.size() > 1 && option_v.substr(0, 2) == "--") {
										option_v.erase(0, 2);
										// some temp variables
										string::size_type eq = option_v.find('=');
										string            tmp_value;
										
										if (eq != string::npos) {
											tmp_value = option_v.substr(eq + 1);
											option_v.erase(eq);
										}
										
										if (option_v == "help") {
											Exception e("command: remove\n"+k_v_remove_usage); e.autohelp=true; throw e;
										} else {
											throw Exception(argc, argv, option_c, "option --" + option_v + " is not valid for the remove command\n(for usage information try the --help option)\n");
										}
									} else if (option_v.size() > 1 && option_v[0] == '-') {
										option_v.erase(0, 1);
										while (option_v.size()) {
											if (option_v[0] == 'R') {
												found_list.v_R = true;
												option_v.erase(0, 1);
												m_values.v_R = true;
											} else if (option_v[0] == 'f') {
												found_list.v_f = true;
												option_v.erase(0, 1);
												m_values.v_f = true;
											} else if (option_v[0] == 'h') {
												Exception e("command: remove\n"+k_v_remove_usage); e.autohelp=true; throw e;
											} else {
												option_v.erase(1);
												throw Exception(argc, argv, option_c, "option -" + option_v + " is not valid for the remove command\n");
											}
										}
									} else {
										while (option_c < argc) {
											if (strcmp(argv[option_c], "--") != 0) {
												m_file_list.push_back(argv[option_c]);
											}
											option_c++;
										}
									}
								} else if (state == state_value) {
									state = state_option;
									option_v.erase();
								}
							} // end parse() while loop
							if (state == state_value) {
								throw Exception("missing value for '" + option_passon + "'\n");
							}
						} else if (option_v == "water" || option_v == "aqua") {
							m_command = "water";
							option_v.erase();
							while (++option_c < argc) {
								if (option_v.empty()) option_v = argv[option_c];
								// a double dash will end command line processing
								// and place remaining command line options in the filename vector
								if (option_v == "--") {
									if (state == state_option) {
										while (++option_c < argc) m_file_list.push_back(argv[option_c]);
										break; // leave main while loop
									} else {
										throw Exception("missing value for '" + option_passon + "'\n");
									}
								}
								if (state == state_option) {
									if (option_v.size() > 1 && option_v.substr(0, 2) == "--") {
										option_v.erase(0, 2);
										// some temp variables
										string::size_type eq = option_v.find('=');
										string            tmp_value;
										
										if (eq != string::npos) {
											tmp_value = option_v.substr(eq + 1);
											option_v.erase(eq);
										}
										
										if (option_v == "speed") {
											if (tmp_value.size()) { option_c--; option_v = tmp_value; }
											else option_v.erase();
											state = state_value;
											option_passon = "speed";
											found_list.v_speed = true;
											continue;
										} else if (option_v == "help") {
											Exception e("command: water\n"+k_v_water_usage); e.autohelp=true; throw e;
										} else {
											throw Exception(argc, argv, option_c, "option --" + option_v + " is not valid for the water command\n(for usage information try the --help option)\n");
										}
									} else if (option_v.size() > 1 && option_v[0] == '-') {
										option_v.erase(0, 1);
										while (option_v.size()) {
											if (option_v[0] == 's') {
												found_list.v_speed = true;
												option_v.erase(0, 1);
												if (option_v.size()) option_c--;
												state = state_value;
												option_passon = "speed";
												break;
											} else if (option_v[0] == 'h') {
												Exception e("command: water\n"+k_v_water_usage); e.autohelp=true; throw e;
											} else {
												option_v.erase(1);
												throw Exception(argc, argv, option_c, "option -" + option_v + " is not valid for the water command\n");
											}
										}
									} else {
										while (option_c < argc) {
											if (strcmp(argv[option_c], "--") != 0) {
												m_file_list.push_back(argv[option_c]);
											}
											option_c++;
										}
									}
								} else if (state == state_value) {
									if (option_passon == "speed") {
										m_values.v_speed = static_cast<int>(strtol(option_v.c_str(), 0, 0));
									}
									state = state_option;
									option_v.erase();
								}
							} // end parse() while loop
							if (state == state_value) {
								throw Exception("missing value for '" + option_passon + "'\n");
							}
							if (!found_list.v_speed) {
								throw Exception("speed is a mandatory option\n(for usage information give the --help option)\n");
							}
							
						}
					}
				}
			} else if (state == state_value) {
				if (option_passon == "bool") {
					m_values.v_bool = truth_function(option_v);
				} else if (option_passon == "int") {
					m_values.v_int = static_cast<int>(strtol(option_v.c_str(), 0, 0));
				} else if (option_passon == "double") {
					m_values.v_double = strtod(option_v.c_str(), 0);
				} else if (option_passon == "string") {
					m_values.v_string = option_v;
				} else if (option_passon == "int-list") {
					m_values.v_int_list.push_back(static_cast<int>(strtol(option_v.c_str(), 0, 0)));
				} else if (option_passon == "bool-map") {
					string::size_type eq_pos = option_v.find('=');
					if (eq_pos == string::npos) {
						throw Exception(argc, argv, option_c, "the " + option_passon + " option needs a key=value");
					}
					string tmp_var = option_v.substr(0, eq_pos);
					option_v.erase(0, eq_pos + 1);
					m_values.v_bool_map[tmp_var] = truth_function(option_v);
				}
				state = state_option;
				option_v.erase();
			}
		} // end parse() while loop
		if (state == state_value) {
			throw Exception("missing value for '" + option_passon + "'\n");
		}
		if (m_command.empty()) { throw Exception("missing command, try --help-commands option\n"); }
		
	} // End parse()
	
	bool Parser::get_flag_option(string option, string command="") {
		if (command == "remove") {
			if (option == "R") {
				return m_values.v_R;
			} else if (option == "f") {
				return m_values.v_f;
			} else {
				throw Exception("option '" + option + "' is not a bool option\n");
			}
		}
		
		if (option == "flag") {
			return m_values.v_flag;
		} else if (option == "usage") {
			return m_values.v_usage;
		} else {
			throw Exception("option '" + option + "' is not a bool option\n");
		}
	} // End get_flag_option()
	int Parser::get_count_option(string option, string command="") {
		if (option == "count") {
			return m_values.v_count;
		} else {
			throw Exception("option '" + option + "' is not a int option\n");
		}
	} // End get_count_option()
	bool Parser::get_bool_option(string option, string command="") {
		if (option == "bool") {
			return m_values.v_bool;
		} else {
			throw Exception("option '" + option + "' is not a bool option\n");
		}
	} // End get_bool_option()
	map<string, bool>& Parser::get_bool_map(string option, string command="") {
		if (option == "bool-map") {
			return m_values.v_bool_map;
		} else {
			throw Exception("option '" + option + "' is not a map<string, bool>& option\n");
		}
	} // End get_bool_map()
	int Parser::get_int_option(string option, string command="") {
		if (command == "water") {
			if (option == "speed") {
				return m_values.v_speed;
			} else {
				throw Exception("option '" + option + "' is not a int option\n");
			}
		}
		
		if (option == "int") {
			return m_values.v_int;
		} else {
			throw Exception("option '" + option + "' is not a int option\n");
		}
	} // End get_int_option()
	vector<int>& Parser::get_int_list(string option, string command="") {
		if (option == "int-list") {
			return m_values.v_int_list;
		} else {
			throw Exception("option '" + option + "' is not a vector<int>& option\n");
		}
	} // End get_int_list()
	double Parser::get_double_option(string option, string command="") {
		if (option == "double") {
			return m_values.v_double;
		} else {
			throw Exception("option '" + option + "' is not a double option\n");
		}
	} // End get_double_option()
	string Parser::get_string_option(string option, string command="") {
		if (option == "string") {
			return m_values.v_string;
		} else {
			throw Exception("option '" + option + "' is not a string option\n");
		}
	} // End get_string_option()
} // End namespace
#endif
